/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class ConsegnaContenutiApplicativiMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private transient MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (log == null) {
                LoggerWrapperFactory.getLogger(ConsegnaContenutiApplicativiMDB.class).error("[ConsegnaContenutiApplicativi] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                log.error("[ConsegnaContenutiApplicativi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                log.error("[ConsegnaContenutiApplicativi] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                log.error("[ConsegnaContenutiApplicativi] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.isSistemaDumpDisponibile()) {
                log.error("[ConsegnaContenutiApplicativi] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ConsegnaContenutiApplicativi lib = null;
            try {
                lib = new ConsegnaContenutiApplicativi(log);
            }
            catch (Exception e) {
                log.error("ConsegnaContenutiApplicativi.instanziazione: " + e.getMessage(), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                log = LoggerWrapperFactory.getLogger(ConsegnaContenutiApplicativiMDB.class);
                log.error("[ConsegnaContenutiApplicativi] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.APPLICATIVA, "ConsegnaContenutiApplicativi");
            msgDiag.mediumDebug("Ricezione richiesta (ConsegnaContenutiApplicativiMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ConsegnaContenutiApplicativiMessage consegnaContenutiApplicativiMsg = null;
            try {
                consegnaContenutiApplicativiMsg = (ConsegnaContenutiApplicativiMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(ConsegnaContenutiApplicativiMessage)");
                return;
            }
            RequestInfo requestInfo = null;
            if (consegnaContenutiApplicativiMsg.getPddContext() != null && consegnaContenutiApplicativiMsg.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)consegnaContenutiApplicativiMsg.getPddContext().getObject(Costanti.REQUEST_INFO);
            }
            if (consegnaContenutiApplicativiMsg.getRichiestaApplicativa() != null && consegnaContenutiApplicativiMsg.getRichiestaApplicativa().getIdPortaApplicativa() != null) {
                msgDiag.updatePorta(consegnaContenutiApplicativiMsg.getRichiestaApplicativa().getIdPortaApplicativa().getNome(), requestInfo);
            } else if (consegnaContenutiApplicativiMsg.getRichiestaDelegata() != null && consegnaContenutiApplicativiMsg.getRichiestaDelegata().getIdPortaDelegata() != null) {
                msgDiag.updatePorta(TipoPdD.DELEGATA, consegnaContenutiApplicativiMsg.getRichiestaDelegata().getIdPortaDelegata().getNome(), requestInfo);
            }
            String idMessaggioConsegna = null;
            try {
                idMessaggioConsegna = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopState stato = null;
            try {
                if (consegnaContenutiApplicativiMsg.getOpenspcoopstate() != null) {
                    stato = consegnaContenutiApplicativiMsg.getOpenspcoopstate();
                    if (stato.getStatoRichiesta() == null && consegnaContenutiApplicativiMsg.getBusta() != null) {
                        StatelessMessage statoRichiesta = new StatelessMessage();
                        statoRichiesta.setBusta(consegnaContenutiApplicativiMsg.getBusta());
                        stato.setStatoRichiesta((IState)statoRichiesta);
                    }
                    stato.setUseConnection(true);
                    ((OpenSPCoopStateless)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                    ((OpenSPCoopStateless)stato).setIDMessaggioSessione(idMessaggioConsegna);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDMessaggioSessione(idMessaggioConsegna);
                    ((OpenSPCoopStateful)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                }
            }
            catch (Exception e) {
                log.error("[ConsegnaContenutiApplicativi] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = consegnaContenutiApplicativiMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME)));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            RichiestaApplicativa richiestaApplicativa = consegnaContenutiApplicativiMsg.getRichiestaApplicativa();
            RichiestaDelegata richiestaDelegata = consegnaContenutiApplicativiMsg.getRichiestaDelegata();
            String servizioApplicativo = null;
            servizioApplicativo = richiestaApplicativa != null ? richiestaApplicativa.getServizioApplicativo() : richiestaDelegata.getServizioApplicativo();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ConsegnaContenutiApplicativi", idMessaggioConsegna, "INBOX", received.getJMSMessageID(), pddContext, servizioApplicativo)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggioConsegna);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "ConsegnaContenutiApplicativi");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                log.error("[ConsegnaContenutiApplicativi] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                log.info("[ConsegnaContenutiApplicativi] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                log.debug("[ConsegnaContenutiApplicativi] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

