/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.record;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.logger.record.AbstractDatoRicostruzione;
import org.openspcoop2.pdd.logger.record.InfoDato;

public class CharDatoRicostruzione
extends AbstractDatoRicostruzione<Character> {
    public CharDatoRicostruzione(InfoDato info, Character dato) throws CoreException {
        super(info, dato);
        if (dato != null && " ".contains(dato.toString())) {
            throw new CoreException("Il dato [" + dato + "] contiene il carattere separatore [ ]");
        }
    }

    public CharDatoRicostruzione(String dato, InfoDato info) throws CoreException {
        super(dato, info);
    }

    @Override
    public String convertToString() {
        if (this.dato == null) {
            return "-";
        }
        return ((Character)this.dato).toString();
    }

    @Override
    protected Character convertToObject(String dato) throws CoreException {
        if (dato == null) {
            throw new CoreException("Dato non fornito");
        }
        if (dato.length() != 1) {
            throw new CoreException("Dato con lunghezza (" + dato.length() + ") diversa da quella attesa (1)");
        }
        if ("-".equals(dato)) {
            return null;
        }
        return Character.valueOf(dato.charAt(0));
    }
}

