/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.resources.MapReader;

public class TracciamentoOpenSPCoopProtocolAppender
implements ITracciaProducer {
    private static HashMap<String, ITracciaProducer> mappingProtocolToAppenders = new HashMap();

    private static synchronized void initProtocolAppender(String protocol, OpenspcoopAppender appenderProperties) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            ITracciaProducer tracciamento = p.createTracciaProducer();
            if (tracciamento == null) {
                throw new ProtocolException("ITracciaProducer not defined for protocol [" + protocol + "]");
            }
            try {
                tracciamento.initializeAppender(appenderProperties);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            mappingProtocolToAppenders.put(protocol, tracciamento);
        }
    }

    private static ITracciaProducer getProtocolAppender(String protocol) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            throw new ProtocolException("ProtocolAppender per protocollo[" + protocol + "] non inizializzato");
        }
        return mappingProtocolToAppenders.get(protocol);
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws TracciamentoException {
        try {
            MapReader table = ProtocolFactoryManager.getInstance().getProtocolFactories();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String protocol = (String)keys.nextElement();
                TracciamentoOpenSPCoopProtocolAppender.initProtocolAppender(protocol, appenderProperties);
            }
        }
        catch (Exception e) {
            throw new TracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public void log(Connection conOpenSPCoopPdD, Traccia traccia) throws TracciamentoException {
        try {
            if (traccia.getProtocollo() != null) {
                TracciamentoOpenSPCoopProtocolAppender.getProtocolAppender(traccia.getProtocollo()).log(conOpenSPCoopPdD, traccia);
            }
        }
        catch (Exception e) {
            throw new TracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public void isAlive() throws CoreException {
        try {
            Enumeration protocols = ProtocolFactoryManager.getInstance().getProtocolNames();
            while (protocols.hasMoreElements()) {
                String protocol = (String)protocols.nextElement();
                TracciamentoOpenSPCoopProtocolAppender.getProtocolAppender(protocol).isAlive();
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return null;
    }
}

