/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.utils.resources.MapReader;

public class DumpOpenSPCoopProtocolAppender
implements IDumpProducer {
    private static Map<String, IDumpProducer> mappingProtocolToAppenders = new HashMap<String, IDumpProducer>();

    private static synchronized void initProtocolAppender(String protocol, OpenspcoopAppender appenderProperties) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IDumpProducer dump = p.createDumpProducer();
            if (dump == null) {
                throw new ProtocolException("IDumpProducer not defined for protocol [" + protocol + "]");
            }
            try {
                dump.initializeAppender(appenderProperties);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            mappingProtocolToAppenders.put(protocol, dump);
        }
    }

    private static IDumpProducer getProtocolAppender(String protocol) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            throw new ProtocolException("ProtocolAppender per protocollo[" + protocol + "] non inizializzato");
        }
        return mappingProtocolToAppenders.get(protocol);
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws DumpException {
        try {
            MapReader table = ProtocolFactoryManager.getInstance().getProtocolFactories();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String protocol = (String)keys.nextElement();
                DumpOpenSPCoopProtocolAppender.initProtocolAppender(protocol, appenderProperties);
            }
        }
        catch (Exception e) {
            throw new DumpException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public void dump(Connection conOpenSPCoopPdD, Messaggio messaggio) throws DumpException {
        try {
            if (messaggio.getProtocollo() != null) {
                DumpOpenSPCoopProtocolAppender.getProtocolAppender(messaggio.getProtocollo()).dump(conOpenSPCoopPdD, messaggio);
            }
        }
        catch (Exception e) {
            throw new DumpException(e.getMessage(), (Throwable)e);
        }
    }

    public void dump(Connection conOpenSPCoopPdD, Messaggio messaggio, boolean headersCompact) throws DumpException {
        try {
            if (messaggio.getProtocollo() != null) {
                IDumpProducer dumpAppender = DumpOpenSPCoopProtocolAppender.getProtocolAppender(messaggio.getProtocollo());
                dumpAppender.dump(conOpenSPCoopPdD, messaggio, headersCompact);
            }
        }
        catch (Exception e) {
            throw new DumpException(e.getMessage(), (Throwable)e);
        }
    }

    public void isAlive() throws CoreException {
        try {
            Enumeration protocols = ProtocolFactoryManager.getInstance().getProtocolNames();
            while (protocols.hasMoreElements()) {
                String protocol = (String)protocols.nextElement();
                DumpOpenSPCoopProtocolAppender.getProtocolAppender(protocol).isAlive();
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return null;
    }
}

