/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.trasformazioni;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.VersioneSOAP;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MessaggioDaNotificare;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.trasformazioni.GestoreTrasformazioniException;
import org.openspcoop2.pdd.core.trasformazioni.GestoreTrasformazioniUtilities;
import org.openspcoop2.pdd.core.trasformazioni.RisultatoTrasformazioneContenuto;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class GestoreTrasformazioni {
    private Logger log = null;
    private static final String TRANSPORT_RESPONSE_CONTEXT_UNAVAILABLE = "Transport Response Context non disponibile";
    private IDServizio idServizio;
    private IDSoggetto soggettoFruitore;
    private String servizioApplicativoFruitore;
    private IDServizioApplicativo idServizioApplicativoToken;
    private Trasformazioni trasformazioni;
    private Transaction transaction;
    private PdDContext pddContext;
    private RequestInfo requestInfo;
    private ErroreIntegrazione errore;
    private MsgDiagnostico msgDiag;
    private TipoPdD tipoPdD;
    private AbstractErrorGenerator errorGenerator;
    private OpenSPCoop2Properties op2Properties;
    private Map<String, Object> dynamicMapRequest = null;
    private OpenSPCoop2Message messageRequest = null;
    private String nomeConnettore;
    private String nomeServizioApplicativoErogatore;
    private IDPortaApplicativa idPA;
    private IDPortaDelegata idPD;
    private ConfigurazionePdDManager configurazionePdDManager;
    private TrasformazioneRegola regolaTrasformazione;
    private boolean trasformazioneContenutoRichiestaEffettuata = false;

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    private void logDebug(String msg, Throwable t) {
        if (this.log != null) {
            this.log.debug(msg, t);
        }
    }

    private void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    private void logError(String msg, Throwable t) {
        if (this.log != null) {
            this.log.error(msg, t);
        }
    }

    private static String getSuffixMessageApplicabilitaContentBasedPattern(String pattern) {
        return " check applicabilit\u00e0 content-based pattern(" + pattern + ")";
    }

    public GestoreTrasformazioni(Logger alog, MsgDiagnostico msgDiag, IDServizio idServizio, IDSoggetto soggettoFruitore, String servizioApplicativoFruitore, Trasformazioni trasformazioni, Transaction transaction, PdDContext pddContext, RequestInfo requestInfo, TipoPdD tipoPdD, AbstractErrorGenerator errorGenerator, ConfigurazionePdDManager configurazionePdDManager, IDPortaApplicativa idPA) {
        this(alog, msgDiag, idServizio, soggettoFruitore, servizioApplicativoFruitore, trasformazioni, transaction, pddContext, requestInfo, tipoPdD, errorGenerator, configurazionePdDManager);
        this.idPA = idPA;
    }

    public GestoreTrasformazioni(Logger alog, MsgDiagnostico msgDiag, IDServizio idServizio, IDSoggetto soggettoFruitore, String servizioApplicativoFruitore, Trasformazioni trasformazioni, Transaction transaction, PdDContext pddContext, RequestInfo requestInfo, TipoPdD tipoPdD, AbstractErrorGenerator errorGenerator, ConfigurazionePdDManager configurazionePdDManager, IDPortaDelegata idPD) {
        this(alog, msgDiag, idServizio, soggettoFruitore, servizioApplicativoFruitore, trasformazioni, transaction, pddContext, requestInfo, tipoPdD, errorGenerator, configurazionePdDManager);
        this.idPD = idPD;
    }

    private GestoreTrasformazioni(Logger alog, MsgDiagnostico msgDiag, IDServizio idServizio, IDSoggetto soggettoFruitore, String servizioApplicativoFruitore, Trasformazioni trasformazioni, Transaction transaction, PdDContext pddContext, RequestInfo requestInfo, TipoPdD tipoPdD, AbstractErrorGenerator errorGenerator, ConfigurazionePdDManager configurazionePdDManager) {
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(GestoreTrasformazioni.class);
        this.msgDiag = msgDiag;
        this.idServizio = idServizio;
        this.soggettoFruitore = soggettoFruitore;
        this.servizioApplicativoFruitore = servizioApplicativoFruitore;
        if (pddContext != null && pddContext.containsKey(Costanti.ID_APPLICATIVO_TOKEN)) {
            this.idServizioApplicativoToken = (IDServizioApplicativo)pddContext.getObject(Costanti.ID_APPLICATIVO_TOKEN);
        }
        this.trasformazioni = trasformazioni;
        this.transaction = transaction;
        this.pddContext = pddContext;
        this.requestInfo = requestInfo;
        this.op2Properties = OpenSPCoop2Properties.getInstance();
        this.tipoPdD = tipoPdD;
        this.errorGenerator = errorGenerator;
        this.configurazionePdDManager = configurazionePdDManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSPCoop2Message trasformazioneNotifica(OpenSPCoop2Message message, Busta busta, MessaggioDaNotificare messageTypeForNotifier, OpenSPCoop2Message responseMessageForNotifier, Context transactionContextForNotifier) throws GestoreTrasformazioniException {
        if (this.transaction != null) {
            this.transaction.getTempiElaborazione().startTrasformazioneRichiesta();
        }
        try {
            OpenSPCoop2Message openSPCoop2Message = this.trasformazioneRichiestaEngine(message, busta, messageTypeForNotifier, responseMessageForNotifier, transactionContextForNotifier);
            return openSPCoop2Message;
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endTrasformazioneRichiesta();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSPCoop2Message trasformazioneRichiesta(OpenSPCoop2Message message, Busta busta) throws GestoreTrasformazioniException {
        if (this.transaction != null) {
            this.transaction.getTempiElaborazione().startTrasformazioneRichiesta();
        }
        try {
            OpenSPCoop2Message openSPCoop2Message = this.trasformazioneRichiestaEngine(message, busta, null, null, null);
            return openSPCoop2Message;
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endTrasformazioneRichiesta();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSPCoop2Message trasformazioneRisposta(OpenSPCoop2Message message, Busta busta) throws GestoreTrasformazioniException {
        if (this.transaction != null) {
            this.transaction.getTempiElaborazione().startTrasformazioneRisposta();
        }
        try {
            OpenSPCoop2Message openSPCoop2Message = this.trasformazioneRispostaEngine(message, busta);
            return openSPCoop2Message;
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endTrasformazioneRisposta();
            }
        }
    }

    public ErroreIntegrazione getErrore() {
        return this.errore;
    }

    public void setNomeConnettore(String nomeConnettore) {
        this.nomeConnettore = nomeConnettore;
    }

    public void setNomeServizioApplicativoErogatore(String nomeServizioApplicativoErogatore) {
        this.nomeServizioApplicativoErogatore = nomeServizioApplicativoErogatore;
    }

    public boolean isTrasformazioneContenutoRichiestaEffettuata() {
        return this.trasformazioneContenutoRichiestaEffettuata;
    }

    private OpenSPCoop2Message trasformazioneRichiestaEngine(OpenSPCoop2Message messageP, Busta busta, MessaggioDaNotificare messageTypeForNotifier, OpenSPCoop2Message responseMessageForNotifier, Context transactionContextForNotifier) throws GestoreTrasformazioniException {
        String forceContentTypeRichiesta;
        RisultatoTrasformazioneContenuto risultato;
        boolean trasformazioneContenuto;
        ErrorHandler errorHandler;
        HashMap<String, Object> dynamicMap;
        TrasformazioneRegolaRichiesta richiesta;
        String interfaceName;
        String nomePortaInvocata;
        HashMap<String, List<String>> parametriUrl;
        HashMap<String, List<String>> parametriTrasporto;
        MessageContent messageContent;
        block95: {
            String msgErrore;
            HashMap<String, List<String>> parametriTrasportoRisposta;
            MessageContent messageResponseContent;
            String urlInvocazione;
            Map<String, List<String>> parametriForm;
            boolean contenutoNonNavigabile;
            block93: {
                if (this.trasformazioni == null || this.trasformazioni.sizeRegolaList() <= 0) {
                    this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaDisabilitato" : "trasformazione.processamentoRichiestaDisabilitato");
                    this.logDebug("Non esistono regole di trasformazione");
                    return messageP;
                }
                boolean existsRuleEnabled = false;
                for (int i = 0; i < this.trasformazioni.sizeRegolaList(); ++i) {
                    TrasformazioneRegola check = this.trasformazioni.getRegola(i);
                    if (check.getStato() != null && StatoFunzionalita.DISABILITATO.equals((Object)check.getStato())) continue;
                    existsRuleEnabled = true;
                    break;
                }
                if (!existsRuleEnabled) {
                    this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaDisabilitato" : "trasformazione.processamentoRichiestaDisabilitato");
                    this.logDebug("Non esistono regole di trasformazione abilitate");
                    return messageP;
                }
                messageContent = null;
                contenutoNonNavigabile = false;
                parametriTrasporto = null;
                parametriUrl = null;
                parametriForm = null;
                urlInvocazione = null;
                nomePortaInvocata = null;
                interfaceName = null;
                try {
                    Object nomePortaInvocataObject;
                    if (messageP != null && (nomePortaInvocataObject = messageP.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA)) instanceof String) {
                        nomePortaInvocata = (String)nomePortaInvocataObject;
                    }
                    boolean bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                    if (messageP != null) {
                        if (ServiceBinding.SOAP.equals((Object)messageP.getServiceBinding())) {
                            OpenSPCoop2SoapMessage soapMessage = messageP.castAsSoap();
                            messageContent = new MessageContent(soapMessage, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.XML.equals((Object)messageP.getMessageType()) && messageP.castAsRest().hasContent()) {
                            OpenSPCoop2RestXmlMessage xml = messageP.castAsRestXml();
                            messageContent = new MessageContent(xml, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.JSON.equals((Object)messageP.getMessageType()) && messageP.castAsRest().hasContent()) {
                            OpenSPCoop2RestJsonMessage json = messageP.castAsRestJson();
                            messageContent = new MessageContent(json, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.MIME_MULTIPART.equals((Object)messageP.getMessageType()) && messageP.castAsRest().hasContent()) {
                            OpenSPCoop2RestMimeMultipartMessage mime = messageP.castAsRestMimeMultipart();
                            messageContent = new MessageContent(mime, bufferMessageReadOnly, (Context)this.pddContext);
                        } else {
                            contenutoNonNavigabile = true;
                        }
                    } else {
                        contenutoNonNavigabile = true;
                    }
                    if (messageP != null && messageP.getTransportRequestContext() != null) {
                        FormUrlEncodedHttpServletRequest formServlet;
                        HttpServletTransportRequestContext httpServletContext;
                        HttpServletRequest httpServletRequest;
                        interfaceName = messageP.getTransportRequestContext().getInterfaceName();
                        if (messageP.getTransportRequestContext().getHeaders() != null && !messageP.getTransportRequestContext().getHeaders().isEmpty()) {
                            parametriTrasporto = messageP.getTransportRequestContext().getHeaders();
                        } else {
                            parametriTrasporto = new HashMap();
                            messageP.getTransportRequestContext().setHeaders(parametriTrasporto);
                        }
                        if (messageP.getTransportRequestContext().getParameters() != null && !messageP.getTransportRequestContext().getParameters().isEmpty()) {
                            parametriUrl = messageP.getTransportRequestContext().getParameters();
                        } else {
                            parametriUrl = new HashMap();
                            messageP.getTransportRequestContext().setParameters(parametriUrl);
                        }
                        if (messageP.getTransportRequestContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = (HttpServletTransportRequestContext)messageP.getTransportRequestContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                            parametriForm = formServlet.getFormUrlEncodedParametersValues();
                        }
                    } else {
                        throw new GestoreTrasformazioniException("Transport Request Context non disponibile");
                    }
                    urlInvocazione = messageP.getTransportRequestContext().getUrlInvocazione_formBased();
                }
                catch (Exception e) {
                    this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", "N.D.");
                    this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                    String msgErrore2 = "Lettura contenuto della richiesta non riuscita: " + e.getMessage();
                    this.logError(msgErrore2, e);
                    throw new GestoreTrasformazioniException(msgErrore2, e);
                }
                messageResponseContent = null;
                parametriTrasportoRisposta = null;
                try {
                    if (messageTypeForNotifier != null && MessaggioDaNotificare.ENTRAMBI.equals(messageTypeForNotifier) && responseMessageForNotifier != null) {
                        boolean bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                        if (ServiceBinding.SOAP.equals((Object)responseMessageForNotifier.getServiceBinding())) {
                            OpenSPCoop2SoapMessage soapMessage = responseMessageForNotifier.castAsSoap();
                            messageResponseContent = new MessageContent(soapMessage, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.XML.equals((Object)responseMessageForNotifier.getMessageType()) && responseMessageForNotifier.castAsRest().hasContent()) {
                            OpenSPCoop2RestXmlMessage xml = responseMessageForNotifier.castAsRestXml();
                            messageResponseContent = new MessageContent(xml, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.JSON.equals((Object)responseMessageForNotifier.getMessageType()) && responseMessageForNotifier.castAsRest().hasContent()) {
                            OpenSPCoop2RestJsonMessage json = responseMessageForNotifier.castAsRestJson();
                            messageResponseContent = new MessageContent(json, bufferMessageReadOnly, (Context)this.pddContext);
                        } else if (MessageType.MIME_MULTIPART.equals((Object)responseMessageForNotifier.getMessageType()) && responseMessageForNotifier.castAsRest().hasContent()) {
                            OpenSPCoop2RestMimeMultipartMessage mime = responseMessageForNotifier.castAsRestMimeMultipart();
                            messageResponseContent = new MessageContent(mime, bufferMessageReadOnly, (Context)this.pddContext);
                        } else {
                            contenutoNonNavigabile = true;
                        }
                        if (responseMessageForNotifier.getTransportResponseContext() != null) {
                            if (responseMessageForNotifier.getTransportResponseContext().getHeaders() != null && !responseMessageForNotifier.getTransportResponseContext().getHeaders().isEmpty()) {
                                parametriTrasportoRisposta = responseMessageForNotifier.getTransportResponseContext().getHeaders();
                            } else {
                                parametriTrasportoRisposta = new HashMap();
                                responseMessageForNotifier.getTransportResponseContext().setHeaders(parametriTrasportoRisposta);
                            }
                            break block93;
                        }
                        throw new GestoreTrasformazioniException(TRANSPORT_RESPONSE_CONTEXT_UNAVAILABLE);
                    }
                    if (messageTypeForNotifier == null || !MessaggioDaNotificare.RISPOSTA.equals(messageTypeForNotifier)) break block93;
                    if (messageP != null && messageP.getTransportResponseContext() != null) {
                        if (messageP.getTransportResponseContext().getHeaders() != null && !messageP.getTransportResponseContext().getHeaders().isEmpty()) {
                            parametriTrasportoRisposta = messageP.getTransportResponseContext().getHeaders();
                        } else {
                            parametriTrasportoRisposta = new HashMap();
                            messageP.getTransportResponseContext().setHeaders(parametriTrasporto);
                        }
                        break block93;
                    }
                    throw new GestoreTrasformazioniException(TRANSPORT_RESPONSE_CONTEXT_UNAVAILABLE);
                }
                catch (Exception e) {
                    this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", "N.D.");
                    this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                    msgErrore = "Lettura contenuto della risposta (notifica) non riuscita: " + e.getMessage();
                    this.logError(msgErrore, e);
                    throw new GestoreTrasformazioniException(msgErrore, e);
                }
            }
            try {
                this.logDebug("Identificazione regola di trasformazione tra le " + this.trasformazioni.sizeRegolaList() + " disponibili ...");
                for (int i = 0; i < this.trasformazioni.sizeRegolaList(); ++i) {
                    String suffix = "[Regola-" + i + "] ";
                    this.logDebug(suffix + "Verifica applicabilit\u00e0 della regola ...");
                    TrasformazioneRegola check = this.trasformazioni.getRegola(i);
                    if (check.getStato() != null && StatoFunzionalita.DISABILITATO.equals((Object)check.getStato())) continue;
                    if (check.getApplicabilita() != null) {
                        boolean found;
                        this.logDebug(suffix + " check applicabilit\u00e0 tra le '" + check.getApplicabilita().sizeAzioneList() + "' azioni ");
                        if (check.getApplicabilita().sizeAzioneList() > 0) {
                            found = false;
                            for (String checkAzione : check.getApplicabilita().getAzioneList()) {
                                if (!checkAzione.equals(this.idServizio.getAzione())) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        this.logDebug(suffix + " check applicabilit\u00e0 tra i " + check.getApplicabilita().sizeContentTypeList() + " content types ");
                        if (check.getApplicabilita().sizeContentTypeList() > 0 && !ContentTypeUtilities.isMatch((Logger)this.log, (String)messageP.getContentType(), (List)check.getApplicabilita().getContentTypeList())) continue;
                        if (check.getApplicabilita().getPattern() != null && !"".equals(check.getApplicabilita().getPattern())) {
                            this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + " ...");
                            if (contenutoNonNavigabile) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", messaggio non conforme al match: " + String.valueOf(messageP.getMessageType()));
                                continue;
                            }
                            String elementJson = null;
                            Object element = null;
                            if (messageContent.isJson()) {
                                elementJson = messageContent.getElementJson();
                            } else {
                                element = messageContent.getElement();
                            }
                            if (element == null && elementJson == null) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", messaggio (" + String.valueOf(messageP.getMessageType()) + ") senza contenuto");
                                continue;
                            }
                            String valore = null;
                            try {
                                if (element != null) {
                                    XPathExpressionEngine xPathEngine = new XPathExpressionEngine(messageP.getFactory());
                                    valore = AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)check.getApplicabilita().getPattern(), (Logger)this.log);
                                } else {
                                    valore = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)check.getApplicabilita().getPattern(), (Logger)this.log);
                                }
                            }
                            catch (Exception e) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + " fallita: " + e.getMessage(), e);
                            }
                            if (valore == null) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", match fallito (" + String.valueOf(messageP.getMessageType()) + ")");
                                continue;
                            }
                        }
                        this.logDebug(suffix + " check applicabilit\u00e0 tra le '" + check.getApplicabilita().sizeConnettoreList() + "' connettori ");
                        if (check.getApplicabilita().sizeConnettoreList() > 0) {
                            found = false;
                            for (String checkConnettore : check.getApplicabilita().getConnettoreList()) {
                                if (!checkConnettore.equals(this.nomeServizioApplicativoErogatore)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        this.logDebug(suffix + " check applicabilit\u00e0 tra i " + check.getApplicabilita().sizeServizioApplicativoList() + " servizi applicativi e i " + check.getApplicabilita().sizeSoggettoList() + " soggetti");
                        if (check.getApplicabilita().sizeServizioApplicativoList() > 0 && check.getApplicabilita().sizeSoggettoList() > 0) {
                            applicativi = false;
                            boolean soggetti = false;
                            if (check.getApplicabilita().sizeServizioApplicativoList() > 0 && !(applicativi = GestoreTrasformazioniUtilities.isMatchServizioApplicativo(this.soggettoFruitore, this.servizioApplicativoFruitore, check.getApplicabilita().getServizioApplicativoList())) && this.idServizioApplicativoToken != null) {
                                applicativi = GestoreTrasformazioniUtilities.isMatchServizioApplicativo(this.idServizioApplicativoToken.getIdSoggettoProprietario(), this.idServizioApplicativoToken.getNome(), check.getApplicabilita().getServizioApplicativoList());
                            }
                            if (check.getApplicabilita().sizeSoggettoList() > 0 && !(soggetti = GestoreTrasformazioniUtilities.isMatchSoggetto(this.soggettoFruitore, check.getApplicabilita().getSoggettoList())) && this.idServizioApplicativoToken != null) {
                                soggetti = GestoreTrasformazioniUtilities.isMatchSoggetto(this.idServizioApplicativoToken.getIdSoggettoProprietario(), check.getApplicabilita().getSoggettoList());
                            }
                            if (!applicativi && !soggetti) {
                                continue;
                            }
                        } else if (check.getApplicabilita().sizeServizioApplicativoList() > 0) {
                            applicativi = false;
                            if (check.getApplicabilita().sizeServizioApplicativoList() > 0 && !(applicativi = GestoreTrasformazioniUtilities.isMatchServizioApplicativo(this.soggettoFruitore, this.servizioApplicativoFruitore, check.getApplicabilita().getServizioApplicativoList())) && this.idServizioApplicativoToken != null) {
                                applicativi = GestoreTrasformazioniUtilities.isMatchServizioApplicativo(this.idServizioApplicativoToken.getIdSoggettoProprietario(), this.idServizioApplicativoToken.getNome(), check.getApplicabilita().getServizioApplicativoList());
                            }
                            if (!applicativi) {
                                continue;
                            }
                        } else if (check.getApplicabilita().sizeSoggettoList() > 0) {
                            boolean soggetti = false;
                            if (check.getApplicabilita().sizeSoggettoList() > 0 && !(soggetti = GestoreTrasformazioniUtilities.isMatchSoggetto(this.soggettoFruitore, check.getApplicabilita().getSoggettoList())) && this.idServizioApplicativoToken != null) {
                                soggetti = GestoreTrasformazioniUtilities.isMatchSoggetto(this.idServizioApplicativoToken.getIdSoggettoProprietario(), check.getApplicabilita().getSoggettoList());
                            }
                            if (!soggetti) continue;
                        }
                    }
                    this.logDebug(suffix + " check applicabilit\u00e0, regola applicabile alla richiesta in corso");
                    this.regolaTrasformazione = check;
                    break;
                }
            }
            catch (Exception er) {
                this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", "N.D.");
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                msgErrore = "Identificazione regola di trasformazione non riuscita: " + er.getMessage();
                this.logError(msgErrore, er);
                throw new GestoreTrasformazioniException(msgErrore, er);
            }
            if (this.regolaTrasformazione == null) {
                this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", "N.D.");
                this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaNessunMatch" : "trasformazione.processamentoRichiestaNessunMatch");
                this.logDebug("Nessuna regola di trasformazione trovata");
                return messageP;
            }
            this.messageRequest = messageP;
            richiesta = this.regolaTrasformazione.getRichiesta();
            String labelTrasformazione = GestoreTrasformazioniUtilities.getLabelTipoTrasformazioneRichiesta(richiesta, messageP);
            this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", labelTrasformazione);
            this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaInCorso" : "trasformazione.processamentoRichiestaInCorso");
            if (this.pddContext != null) {
                this.pddContext.addObject(CostantiPdD.TIPO_TRASFORMAZIONE_RICHIESTA, labelTrasformazione);
            }
            this.logDebug("Costruzione dynamic map ...");
            dynamicMap = new HashMap<String, Object>();
            errorHandler = new ErrorHandler(this.errorGenerator, IntegrationFunctionError.TRANSFORMATION_RULE_REQUEST_FAILED, this.pddContext);
            DynamicUtils.fillDynamicMapRequest(this.log, dynamicMap, this.pddContext, urlInvocazione, messageP, messageContent, busta, parametriTrasporto, parametriUrl, parametriForm, errorHandler);
            this.dynamicMapRequest = dynamicMap;
            if (messageTypeForNotifier != null && (MessaggioDaNotificare.ENTRAMBI.equals(messageTypeForNotifier) && responseMessageForNotifier != null || MessaggioDaNotificare.RISPOSTA.equals(messageTypeForNotifier))) {
                HashMap<String, Object> dynamicMapWithResponse = new HashMap<String, Object>();
                boolean preserveRequest = true;
                if (MessaggioDaNotificare.RISPOSTA.equals(messageTypeForNotifier)) {
                    Object o = dynamicMap.remove("response");
                    if (o != null) {
                        dynamicMap.put("request", o);
                    }
                    DynamicUtils.fillDynamicMapResponse(this.log, dynamicMapWithResponse, dynamicMap, this.pddContext, messageP, messageContent, busta, parametriTrasportoRisposta, errorHandler, preserveRequest);
                } else {
                    DynamicUtils.fillDynamicMapResponse(this.log, dynamicMapWithResponse, dynamicMap, this.pddContext, responseMessageForNotifier, messageResponseContent, busta, parametriTrasportoRisposta, errorHandler, preserveRequest);
                }
                dynamicMap = dynamicMapWithResponse;
            }
            this.logDebug("Costruzione dynamic map completata");
            trasformazioneContenuto = richiesta.getConversione();
            risultato = null;
            forceContentTypeRichiesta = null;
            try {
                if (richiesta.getContentType() != null && StringUtils.isNotEmpty((CharSequence)richiesta.getContentType())) {
                    forceContentTypeRichiesta = richiesta.getContentType();
                    forceContentTypeRichiesta = DynamicUtils.convertDynamicPropertyValue("forceContentTypeRichiesta", forceContentTypeRichiesta, dynamicMap, this.pddContext);
                }
                if (!trasformazioneContenuto) {
                    this.logDebug("Trasformazione contenuto della richiesta disabilitato");
                } else {
                    Template template = this.idPA != null ? this.configurazionePdDManager.getTemplateTrasformazioneRichiesta(this.idPA, this.regolaTrasformazione.getNome(), richiesta, this.requestInfo) : this.configurazionePdDManager.getTemplateTrasformazioneRichiesta(this.idPD, this.regolaTrasformazione.getNome(), richiesta, this.requestInfo);
                    risultato = GestoreTrasformazioniUtilities.trasformazioneContenuto(this.log, richiesta.getConversioneTipo(), template, "richiesta", dynamicMap, messageP, messageContent, this.pddContext, forceContentTypeRichiesta, this.op2Properties.isTrasformazioni_readCharsetFromContentType());
                    if (risultato != null && risultato.getTipoTrasformazione() != null && risultato.getTipoTrasformazione().isContextInjection()) {
                        trasformazioneContenuto = false;
                        this.logDebug("Trasformazione contenuto della richiesta disabilitato (Context Injection)");
                    }
                }
            }
            catch (Exception er) {
                if (errorHandler.isError()) break block95;
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                String msgErrore3 = "Trasformazione richiesta fallita: " + er.getMessage();
                this.logError(msgErrore3, er);
                throw new GestoreTrasformazioniException(msgErrore3, er);
            }
        }
        if (errorHandler.isError()) {
            String msgErrore = "Trasformazione richiesta terminata con errore: " + errorHandler.getDetail();
            this.logError(msgErrore);
            if (errorHandler.getMessage() != null) {
                throw new GestoreTrasformazioniException(msgErrore, errorHandler.getMessage());
            }
            throw new GestoreTrasformazioniException(msgErrore, errorHandler.getOp2Message(), errorHandler.getOp2IntegrationFunctionError());
        }
        try {
            HashMap<String, List<String>> trasporto = parametriTrasporto;
            HashMap<String, List<String>> forceAddTrasporto = new HashMap<String, List<String>>();
            GestoreTrasformazioniUtilities.trasformazione(this.log, richiesta.getHeaderList(), trasporto, forceAddTrasporto, "RequestHeader", dynamicMap, this.pddContext);
            if (forceContentTypeRichiesta != null && StringUtils.isNotEmpty((CharSequence)forceContentTypeRichiesta)) {
                TransportUtils.removeRawObject(trasporto, (String)"Content-Type");
                TransportUtils.setHeader(trasporto, (String)"Content-Type", (String)forceContentTypeRichiesta);
            }
            HashMap<String, List<String>> url = parametriUrl;
            HashMap<String, List<String>> forceAddUrl = new HashMap<String, List<String>>();
            GestoreTrasformazioniUtilities.trasformazione(this.log, richiesta.getParametroUrlList(), url, forceAddUrl, "QueryParameter", dynamicMap, this.pddContext);
            if (!trasformazioneContenuto) {
                GestoreTrasformazioniUtilities.addTransportInfo(forceAddTrasporto, forceAddUrl, null, messageP);
                if (ServiceBinding.REST.equals((Object)messageP.getServiceBinding()) && richiesta.getTrasformazioneRest() != null && (StringUtils.isNotEmpty((CharSequence)richiesta.getTrasformazioneRest().getMetodo()) || StringUtils.isNotEmpty((CharSequence)richiesta.getTrasformazioneRest().getPath()))) {
                    GestoreTrasformazioniUtilities.injectNewRestParameter(messageP, richiesta.getTrasformazioneRest().getMetodo(), richiesta.getTrasformazioneRest().getPath(), dynamicMap, this.pddContext);
                }
                this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaEffettuato" : "trasformazione.processamentoRichiestaEffettuato");
                return messageP;
            }
            boolean trasformazioneRest = false;
            String trasformazioneRestMethod = null;
            String trasformazioneRestPath = null;
            if (richiesta.getTrasformazioneRest() != null) {
                trasformazioneRest = true;
                trasformazioneRestMethod = richiesta.getTrasformazioneRest().getMetodo();
                trasformazioneRestPath = richiesta.getTrasformazioneRest().getPath();
            }
            boolean trasformazioneSoap = false;
            VersioneSOAP trasformazioneSoapVersione = null;
            String trasformazioneSoapSOAPAction = null;
            boolean trasformazioneSoapEnvelope = false;
            boolean trasformazioneSoapEnvelopeAsAttachment = false;
            String trasformazioneSoapTipoConversione = null;
            Template trasformazioneSoapTemplateConversione = null;
            if (richiesta.getTrasformazioneSoap() != null) {
                trasformazioneSoap = true;
                trasformazioneSoapVersione = richiesta.getTrasformazioneSoap().getVersione();
                trasformazioneSoapSOAPAction = richiesta.getTrasformazioneSoap().getSoapAction();
                trasformazioneSoapEnvelope = richiesta.getTrasformazioneSoap().isEnvelope();
                trasformazioneSoapEnvelopeAsAttachment = richiesta.getTrasformazioneSoap().isEnvelopeAsAttachment();
                trasformazioneSoapTipoConversione = richiesta.getTrasformazioneSoap().getEnvelopeBodyConversioneTipo();
                trasformazioneSoapTemplateConversione = this.idPA != null ? this.configurazionePdDManager.getTemplateTrasformazioneSoapRichiesta(this.idPA, this.regolaTrasformazione.getNome(), richiesta, this.requestInfo) : this.configurazionePdDManager.getTemplateTrasformazioneSoapRichiesta(this.idPD, this.regolaTrasformazione.getNome(), richiesta, this.requestInfo);
            }
            OpenSPCoop2Message msg = GestoreTrasformazioniUtilities.trasformaMessaggio(this.log, messageP, messageContent, this.requestInfo, dynamicMap, this.pddContext, this.op2Properties, trasporto, forceAddTrasporto, url, forceAddUrl, -1, forceContentTypeRichiesta, null, risultato, trasformazioneRest, trasformazioneRestMethod, trasformazioneRestPath, trasformazioneSoap, trasformazioneSoapVersione, trasformazioneSoapSOAPAction, trasformazioneSoapEnvelope, trasformazioneSoapEnvelopeAsAttachment, trasformazioneSoapTipoConversione, trasformazioneSoapTemplateConversione);
            this.trasformazioneContenutoRichiestaEffettuata = true;
            this.msgDiag.logPersonalizzato(messageTypeForNotifier != null ? "trasformazione.processamentoNotificaEffettuato" : "trasformazione.processamentoRichiestaEffettuato");
            if (msg != null) {
                Object nomePortaInvocataObject;
                if (nomePortaInvocata != null && (nomePortaInvocataObject = msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA)) == null) {
                    msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
                }
                if (interfaceName != null && msg.getTransportRequestContext() != null && msg.getTransportRequestContext().getInterfaceName() == null) {
                    msg.getTransportRequestContext().setInterfaceName(interfaceName);
                }
            }
            return msg;
        }
        catch (Throwable er) {
            this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
            String msgErrore = "Trasformazione richiesta fallita: " + er.getMessage();
            this.logError(msgErrore, er);
            throw new GestoreTrasformazioniException(msgErrore, er);
        }
    }

    private OpenSPCoop2Message trasformazioneRispostaEngine(OpenSPCoop2Message message, Busta busta) throws GestoreTrasformazioniException {
        String forceContentTypeRisposta;
        RisultatoTrasformazioneContenuto risultato;
        boolean trasformazioneContenuto;
        ErrorHandler errorHandler;
        HashMap<String, Object> dynamicMap;
        TrasformazioneRegolaRisposta trasformazioneRisposta;
        int httpStatus;
        HashMap<String, List<String>> parametriTrasporto;
        MessageContent messageContent;
        block62: {
            boolean contenutoNonNavigabile;
            block60: {
                if (this.regolaTrasformazione == null || this.regolaTrasformazione.sizeRispostaList() <= 0) {
                    this.msgDiag.logPersonalizzato("trasformazione.processamentoRispostaDisabilitato");
                    this.logDebug("Non esistono regole di trasformazione della risposta");
                    return message;
                }
                messageContent = null;
                contenutoNonNavigabile = false;
                parametriTrasporto = null;
                httpStatus = -1;
                try {
                    boolean bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                    if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                        OpenSPCoop2SoapMessage soapMessage = message.castAsSoap();
                        messageContent = new MessageContent(soapMessage, bufferMessageReadOnly, (Context)this.pddContext);
                    } else if (MessageType.XML.equals((Object)message.getMessageType()) && message.castAsRest().hasContent()) {
                        OpenSPCoop2RestXmlMessage xml = message.castAsRestXml();
                        messageContent = new MessageContent(xml, bufferMessageReadOnly, (Context)this.pddContext);
                    } else if (MessageType.JSON.equals((Object)message.getMessageType()) && message.castAsRest().hasContent()) {
                        OpenSPCoop2RestJsonMessage json = message.castAsRestJson();
                        messageContent = new MessageContent(json, bufferMessageReadOnly, (Context)this.pddContext);
                    } else if (MessageType.MIME_MULTIPART.equals((Object)message.getMessageType()) && message.castAsRest().hasContent()) {
                        OpenSPCoop2RestMimeMultipartMessage mime = message.castAsRestMimeMultipart();
                        messageContent = new MessageContent(mime, bufferMessageReadOnly, (Context)this.pddContext);
                    } else {
                        contenutoNonNavigabile = true;
                    }
                    if (message.getTransportResponseContext() != null) {
                        if (message.getTransportResponseContext().getHeaders() != null && !message.getTransportResponseContext().getHeaders().isEmpty()) {
                            parametriTrasporto = message.getTransportResponseContext().getHeaders();
                        } else {
                            parametriTrasporto = new HashMap();
                            message.getTransportResponseContext().setHeaders(parametriTrasporto);
                        }
                        try {
                            httpStatus = Integer.parseInt(message.getTransportResponseContext().getCodiceTrasporto());
                        }
                        catch (Exception mime) {}
                        break block60;
                    }
                    throw new GestoreTrasformazioniException(TRANSPORT_RESPONSE_CONTEXT_UNAVAILABLE);
                }
                catch (Throwable e) {
                    this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RISPOSTA@", "N.D.");
                    this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(e, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                    String msgErrore = "Lettura contenuto della risposta non riuscita: " + e.getMessage();
                    this.logError(msgErrore, e);
                    throw new GestoreTrasformazioniException(msgErrore, e);
                }
            }
            trasformazioneRisposta = null;
            try {
                this.logDebug("Identificazione regola di trasformazione della risposta tra le " + this.regolaTrasformazione.sizeRispostaList() + " disponibili ...");
                for (int i = 0; i < this.regolaTrasformazione.sizeRispostaList(); ++i) {
                    String suffix = "[Regola-" + i + "] ";
                    this.logDebug(suffix + "Verifica applicabilit\u00e0 della regola ...");
                    TrasformazioneRegolaRisposta check = this.regolaTrasformazione.getRisposta(i);
                    if (check.getApplicabilita() != null) {
                        if (check.getApplicabilita().getReturnCodeMax() != null || check.getApplicabilita().getReturnCodeMin() != null) {
                            Object min = "*";
                            if (check.getApplicabilita().getReturnCodeMin() != null) {
                                min = "" + check.getApplicabilita().getReturnCodeMin();
                            }
                            Object max = "*";
                            if (check.getApplicabilita().getReturnCodeMax() != null) {
                                max = "" + check.getApplicabilita().getReturnCodeMax();
                            }
                            this.logDebug(suffix + " check applicabilit\u00e0 return code [" + (String)min + "-" + (String)max + "]");
                            if (check.getApplicabilita().getReturnCodeMin() != null && httpStatus < check.getApplicabilita().getReturnCodeMin() || check.getApplicabilita().getReturnCodeMax() != null && httpStatus > check.getApplicabilita().getReturnCodeMax()) continue;
                        }
                        if (!ContentTypeUtilities.isMatch((Logger)this.log, (String)message.getContentType(), (List)check.getApplicabilita().getContentTypeList())) continue;
                        if (check.getApplicabilita().getPattern() != null && !"".equals(check.getApplicabilita().getPattern())) {
                            this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + " ...");
                            if (contenutoNonNavigabile) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", messaggio non conforme al match: " + String.valueOf(message.getMessageType()));
                                continue;
                            }
                            String elementJson = null;
                            Element element = null;
                            if (messageContent.isJson()) {
                                elementJson = messageContent.getElementJson();
                            } else {
                                element = messageContent.getElement();
                            }
                            if (element == null && elementJson == null) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", messaggio (" + String.valueOf(message.getMessageType()) + ") senza contenuto");
                                continue;
                            }
                            String valore = null;
                            try {
                                if (element != null) {
                                    XPathExpressionEngine xPathEngine = new XPathExpressionEngine(message.getFactory());
                                    valore = AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)check.getApplicabilita().getPattern(), (Logger)this.log);
                                } else {
                                    valore = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)check.getApplicabilita().getPattern(), (Logger)this.log);
                                }
                            }
                            catch (Exception e) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + " fallita: " + e.getMessage(), e);
                            }
                            if (valore == null) {
                                this.logDebug(suffix + GestoreTrasformazioni.getSuffixMessageApplicabilitaContentBasedPattern(check.getApplicabilita().getPattern()) + ", match fallito (" + String.valueOf(message.getMessageType()) + ")");
                                continue;
                            }
                        }
                    }
                    this.logDebug(suffix + " check applicabilit\u00e0, regola applicabile alla risposta in corso");
                    trasformazioneRisposta = check;
                    break;
                }
            }
            catch (Throwable er) {
                this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RISPOSTA@", "N.D.");
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                String msgErrore = "Identificazione regola di trasformazione della risposta non riuscita: " + er.getMessage();
                this.logError(msgErrore, er);
                throw new GestoreTrasformazioniException(msgErrore, er);
            }
            if (trasformazioneRisposta == null) {
                this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RISPOSTA@", "N.D.");
                this.msgDiag.logPersonalizzato("trasformazione.processamentoRispostaNessunMatch");
                this.logDebug("Nessuna regola di trasformazione della risposta trovata");
                return message;
            }
            String labelTrasformazione = GestoreTrasformazioniUtilities.getLabelTipoTrasformazioneRisposta(this.regolaTrasformazione.getRichiesta(), trasformazioneRisposta);
            this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RISPOSTA@", labelTrasformazione);
            this.msgDiag.logPersonalizzato("trasformazione.processamentoRispostaInCorso");
            if (this.pddContext != null) {
                this.pddContext.addObject(CostantiPdD.TIPO_TRASFORMAZIONE_RISPOSTA, labelTrasformazione);
            }
            this.logDebug("Costruzione dynamic map ...");
            dynamicMap = new HashMap<String, Object>();
            errorHandler = new ErrorHandler(this.errorGenerator, IntegrationFunctionError.TRANSFORMATION_RULE_RESPONSE_FAILED, this.pddContext);
            DynamicUtils.fillDynamicMapResponse(this.log, dynamicMap, this.dynamicMapRequest, this.pddContext, message, messageContent, busta, parametriTrasporto, errorHandler);
            this.logDebug("Costruzione dynamic map completata");
            trasformazioneContenuto = trasformazioneRisposta.getConversione();
            risultato = null;
            forceContentTypeRisposta = null;
            try {
                if (trasformazioneRisposta.getContentType() != null && StringUtils.isNotEmpty((CharSequence)trasformazioneRisposta.getContentType())) {
                    forceContentTypeRisposta = trasformazioneRisposta.getContentType();
                    forceContentTypeRisposta = DynamicUtils.convertDynamicPropertyValue("forceContentTypeRisposta", forceContentTypeRisposta, dynamicMap, this.pddContext);
                }
                if (!trasformazioneContenuto) {
                    this.logDebug("Trasformazione contenuto della richiesta disabilitato");
                } else {
                    Template template = this.idPA != null ? this.configurazionePdDManager.getTemplateTrasformazioneRisposta(this.idPA, this.regolaTrasformazione.getNome(), trasformazioneRisposta, this.requestInfo) : this.configurazionePdDManager.getTemplateTrasformazioneRisposta(this.idPD, this.regolaTrasformazione.getNome(), trasformazioneRisposta, this.requestInfo);
                    risultato = GestoreTrasformazioniUtilities.trasformazioneContenuto(this.log, trasformazioneRisposta.getConversioneTipo(), template, "risposta", dynamicMap, message, messageContent, this.pddContext, forceContentTypeRisposta, this.op2Properties.isTrasformazioni_readCharsetFromContentType());
                    if (risultato != null && risultato.getTipoTrasformazione() != null && risultato.getTipoTrasformazione().isContextInjection()) {
                        trasformazioneContenuto = false;
                        this.logDebug("Trasformazione contenuto della risposta disabilitato (Context Injection)");
                    }
                }
            }
            catch (Throwable er) {
                if (errorHandler.isError()) break block62;
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
                String msgErrore = "Trasformazione risposta fallita: " + er.getMessage();
                this.logError(msgErrore, er);
                throw new GestoreTrasformazioniException(msgErrore, er);
            }
        }
        if (errorHandler.isError()) {
            String msgErrore = "Trasformazione risposta terminata con errore: " + errorHandler.getDetail();
            this.logError(msgErrore);
            if (errorHandler.getMessage() != null) {
                throw new GestoreTrasformazioniException(msgErrore, errorHandler.getMessage());
            }
            throw new GestoreTrasformazioniException(msgErrore, errorHandler.getOp2Message(), errorHandler.getOp2IntegrationFunctionError());
        }
        try {
            HashMap<String, List<String>> trasporto = parametriTrasporto != null ? parametriTrasporto : new HashMap<String, List<String>>();
            HashMap<String, List<String>> forceAddTrasporto = new HashMap<String, List<String>>();
            GestoreTrasformazioniUtilities.trasformazione(this.log, trasformazioneRisposta.getHeaderList(), trasporto, forceAddTrasporto, "ResponseHeader", dynamicMap, this.pddContext);
            if (forceContentTypeRisposta != null && StringUtils.isNotEmpty((CharSequence)forceContentTypeRisposta)) {
                TransportUtils.removeRawObject(trasporto, (String)"Content-Type");
                TransportUtils.setHeader(trasporto, (String)"Content-Type", (String)forceContentTypeRisposta);
            }
            Object forceResponseStatus = null;
            if (trasformazioneRisposta.getReturnCode() != null && StringUtils.isNotEmpty((CharSequence)trasformazioneRisposta.getReturnCode())) {
                forceResponseStatus = trasformazioneRisposta.getReturnCode();
                if ((forceResponseStatus = DynamicUtils.convertDynamicPropertyValue("forceResponseStatus", (String)forceResponseStatus, dynamicMap, this.pddContext)) != null && StringUtils.isNotEmpty((CharSequence)forceResponseStatus)) {
                    GestoreTrasformazioniUtilities.checkReturnCode((String)forceResponseStatus);
                } else {
                    forceResponseStatus = "" + httpStatus;
                }
            } else {
                forceResponseStatus = "" + httpStatus;
            }
            if (!trasformazioneContenuto) {
                GestoreTrasformazioniUtilities.addTransportInfo(forceAddTrasporto, null, (String)forceResponseStatus, message);
                this.msgDiag.logPersonalizzato("trasformazione.processamentoRispostaEffettuato");
                return message;
            }
            boolean trasformazioneRest = false;
            if (this.regolaTrasformazione.getRichiesta().getTrasformazioneSoap() != null) {
                trasformazioneRest = true;
            }
            boolean trasformazioneSoap = false;
            VersioneSOAP trasformazioneSoapVersione = null;
            String trasformazioneSoapSOAPAction = null;
            boolean trasformazioneSoapEnvelope = false;
            boolean trasformazioneSoapEnvelopeAsAttachment = false;
            String trasformazioneSoapTipoConversione = null;
            Template trasformazioneSoapTemplateConversione = null;
            if (this.regolaTrasformazione.getRichiesta().getTrasformazioneRest() != null) {
                trasformazioneSoap = true;
                if (this.messageRequest != null) {
                    if (MessageType.SOAP_11.equals((Object)this.messageRequest.getMessageType())) {
                        trasformazioneSoapVersione = VersioneSOAP._1_1;
                    } else if (MessageType.SOAP_12.equals((Object)this.messageRequest.getMessageType())) {
                        trasformazioneSoapVersione = VersioneSOAP._1_2;
                    } else {
                        throw new GestoreTrasformazioniException("Atteso messaggio di richiesta di tipo SOAP, in presenza di una trasformazione REST attiva");
                    }
                    trasformazioneSoapSOAPAction = this.messageRequest.castAsSoap().getSoapAction();
                } else {
                    trasformazioneSoapVersione = VersioneSOAP._1_1;
                }
                if (trasformazioneRisposta.getTrasformazioneSoap() != null) {
                    trasformazioneSoapEnvelope = trasformazioneRisposta.getTrasformazioneSoap().isEnvelope();
                    trasformazioneSoapEnvelopeAsAttachment = trasformazioneRisposta.getTrasformazioneSoap().isEnvelopeAsAttachment();
                    trasformazioneSoapTipoConversione = trasformazioneRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTipo();
                    trasformazioneSoapTemplateConversione = this.idPA != null ? this.configurazionePdDManager.getTemplateTrasformazioneSoapRisposta(this.idPA, this.regolaTrasformazione.getNome(), trasformazioneRisposta, this.requestInfo) : this.configurazionePdDManager.getTemplateTrasformazioneSoapRisposta(this.idPD, this.regolaTrasformazione.getNome(), trasformazioneRisposta, this.requestInfo);
                }
            }
            OpenSPCoop2Message msg = GestoreTrasformazioniUtilities.trasformaMessaggio(this.log, message, messageContent, this.requestInfo, dynamicMap, this.pddContext, this.op2Properties, trasporto, forceAddTrasporto, null, null, httpStatus, forceContentTypeRisposta, (String)forceResponseStatus, risultato, trasformazioneRest, null, null, trasformazioneSoap, trasformazioneSoapVersione, trasformazioneSoapSOAPAction, trasformazioneSoapEnvelope, trasformazioneSoapEnvelopeAsAttachment, trasformazioneSoapTipoConversione, trasformazioneSoapTemplateConversione);
            this.msgDiag.logPersonalizzato("trasformazione.processamentoRispostaEffettuato");
            return msg;
        }
        catch (Throwable er) {
            this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(er, CodiceErroreIntegrazione.CODICE_562_TRASFORMAZIONE);
            String msgErrore = "Trasformazione risposta fallita: " + er.getMessage();
            this.logError(msgErrore, er);
            throw new GestoreTrasformazioniException(msgErrore, er);
        }
    }
}

