/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionInfo;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;

public class TransactionContext {
    private static final String INDICAZIONE_GESTIONE_STATEFUL_ERRATA = "Indicazione sulla gestione stateful errata: ";
    private static Boolean gestioneStateful = null;
    private static boolean useThreadLocal = true;
    private static Map<String, TransactionInfo> setTransactionInfoThreadLocal = new ConcurrentHashMap<String, TransactionInfo>();
    private static final ThreadLocal<TransactionInfo> transactionContextThreadLocal = ThreadLocal.withInitial(() -> {
        String tName = Thread.currentThread().getName();
        TransactionInfo info = new TransactionInfo(tName);
        setTransactionInfoThreadLocal.put(tName, info);
        return info;
    });
    private static Map<String, Transaction> transactionContextShared = null;
    private static Set<String> idBustaFiltroDuplicati = ConcurrentHashMap.newKeySet();
    private static Semaphore semaphoreIdentificativoProtocollo = new Semaphore("TransactionContext.idProtocollo");

    private TransactionContext() {
    }

    public static synchronized void initGestioneStateful() {
        if (gestioneStateful == null) {
            gestioneStateful = OpenSPCoop2Properties.getInstance().isTransazioniStatefulEnabled();
        }
    }

    public static boolean isUseThreadLocal() {
        return useThreadLocal;
    }

    public static void removeTransactionContextThreadLocal() {
        if (transactionContextThreadLocal != null) {
            transactionContextThreadLocal.remove();
        }
    }

    public static synchronized void initResources() {
        if (!useThreadLocal) {
            transactionContextShared = OpenSPCoop2Properties.getInstance().isConfigurazioneCache_transactionContext_accessiSynchronized() ? new Hashtable<String, Transaction>() : new ConcurrentHashMap<String, Transaction>();
        }
    }

    public static String getTransactionContextType() {
        if (useThreadLocal) {
            return "ThreadLocal";
        }
        return transactionContextShared.getClass().getName();
    }

    public static List<String> getTransactionKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (useThreadLocal) {
            TransactionContext.fillTransactionKeysThreadLocal(keys);
        } else {
            keys.addAll(transactionContextShared.keySet());
        }
        return keys;
    }

    private static void fillTransactionKeysThreadLocal(List<String> keys) {
        ArrayList<String> thNames = new ArrayList<String>();
        thNames.addAll(setTransactionInfoThreadLocal.keySet());
        ArrayList<String> threadsClientNio = new ArrayList<String>();
        for (String tName : thNames) {
            TransactionContext.fillTransactionKeysThreadLocal(tName, threadsClientNio, keys);
        }
        if (useThreadLocal) {
            TransactionContext.fillTransactionKeysThreadLocalCleanThreadNio(threadsClientNio, thNames, keys);
        }
    }

    private static boolean isClientNio(String tName) {
        return tName.startsWith("httpclient-dispatch");
    }

    private static void fillTransactionKeysThreadLocal(String tName, List<String> threadsClientNio, List<String> keys) {
        TransactionInfo tInfo = setTransactionInfoThreadLocal.get(tName);
        if (tInfo != null && tInfo.transaction != null) {
            String id = null;
            try {
                id = tInfo.transaction.getId();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (id != null) {
                if (useThreadLocal) {
                    String threadNameId = TransactionContext.formatThreadId(tName, id);
                    if (TransactionContext.isClientNio(tName) && !threadsClientNio.contains(threadNameId)) {
                        threadsClientNio.add(threadNameId);
                    }
                    keys.add(threadNameId);
                } else {
                    keys.add(id);
                }
            }
        }
    }

    private static String formatThreadId(String tName, String id) {
        return "Thread:" + tName + " id:" + id;
    }

    private static String extractIdFromFormatThreadId(String id) {
        String[] split;
        String f = " id:";
        if (id.contains(f) && (split = id.split(f)).length == 2) {
            return split[1];
        }
        return id;
    }

    private static void fillTransactionKeysThreadLocalCleanThreadNio(List<String> threadsClientNio, List<String> thNames, List<String> keys) {
        if (!threadsClientNio.isEmpty()) {
            for (String threadNameId : threadsClientNio) {
                String id = TransactionContext.extractIdFromFormatThreadId(threadNameId);
                boolean find = TransactionContext.existsAnotherThreadWithSameId(thNames, id);
                if (find) continue;
                keys.remove(threadNameId);
            }
        }
    }

    private static boolean existsAnotherThreadWithSameId(List<String> thNames, String id) {
        boolean find = false;
        for (String tName : thNames) {
            if (TransactionContext.isClientNio(tName)) continue;
            TransactionInfo tInfo = setTransactionInfoThreadLocal.get(tName);
            String idAltroThread = null;
            if (tInfo != null && tInfo.transaction != null) {
                try {
                    idAltroThread = tInfo.transaction.getId();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (idAltroThread == null || !idAltroThread.equals(id)) continue;
            find = true;
            break;
        }
        return find;
    }

    public static void createTransaction(String id, String originator) throws TransactionNotExistsException {
        if (useThreadLocal) {
            TransactionContext.createTransactionThreadLocal(id, originator);
        } else if (!transactionContextShared.containsKey(id)) {
            try {
                if (gestioneStateful == null) {
                    TransactionContext.initGestioneStateful();
                }
            }
            catch (Exception e) {
                throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
            }
            Transaction transaction = new Transaction(id, originator, gestioneStateful);
            transactionContextShared.put(id, transaction);
        }
    }

    private static void createTransactionThreadLocal(String id, String originator) throws TransactionNotExistsException {
        if (TransactionContext.transactionContextThreadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContextThreadLocal.get().transaction.getId())) {
            try {
                if (gestioneStateful == null) {
                    TransactionContext.initGestioneStateful();
                }
            }
            catch (Exception e) {
                throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
            }
            TransactionContext.transactionContextThreadLocal.get().transaction = new Transaction(id, originator, gestioneStateful);
        }
    }

    public static void setTransactionThreadLocal(String id, Transaction transaction) throws TransactionNotExistsException {
        if (useThreadLocal && (TransactionContext.transactionContextThreadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContextThreadLocal.get().transaction.getId()))) {
            try {
                if (gestioneStateful == null) {
                    TransactionContext.initGestioneStateful();
                }
            }
            catch (Exception e) {
                throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
            }
            TransactionContext.transactionContextThreadLocal.get().transaction = transaction;
        }
    }

    public static Transaction getTransaction(String id) throws TransactionNotExistsException {
        return TransactionContext.getTransaction(id, null, false);
    }

    private static Transaction getTransaction(String id, String originator, boolean createIfNotExists) throws TransactionNotExistsException {
        if (useThreadLocal) {
            if (TransactionContext.transactionContextThreadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContextThreadLocal.get().transaction.getId())) {
                if (createIfNotExists) {
                    TransactionContext.createTransaction(id, originator);
                } else {
                    throw new TransactionNotExistsException("Transaction con id [" + id + "] non esiste");
                }
            }
            return TransactionContext.transactionContextThreadLocal.get().transaction;
        }
        Transaction transaction = transactionContextShared.get(id);
        if (transaction == null) {
            if (createIfNotExists) {
                TransactionContext.createTransaction(id, originator);
            } else {
                throw new TransactionNotExistsException("Transaction con id [" + id + "] non esiste");
            }
        }
        return transaction;
    }

    public static Transaction removeTransaction(String id) {
        if (useThreadLocal) {
            Transaction t = TransactionContext.transactionContextThreadLocal.get().transaction;
            TransactionContext.transactionContextThreadLocal.get().transaction = null;
            return t;
        }
        return transactionContextShared.remove(id);
    }

    public static List<String> getIdBustaKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(idBustaFiltroDuplicati);
        return keys;
    }

    public static void registraIdentificativoProtocollo(String idBusta, String idTransazione) throws UtilsException {
        SemaphoreLock lock = semaphoreIdentificativoProtocollo.acquire("registraIdentificativoProtocollo_" + idBusta, idTransazione);
        try {
            if (idBustaFiltroDuplicati.contains(idBusta)) {
                throw new UtilsException("DUPLICATA");
            }
            idBustaFiltroDuplicati.add(idBusta);
        }
        finally {
            semaphoreIdentificativoProtocollo.release(lock, "registraIdentificativoProtocollo_" + idBusta, idTransazione);
        }
    }

    public static boolean containsIdentificativoProtocollo(String idBusta) {
        return idBustaFiltroDuplicati.contains(idBusta);
    }

    public static void removeIdentificativoProtocollo(String idBusta) {
        idBustaFiltroDuplicati.remove(idBusta);
    }
}

