/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.attribute_authority;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.token.AbstractPolicyToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.BasicRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.attribute_authority.TipologiaResponseAttributeAuthority;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class PolicyAttributeAuthority
extends AbstractPolicyToken
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRetrieveAttributeAuthorityResponseParser getRetrieveAttributeAuthorityResponseParser(Logger log) throws TokenException {
        IRetrieveAttributeAuthorityResponseParser parser = null;
        TipologiaResponseAttributeAuthority tipologiaResponse = TipologiaResponseAttributeAuthority.valueOf(this.defaultProperties.getProperty("policy.attributeAuthority.response.type"));
        if (TipologiaResponseAttributeAuthority.custom.equals((Object)tipologiaResponse)) {
            String className = this.defaultProperties.getProperty("policy.attributeAuthority.claimsParser.className");
            if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
                try {
                    return (IRetrieveAttributeAuthorityResponseParser)ClassLoaderUtilities.newInstance((String)className);
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
            String tipo = this.defaultProperties.getProperty("policy.attributeAuthority.claimsParser.pluginType");
            if (tipo == null) throw new TokenException("Deve essere selezionato un plugin per la risposta");
            if (!StringUtils.isNotEmpty((CharSequence)tipo)) throw new TokenException("Deve essere selezionato un plugin per la risposta");
            if ("-".equals(tipo)) throw new TokenException("Deve essere selezionato un plugin per la risposta");
            try {
                PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                return pluginLoader.newAttributeAuthority(tipo);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        String claims = this.defaultProperties.getProperty("policy.attributeAuthority.response.jwt.attributes");
        ArrayList<String> attributesClaims = new ArrayList<String>();
        if (claims == null) return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
        if ("".equals(claims)) return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
        if (claims.contains(",")) {
            String[] tmp = claims.split(",");
            if (tmp == null) return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
            if (tmp.length <= 0) return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
            int i = 0;
            while (i < tmp.length) {
                String claim = tmp[i];
                if (claim != null && !"".equals(claim)) {
                    attributesClaims.add(claim.trim());
                }
                ++i;
            }
            return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
        }
        attributesClaims.add(claims.trim());
        return new BasicRetrieveAttributeAuthorityResponseParser(this.getName(), log, tipologiaResponse, attributesClaims);
    }

    public boolean isSaveErrorInCache() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.saveErrorInCache");
    }

    public String getEndpoint() {
        return this.defaultProperties.getProperty("policy.endpoint.url");
    }

    public boolean isEndpointHttps() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.https.stato") || this.isHttpsAuthentication();
    }

    public boolean isHttpsAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.https.client.stato");
    }

    public boolean isBasicAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.basic.stato");
    }

    public String getBasicAuthenticationUsername() {
        return this.defaultProperties.getProperty("policy.endpoint.basic.username");
    }

    public String getBasicAuthenticationPassword() {
        return this.defaultProperties.getProperty("policy.endpoint.basic.password");
    }

    public boolean isBearerAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.bearer.stato");
    }

    public String getBeareAuthenticationToken() {
        return this.defaultProperties.getProperty("policy.endpoint.bearer.token");
    }

    public String getRequestPosition() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.position");
    }

    public boolean isRequestPositionBearer() {
        return "bearer".equals(this.getRequestPosition());
    }

    public boolean isRequestPositionPayload() {
        return "payload".equals(this.getRequestPosition());
    }

    public boolean isRequestPositionHeader() {
        return "header".equals(this.getRequestPosition());
    }

    public boolean isRequestPositionQuery() {
        return "query".equals(this.getRequestPosition());
    }

    public String getRequestPositionHeaderName() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.position.header");
    }

    public String getRequestPositionQueryParameterName() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.position.queryParameter");
    }

    public HttpRequestMethod getRequestHttpMethod() {
        return HttpRequestMethod.valueOf((String)this.defaultProperties.getProperty("policy.attributeAuthority.httpMethod"));
    }

    public String getRequestType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.type");
    }

    public boolean isRequestJson() {
        return "json".equals(this.getRequestType());
    }

    public boolean isRequestJws() {
        return "jws".equals(this.getRequestType());
    }

    public boolean isRequestCustom() {
        return "custom".equals(this.getRequestType());
    }

    public String getRequestContentType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.contentType");
    }

    public String getRequestDynamicPayloadType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.templateType");
    }

    public boolean isRequestDynamicPayloadJwt() {
        return "jwt".equals(this.getRequestDynamicPayloadType());
    }

    public boolean isRequestDynamicPayloadTemplate() {
        return "template".equals(this.getRequestDynamicPayloadType());
    }

    public boolean isRequestDynamicPayloadFreemarkerTemplate() {
        return "freemarker-template".equals(this.getRequestDynamicPayloadType());
    }

    public boolean isRequestDynamicPayloadVelocityTemplate() {
        return "velocity-template".equals(this.getRequestDynamicPayloadType());
    }

    public String getRequestDynamicPayload() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.template");
    }

    public String getRequestJwtIssuer() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.issuer");
    }

    public String getRequestJwtSubject() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.subject");
    }

    public String getRequestJwtAudience() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.audience");
    }

    public Integer getJwtTtlSeconds() {
        String ttl = this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.expired");
        if (ttl == null || StringUtils.isEmpty((CharSequence)ttl)) {
            ttl = "300";
        }
        return Integer.valueOf(ttl);
    }

    public String getRequestJwtExpired() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.expired");
    }

    public String getRequestJwtClaims() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwt.claims");
    }

    public String getRequestJwtSignAlgorithm() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.algorithm");
    }

    public boolean isRequestJwtSignIncludeKeyIdWithKeyAlias() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.key.id");
        return tmp != null && "true".equals(tmp);
    }

    public boolean isRequestJwtSignIncludeKeyIdCustom() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.key.id");
        return tmp != null && "custom".equals(tmp);
    }

    public String getRequestJwtSignIncludeKeyIdCustom() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.key.id.value");
    }

    public boolean isRequestJwtSignIncludeX509Cert() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.cert");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public String getRequestJwtSignIncludeX509URL() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.x509url");
    }

    public boolean isRequestJwtSignIncludeX509CertSha1() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.cert.sha1");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public boolean isRequestJwtSignIncludeX509CertSha256() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.signature.include.cert.sha256");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public boolean isRequestJwtSignJoseContentType() {
        String tmp = this.defaultProperties.getProperty("policy.attributeAuthority.request.jwsHeader.joseContentType");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public String getRequestJwtSignJoseType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jwsHeader.joseType");
    }

    public String getRequestJwtSignKeystoreType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.type");
    }

    public String getRequestJwtSignKeystoreFile() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.file");
    }

    public String getRequestJwtSignKeystoreFilePublicKey() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.file.public");
    }

    public String getRequestJwtSignKeystoreFileAlgorithm() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.file.algorithm");
    }

    public String getRequestJwtSignKeystorePassword() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.password");
    }

    public String getRequestJwtSignKeystoreByokPolicy() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.keystore.byok");
    }

    public String getRequestJwtSignKeyAlias() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.key.alias");
    }

    public String getRequestJwtSignKeyPassword() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.request.jws.key.password");
    }

    public String getResponseType() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.response.type");
    }

    public boolean isResponseJson() {
        return "json".equals(this.getResponseType());
    }

    public boolean isResponseJws() {
        return "jws".equals(this.getResponseType());
    }

    public boolean isResponseCustom() {
        return "custom".equals(this.getResponseType());
    }

    public boolean isResponseJwsLocationHttp() {
        String location = this.getResponseJwsLocation();
        return location != null && (location.startsWith("http") || location.startsWith("https"));
    }

    public String getResponseJwsLocation() {
        Properties p;
        if (this.properties != null && (p = (Properties)this.properties.get("signatureVerifyPropRefId")) != null) {
            return p.getProperty("rs.security.keystore.file");
        }
        return null;
    }

    public String getResponseJwsOcspPolicy() {
        return this.defaultProperties.getProperty("signatureOCSP");
    }

    public String getResponseJwsCrl() {
        return this.defaultProperties.getProperty("signatureCRL");
    }

    public String getResponseAudience() {
        return this.defaultProperties.getProperty("policy.attributeAuthority.response.jwt.audience");
    }
}

