/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.controllo_traffico.ReadTimeoutConfigurationUtils;
import org.openspcoop2.pdd.core.controllo_traffico.ReadTimeoutContextParam;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifierType;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.jose.JOSEUtils;
import org.slf4j.Logger;

public class TokenKeystoreInjectUtilities {
    private Logger log;
    private RequestInfo requestInfo;
    private IProtocolFactory<?> protocolFactory;
    private Context context;
    private IState state;
    private Busta busta;
    private boolean portaDelegata;
    private PortaDelegata pd;
    private PortaApplicativa pa;
    private PolicyTimeoutConfig policyTimeoutConfig;
    private int connectionTimeout = -1;
    private boolean connectionTimeoutConfigurazioneGlobale = true;
    private int readConnectionTimeout = -1;
    private boolean readConnectionTimeoutConfigurazioneGlobale = true;

    public TokenKeystoreInjectUtilities(Logger log, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory, Context context, IState state, Busta busta) {
        this.log = log;
        this.requestInfo = requestInfo;
        this.protocolFactory = protocolFactory;
        this.context = context;
        this.state = state;
        this.busta = busta;
    }

    public void initTokenPolicyValidazioneJwt(String nomePolicy, boolean portaDelegata, PortaDelegata pd, PortaApplicativa pa, Properties p) {
        this.policyTimeoutConfig = new PolicyTimeoutConfig();
        this.policyTimeoutConfig.setPolicyValidazioneJwt(nomePolicy);
        this.init(portaDelegata, pd, pa, p);
    }

    public void initAttributeAuthorityValidazioneRispostaJwt(String nomePolicy, boolean portaDelegata, PortaDelegata pd, PortaApplicativa pa, Properties p) {
        this.policyTimeoutConfig = new PolicyTimeoutConfig();
        this.policyTimeoutConfig.setAttributeAuthorityResponseJwt(nomePolicy);
        this.init(portaDelegata, pd, pa, p);
    }

    private void init(boolean portaDelegata, PortaDelegata pd, PortaApplicativa pa, Properties p) {
        this.portaDelegata = portaDelegata;
        this.pd = pd;
        this.pa = pa;
        String trustStoreSslConnectionTimeoutPropertyName = "rs.security.keystore.ssl.connectionTimeout";
        String trustStoreSslReadTimeoutPropertyName = "rs.security.keystore.ssl.readTimeout";
        String trustStoreSslConnectionTimeoutProperty = p.getProperty(trustStoreSslConnectionTimeoutPropertyName);
        String trustStoreSslReadTimeoutProperty = p.getProperty(trustStoreSslReadTimeoutPropertyName);
        if (trustStoreSslConnectionTimeoutProperty != null && trustStoreSslReadTimeoutProperty != null) {
            this.connectionTimeout = Integer.valueOf(trustStoreSslConnectionTimeoutProperty);
            this.readConnectionTimeout = Integer.valueOf(trustStoreSslReadTimeoutProperty);
            this.connectionTimeoutConfigurazioneGlobale = false;
            this.readConnectionTimeoutConfigurazioneGlobale = false;
        } else {
            this.connectionTimeout = 10000;
            this.readConnectionTimeout = 120000;
        }
    }

    public void inject(Properties p) throws SecurityException {
        try {
            boolean throwError = true;
            Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(this.busta, this.requestInfo, this.context, this.log);
            JOSEUtils.injectKeystore((RequestInfo)this.requestInfo, dynamicMap, (Properties)p, (Logger)this.log, (boolean)throwError);
        }
        catch (SecurityException e) {
            String msgErrore = ConnettoreBase.readConnectionExceptionMessageFromException(e);
            this.processConnectionTimeoutException(this.connectionTimeout, this.connectionTimeoutConfigurazioneGlobale, (Exception)((Object)e), msgErrore);
            this.processReadTimeoutException(this.readConnectionTimeout, this.readConnectionTimeoutConfigurazioneGlobale, (Exception)((Object)e), msgErrore);
            throw e;
        }
    }

    private void processReadTimeoutException(int timeout, boolean configurazioneGlobale, Exception e, String message) {
        block3: {
            try {
                if (timeout > 0 && ConnettoreBaseWithResponse.containsReadTimeoutException(e, message)) {
                    TimeoutNotifier notifier = this.getTimeoutNotifier(timeout, configurazioneGlobale, TimeoutNotifierType.WAIT_RESPONSE);
                    notifier.notify(timeout);
                }
            }
            catch (Exception error) {
                if (this.log == null) break block3;
                this.log.error("Errore avvenuto durante la registrazione dell'evento di read timeout: " + error.getMessage(), (Throwable)error);
            }
        }
    }

    private void processConnectionTimeoutException(int timeout, boolean configurazioneGlobale, Exception e, String message) {
        block3: {
            try {
                if (timeout > 0 && ConnettoreBaseWithResponse.containsConnectionTimeoutException(e, message)) {
                    TimeoutNotifier notifier = this.getTimeoutNotifier(timeout, configurazioneGlobale, TimeoutNotifierType.CONNECTION);
                    notifier.notify(timeout);
                }
            }
            catch (Exception error) {
                if (this.log == null) break block3;
                this.log.error("Errore avvenuto durante la registrazione dell'evento di connection timeout: " + error.getMessage(), (Throwable)error);
            }
        }
    }

    private TimeoutNotifier getTimeoutNotifier(int timeout, boolean configurazioneGlobale, TimeoutNotifierType type) throws DriverConfigurazioneException, ProtocolException {
        SogliaReadTimeout soglia = null;
        soglia = !this.portaDelegata ? (this.pa != null ? ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, configurazioneGlobale, this.pa, null, this.policyTimeoutConfig, new ReadTimeoutContextParam(this.requestInfo, this.protocolFactory, this.context, this.state)) : ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, false, this.protocolFactory)) : (this.pd != null ? ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, configurazioneGlobale, this.pd, this.policyTimeoutConfig, new ReadTimeoutContextParam(this.requestInfo, this.protocolFactory, this.context, this.state)) : ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, true, this.protocolFactory));
        boolean saveInContext = this.policyTimeoutConfig == null || this.policyTimeoutConfig.getAttributeAuthority() == null && this.policyTimeoutConfig.getAttributeAuthorityResponseJwt() == null;
        return new TimeoutNotifier(this.context, this.protocolFactory, soglia, type, this.log, saveInContext);
    }
}

