/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.slf4j.Logger;

public class InformazioniJWTClientAssertion
extends BaseBean
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String token;
    private Map<String, Serializable> header = null;
    private Map<String, Serializable> payload = null;
    private String jsonHeader;
    private String jsonPayload;

    public InformazioniJWTClientAssertion() {
    }

    public InformazioniJWTClientAssertion(Logger log, String base64, boolean infoNormalizzate) {
        String[] split;
        this.token = base64;
        if (infoNormalizzate && (split = this.token.split("\\.")) != null && split.length > 0) {
            JsonNode root;
            Map readClaims;
            JSONUtils jsonUtils;
            if (split[0] != null) {
                String hdrBase64 = split[0];
                try {
                    this.jsonHeader = new String(Base64Utilities.decode((String)hdrBase64));
                }
                catch (Exception t) {
                    log.error("Decode header failed (hdr: " + hdrBase64 + " assertion:" + base64 + "): " + t.getMessage(), (Throwable)t);
                }
                if (this.jsonHeader != null) {
                    try {
                        jsonUtils = JSONUtils.getInstance();
                        if (jsonUtils.isJson(this.jsonHeader) && (readClaims = jsonUtils.convertToSimpleMap(root = jsonUtils.getAsNode(this.jsonHeader))) != null && readClaims.size() > 0) {
                            this.header = new HashMap<String, Serializable>();
                            this.header.putAll(readClaims);
                        }
                    }
                    catch (Exception t) {
                        log.error("Decode header failed (json: " + this.jsonHeader + "): " + t.getMessage(), (Throwable)t);
                    }
                }
            }
            if (split.length > 1 && split[1] != null) {
                String payloadBase64 = split[1];
                try {
                    this.jsonPayload = new String(Base64Utilities.decode((String)payloadBase64));
                }
                catch (Exception t) {
                    log.error("Decode payload failed (payload: " + payloadBase64 + " assertion:" + base64 + "): " + t.getMessage(), (Throwable)t);
                }
                if (this.jsonPayload != null) {
                    try {
                        jsonUtils = JSONUtils.getInstance();
                        if (jsonUtils.isJson(this.jsonPayload) && (readClaims = jsonUtils.convertToSimpleMap(root = jsonUtils.getAsNode(this.jsonPayload))) != null && readClaims.size() > 0) {
                            this.payload = new HashMap<String, Serializable>();
                            this.payload.putAll(readClaims);
                        }
                    }
                    catch (Exception t) {
                        log.error("Decode payload failed (json: " + this.jsonPayload + "): " + t.getMessage(), (Throwable)t);
                    }
                }
            }
        }
    }

    public Map<String, Serializable> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, Serializable> header) {
        this.header = header;
    }

    public Map<String, Serializable> getPayload() {
        return this.payload;
    }

    public void setPayload(Map<String, Serializable> payload) {
        this.payload = payload;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getJsonHeader() {
        return this.jsonHeader;
    }

    public void setJsonHeader(String jsonHeader) {
        this.jsonHeader = jsonHeader;
    }

    public String getJsonPayload() {
        return this.jsonPayload;
    }

    public void setJsonPayload(String jsonPayload) {
        this.jsonPayload = jsonPayload;
    }
}

