/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.response_caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.context.HeaderParameters;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.context.StringParameter;
import org.openspcoop2.message.context.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public class ResponseCached
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String contentType;
    private byte[] message;
    private long messageLength;
    private byte[] context;
    private Date creazione;
    private Date scadenza;
    private String digest;
    private String uuid;

    public Date getCreazione() {
        return this.creazione;
    }

    public long getAgeInSeconds() {
        long now = DateManager.getTimeMillis();
        long creazione = this.creazione.getTime();
        long diff = now - creazione;
        return diff / 1000L;
    }

    public void setCreazione(Date creazione) {
        this.creazione = creazione;
    }

    public Date getScadenza() {
        return this.scadenza;
    }

    public void setScadenza(Date scadenza) {
        this.scadenza = scadenza;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public long getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(long messageLength) {
        this.messageLength = messageLength;
    }

    public byte[] getContext() {
        return this.context;
    }

    public void setContext(byte[] context) {
        this.context = context;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String print() throws UtilsException {
        StringBuilder bf = new StringBuilder();
        bf.append("UUID: ").append(this.uuid).append("\n\n");
        bf.append("Digest: ").append(this.digest).append("\n\n");
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        String creazione = dateformat.format(this.creazione).replace('_', 'T');
        bf.append("Creazione: ").append(creazione).append("\n\n");
        String scadenza = dateformat.format(this.scadenza).replace('_', 'T');
        bf.append("Scadenza: ").append(scadenza).append("\n\n");
        bf.append("Et\u00e0 (secondi): ").append(this.getAgeInSeconds()).append("\n\n");
        bf.append("Content-Type: ").append(this.contentType).append("\n\n");
        bf.append("Content-Length: ").append(this.messageLength).append("\n\n");
        bf.append("Context: \n").append(new String(this.context)).append("\n\n");
        int max = 20480;
        String message = Utilities.convertToPrintableText((byte[])this.message, (int)max);
        bf.append("Messaggio: \n").append(message);
        return bf.toString();
    }

    public OpenSPCoop2Message toOpenSPCoop2Message(OpenSPCoop2MessageFactory messageFactory, AttachmentsProcessingMode attachmentProcessingMode, String headerCacheKey) throws Exception {
        JaxbDeserializer jaxbDeserializer = new JaxbDeserializer();
        MessageContext msgContext = jaxbDeserializer.readMessageContext(this.context);
        if (msgContext.getMessageType() == null) {
            throw new MessageException("Message Type undefined in context serialized");
        }
        MessageType mt = MessageType.valueOf((String)msgContext.getMessageType());
        if (mt == null) {
            throw new MessageException("MessageType [" + msgContext.getMessageType() + "] unknown");
        }
        if (msgContext.getMessageRole() == null) {
            throw new MessageException("Message Role undefined in context serialized");
        }
        MessageRole mr = MessageRole.valueOf((String)msgContext.getMessageRole());
        if (mr == null) {
            throw new MessageException("MessageRole [" + msgContext.getMessageRole() + "] unknown");
        }
        if (headerCacheKey != null && msgContext.getTransportResponseContext() != null) {
            if (msgContext.getTransportResponseContext().getHeaderParameters() == null) {
                msgContext.getTransportResponseContext().setHeaderParameters(new HeaderParameters());
            }
            StringParameter headerParameter = new StringParameter();
            headerParameter.setNome(headerCacheKey);
            headerParameter.setBase(this.uuid);
            msgContext.getTransportResponseContext().getHeaderParameters().addHeaderParameter(headerParameter);
        }
        NotifierInputStreamParams notifierInputStreamParams = null;
        OpenSPCoop2MessageParseResult pr = null;
        pr = messageFactory.createMessage(mt, mr, this.contentType, this.message, notifierInputStreamParams, attachmentProcessingMode);
        OpenSPCoop2Message msg = pr.getMessage_throwParseException();
        msg.readResourcesFrom(msgContext);
        return msg;
    }

    public static ResponseCached toResponseCached(OpenSPCoop2Message msg, int seconds) throws MessageException, IOException {
        ResponseCached rCached = new ResponseCached();
        long now = DateManager.getTimeMillis();
        long ms = (long)seconds * 1000L;
        Date creazione = new Date(now);
        rCached.setCreazione(creazione);
        Date scadenza = new Date(now + ms);
        rCached.setScadenza(scadenza);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bout, false);
        bout.flush();
        bout.close();
        rCached.setMessage(bout.toByteArray());
        rCached.setMessageLength(bout.size());
        bout = new ByteArrayOutputStream();
        msg.serializeResourcesTo((OutputStream)bout);
        bout.flush();
        bout.close();
        rCached.setContext(bout.toByteArray());
        rCached.setContentType(msg.getContentType());
        return rCached;
    }
}

