/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.keystore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.remote.RemoteKeyIdMode;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.transport.http.HttpLibrary;

public class RemoteStoreConfigPropertiesUtils {
    public static final String PROPERTY_STORE_NAME = "name";
    public static final String PROPERTY_STORE_LABEL = "label";
    public static final String PROPERTY_STORE_TOKEN_POLICY = "tokenPolicy";
    public static final String PROPERTY_STORE_URL = "baseUrl";
    public static final String PROPERTY_STORE_ID_MODE = "keyId.mode";
    public static final String PROPERTY_STORE_ID_PARAMETER_NAME = "keyId.parameter";
    public static final String PROPERTY_STORE_KEY_ALGORITHM = "keyAlgorithm";
    public static final String PROPERTY_READ_TIMEOUT = "readTimeout";
    public static final String PROPERTY_CONNECT_TIMEOUT = "connectTimeout";
    public static final String PROPERTY_HTTP_BASIC_USERNAME = "http.username";
    public static final String PROPERTY_HTTP_BASIC_USERNAME_DISABLE_VALUE = "#none#";
    public static final String PROPERTY_HTTP_BASIC_PASSWORD = "http.password";
    public static final String PROPERTY_HTTP_HEADER_PREFIX = "http.header.";
    public static final String PROPERTY_HTTP_QUERY_PARAMETER_PREFIX = "http.queryParameter.";
    public static final String PROPERTY_HTTPS_HOSTNAME_VERIFIER = "https.hostnameVerifier";
    public static final String PROPERTY_HTTPS_TRUST_ALL_CERTS = "https.trustAllCerts";
    public static final String PROPERTY_HTTPS_TRUST_STORE = "https.trustStore";
    public static final String PROPERTY_HTTPS_TRUST_STORE_PASSWORD = "https.trustStore.password";
    public static final String PROPERTY_HTTPS_TRUST_STORE_TYPE = "https.trustStore.type";
    public static final String PROPERTY_HTTPS_TRUST_STORE_CRL = "https.trustStore.crl";
    public static final String PROPERTY_HTTPS_KEY_STORE = "https.keyStore";
    public static final String PROPERTY_HTTPS_KEY_STORE_PASSWORD = "https.keyStore.password";
    public static final String PROPERTY_HTTPS_KEY_STORE_TYPE = "https.keyStore.type";
    public static final String PROPERTY_HTTPS_KEY_ALIAS = "https.key.alias";
    public static final String PROPERTY_HTTPS_KEY_PASSWORD = "https.key.password";
    public static final String PROPERTY_FORWARD_PROXY_URL = "forwardProxy.url";
    public static final String PROPERTY_FORWARD_PROXY_HEADER = "forwardProxy.header";
    public static final String PROPERTY_FORWARD_PROXY_QUERY_PARAMETER = "forwardProxy.queryParameter";
    public static final String PROPERTY_FORWARD_PROXY_BASE64 = "forwardProxy.base64";
    public static final String PROPERTY_MULTITENANT = "multiTenant";
    public static final String PROPERTY_MULTITENANT_BASEURL_DEFAULT_STRING = "multiTenant.baseUrl.defaultString";
    public static final String PROPERTY_MULTITENANT_BASEURL_PLACEHOLDER = "multiTenant.baseUrl.placeholder";
    public static final String PROPERTY_MULTITENANT_BASEURL_TENANT_STRING = "multiTenant.baseUrl.tenantString";
    public static final String PROPERTY_MULTITENANT_BASE_URL_PREFIX = "multiTenant.baseUrl.";
    public static final String PROPERTY_MULTITENANT_HTTP_BASIC_USERNAME_PREFIX = "multiTenant.http.username.";
    public static final String PROPERTY_MULTITENANT_HTTP_BASIC_PASSWORD_PREFIX = "multiTenant.http.password.";
    public static final String PROPERTY_MULTITENANT_HTTP_HEADER_PREFIX = "multiTenant.http.header.";
    public static final String PROPERTY_MULTITENANT_HTTP_QUERY_PARAMETER_PREFIX = "multiTenant.http.queryParameter.";
    public static final String PROPERTY_HTTP_LIBRARY = "httpLibrary";

    private RemoteStoreConfigPropertiesUtils() {
    }

    public static RemoteStoreConfig read(Properties p, RequestInfo requestInfo) throws KeystoreException {
        String httpLibraryProp;
        String tokenPolicy;
        String storeName = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_NAME, true);
        RemoteStoreConfig config = new RemoteStoreConfig(storeName);
        String storeLabel = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_LABEL, false);
        if (storeLabel != null && StringUtils.isNotEmpty((CharSequence)storeLabel)) {
            config.setStoreLabel(storeLabel);
        }
        if ((tokenPolicy = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_TOKEN_POLICY, false)) != null && StringUtils.isNotEmpty((CharSequence)tokenPolicy)) {
            config.setTokenPolicy(tokenPolicy);
        }
        String storeUrl = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_URL, true);
        config.setBaseUrl(storeUrl);
        String idMode = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_ID_MODE, true);
        RemoteKeyIdMode keyIdMode = RemoteKeyIdMode.valueOf((String)idMode);
        config.setIdMode(keyIdMode);
        switch (keyIdMode) {
            case HEADER: 
            case URL_PARAMETER: {
                config.setParameterName(RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_ID_PARAMETER_NAME, true));
                break;
            }
        }
        String keyAlgo = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_STORE_KEY_ALGORITHM, false);
        if (keyAlgo != null && StringUtils.isNotEmpty((CharSequence)keyAlgo)) {
            config.setKeyAlgorithm(keyAlgo);
        }
        config.setReadTimeout(RemoteStoreConfigPropertiesUtils.getIntProperty(p, PROPERTY_READ_TIMEOUT, false, 15000));
        config.setConnectTimeout(RemoteStoreConfigPropertiesUtils.getIntProperty(p, PROPERTY_CONNECT_TIMEOUT, false, 10000));
        String basicUsername = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTP_BASIC_USERNAME, false);
        if (basicUsername != null && StringUtils.isNotEmpty((CharSequence)basicUsername) && !PROPERTY_HTTP_BASIC_USERNAME_DISABLE_VALUE.equals(basicUsername)) {
            config.setBasicUsername(basicUsername);
            String basicPassword = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTP_BASIC_PASSWORD, false);
            if (basicPassword != null && StringUtils.isNotEmpty((CharSequence)basicPassword)) {
                config.setBasicPassword(basicPassword);
            }
        }
        PropertiesReader pReader = new PropertiesReader(p, false);
        config.setHeaders(RemoteStoreConfigPropertiesUtils.read(pReader, PROPERTY_HTTP_HEADER_PREFIX, config.getHeaders()));
        config.setQueryParameters(RemoteStoreConfigPropertiesUtils.read(pReader, PROPERTY_HTTP_QUERY_PARAMETER_PREFIX, config.getQueryParameters()));
        config.setHostnameVerifier(RemoteStoreConfigPropertiesUtils.getBooleanProperty(p, PROPERTY_HTTPS_HOSTNAME_VERIFIER, false, true));
        RemoteStoreConfigPropertiesUtils.readTrustStoreConfig(config, p, requestInfo);
        RemoteStoreConfigPropertiesUtils.readKeyStoreConfig(config, p, requestInfo);
        RemoteStoreConfigPropertiesUtils.readForwardProxyConfig(config, p);
        List<String> multi = RemoteStoreConfigPropertiesUtils.readMultitenant(p);
        if (multi != null && !multi.isEmpty()) {
            RemoteStoreConfigPropertiesUtils.setMultitenant(config, multi, p, pReader);
        }
        if ((httpLibraryProp = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTP_LIBRARY, false)) != null && StringUtils.isNotEmpty((CharSequence)httpLibraryProp)) {
            config.setHttpLibrary(HttpLibrary.fromName((String)httpLibraryProp));
        }
        return config;
    }

    private static Map<String, String> read(PropertiesReader pReader, String pName, Map<String, String> map) throws KeystoreException {
        Properties properties = null;
        try {
            properties = pReader.readProperties_convertEnvProperties(pName);
        }
        catch (Exception e) {
            throw new KeystoreException("Property '" + pName + ".*' read failed: " + e.getMessage(), e);
        }
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                map.put(name, value);
            }
        }
        return map;
    }

    private static List<String> readMultitenant(Properties p) throws KeystoreException {
        ArrayList<String> l = new ArrayList<String>();
        String multi = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT, false);
        if (multi == null || StringUtils.isEmpty((CharSequence)multi.trim())) {
            return l;
        }
        if (!(multi = multi.trim()).contains(",")) {
            l.add(multi);
            return l;
        }
        String[] tmp = multi.split(",");
        if (tmp != null && tmp.length > 0) {
            for (String s : tmp) {
                if (s == null || !StringUtils.isNotEmpty((CharSequence)s.trim())) continue;
                l.add(s.trim());
            }
        }
        return l;
    }

    private static void setMultitenant(RemoteStoreConfig config, List<String> multi, Properties p, PropertiesReader pReader) throws KeystoreException {
        config.setMultitenant(true);
        String defaultS = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_BASEURL_DEFAULT_STRING, false);
        boolean requiredMultitenantBaseUrlConfig = StringUtils.isNotEmpty((CharSequence)defaultS);
        config.setBaseUrlMultitenantDefaultString(defaultS);
        config.setBaseUrlMultitenantPlaceholder(RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_BASEURL_PLACEHOLDER, requiredMultitenantBaseUrlConfig));
        config.setBaseUrlMultitenantTenantString(RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_BASEURL_TENANT_STRING, requiredMultitenantBaseUrlConfig));
        for (String tenant : multi) {
            RemoteStoreConfigPropertiesUtils.setMultitenantBaseUrl(config, tenant, p);
            RemoteStoreConfigPropertiesUtils.setMultitenantHttpBasic(config, tenant, p);
            RemoteStoreConfigPropertiesUtils.setMultitenantHttp(config, tenant, pReader);
        }
    }

    private static void setMultitenantBaseUrl(RemoteStoreConfig config, String tenant, Properties p) throws KeystoreException {
        String baseUrl = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_BASE_URL_PREFIX + tenant, false);
        if (baseUrl != null) {
            if (config.getMultiTenantBaseUrl() == null) {
                config.setMultiTenantBaseUrl(new HashMap());
            }
            config.getMultiTenantBaseUrl().put(tenant, baseUrl);
        }
    }

    private static void setMultitenantHttpBasic(RemoteStoreConfig config, String tenant, Properties p) throws KeystoreException {
        String password;
        String username = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_HTTP_BASIC_USERNAME_PREFIX + tenant, false);
        if (username != null) {
            if (config.getMultiTenantBasicUsername() == null) {
                config.setMultiTenantBasicUsername(new HashMap());
            }
            config.getMultiTenantBasicUsername().put(tenant, username);
        }
        if ((password = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_MULTITENANT_HTTP_BASIC_PASSWORD_PREFIX + tenant, false)) != null) {
            if (config.getMultiTenantBasicPassword() == null) {
                config.setMultiTenantBasicPassword(new HashMap());
            }
            config.getMultiTenantBasicPassword().put(tenant, password);
        }
    }

    private static void setMultitenantHttp(RemoteStoreConfig config, String tenant, PropertiesReader pReader) throws KeystoreException {
        Map<String, String> query;
        Map<String, String> header = RemoteStoreConfigPropertiesUtils.read(pReader, PROPERTY_MULTITENANT_HTTP_HEADER_PREFIX + tenant + ".", config.getMultiTenantHeaders() != null ? (Map)config.getMultiTenantHeaders().get(tenant) : null);
        if (header != null && !header.isEmpty()) {
            if (config.getMultiTenantHeaders() == null) {
                config.setMultiTenantHeaders(new HashMap());
            }
            config.getMultiTenantHeaders().put(tenant, header);
        }
        if ((query = RemoteStoreConfigPropertiesUtils.read(pReader, PROPERTY_MULTITENANT_HTTP_QUERY_PARAMETER_PREFIX + tenant + ".", config.getMultiTenantQueryParameters() != null ? (Map)config.getMultiTenantQueryParameters().get(tenant) : null)) != null && !query.isEmpty()) {
            if (config.getMultiTenantQueryParameters() == null) {
                config.setMultiTenantQueryParameters(new HashMap());
            }
            config.getMultiTenantQueryParameters().put(tenant, query);
        }
    }

    private static void readTrustStoreConfig(RemoteStoreConfig config, Properties p, RequestInfo requestInfo) throws KeystoreException {
        config.setTrustAllCerts(RemoteStoreConfigPropertiesUtils.getBooleanProperty(p, PROPERTY_HTTPS_TRUST_ALL_CERTS, false, false));
        String trustStorePath = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_TRUST_STORE, false);
        if (trustStorePath != null && StringUtils.isNotEmpty((CharSequence)trustStorePath)) {
            String trustStorePassword = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_TRUST_STORE_PASSWORD, true);
            String trustStoreType = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_TRUST_STORE_TYPE, false);
            if (trustStoreType == null || StringUtils.isEmpty((CharSequence)trustStoreType)) {
                trustStoreType = KeystoreType.JKS.getNome();
            }
            try {
                config.setTrustStore(GestoreKeystoreCaching.getMerlinTruststore(requestInfo, trustStorePath, trustStoreType, trustStorePassword).getTrustStore().getKeystore());
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
            String crl = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_TRUST_STORE_CRL, false);
            if (crl != null && StringUtils.isNotEmpty((CharSequence)crl)) {
                try {
                    config.setCrlStore(GestoreKeystoreCaching.getCRLCertstore(requestInfo, crl).getCertStore());
                }
                catch (Exception e) {
                    throw new KeystoreException(e.getMessage(), e);
                }
            }
        }
    }

    private static void readKeyStoreConfig(RemoteStoreConfig config, Properties p, RequestInfo requestInfo) throws KeystoreException {
        String keyStorePath = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_KEY_STORE, false);
        if (keyStorePath != null && StringUtils.isNotEmpty((CharSequence)keyStorePath)) {
            String keyStorePassword = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_KEY_STORE_PASSWORD, true);
            String keyStoreType = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_KEY_STORE_TYPE, false);
            if (keyStoreType == null || StringUtils.isEmpty((CharSequence)keyStoreType)) {
                keyStoreType = KeystoreType.JKS.getNome();
            }
            String keyPassword = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_KEY_PASSWORD, true);
            String keyAlias = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_HTTPS_KEY_ALIAS, false);
            try {
                config.setKeyStore(GestoreKeystoreCaching.getMerlinKeystore(requestInfo, keyStorePath, keyStoreType, keyStorePassword, keyPassword).getKeyStore().getKeystore());
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
            config.setKeyAlias(keyAlias);
            config.setKeyPassword(keyPassword);
        }
    }

    private static void readForwardProxyConfig(RemoteStoreConfig config, Properties p) throws KeystoreException {
        String forwardProxyUrl = RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_FORWARD_PROXY_URL, false);
        if (forwardProxyUrl != null && StringUtils.isNotEmpty((CharSequence)forwardProxyUrl)) {
            config.setForwardProxyUrl(forwardProxyUrl);
            config.setForwardProxyHeader(RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_FORWARD_PROXY_HEADER, false));
            config.setForwardProxyQueryParameter(RemoteStoreConfigPropertiesUtils.getProperty(p, PROPERTY_FORWARD_PROXY_QUERY_PARAMETER, false));
            if (config.getForwardProxyHeader() == null && config.getForwardProxyQueryParameter() == null) {
                throw new KeystoreException("ForwardProxy property 'forwardProxy.url' require 'forwardProxy.header' o 'forwardProxy.queryParameter'");
            }
            config.setForwardProxyBase64(RemoteStoreConfigPropertiesUtils.getBooleanProperty(p, PROPERTY_FORWARD_PROXY_BASE64, false, true));
        }
    }

    private static String getProperty(Properties p, String name, boolean required) throws KeystoreException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new KeystoreException("Property '" + name + "' notFound");
        }
        return null;
    }

    private static boolean getBooleanProperty(Properties p, String name, boolean required, boolean defaultValue) throws KeystoreException {
        String tmp = RemoteStoreConfigPropertiesUtils.getProperty(p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            try {
                return Boolean.valueOf(tmp);
            }
            catch (Exception t) {
                throw new KeystoreException("Boolean property '" + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        return defaultValue;
    }

    private static int getIntProperty(Properties p, String name, boolean required, int defaultValue) throws KeystoreException {
        String tmp = RemoteStoreConfigPropertiesUtils.getProperty(p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception t) {
                throw new KeystoreException("Boolean property '" + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        return defaultValue;
    }
}

