/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione.peer;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openspcoop2.pdd.core.integrazione.peer.PeerHeaderDescriptor;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.regexp.RegularExpressionPatternCompileMode;

public class RegexpPeerHeaderDescriptor
implements PeerHeaderDescriptor {
    private Pattern pattern = null;
    private String headerName;
    private static ConcurrentMap<String, Pattern> compiledCache;
    private static Queue<String> lruRecord;
    private static int cacheSize;
    private static final Semaphore lockCache;
    private static final Pattern NAME_PARAM_PATTERN;

    public static void initCache(int cacheSize) {
        RegexpPeerHeaderDescriptor.cacheSize = cacheSize;
        lruRecord = new LinkedList<String>();
        compiledCache = new ConcurrentHashMap<String, Pattern>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegexpPeerHeaderDescriptor(String key, String value) {
        this.headerName = key;
        if (compiledCache != null) {
            this.pattern = (Pattern)compiledCache.get(value);
            if (this.pattern == null) {
                try {
                    SemaphoreLock lock = lockCache.acquire("RegexpPeerHeaderDescriptor");
                    try {
                        this.pattern = (Pattern)compiledCache.get(value);
                        if (this.pattern == null) {
                            this.pattern = RegularExpressionEngine.createPatternEngine((String)("^" + value + "$"), (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[0]);
                            compiledCache.put(value, this.pattern);
                            if (compiledCache.size() > cacheSize) {
                                String firstElement = lruRecord.remove();
                                compiledCache.remove(firstElement);
                            }
                            lruRecord.add(value);
                        }
                    }
                    finally {
                        lockCache.release(lock, "RegexpPeerHeaderDescriptor");
                    }
                }
                catch (UtilsException utilsException) {
                    // empty catch block
                }
            }
        }
        if (this.pattern == null) {
            this.pattern = RegularExpressionEngine.createPatternEngine((String)("^" + value + "$"), (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[0]);
        }
    }

    @Override
    public Map<String, String> computeHeaders(Collection<String> headers) {
        HashMap<String, String> newHdrs = new HashMap<String, String>();
        for (String header : headers) {
            try {
                List groups = RegularExpressionEngine.getAllStringMatchPattern((String)header, (Pattern)this.pattern);
                Matcher m = NAME_PARAM_PATTERN.matcher(this.headerName);
                String name = m.replaceAll(g -> {
                    String id = g.group(1);
                    int index = Integer.parseInt(id) - 1;
                    if (index < 0) {
                        return header;
                    }
                    return (String)groups.get(index);
                });
                String value = header;
                newHdrs.put(name, value);
            }
            catch (RegExpException | RegExpNotFoundException throwable) {}
        }
        return newHdrs;
    }

    static {
        lockCache = new Semaphore("PeerHeaderPatternLock");
        NAME_PARAM_PATTERN = Pattern.compile("\\$\\{(\\d+)\\}");
    }
}

