/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.core.handlers.transazioni.LastPositionHandler;
import org.openspcoop2.pdd.core.transazioni.OutRequestStatefulObject;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.core.transazioni.TransactionStatefulNotSupportedException;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class OutRequestHandler
extends LastPositionHandler
implements org.openspcoop2.pdd.core.handlers.OutRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void invoke(OutRequestContext context) throws HandlerException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        if (!op2Properties.isTransazioniEnabled()) {
            return;
        }
        String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        if (context.getTransazioneApplicativoServer() != null) {
            try {
                context.getTransazioneApplicativoServer().setDataUscitaRichiesta(context.getDataElaborazioneMessaggio());
                if (context.getConnettore() == null) return;
                context.getTransazioneApplicativoServer().setLocationConnettore(context.getConnettore().getLocation());
                return;
            }
            catch (Exception e) {
                throw new HandlerException("Errore durante il processamento delle informazioni relative alla consegna per l'applicativo '" + context.getTransazioneApplicativoServer().getServizioApplicativoErogatore() + "': " + e.getMessage(), e);
            }
        }
        if (context.getIntegrazione() != null && context.getIntegrazione().isGestioneStateless() != null && !context.getIntegrazione().isGestioneStateless().booleanValue() && !op2Properties.isTransazioniStatefulEnabled()) {
            throw new HandlerException("Gestione delle transazioni stateful non abilita");
        }
        boolean gestioneStateful = false;
        Transaction tr = null;
        try {
            tr = TransactionContext.getTransaction(idTransazione);
        }
        catch (TransactionNotExistsException e) {
            gestioneStateful = true;
        }
        try {
            OutRequestStatefulObject sObject = null;
            if (tr == null && gestioneStateful) {
                sObject = new OutRequestStatefulObject();
                Date dataElaborazioneMessaggio = context.getDataElaborazioneMessaggio();
                sObject.setDataUscitaRichiesta(dataElaborazioneMessaggio);
                if (context.getProtocollo() != null) {
                    sObject.setScenarioCooperazione(context.getProtocollo().getScenarioCooperazione());
                }
                if (context.getConnettore() != null) {
                    sObject.setTipoConnettore(context.getConnettore().getTipoConnettore());
                    sObject.setLocation(context.getConnettore().getLocation());
                }
                if (context.getIntegrazione() != null) {
                    for (int i = 0; i < context.getIntegrazione().sizeServiziApplicativiErogatori(); ++i) {
                        sObject.addServizioApplicativoErogatore(context.getIntegrazione().getServizioApplicativoErogatore(i));
                    }
                }
            } else {
                if (tr == null) {
                    throw new HandlerException("Transaction is null");
                }
                Date dataElaborazioneMessaggio = context.getDataElaborazioneMessaggio();
                try {
                    tr.setDataUscitaRichiesta(dataElaborazioneMessaggio);
                }
                catch (TransactionDeletedException e) {
                    if (sObject == null) {
                        sObject = new OutRequestStatefulObject();
                    }
                    sObject.setDataUscitaRichiesta(dataElaborazioneMessaggio);
                }
                try {
                    if (context.getProtocollo() != null) {
                        tr.setScenarioCooperazione(context.getProtocollo().getScenarioCooperazione());
                    }
                }
                catch (TransactionDeletedException e) {
                    if (sObject == null) {
                        sObject = new OutRequestStatefulObject();
                    }
                    sObject.setScenarioCooperazione(context.getProtocollo().getScenarioCooperazione());
                }
                if (context.getConnettore() != null) {
                    try {
                        tr.setTipoConnettore(context.getConnettore().getTipoConnettore());
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new OutRequestStatefulObject();
                        }
                        sObject.setTipoConnettore(context.getConnettore().getTipoConnettore());
                    }
                    try {
                        String connettoreRequestUrl = null;
                        String connettoreRequestMethod = null;
                        if (context.getPddContext() != null) {
                            if (context.getPddContext().containsKey(CostantiPdD.CONNETTORE_REQUEST_URL)) {
                                connettoreRequestUrl = (String)context.getPddContext().getObject(CostantiPdD.CONNETTORE_REQUEST_URL);
                            }
                            if (context.getPddContext().containsKey(CostantiPdD.CONNETTORE_REQUEST_METHOD)) {
                                Object o = context.getPddContext().getObject(CostantiPdD.CONNETTORE_REQUEST_METHOD);
                                if (o instanceof String) {
                                    connettoreRequestMethod = (String)o;
                                } else if (o instanceof HttpRequestMethod) {
                                    HttpRequestMethod oConnettoreRequestMethod = (HttpRequestMethod)o;
                                    connettoreRequestMethod = oConnettoreRequestMethod.name();
                                }
                            }
                        }
                        if (!StringUtils.isEmpty(connettoreRequestUrl) && !StringUtils.isEmpty(connettoreRequestMethod)) {
                            tr.setLocation(CostantiPdD.getConnettoreRequest(connettoreRequestUrl, connettoreRequestMethod));
                        } else {
                            tr.setLocation(context.getConnettore().getLocation());
                        }
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new OutRequestStatefulObject();
                        }
                        sObject.setLocation(context.getConnettore().getLocation());
                    }
                }
                if (context.getIntegrazione() != null) {
                    for (int i = 0; i < context.getIntegrazione().sizeServiziApplicativiErogatori(); ++i) {
                        try {
                            tr.addServizioApplicativoErogatore(context.getIntegrazione().getServizioApplicativoErogatore(i));
                            continue;
                        }
                        catch (TransactionDeletedException e) {
                            if (sObject == null) {
                                sObject = new OutRequestStatefulObject();
                            }
                            sObject.addServizioApplicativoErogatore(context.getIntegrazione().getServizioApplicativoErogatore(i));
                        }
                    }
                }
            }
            if (sObject == null) return;
            RepositoryGestioneStateful.addOutRequestStatefulObject(context.getProtocolFactory().getProtocol(), idTransazione, sObject);
            return;
        }
        catch (TransactionStatefulNotSupportedException e) {
            throw new HandlerException("Errore durante il processamento dell'handler: " + e.getMessage(), e);
        }
    }
}

