/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.handler.InRequestProtocolHandlerGestioneControlloTraffico;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.engine.GestoreCredenzialiEngine;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.transazioni.FirstPositionHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;

public class InRequestProtocolHandler
extends FirstPositionHandler
implements org.openspcoop2.pdd.core.handlers.InRequestProtocolHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(InRequestProtocolContext context) throws HandlerException {
        block11: {
            OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
            if (!op2Properties.isTransazioniEnabled()) {
                return;
            }
            String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
            try {
                Transaction tr = TransactionContext.getTransaction(idTransazione);
                if (context.getConnettore() != null) {
                    Credenziali credenziali = context.getConnettore().getCredenziali();
                    String credenzialiFornite = "";
                    if (credenziali != null) {
                        credenzialiFornite = credenziali.toString(false, true, false, true, "", "", "\n");
                    }
                    boolean credenzialiModificateTramiteGateway = false;
                    if (tr.getCredenziali() != null && !tr.getCredenziali().equals(credenzialiFornite)) {
                        credenzialiModificateTramiteGateway = true;
                    }
                    if (credenzialiModificateTramiteGateway && context.getPddContext() != null && context.getPddContext().containsKey(Costanti.IDENTITA_GESTORE_CREDENZIALI)) {
                        String identitaGateway = (String)context.getPddContext().getObject(Costanti.IDENTITA_GESTORE_CREDENZIALI);
                        tr.setCredenziali(GestoreCredenzialiEngine.getDBValuePrefixGatewayCredenziali(identitaGateway, credenzialiFornite));
                    }
                }
                if (!op2Properties.isControlloTrafficoEnabled()) break block11;
                tr.getTempiElaborazione().startControlloTraffico_rateLimiting();
                try {
                    InRequestProtocolHandlerGestioneControlloTraffico inRequestProtocolHandler_gestioneControlloTraffico = new InRequestProtocolHandlerGestioneControlloTraffico();
                    inRequestProtocolHandler_gestioneControlloTraffico.process(context, tr);
                }
                finally {
                    tr.getTempiElaborazione().endControlloTraffico_rateLimiting();
                }
            }
            catch (TransactionDeletedException e) {
                throw new HandlerException(e);
            }
            catch (TransactionNotExistsException e) {
                throw new HandlerException(e);
            }
        }
    }
}

