/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers;

import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;

public class GeneratoreCasualeDate {
    private static GeneratoreCasualeDate generatore = null;
    private static long sogliaMsMin = 1L;
    private static long sogliaMsMax = 20L;
    private static Random randomEngine = null;
    private Date intervalloInizio = null;
    private Date intervalloFine = null;
    private Map<String, Date> dateGenerate = new HashMap<String, Date>();

    public static synchronized void init(Date intervalloInizio, Date intervalloFine, Logger log) {
        if (generatore == null) {
            generatore = new GeneratoreCasualeDate(intervalloInizio, intervalloFine, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeneratoreCasualeDate getGeneratoreCasualeDate() {
        if (generatore != null) return generatore;
        Class<GeneratoreCasualeDate> clazz = GeneratoreCasualeDate.class;
        synchronized (GeneratoreCasualeDate.class) {
            if (generatore != null) return generatore;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    private static synchronized void initRandom() {
        if (randomEngine == null) {
            randomEngine = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (randomEngine == null) {
            GeneratoreCasualeDate.initRandom();
        }
        return randomEngine;
    }

    private static long getRandom(long inizio, long fine) {
        return inizio + Math.round(GeneratoreCasualeDate.getRandom().nextDouble() * (double)(fine - inizio));
    }

    private GeneratoreCasualeDate(Date intervalloInizio, Date intervalloFine, Logger log) {
        this.intervalloInizio = intervalloInizio;
        this.intervalloFine = intervalloFine;
        String msg = "Generatore di date causauli dei log attivato con intervallo [" + String.valueOf(this.intervalloInizio) + "] - [" + String.valueOf(this.intervalloFine) + "]";
        log.info(msg);
    }

    private Date getNextDate(String idCluster) {
        Date nextDate = null;
        if (this.dateGenerate.containsKey(idCluster)) {
            Date data = this.dateGenerate.remove(idCluster);
            nextDate = new Date(data.getTime() + GeneratoreCasualeDate.getRandom(sogliaMsMin, sogliaMsMax));
        } else {
            nextDate = new Date(GeneratoreCasualeDate.getRandom(this.intervalloInizio.getTime(), this.intervalloFine.getTime()));
        }
        this.dateGenerate.put(idCluster, nextDate);
        return nextDate;
    }

    public Date getProssimaData(String idCluster) {
        return this.getNextDate(idCluster);
    }

    public void releaseResource(String idCluster) {
        this.dateGenerate.remove(idCluster);
    }
}

