/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic.test;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.dynamic.test.DynamicTest;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

class ClientTestThread
implements Runnable {
    private static final String EXPECTED_JSON_TH_NAME = "THREADNAME";
    private static final String EXPECTED_JSON = "{\n    \"Thread\": \"THREADNAME\",\n    \"Prova\": \"TEST\"\n}";
    private Template template;
    private java.util.Map<String, Object> dynamicMap;
    private String threadName;
    private boolean freemarker;
    private boolean finished = false;
    private boolean error = false;
    private Exception exception = null;

    ClientTestThread(String threadName, Template template, boolean freemarker) {
        this.threadName = threadName;
        this.template = template;
        this.dynamicMap = new HashMap<String, Object>();
        ConnettoreMsg connettoreMsg = new ConnettoreMsg();
        PdDContext pddContext = new PdDContext();
        MapKey THREADNAME = Map.newMapKey((String)"thread-name");
        pddContext.addObject(THREADNAME, this.threadName);
        DynamicInfo dInfo = new DynamicInfo(connettoreMsg, pddContext);
        Logger log = LoggerWrapperFactory.getLogger(DynamicTest.class);
        DynamicUtils.fillDynamicMap(log, this.dynamicMap, dInfo);
        this.freemarker = freemarker;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (this.freemarker) {
                DynamicUtils.convertFreeMarkerTemplate(this.template, this.dynamicMap, bout);
            } else {
                DynamicUtils.convertVelocityTemplate(this.template, this.dynamicMap, bout);
            }
            bout.flush();
            bout.close();
            String value = bout.toString();
            System.out.println("[" + this.threadName + "] Test conversione xml2json via " + (this.freemarker ? "freemarker" : "velocity") + ": \n" + value);
            String expected = EXPECTED_JSON.replace(EXPECTED_JSON_TH_NAME, this.threadName);
            if (!expected.equals(value)) {
                throw new Exception("(" + this.threadName + ") Expected value '" + expected + "', found '" + value + "'");
            }
        }
        catch (Exception e) {
            this.error = true;
            this.exception = e;
        }
        finally {
            this.finished = true;
        }
    }
}

