/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.util.List;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class URLRegExpExtractor {
    private Logger log;
    private String url;

    public URLRegExpExtractor(String url, Logger log) {
        this.url = url;
        this.log = log;
    }

    public boolean match(String pattern) throws DynamicException {
        String v = this.read(pattern);
        return v != null && !"".equals(v);
    }

    public String read(String pattern) throws DynamicException {
        String valore = null;
        try {
            valore = RegularExpressionEngine.getStringMatchPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug("Estrazione '" + pattern + "' non ha trovato risultati: " + e.getMessage(), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException("Estrazione '" + pattern + "' fallita: " + e.getMessage(), e);
        }
        return valore;
    }

    public List<String> readList(String pattern) throws DynamicException {
        List valore = null;
        try {
            valore = RegularExpressionEngine.getAllStringMatchPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug("Estrazione '" + pattern + "' non ha trovato risultati: " + e.getMessage(), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException("Estrazione '" + pattern + "' fallita: " + e.getMessage(), e);
        }
        return valore;
    }

    public boolean found(String pattern) throws DynamicException {
        String v = this.find(pattern);
        return v != null && !"".equals(v);
    }

    public String find(String pattern) throws DynamicException {
        String valore = null;
        try {
            valore = RegularExpressionEngine.getStringFindPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug("Estrazione '" + pattern + "' non ha trovato risultati: " + e.getMessage(), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException("Estrazione '" + pattern + "' fallita: " + e.getMessage(), e);
        }
        return valore;
    }

    public List<String> findAll(String pattern) throws DynamicException {
        List valore = null;
        try {
            valore = RegularExpressionEngine.getAllStringFindPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug("Estrazione '" + pattern + "' non ha trovato risultati: " + e.getMessage(), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException("Estrazione '" + pattern + "' fallita: " + e.getMessage(), e);
        }
        return valore;
    }
}

