/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.io.Serializable;
import java.util.Map;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ZipTemplate;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;

public class Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private byte[] template;
    private Map<String, byte[]> templateIncludes;
    private boolean correctClassBackwardCompatibility = false;
    private transient freemarker.template.Template templateFreeMarker;
    private transient org.apache.velocity.Template templateVelocity;
    private ZipTemplate templateZip;
    private transient Semaphore _lock = null;

    public Template(String name, byte[] template) {
        this(name, template, null);
    }

    public Template(String name, byte[] template, Map<String, byte[]> templateIncludes) {
        this.name = name;
        this.template = template;
        this.templateIncludes = templateIncludes;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public Map<String, byte[]> getTemplateIncludes() {
        return this.templateIncludes;
    }

    private synchronized void _correctClassBackwardCompatibility() {
        if (!this.correctClassBackwardCompatibility) {
            Map<String, String> map = null;
            OpenSPCoop2Properties op2 = OpenSPCoop2Properties.getInstance();
            if (op2 != null) {
                map = op2.getTrasformazioni_backwardCompatibility();
            }
            if (map != null && !map.isEmpty()) {
                if (this.template != null) {
                    boolean modify = false;
                    String s = new String(this.template);
                    for (String key : map.keySet()) {
                        if (!s.contains(key)) continue;
                        String newValue = map.get(key);
                        s = s.replaceAll(key, newValue);
                        modify = true;
                    }
                    if (modify) {
                        this.template = s.getBytes();
                    }
                }
                if (this.templateIncludes != null && !this.templateIncludes.isEmpty()) {
                    for (String idTemplate : this.templateIncludes.keySet()) {
                        byte[] template = this.templateIncludes.get(idTemplate);
                        if (template == null) continue;
                        boolean modify = false;
                        String s = new String(template);
                        for (String key : map.keySet()) {
                            if (!s.contains(key)) continue;
                            String newValue = map.get(key);
                            s = s.replaceAll(key, newValue);
                            modify = true;
                        }
                        if (!modify) continue;
                        template = s.getBytes();
                        this.templateIncludes.put(idTemplate, template);
                    }
                }
            }
            this.correctClassBackwardCompatibility = true;
        }
    }

    private void correctClassBackwardCompatibility() {
        if (!this.correctClassBackwardCompatibility) {
            this._correctClassBackwardCompatibility();
        }
    }

    private synchronized void initLock() {
        if (this._lock == null) {
            this._lock = new Semaphore("Template");
        }
    }

    public Semaphore getLock() {
        if (this._lock == null) {
            this.initLock();
        }
        return this._lock;
    }

    private void initTemplateFreeMarker() throws DynamicException {
        if (this.templateFreeMarker == null) {
            SemaphoreLock lock = null;
            try {
                lock = this.getLock().acquire("initTemplateFreeMarker");
            }
            catch (Throwable t) {
                throw new DynamicException(t.getMessage(), t);
            }
            try {
                this.correctClassBackwardCompatibility();
                this.templateFreeMarker = DynamicUtils.buildFreeMarkerTemplate(this);
            }
            finally {
                this.getLock().release(lock, "initTemplateFreeMarker");
            }
        }
    }

    public freemarker.template.Template getTemplateFreeMarker() throws DynamicException {
        if (this.templateFreeMarker == null) {
            this.initTemplateFreeMarker();
        }
        return this.templateFreeMarker;
    }

    private void initTemplateVelocity() throws DynamicException {
        if (this.templateVelocity == null) {
            SemaphoreLock lock = null;
            try {
                lock = this.getLock().acquire("initTemplateVelocity");
            }
            catch (Throwable t) {
                throw new DynamicException(t.getMessage(), t);
            }
            try {
                this.correctClassBackwardCompatibility();
                this.templateVelocity = DynamicUtils.buildVelocityTemplate(this);
            }
            finally {
                this.getLock().release(lock, "initTemplateVelocity");
            }
        }
    }

    public org.apache.velocity.Template getTemplateVelocity() throws DynamicException {
        if (this.templateVelocity == null) {
            this.initTemplateVelocity();
        }
        return this.templateVelocity;
    }

    private void initTemplateZip() throws DynamicException {
        if (this.templateZip == null) {
            SemaphoreLock lock = null;
            try {
                lock = this.getLock().acquire("initTemplateZip");
            }
            catch (Throwable t) {
                throw new DynamicException(t.getMessage(), t);
            }
            try {
                this.templateZip = new ZipTemplate(this.name, this.template);
            }
            finally {
                this.getLock().release(lock, "initTemplateZip");
            }
        }
    }

    public ZipTemplate getZipTemplate() throws DynamicException {
        if (this.templateZip == null) {
            this.initTemplateZip();
        }
        return this.templateZip;
    }
}

