/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.protocol.sdk.Context;
import org.w3c.dom.Element;

public class MessageContent {
    private OpenSPCoop2MessageFactory messageFactory;
    private OpenSPCoop2SoapMessage soapMessage;
    private OpenSPCoop2RestXmlMessage restXmlMessage;
    private OpenSPCoop2RestJsonMessage restJsonMessage;
    private OpenSPCoop2RestMimeMultipartMessage restMultipartMessage;
    private String idTransazione;
    private boolean bufferMessage_readOnly;
    private Element element = null;
    private String elementJson = null;

    public MessageContent(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessage_readOnly, Context context) {
        this.soapMessage = soapMessage;
        this.init((OpenSPCoop2Message)this.soapMessage, bufferMessage_readOnly, context);
    }

    public MessageContent(OpenSPCoop2RestXmlMessage restXmlMessage, boolean bufferMessage_readOnly, Context context) {
        this.restXmlMessage = restXmlMessage;
        this.init((OpenSPCoop2Message)this.restXmlMessage, bufferMessage_readOnly, context);
    }

    public MessageContent(OpenSPCoop2RestJsonMessage restJsonMessage, boolean bufferMessage_readOnly, Context context) {
        this.restJsonMessage = restJsonMessage;
        this.init((OpenSPCoop2Message)this.restJsonMessage, bufferMessage_readOnly, context);
    }

    public MessageContent(OpenSPCoop2RestMimeMultipartMessage restMultipartMessage, boolean bufferMessage_readOnly, Context context) {
        this.restMultipartMessage = restMultipartMessage;
        this.init((OpenSPCoop2Message)this.restMultipartMessage, bufferMessage_readOnly, context);
    }

    private void init(OpenSPCoop2Message msg, boolean bufferMessage_readOnly, Context context) {
        this.messageFactory = msg.getFactory();
        this.bufferMessage_readOnly = bufferMessage_readOnly;
        if (context != null) {
            this.idTransazione = (String)context.getObject(Costanti.ID_TRANSAZIONE);
        }
    }

    public OpenSPCoop2MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public boolean isJson() {
        return this.restJsonMessage != null;
    }

    public OpenSPCoop2RestJsonMessage getJsonMessage() {
        return this.restJsonMessage;
    }

    public boolean isXml() {
        return this.soapMessage != null || this.restXmlMessage != null;
    }

    public boolean isRestMultipart() {
        return this.restMultipartMessage != null;
    }

    public Element getElement() throws MessageException, MessageNotSupportedException {
        if (this.element != null) {
            return this.element;
        }
        boolean checkSoapBodyEmpty = false;
        if (this.soapMessage != null) {
            this.element = MessageUtils.getContentElement((OpenSPCoop2Message)this.soapMessage, (boolean)checkSoapBodyEmpty, (boolean)this.bufferMessage_readOnly, (String)this.idTransazione);
        } else if (this.restXmlMessage != null) {
            this.element = MessageUtils.getContentElement((OpenSPCoop2Message)this.restXmlMessage, (boolean)checkSoapBodyEmpty, (boolean)this.bufferMessage_readOnly, (String)this.idTransazione);
        } else if (this.restMultipartMessage != null) {
            this.element = MessageUtils.getContentElement((OpenSPCoop2Message)this.restMultipartMessage, (boolean)checkSoapBodyEmpty, (boolean)this.bufferMessage_readOnly, (String)this.idTransazione);
        }
        return this.element;
    }

    public String getElementJson() throws MessageException, MessageNotSupportedException {
        if (this.elementJson != null) {
            return this.elementJson;
        }
        if (this.restJsonMessage != null) {
            this.elementJson = MessageUtils.getContentString((OpenSPCoop2Message)this.restJsonMessage, (boolean)this.bufferMessage_readOnly, (String)this.idTransazione);
        } else if (this.restMultipartMessage != null) {
            this.elementJson = MessageUtils.getContentString((OpenSPCoop2Message)this.restMultipartMessage, (boolean)this.bufferMessage_readOnly, (String)this.idTransazione);
        }
        return this.elementJson;
    }

    public void setUpdatable() throws MessageException {
        OpenSPCoop2SoapMessage msg = null;
        if (this.soapMessage != null) {
            msg = this.soapMessage;
        } else if (this.restXmlMessage != null) {
            msg = this.restXmlMessage;
        } else if (this.restJsonMessage != null) {
            msg = this.restJsonMessage;
        } else if (this.restMultipartMessage != null) {
            msg = this.restMultipartMessage;
        }
        MessageUtils.setUpdatable((OpenSPCoop2Message)msg);
    }
}

