/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneCodifica;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneSorgente;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;

public class InformazioniIntegrazione
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static boolean logError = true;
    private transient Logger log;
    private Map<String, Serializable> integrationInfo;
    private Map<String, Object> claims = new HashMap<String, Object>();
    private String raw;
    private byte[] rawDecoded;
    private InformazioniIntegrazioneSorgente sourceType;
    private String sourceName;
    private InformazioniIntegrazioneCodifica sourceEncodeType;
    private boolean sourceRequired;

    public InformazioniIntegrazione() {
    }

    public InformazioniIntegrazione(InformazioniIntegrazioneSorgente sourceType, String sourceName, InformazioniIntegrazioneCodifica sourceEncodeType, boolean sourceRequired, Logger log, TransportRequestContext transportRequestContext) throws Exception {
        this.init(sourceType, sourceName, sourceEncodeType, sourceRequired, log, transportRequestContext, null);
    }

    public InformazioniIntegrazione(InformazioniIntegrazioneSorgente sourceType, String sourceName, InformazioniIntegrazioneCodifica sourceEncodeType, boolean sourceRequired, Logger log, TransportResponseContext transportResponseContext) throws Exception {
        this.init(sourceType, sourceName, sourceEncodeType, sourceRequired, log, null, transportResponseContext);
    }

    public static boolean isLogError() {
        return logError;
    }

    public static void setLogError(boolean logError) {
        InformazioniIntegrazione.logError = logError;
    }

    private void init(InformazioniIntegrazioneSorgente sourceType, String sourceName, InformazioniIntegrazioneCodifica sourceEncodeType, boolean sourceRequired, Logger log, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext) throws Exception {
        Map readClaims;
        this.log = log;
        this.sourceType = sourceType;
        this.sourceName = sourceName;
        this.sourceEncodeType = sourceEncodeType;
        this.sourceRequired = sourceRequired;
        if (this.sourceType == null) {
            throw new Exception("Source type undefined");
        }
        if (this.sourceName == null) {
            throw new Exception("Source name undefined");
        }
        if (this.sourceEncodeType == null) {
            throw new Exception("Source encode type undefined");
        }
        if (transportRequestContext == null && transportResponseContext == null) {
            throw new Exception("TransportContext undefined");
        }
        List values = null;
        String debugName = null;
        switch (this.sourceType) {
            case http_header: {
                if (transportRequestContext != null) {
                    values = transportRequestContext.getHeaderValues(this.sourceName);
                } else if (transportResponseContext != null) {
                    values = transportResponseContext.getHeaderValues(this.sourceName);
                }
                debugName = "http header " + this.sourceName;
                break;
            }
            case query_parameter: {
                if (transportRequestContext == null) {
                    throw new Exception("QueryParameter unsupported for transport response context");
                }
                values = transportRequestContext.getParameterValues(this.sourceName);
                debugName = "query parameter " + this.sourceName;
            }
        }
        if (values == null || values.isEmpty()) {
            if (this.sourceRequired) {
                throw new Exception("Required " + debugName + " not found");
            }
            this.claims = new HashMap<String, Object>();
            this.integrationInfo = new HashMap<String, Serializable>();
            return;
        }
        if (values.size() > 1) {
            throw new Exception("Found more than one " + debugName + " (" + values.size() + ")");
        }
        this.raw = (String)values.get(0);
        if (this.raw == null || StringUtils.isEmpty((CharSequence)this.raw)) {
            throw new Exception("Found empty " + debugName);
        }
        switch (this.sourceEncodeType) {
            case plain: {
                this.rawDecoded = this.raw.getBytes();
                break;
            }
            case base64: {
                try {
                    this.rawDecoded = Base64Utilities.decode((String)this.raw);
                    break;
                }
                catch (Throwable t) {
                    throw new Exception("Base64 decode " + debugName + " failed: " + t.getMessage(), t);
                }
            }
            case hex: {
                try {
                    this.rawDecoded = HexBinaryUtilities.decode((String)this.raw);
                    break;
                }
                catch (Throwable t) {
                    throw new Exception("HEX decode " + debugName + " failed: " + t.getMessage(), t);
                }
            }
            case jwt: {
                try {
                    String[] split = this.raw.split("\\.");
                    if (split == null || split.length < 2) {
                        throw new Exception("uncorrect jwt format");
                    }
                    String payload = split[1];
                    if (payload == null || StringUtils.isEmpty((CharSequence)payload)) {
                        throw new Exception("Found empty jwt payload in " + debugName);
                    }
                    this.rawDecoded = Base64Utilities.decode((String)payload);
                    break;
                }
                catch (Throwable t) {
                    throw new Exception("JWT decode " + debugName + " failed: " + t.getMessage(), t);
                }
            }
        }
        JSONUtils jsonUtils = JSONUtils.getInstance();
        JsonNode root = null;
        if (logError) {
            try {
                root = jsonUtils.getAsNode(this.rawDecoded);
            }
            catch (Throwable t) {
                throw new Exception("Content in " + debugName + " isn't a json: " + t.getMessage(), t);
            }
        } else if (jsonUtils.isJson(this.rawDecoded)) {
            root = jsonUtils.getAsNode(this.rawDecoded);
        }
        if (root != null && (readClaims = jsonUtils.convertToSimpleMap(root)) != null && readClaims.size() > 0) {
            this.claims.putAll(readClaims);
        }
        this.integrationInfo = jsonUtils.convertToMap(log, debugName, this.rawDecoded);
    }

    public Map<String, Serializable> getIntegrationInfo() {
        return this.integrationInfo;
    }

    public Map<String, Serializable> getInfo() {
        return this.integrationInfo;
    }

    public void setIntegrationInfo(Map<String, Serializable> integrationInfo) {
        this.integrationInfo = integrationInfo;
    }

    public List<String> getInfoNames() {
        return this.getIntegrationInfoNames();
    }

    public List<String> getIntegrationInfoNames() {
        if (this.integrationInfo != null && !this.integrationInfo.isEmpty()) {
            ArrayList<String> attributesNames = new ArrayList<String>();
            for (String attrName : this.integrationInfo.keySet()) {
                attributesNames.add(attrName);
            }
            Collections.sort(attributesNames);
            return attributesNames;
        }
        return null;
    }

    public String getClaim(String name) throws Exception {
        if (name == null) {
            throw new Exception("Claim name is null");
        }
        String pattern = "$.." + name;
        return JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)this.getRawDecodedAsString(), (String)pattern, (Logger)this.log);
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public void setRawDecoded(byte[] rawDecoded) {
        this.rawDecoded = rawDecoded;
    }

    public byte[] getRawDecoded() {
        return this.rawDecoded;
    }

    public String getRawDecodedAsString() {
        return new String(this.rawDecoded);
    }

    public InformazioniIntegrazioneSorgente getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(InformazioniIntegrazioneSorgente sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceEncodeType(InformazioniIntegrazioneCodifica sourceEncodeType) {
        this.sourceEncodeType = sourceEncodeType;
    }

    public void setSourceRequired(boolean sourceRequired) {
        this.sourceRequired = sourceRequired;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public InformazioniIntegrazioneCodifica getSourceEncodeType() {
        return this.sourceEncodeType;
    }

    public boolean isSourceRequired() {
        return this.sourceRequired;
    }
}

