/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.slf4j.Logger;

public class DynamicMapBuilderUtils {
    private DynamicMapBuilderUtils() {
    }

    public static void injectDynamicMap(Busta busta, RequestInfo requestInfo, Map<Object> contextParam, Logger log) {
        Context context = null;
        if (contextParam instanceof Context) {
            context = (Context)contextParam;
        }
        java.util.Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, context, log);
        if (context != null) {
            context.put(Costanti.DYNAMIC_MAP_CONTEXT, dynamicMap);
        }
        if (requestInfo != null) {
            requestInfo.setDynamicMap(dynamicMap);
        }
    }

    public static java.util.Map<String, Object> readDynamicMap(Map<Object> context) {
        return Costanti.readDynamicMap(context);
    }

    public static java.util.Map<String, Object> buildDynamicMap(Busta busta, RequestInfo requestInfo, Context pddContext, Logger log) {
        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
        java.util.Map pTrasporto = null;
        String urlInvocazione = null;
        java.util.Map pQuery = null;
        java.util.Map<String, List<String>> pForm = null;
        if (requestInfo != null && requestInfo.getProtocolContext() != null) {
            FormUrlEncodedHttpServletRequest formServlet;
            URLProtocolContext httpServletContext;
            HttpServletRequest httpServletRequest;
            pTrasporto = requestInfo.getProtocolContext().getHeaders();
            urlInvocazione = requestInfo.getProtocolContext().getUrlInvocazione_formBased();
            pQuery = requestInfo.getProtocolContext().getParameters();
            if (requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = requestInfo.getProtocolContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                pForm = formServlet.getFormUrlEncodedParametersValues();
            }
        }
        ErrorHandler errorHandler = new ErrorHandler();
        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, null, null, busta, pTrasporto, pQuery, pForm, errorHandler);
        return dynamicMap;
    }

    public static String convertDynamicPropertyValue(String v, String nome, java.util.Map<String, Object> dynamicMap, Context context) throws TokenException {
        if (v != null && !"".equals(v) && dynamicMap != null) {
            try {
                v = DynamicUtils.convertDynamicPropertyValue(nome + ".gwt", v, dynamicMap, context);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        return v;
    }
}

