/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.util.Map;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.slf4j.Logger;

public class DynamicConfig {
    private Logger log;
    private Map<String, Object> dynamicMap;
    private RequestInfo requestInfo;
    private Busta busta;
    private IDServizio configId = null;
    private Map<String, String> mapConfig = null;
    private IDSoggetto providerOrganizationId;
    private Map<String, String> mapProviderOrganizationConfig = null;
    private IDSoggetto clientOrganizationId;
    private Map<String, String> mapClientOrganizationConfig = null;
    private IDServizioApplicativo clientApplicationId;
    private Map<String, String> mapClientApplicationConfig = null;
    private IDSoggetto tokenTokenClientOrganizationId;
    private Map<String, String> mapTokenClientOrganizationConfig = null;
    private IDServizioApplicativo tokenTokenClientApplicationId;
    private Map<String, String> mapTokenClientApplicationConfig = null;

    public DynamicConfig(Logger log, Map<String, Object> dynamicMap, RequestInfo requestInfo, Busta busta) {
        this.log = log;
        this.dynamicMap = dynamicMap;
        this.requestInfo = requestInfo;
        this.busta = busta;
    }

    private IDServizio getConfigId() {
        Object o;
        if (this.configId != null) {
            return this.configId;
        }
        if (this.requestInfo != null && this.requestInfo.getIdServizio() != null) {
            this.configId = this.requestInfo.getIdServizio();
        } else if (this.busta == null && this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("busta")) != null && o instanceof Busta) {
            this.busta = (Busta)o;
        }
        if (this.configId == null && this.busta != null) {
            try {
                this.configId = IDServizioFactory.getInstance().getIDServizioFromValues(this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getTipoDestinatario(), this.busta.getDestinatario(), this.busta.getVersioneServizio().intValue());
            }
            catch (Exception e) {
                this.log.error("Creazione IDServizio per dynamic config fallita: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.configId;
    }

    private Map<String, String> getMapConfig() {
        Object o;
        if (this.mapConfig != null) {
            return this.mapConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("config")) != null && o instanceof Map) {
            this.mapConfig = (Map)o;
        }
        return this.mapConfig;
    }

    private IDSoggetto getProviderOrganizationId() {
        Object o;
        if (this.providerOrganizationId != null) {
            return this.providerOrganizationId;
        }
        if (this.requestInfo != null && this.requestInfo.getIdServizio() != null && this.requestInfo.getIdServizio().getSoggettoErogatore() != null) {
            this.providerOrganizationId = this.requestInfo.getIdServizio().getSoggettoErogatore();
        } else if (this.busta == null && this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("busta")) != null && o instanceof Busta) {
            this.busta = (Busta)o;
        }
        if (this.providerOrganizationId == null && this.busta != null) {
            try {
                this.providerOrganizationId = new IDSoggetto(this.busta.getTipoDestinatario(), this.busta.getDestinatario());
            }
            catch (Exception e) {
                this.log.error("Creazione IDSoggetto provider per dynamic config fallita: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.providerOrganizationId;
    }

    private Map<String, String> getMapProviderOrganizationConfig() {
        Object o;
        if (this.mapProviderOrganizationConfig != null) {
            return this.mapProviderOrganizationConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("providerOrganizationConfig")) != null && o instanceof Map) {
            this.mapProviderOrganizationConfig = (Map)o;
        }
        return this.mapProviderOrganizationConfig;
    }

    private IDSoggetto getClientOrganizationId() {
        Object o;
        if (this.clientOrganizationId != null) {
            return this.clientOrganizationId;
        }
        if (this.requestInfo != null && this.requestInfo.getFruitore() != null) {
            this.clientOrganizationId = this.requestInfo.getFruitore();
        } else if (this.busta == null && this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("busta")) != null && o instanceof Busta) {
            this.busta = (Busta)o;
        }
        if (this.clientOrganizationId == null && this.busta != null) {
            this.clientOrganizationId = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
        }
        return this.clientOrganizationId;
    }

    private Map<String, String> getMapClientOrganizationConfig() {
        Object o;
        if (this.mapClientOrganizationConfig != null) {
            return this.mapClientOrganizationConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("clientOrganizationConfig")) != null && o instanceof Map) {
            this.mapClientOrganizationConfig = (Map)o;
        }
        return this.mapClientOrganizationConfig;
    }

    private IDServizioApplicativo getClientApplicationId() {
        Object o;
        if (this.clientApplicationId != null) {
            return this.clientApplicationId;
        }
        if (this.busta == null && this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("busta")) != null && o instanceof Busta) {
            this.busta = (Busta)o;
        }
        if (this.clientOrganizationId == null && this.busta != null && this.busta.getServizioApplicativoFruitore() != null) {
            IDSoggetto organization = this.getClientOrganizationId();
            this.clientApplicationId = new IDServizioApplicativo();
            this.clientApplicationId.setIdSoggettoProprietario(organization);
            this.clientApplicationId.setNome(this.busta.getServizioApplicativoFruitore());
        }
        return this.clientApplicationId;
    }

    private Map<String, String> getMapClientApplicationConfig() {
        Object o;
        if (this.mapClientApplicationConfig != null) {
            return this.mapClientApplicationConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("clientApplicationConfig")) != null && o instanceof Map) {
            this.mapClientApplicationConfig = (Map)o;
        }
        return this.mapClientApplicationConfig;
    }

    private IDSoggetto getTokenClientOrganizationId() {
        Object o;
        if (this.tokenTokenClientOrganizationId != null) {
            return this.tokenTokenClientOrganizationId;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("tokenClient")) != null && o instanceof IDServizioApplicativo) {
            this.tokenTokenClientApplicationId = (IDServizioApplicativo)o;
            this.tokenTokenClientOrganizationId = this.tokenTokenClientApplicationId.getIdSoggettoProprietario();
        }
        return this.tokenTokenClientOrganizationId;
    }

    private Map<String, String> getMapTokenClientOrganizationConfig() {
        Object o;
        if (this.mapTokenClientOrganizationConfig != null) {
            return this.mapTokenClientOrganizationConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("tokenClientOrganizationConfig")) != null && o instanceof Map) {
            this.mapTokenClientOrganizationConfig = (Map)o;
        }
        return this.mapTokenClientOrganizationConfig;
    }

    private IDServizioApplicativo getTokenClientApplicationId() {
        Object o;
        if (this.tokenTokenClientApplicationId != null) {
            return this.tokenTokenClientApplicationId;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("tokenClient")) != null && o instanceof IDServizioApplicativo) {
            this.tokenTokenClientApplicationId = (IDServizioApplicativo)o;
            this.tokenTokenClientOrganizationId = this.tokenTokenClientApplicationId.getIdSoggettoProprietario();
        }
        return this.tokenTokenClientApplicationId;
    }

    private Map<String, String> getMapTokenClientApplicationConfig() {
        Object o;
        if (this.mapTokenClientApplicationConfig != null) {
            return this.mapTokenClientApplicationConfig;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty() && (o = this.dynamicMap.get("tokenClientApplicationConfig")) != null && o instanceof Map) {
            this.mapTokenClientApplicationConfig = (Map)o;
        }
        return this.mapTokenClientApplicationConfig;
    }

    public String getApi(String pName) throws DynamicException {
        return this.getValue(this.getMapConfig(), pName);
    }

    public String getProviderOrganization(String pName) throws DynamicException {
        return this.getValue(this.getMapProviderOrganizationConfig(), pName);
    }

    public String getClientApplication(String pName) throws DynamicException {
        return this.getValue(this.getMapClientApplicationConfig(), pName);
    }

    public String getClientOrganization(String pName) throws DynamicException {
        return this.getValue(this.getMapClientOrganizationConfig(), pName);
    }

    public String getTokenClientApplication(String pName) throws DynamicException {
        return this.getValue(this.getMapTokenClientApplicationConfig(), pName);
    }

    public String getTokenClientOrganization(String pName) throws DynamicException {
        return this.getValue(this.getMapTokenClientOrganizationConfig(), pName);
    }

    public String apiSearchByClientApplication(String pNameParam) throws DynamicException {
        IDServizioApplicativo clientApplicationId = this.getClientApplicationId();
        return this.apiSearchByClientApplication(pNameParam, clientApplicationId);
    }

    public String clientApplicationSearch(String pNameParam) throws DynamicException {
        Map<String, String> mapClientApplicationConfig = this.getMapClientApplicationConfig();
        return this.searchByAPI(pNameParam, mapClientApplicationConfig);
    }

    public String clientOrganizationSearch(String pNameParam) throws DynamicException {
        Map<String, String> mapClientOrganizationConfig = this.getMapClientOrganizationConfig();
        return this.searchByAPI(pNameParam, mapClientOrganizationConfig);
    }

    public String apiSearchByTokenClientApplication(String pNameParam) throws DynamicException {
        IDServizioApplicativo tokenClientApplicationId = this.getTokenClientApplicationId();
        return this.apiSearchByClientApplication(pNameParam, tokenClientApplicationId);
    }

    public String tokenClientApplicationSearch(String pNameParam) throws DynamicException {
        Map<String, String> mapTokenClientApplicationConfig = this.getMapTokenClientApplicationConfig();
        return this.searchByAPI(pNameParam, mapTokenClientApplicationConfig);
    }

    public String tokenClientOrganizationSearch(String pNameParam) throws DynamicException {
        Map<String, String> mapTokenClientOrganizationConfig = this.getMapTokenClientOrganizationConfig();
        return this.searchByAPI(pNameParam, mapTokenClientOrganizationConfig);
    }

    public String providerSearch(String pNameParam) throws DynamicException {
        Map<String, String> mapProviderOrganizationConfig = this.getMapProviderOrganizationConfig();
        return this.searchByAPIwithoutProvider(pNameParam, mapProviderOrganizationConfig);
    }

    private String apiSearchByClientApplication(String pNameParam, IDServizioApplicativo idSA) throws DynamicException {
        String pName;
        String v;
        Map<String, String> mapConfig = this.getMapConfig();
        if (idSA != null && idSA.getNome() != null && idSA.getIdSoggettoProprietario() != null && idSA.getIdSoggettoProprietario().getNome() != null && (v = this.getValue(mapConfig, pName = idSA.getIdSoggettoProprietario().getNome() + "." + idSA.getNome() + "." + pNameParam)) != null) {
            return v;
        }
        if (idSA != null && idSA.getNome() != null && (v = this.getValue(mapConfig, pName = idSA.getNome() + "." + pNameParam)) != null) {
            return v;
        }
        if (idSA != null && idSA.getIdSoggettoProprietario() != null && idSA.getIdSoggettoProprietario().getNome() != null && (v = this.getValue(mapConfig, pName = idSA.getIdSoggettoProprietario().getNome() + "." + pNameParam)) != null) {
            return v;
        }
        return this.getValue(mapConfig, pNameParam);
    }

    private String searchByAPI(String pNameParam, Map<String, String> map) throws DynamicException {
        String pName;
        String v;
        IDServizio configId = this.getConfigId();
        if (configId != null && configId.getNome() != null && configId.getVersione() != null && configId.getSoggettoErogatore() != null && configId.getSoggettoErogatore().getNome() != null && (v = this.getValue(map, pName = configId.getSoggettoErogatore().getNome() + "." + configId.getNome() + ".v" + configId.getVersione() + "." + pNameParam)) != null) {
            return v;
        }
        if (configId != null && configId.getNome() != null && configId.getVersione() != null && (v = this.getValue(map, pName = configId.getNome() + ".v" + configId.getVersione() + "." + pNameParam)) != null) {
            return v;
        }
        if (configId != null && configId.getSoggettoErogatore() != null && configId.getSoggettoErogatore().getNome() != null && (v = this.getValue(map, pName = configId.getSoggettoErogatore().getNome() + "." + pNameParam)) != null) {
            return v;
        }
        return this.getValue(map, pNameParam);
    }

    private String searchByAPIwithoutProvider(String pNameParam, Map<String, String> map) throws DynamicException {
        String pName;
        String v;
        IDServizio configId = this.getConfigId();
        if (configId != null && configId.getNome() != null && configId.getVersione() != null && (v = this.getValue(map, pName = configId.getNome() + ".v" + configId.getVersione() + "." + pNameParam)) != null) {
            return v;
        }
        return this.getValue(map, pNameParam);
    }

    private String getValue(Map<String, String> map, String pName) {
        if (map != null && !map.isEmpty()) {
            for (String name : map.keySet()) {
                if (!name.equals(pName)) continue;
                return map.get(name);
            }
        }
        return null;
    }
}

