/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.DatoRAtomicLong;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.DatoRLongAdder;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class DatiCollezionatiDistributedLongAdder
extends DatiCollezionati
implements IDatiCollezionatiDistributed {
    private static final long serialVersionUID = 1L;
    private final transient Semaphore lock = new Semaphore("DatiCollezionatiDistributedLongAdder");
    private final transient Semaphore lockActiveRequestCounterGetAndSum = new Semaphore("DatiCollezionatiDistributedLongAdder_ActiveRequestCounterGetAndSum");
    private final transient Semaphore lockRequestCounterGetAndSum = new Semaphore("DatiCollezionatiDistributedLongAdder_RequestCounterGetAndSum");
    private final transient Semaphore lockCounterGetAndSum = new Semaphore("DatiCollezionatiDistributedLongAdder_CounterGetAndSum");
    private final transient Semaphore lockDegradoPrestazionaleRequestCounterGetAndSum = new Semaphore("DatiCollezionatiDistributedLongAdder_DegradoPrestazionaleRequestCounterGetAndSum");
    private final transient Semaphore lockDegradoPrestazionaleCounterGetAndSum = new Semaphore("DatiCollezionatiDistributedLongAdder_DegradoPrestazionaleCounterGetAndSum");
    private final transient RedissonClient redisson;
    private final IDUnivocoGroupByPolicyMapId groupByPolicyMapId;
    private final int groupByPolicyMapIdHashCode;
    private final transient DatoRAtomicLong distributedUpdatePolicyDate;
    private final transient DatoRAtomicLong distributedPolicyDate;
    private transient DatoRLongAdder distributedPolicyRequestCounter;
    private transient DatoRLongAdder distributedPolicyCounter;
    private final transient DatoRAtomicLong distributedPolicyDegradoPrestazionaleDate;
    private transient DatoRLongAdder distributedPolicyDegradoPrestazionaleRequestCounter;
    private transient DatoRLongAdder distributedPolicyDegradoPrestazionaleCounter;
    private final boolean distribuitedActiveRequestCounterPolicyRichiesteSimultanee;
    private final transient DatoRLongAdder distributedActiveRequestCounterForStats;
    private transient DatoRLongAdder distributedActiveRequestCounterForCheck;
    private transient DatoRLongAdder distributedPolicyDenyRequestCounter;
    private transient List<DatoRLongAdder> cestinoPolicyCounters = new ArrayList<DatoRLongAdder>();
    private transient List<DatoRLongAdder> cestinoPolicyCountersDegradoPrestazionale = new ArrayList<DatoRLongAdder>();
    private boolean initialized = false;

    private String getRLongAdderName(String name, Long date) {
        Object t = "";
        if (date != null) {
            t = "" + date;
        }
        String configDate = "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L);
        return "longadder-" + this.groupByPolicyMapIdHashCode + "-" + name + (String)t + configDate + "-rl";
    }

    public DatiCollezionatiDistributedLongAdder(Logger log, Date updatePolicyDate, Date gestorePolicyConfigDate, RedissonClient redisson, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(updatePolicyDate, gestorePolicyConfigDate);
        this.redisson = redisson;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.initDatiIniziali(activePolicy);
        this.checkDate(log, activePolicy);
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.initPolicyCounters(super.getPolicyDate().getTime());
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.initPolicyCountersDegradoPrestazionale(super.getPolicyDegradoPrestazionaleDate().getTime());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue() && updatePolicyDate != null && this.distributedUpdatePolicyDate != null && this.distributedUpdatePolicyDate.get() < updatePolicyDate.getTime()) {
            this.resetCounters(updatePolicyDate);
        }
        this.initialized = true;
    }

    public DatiCollezionatiDistributedLongAdder(Logger log, DatiCollezionati dati, RedissonClient redisson, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(dati.getUpdatePolicyDate(), dati.getGestorePolicyConfigDate());
        if (log != null) {
            // empty if block
        }
        dati.setValuesIn((DatiCollezionati)this, false);
        this.redisson = redisson;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (super.getPolicyDate() != null) {
            Long polDate = this.distributedPolicyDegradoPrestazionaleDate != null ? Long.valueOf(this.distributedPolicyDegradoPrestazionaleDate.get()) : null;
            this.initPolicyCounters(polDate);
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue() && super.getPolicyDegradoPrestazionaleDate() != null) {
            Long degradoPrestazionaleTime = this.distributedPolicyDate != null ? Long.valueOf(this.distributedPolicyDate.get()) : null;
            this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
        }
        this.initialized = true;
    }

    private DatoRAtomicLong initPolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDate-c" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRAtomicLong initUpdatePolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-updatePolicyDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRAtomicLong initPolicyDegradoPrestazionaleDate() {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRLongAdder initActiveRequestCounters() {
        return new DatoRLongAdder(this.redisson, this.getRLongAdderName("-activeRequestCounter-c-", this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
    }

    private void initPolicyCounters(Long policyDate) {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.distributedPolicyRequestCounter = new DatoRLongAdder(this.redisson, this.getRLongAdderName("-policyRequestCounter-i-", policyDate));
            this.distributedPolicyDenyRequestCounter = new DatoRLongAdder(this.redisson, this.getRLongAdderName("-policyDenyRequestCounter-i-", policyDate));
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.distributedPolicyCounter = new DatoRLongAdder(this.redisson, this.getRLongAdderName("-policyCounter-i-", policyDate));
            }
        }
    }

    private void initPolicyCountersDegradoPrestazionale(Long policyDate) {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.distributedPolicyDegradoPrestazionaleCounter = new DatoRLongAdder(this.redisson, this.getRLongAdderName("-policyDegradoPrestazionaleCounter-i-", policyDate));
            this.distributedPolicyDegradoPrestazionaleRequestCounter = new DatoRLongAdder(this.redisson, this.getRLongAdderName("-policyDegradoPrestazionaleRequestCounter-i-", policyDate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDate(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDate");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDate != null ? this.policyDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCounters.isEmpty()) {
                        for (DatoRLongAdder rLongAdder : this.cestinoPolicyCounters) {
                            rLongAdder.destroy();
                        }
                        this.cestinoPolicyCounters.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyRequestCounter);
                        }
                        if (this.distributedPolicyDenyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyDenyRequestCounter);
                        }
                        if (this.distributedPolicyCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCounters(policyDate);
                super.resetPolicyCounterForDate(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDate");
            }
        } else {
            super.resetPolicyCounterForDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDateDegradoPrestazionale(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDateDegradoPrestazionale");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDegradoPrestazionaleDate != null ? this.policyDegradoPrestazionaleDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
                        for (DatoRLongAdder pnCounter : this.cestinoPolicyCountersDegradoPrestazionale) {
                            pnCounter.destroy();
                        }
                        this.cestinoPolicyCountersDegradoPrestazionale.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleCounter);
                        }
                        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleRequestCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCountersDegradoPrestazionale(policyDate);
                super.resetPolicyCounterForDateDegradoPrestazionale(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDateDegradoPrestazionale");
            }
        } else {
            super.resetPolicyCounterForDateDegradoPrestazionale(date);
        }
    }

    public void resetCounters(Date updatePolicyDate) {
        super.resetCounters(updatePolicyDate);
        if (updatePolicyDate != null) {
            this.distributedUpdatePolicyDate.set(updatePolicyDate.getTime());
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.reset();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.reset();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.reset();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.reset();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            SemaphoreLock slock = this.lockActiveRequestCounterGetAndSum.acquireThrowRuntime("internalRegisterStartRequestIncrementActiveRequestCounter");
            try {
                this.activeRequestCounter = datiCollezionatiPerPolicyVerifier != null ? Long.valueOf(datiCollezionatiPerPolicyVerifier.setAndGetActiveRequestCounter(this.distributedActiveRequestCounterForCheck.sum())) : Long.valueOf(this.distributedActiveRequestCounterForCheck.sum());
                this.distributedActiveRequestCounterForCheck.increment();
                Long l = this.activeRequestCounter;
                this.activeRequestCounter = this.activeRequestCounter + 1L;
            }
            finally {
                this.lockActiveRequestCounterGetAndSum.release(slock, "internalRegisterStartRequestIncrementActiveRequestCounter");
            }
        } else {
            this.distributedActiveRequestCounterForStats.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        SemaphoreLock slock = this.lockRequestCounterGetAndSum.acquireThrowRuntime("internalUpdateDatiStartRequestApplicabileIncrementRequestCounter");
        try {
            this.policyRequestCounter = datiCollezionatiPerPolicyVerifier != null ? datiCollezionatiPerPolicyVerifier.setAndGetPolicyRequestCounter(Long.valueOf(this.distributedPolicyRequestCounter.sum())) : Long.valueOf(this.distributedPolicyRequestCounter.sum());
            this.distributedPolicyRequestCounter.increment();
            Long l = this.policyRequestCounter;
            this.policyRequestCounter = this.policyRequestCounter + 1L;
        }
        finally {
            this.lockRequestCounterGetAndSum.release(slock, "internalUpdateDatiStartRequestApplicabileIncrementRequestCounter");
        }
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            SemaphoreLock slock = this.lockActiveRequestCounterGetAndSum.acquireThrowRuntime("internalRegisterEndRequestDecrementActiveRequestCounter");
            try {
                this.activeRequestCounter = this.distributedActiveRequestCounterForCheck.sum();
                this.distributedActiveRequestCounterForCheck.decrement();
                Long l = this.activeRequestCounter;
                this.activeRequestCounter = this.activeRequestCounter - 1L;
            }
            finally {
                this.lockActiveRequestCounterGetAndSum.release(slock, "internalRegisterEndRequestDecrementActiveRequestCounter");
            }
        } else {
            this.distributedActiveRequestCounterForStats.decrement();
        }
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        SemaphoreLock slock = this.lockDegradoPrestazionaleRequestCounterGetAndSum.acquireThrowRuntime("internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter");
        try {
            this.policyDegradoPrestazionaleRequestCounter = this.distributedPolicyDegradoPrestazionaleRequestCounter.sum();
            this.distributedPolicyDegradoPrestazionaleRequestCounter.increment();
            Long l = this.policyDegradoPrestazionaleRequestCounter;
            this.policyDegradoPrestazionaleRequestCounter = this.policyDegradoPrestazionaleRequestCounter + 1L;
        }
        finally {
            this.lockDegradoPrestazionaleRequestCounterGetAndSum.release(slock, "internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        SemaphoreLock slock = this.lockDegradoPrestazionaleCounterGetAndSum.acquireThrowRuntime("internalRegisterEndRequestIncrementDegradoPrestazionaleCounter");
        try {
            this.policyDegradoPrestazionaleCounter = this.distributedPolicyDegradoPrestazionaleCounter.sum();
            this.distributedPolicyDegradoPrestazionaleCounter.add(latenza);
            Long l = this.policyDegradoPrestazionaleCounter;
            this.policyDegradoPrestazionaleCounter = this.policyDegradoPrestazionaleCounter + 1L;
        }
        finally {
            this.lockDegradoPrestazionaleCounterGetAndSum.release(slock, "internalRegisterEndRequestIncrementDegradoPrestazionaleCounter");
        }
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        SemaphoreLock slock = this.lockRequestCounterGetAndSum.acquireThrowRuntime("internalUpdateDatiEndRequestApplicabileIncrementRequestCounter");
        try {
            this.policyRequestCounter = this.distributedPolicyRequestCounter.sum();
            this.distributedPolicyRequestCounter.increment();
            Long l = this.policyRequestCounter;
            this.policyRequestCounter = this.policyRequestCounter + 1L;
        }
        finally {
            this.lockRequestCounterGetAndSum.release(slock, "internalUpdateDatiEndRequestApplicabileIncrementRequestCounter");
        }
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        SemaphoreLock slock = this.lockRequestCounterGetAndSum.acquireThrowRuntime("internalUpdateDatiEndRequestApplicabileDecrementRequestCounter");
        try {
            this.policyRequestCounter = this.distributedPolicyRequestCounter.sum();
            this.distributedPolicyRequestCounter.decrement();
            Long l = this.policyRequestCounter;
            this.policyRequestCounter = this.policyRequestCounter - 1L;
        }
        finally {
            this.lockRequestCounterGetAndSum.release(slock, "internalUpdateDatiEndRequestApplicabileDecrementRequestCounter");
        }
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        this.distributedPolicyDenyRequestCounter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        SemaphoreLock slock = this.lockCounterGetAndSum.acquireThrowRuntime("internalUpdateDatiEndRequestApplicabileIncrementCounter");
        try {
            this.policyCounter = this.distributedPolicyCounter.sum();
            this.distributedPolicyCounter.add(v);
            this.policyCounter = this.policyCounter + v;
        }
        finally {
            this.lockCounterGetAndSum.release(slock, "internalUpdateDatiEndRequestApplicabileIncrementCounter");
        }
    }

    public void destroyDatiDistribuiti() {
        if (this.distributedPolicyDate != null) {
            this.distributedPolicyDate.delete();
        }
        if (this.distributedUpdatePolicyDate != null) {
            this.distributedUpdatePolicyDate.delete();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.destroy();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleDate != null) {
            this.distributedPolicyDegradoPrestazionaleDate.delete();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.destroy();
        }
        if (this.distributedActiveRequestCounterForStats != null) {
            this.distributedActiveRequestCounterForStats.destroy();
        }
        if (this.distributedActiveRequestCounterForCheck != null) {
            this.distributedActiveRequestCounterForCheck.destroy();
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.destroy();
        }
    }

    public Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (readRemoteInfo) {
                return this.distributedActiveRequestCounterForCheck.sum();
            }
            return this.activeRequestCounter;
        }
        return this.distributedActiveRequestCounterForStats.sum();
    }

    public Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDenyRequestCounter != null) {
                return this.distributedPolicyDenyRequestCounter.sum();
            }
            return null;
        }
        return super.getPolicyDenyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyRequestCounter != null) {
                return this.distributedPolicyRequestCounter.sum();
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyCounter != null) {
                return this.distributedPolicyCounter.sum();
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleRequestCounter.sum();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleCounter.sum();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
    }
}

