/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.BuilderDatiCollezionatiDistributed;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsDistributedCountersWithLock
implements Serializable,
IPolicyGroupByActiveThreadsInMemory {
    private static final long serialVersionUID = 1L;
    private transient Semaphore _lock = null;
    private final java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> mapActiveThreads = new HashMap<IDUnivocoGroupByPolicy, DatiCollezionati>();
    private String uniqueIdMap_idActivePolicy;
    private Date uniqueIdMap_updateTime;
    private final ActivePolicy activePolicy;
    private final BuilderDatiCollezionatiDistributed builderDatiCollezionati;

    private synchronized void initLock() {
        if (this._lock == null) {
            this._lock = new Semaphore("PolicyGroupByActiveThreadsDistributedCountersWithLock");
        }
    }

    public Semaphore getLock() {
        if (this._lock == null) {
            this.initLock();
        }
        return this._lock;
    }

    public PolicyGroupByActiveThreadsDistributedCountersWithLock(ActivePolicy activePolicy, String uniqueIdMap, BuilderDatiCollezionatiDistributed builder) throws PolicyException {
        this.activePolicy = activePolicy;
        this.builderDatiCollezionati = builder;
        this.uniqueIdMap_idActivePolicy = UniqueIdentifierUtilities.extractIdActivePolicy((String)uniqueIdMap);
        try {
            this.uniqueIdMap_updateTime = UniqueIdentifierUtilities.extractUpdateTimeActivePolicy((String)uniqueIdMap);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        return this.mapActiveThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMap(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("initMap");
        try {
            if (map != null && !map.isEmpty()) {
                for (IDUnivocoGroupByPolicy datiGroupBy : map.keySet()) {
                    IDUnivocoGroupByPolicyMapId datiGroupByMapId = this.augmentIDUnivoco(datiGroupBy);
                    DatiCollezionati dati = map.get(datiGroupBy);
                    DatiCollezionati datiContatoriDistribuiti = this.builderDatiCollezionati.build(dati, datiGroupByMapId, this.activePolicy);
                    this.mapActiveThreads.put((IDUnivocoGroupByPolicy)datiGroupByMapId, datiContatoriDistribuiti);
                }
            }
        }
        finally {
            this.getLock().release(slock, "initMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCounters() {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("resetCounters");
        try {
            if (this.mapActiveThreads.size() > 0) {
                for (DatiCollezionati item : this.mapActiveThreads.values()) {
                    item.resetCounters();
                }
            }
        }
        finally {
            this.getLock().release(slock, "resetCounters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws UtilsException {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("remove");
        try {
            ArrayList<IDUnivocoGroupByPolicy> deleteList = new ArrayList<IDUnivocoGroupByPolicy>();
            for (IDUnivocoGroupByPolicy datiGroupBy : this.mapActiveThreads.keySet()) {
                IDUnivocoGroupByPolicyMapId mapId;
                if (!(datiGroupBy instanceof IDUnivocoGroupByPolicyMapId) || !this.uniqueIdMap_idActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
                deleteList.add(datiGroupBy);
            }
            while (!deleteList.isEmpty()) {
                IDUnivocoGroupByPolicy id = (IDUnivocoGroupByPolicy)deleteList.remove(0);
                IDatiCollezionatiDistributed dati = (IDatiCollezionatiDistributed)this.mapActiveThreads.remove(id);
                dati.destroyDatiDistribuiti();
            }
        }
        finally {
            this.getLock().release(slock, "remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("registerStartRequest");
        try {
            IDUnivocoGroupByPolicyMapId datiGroupByMapId = this.augmentIDUnivoco(datiGroupBy);
            DatiCollezionati datiCollezionati = this.mapActiveThreads.get(datiGroupByMapId);
            if (datiCollezionati == null) {
                datiCollezionati = this.builderDatiCollezionati.build(this.activePolicy.getInstanceConfiguration().getUpdateTime(), datiGroupByMapId, this.activePolicy, ctx);
                this.mapActiveThreads.put((IDUnivocoGroupByPolicy)datiGroupByMapId, datiCollezionati);
            }
            datiCollezionati.registerStartRequest(log, this.activePolicy, ctx);
            DatiCollezionati datiCollezionati2 = datiCollezionati.newInstance();
            return datiCollezionati2;
        }
        finally {
            this.getLock().release(slock, "registerStartRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("updateDatiStartRequestApplicabile");
        try {
            IDUnivocoGroupByPolicyMapId datiGroupByMapId = this.augmentIDUnivoco(datiGroupBy);
            DatiCollezionati datiCollezionati = this.mapActiveThreads.get(datiGroupByMapId);
            if (datiCollezionati == null) {
                throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupByMapId.toString() + "]");
            }
            boolean updated = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx);
            if (updated) {
                DatiCollezionati datiCollezionati2 = datiCollezionati.newInstance();
                return datiCollezionati2;
            }
        }
        finally {
            this.getLock().release(slock, "updateDatiStartRequestApplicabile");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        block6: {
            SemaphoreLock slock = this.getLock().acquireThrowRuntime("registerStopRequest");
            try {
                IDUnivocoGroupByPolicyMapId datiGroupByMapId = this.augmentIDUnivoco(datiGroupBy);
                DatiCollezionati datiCollezionati = this.mapActiveThreads.get(datiGroupByMapId);
                if (datiCollezionati == null) {
                    throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupByMapId.toString() + "]");
                }
                datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
                if (!isApplicabile) break block6;
                List esitiCodeOk = null;
                List esitiCodeKoSenzaFaultApplicativo = null;
                List esitiCodeFaultApplicativo = null;
                try {
                    EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                    esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                    esitiCodeKoSenzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                    esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
                datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, esitiCodeOk, esitiCodeKoSenzaFaultApplicativo, esitiCodeFaultApplicativo, isViolata);
            }
            finally {
                this.getLock().release(slock, "registerStopRequest");
            }
        }
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("getActiveThreads");
        try {
            long counter = 0L;
            if (this.mapActiveThreads != null && !this.mapActiveThreads.isEmpty()) {
                for (IDUnivocoGroupByPolicy datiGroupBy : this.mapActiveThreads.keySet()) {
                    IDUnivocoGroupByPolicy idAstype;
                    if (filtro != null && !(idAstype = datiGroupBy).match((Object)filtro)) continue;
                    counter += this.mapActiveThreads.get(datiGroupBy).getActiveRequestCounter().longValue();
                }
            }
            long l = counter;
            return l;
        }
        finally {
            this.getLock().release(slock, "getActiveThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("printInfos");
        try {
            Object object;
            StringBuilder bf = new StringBuilder();
            if (this.mapActiveThreads != null && !this.mapActiveThreads.isEmpty()) {
                for (IDUnivocoGroupByPolicy datiGroupBy : this.mapActiveThreads.keySet()) {
                    bf.append(separatorGroups);
                    bf.append("\n");
                    bf.append("Sincronizzazione").append(" ").append(this.builderDatiCollezionati.tipoPolicy.toLabel());
                    bf.append("\n");
                    bf.append("Criterio di Collezionamento dei Dati\n");
                    bf.append(datiGroupBy.toString(true));
                    bf.append("\n");
                    this.mapActiveThreads.get(datiGroupBy).checkDate(log, this.activePolicy);
                    bf.append(this.mapActiveThreads.get(datiGroupBy).toString());
                    bf.append("\n");
                }
            }
            if (bf.length() <= 0) {
                bf.append("Nessuna informazione disponibile");
                object = bf.toString();
                return object;
            }
            object = bf.toString() + separatorGroups;
            return object;
        }
        finally {
            this.getLock().release(slock, "printInfos");
        }
    }

    protected IDUnivocoGroupByPolicyMapId augmentIDUnivoco(IDUnivocoGroupByPolicy idUnivoco) {
        if (idUnivoco instanceof IDUnivocoGroupByPolicyMapId) {
            return (IDUnivocoGroupByPolicyMapId)idUnivoco;
        }
        return new IDUnivocoGroupByPolicyMapId(idUnivoco, this.uniqueIdMap_idActivePolicy);
    }
}

