/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreads
implements Serializable,
IPolicyGroupByActiveThreadsInMemory {
    private static final long serialVersionUID = 1L;
    private java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> mapActiveThreads = new HashMap<IDUnivocoGroupByPolicy, DatiCollezionati>();
    private transient Semaphore _lock = null;
    private ActivePolicy activePolicy;
    private PolicyGroupByActiveThreadsType tipoGestore;

    private synchronized void initLock() {
        if (this._lock == null) {
            this._lock = new Semaphore("PolicyGroupByActiveThreads");
        }
    }

    public Semaphore getLock() {
        if (this._lock == null) {
            this.initLock();
        }
        return this._lock;
    }

    public PolicyGroupByActiveThreads(ActivePolicy activePolicy, PolicyGroupByActiveThreadsType tipoGestore) {
        this.activePolicy = activePolicy;
        this.tipoGestore = tipoGestore;
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        return this.mapActiveThreads;
    }

    public void setMapActiveThreads(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> value) {
        this.mapActiveThreads = value;
    }

    public void initMap(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("initMap");
        try {
            if (map != null && map.size() > 0) {
                this.mapActiveThreads.putAll(map);
            }
        }
        finally {
            this.getLock().release(slock, "initMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCounters() {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("resetCounters");
        try {
            if (this.mapActiveThreads.size() > 0) {
                for (DatiCollezionati item : this.mapActiveThreads.values()) {
                    item.resetCounters();
                }
            }
        }
        finally {
            this.getLock().release(slock, "resetCounters");
        }
    }

    public void remove() throws UtilsException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        DatiCollezionati datiCollezionatiReaded = null;
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("registerStartRequest", idTransazione);
        try {
            DatiCollezionati datiCollezionati = null;
            if (this.mapActiveThreads.containsKey(datiGroupBy)) {
                datiCollezionati = this.mapActiveThreads.get(datiGroupBy);
            } else {
                Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
                datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
                this.mapActiveThreads.put(datiGroupBy, datiCollezionati);
            }
            datiCollezionati.registerStartRequest(log, this.activePolicy, ctx);
            datiCollezionatiReaded = datiCollezionati.newInstance();
        }
        finally {
            this.getLock().release(slock, "registerStartRequest", idTransazione);
        }
        return datiCollezionatiReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        DatiCollezionati datiCollezionatiReaded = null;
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("updateDatiStartRequestApplicabile", idTransazione);
        try {
            DatiCollezionati datiCollezionati = null;
            if (!this.mapActiveThreads.containsKey(datiGroupBy)) {
                throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
            }
            datiCollezionati = this.mapActiveThreads.get(datiGroupBy);
            boolean updated = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx);
            if (updated) {
                datiCollezionatiReaded = datiCollezionati.newInstance();
            }
        }
        finally {
            this.getLock().release(slock, "updateDatiStartRequestApplicabile", idTransazione);
        }
        return datiCollezionatiReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        block6: {
            SemaphoreLock slock = this.getLock().acquireThrowRuntime("registerStopRequest", idTransazione);
            try {
                if (!this.mapActiveThreads.containsKey(datiGroupBy)) {
                    throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
                }
                DatiCollezionati datiCollezionati = this.mapActiveThreads.get(datiGroupBy);
                datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
                if (!isApplicabile) break block6;
                List esitiCodeOk = null;
                List esitiCodeKoSenzaFaultApplicativo = null;
                List esitiCodeFaultApplicativo = null;
                try {
                    EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                    esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                    esitiCodeKoSenzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                    esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
                datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, esitiCodeOk, esitiCodeKoSenzaFaultApplicativo, esitiCodeFaultApplicativo, isViolata);
            }
            finally {
                this.getLock().release(slock, "registerStopRequest", idTransazione);
            }
        }
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("getActiveThreads");
        try {
            long counter = 0L;
            if (this.mapActiveThreads != null && !this.mapActiveThreads.isEmpty()) {
                for (IDUnivocoGroupByPolicy datiGroupBy : this.mapActiveThreads.keySet()) {
                    IDUnivocoGroupByPolicy idAstype;
                    if (filtro != null && !(idAstype = datiGroupBy).match((Object)filtro)) continue;
                    counter += this.mapActiveThreads.get(datiGroupBy).getActiveRequestCounter().longValue();
                }
            }
            long l = counter;
            return l;
        }
        finally {
            this.getLock().release(slock, "getActiveThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        SemaphoreLock slock = this.getLock().acquireThrowRuntime("printInfos");
        try {
            Object object;
            StringBuilder bf = new StringBuilder();
            if (this.mapActiveThreads != null && !this.mapActiveThreads.isEmpty()) {
                for (IDUnivocoGroupByPolicy datiGroupBy : this.mapActiveThreads.keySet()) {
                    bf.append(separatorGroups);
                    bf.append("\n");
                    bf.append("Sincronizzazione").append(" ").append(this.tipoGestore.toLabel());
                    bf.append("\n");
                    bf.append("Criterio di Collezionamento dei Dati\n");
                    bf.append(datiGroupBy.toString(true));
                    bf.append("\n");
                    this.mapActiveThreads.get(datiGroupBy).checkDate(log, this.activePolicy);
                    bf.append(this.mapActiveThreads.get(datiGroupBy).toString());
                    bf.append("\n");
                }
            }
            if (bf.length() <= 0) {
                bf.append("Nessuna informazione disponibile");
                object = bf.toString();
                return object;
            }
            object = bf.toString() + separatorGroups;
            return object;
        }
        finally {
            this.getLock().release(slock, "printInfos");
        }
    }
}

