/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateUtils;

public class PolicyDateUtils {
    private static final MapKey<String> RATE_LIMITING_GESTORE_POLICY_CONFIG_DATE = Map.newMapKey((String)"RATE_LIMITING_GESTORE_POLICY_CONFIG_DATE");

    public static String toStringIntervalloTemporale(TipoFinestra tipoFinestra, Date leftDate, Date rightDate, Date checkDate, boolean statistic) throws NotFoundException {
        StringBuilder bf = new StringBuilder("");
        SimpleDateFormat dateFormat = DateUtils.getSimpleDateFormatMs();
        if (statistic) {
            bf.append("[campionamento statistico, finestra osservazione ");
        } else {
            bf.append("[campionamento realtime, finestra osservazione ");
        }
        bf.append(tipoFinestra.getValue());
        bf.append(" ");
        if (leftDate != null && rightDate != null) {
            bf.append(dateFormat.format(leftDate));
            bf.append(" - ");
            bf.append(dateFormat.format(rightDate));
        } else {
            bf.append("non disponibile");
        }
        if (statistic) {
            bf.append(" (ultimo aggiornamento:").append(dateFormat.format(checkDate)).append(")");
        }
        bf.append("]");
        return bf.toString();
    }

    public static void setGestorePolicyConfigDateIntoContext(Map<Object> ctx, Long gestorePolicyConfigDate) {
        if (ctx != null && gestorePolicyConfigDate != null && gestorePolicyConfigDate > 0L) {
            ctx.put(RATE_LIMITING_GESTORE_POLICY_CONFIG_DATE, (Object)gestorePolicyConfigDate);
        }
    }

    public static void removeGestorePolicyConfigDateIntoContext(Map<Object> ctx) {
        if (ctx != null) {
            ctx.remove(RATE_LIMITING_GESTORE_POLICY_CONFIG_DATE);
        }
    }

    public static Date readGestorePolicyConfigDateIntoContext(Map<Object> ctx) {
        Object o;
        if (ctx != null && (o = ctx.get(RATE_LIMITING_GESTORE_POLICY_CONFIG_DATE)) != null && o instanceof Long) {
            long l = (Long)o;
            return new Date(l);
        }
        return null;
    }
}

