/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREResponse;
import org.openspcoop2.pdd.services.connector.ConnectorApplicativeThreadPool;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedStreamFactory;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class ConnettoreHTTPCOREInputStreamEntityConsumer
implements AsyncResponseConsumer<ConnettoreHTTPCOREResponse> {
    private ConnettoreHTTPCOREResponse res = null;
    private ContentType ct = null;
    private IPipedUnblockedStream stream = null;
    private FutureCallback<ConnettoreHTTPCOREResponse> callback;
    private long count = 0L;
    private boolean complete = false;
    private boolean delegata;
    private ConnettoreLogger logger;
    private int sizeBuffer;
    private Integer readTimeout;
    private final HttpRequestMethod method;

    public ConnettoreHTTPCOREInputStreamEntityConsumer(ConnettoreLogger logger, int sizeBuffer, int readTimeout, boolean delegata) {
        this.logger = logger;
        this.sizeBuffer = sizeBuffer;
        this.readTimeout = readTimeout;
        this.delegata = delegata;
        this.method = null;
    }

    public ConnettoreHTTPCOREInputStreamEntityConsumer(HttpRequestMethod method, ConnettoreLogger logger, int sizeBuffer, int readTimeout, boolean delegata) {
        this.logger = logger;
        this.sizeBuffer = sizeBuffer;
        this.readTimeout = readTimeout;
        this.delegata = delegata;
        this.method = method;
    }

    private void invokeCallback() {
        if (this.callback != null) {
            Runnable runnable = new Runnable(this){
                private FutureCallback<ConnettoreHTTPCOREResponse> callback;
                private ConnettoreHTTPCOREResponse res = null;

                public Runnable init(FutureCallback<ConnettoreHTTPCOREResponse> callback, ConnettoreHTTPCOREResponse res) {
                    this.callback = callback;
                    this.res = res;
                    return this;
                }

                @Override
                public void run() {
                    this.callback.completed((Object)this.res);
                }
            }.init(this.callback, this.res);
            if (this.delegata) {
                ConnectorApplicativeThreadPool.executeByAsyncInResponsePool(runnable);
            } else {
                ConnectorApplicativeThreadPool.executeByAsyncOutResponsePool(runnable);
            }
            this.callback = null;
        }
    }

    public void informationResponse(HttpResponse res, HttpContext context) throws HttpException, IOException {
    }

    public void consumeResponse(HttpResponse res, EntityDetails entityDetails, HttpContext context, FutureCallback<ConnettoreHTTPCOREResponse> callback) throws HttpException, IOException {
        if (entityDetails != null && entityDetails.getContentType() != null) {
            this.ct = ContentType.parse((CharSequence)entityDetails.getContentType());
        }
        this.res = new ConnettoreHTTPCOREResponse(res);
        this.callback = callback;
        if (this.method != null && this.method.equals((Object)HttpRequestMethod.HEAD)) {
            this.invokeCallback();
        }
    }

    public void consume(ByteBuffer bb) throws IOException {
        if (bb != null && bb.remaining() > 0) {
            if (this.stream == null) {
                this.stream = PipedUnblockedStreamFactory.newPipedUnblockedStream((Logger)this.logger.getLogger(), (long)this.sizeBuffer, (int)this.readTimeout, (String)"Response");
                this.res.setEntity((HttpEntity)new InputStreamEntity((InputStream)this.stream, this.ct));
            }
            if (this.callback != null) {
                this.invokeCallback();
            }
            while (bb.remaining() > 0) {
                byte[] buf = new byte[bb.remaining()];
                bb.get(buf);
                this.stream.write(buf);
                this.count += (long)buf.length;
            }
        }
    }

    public void updateCapacity(CapacityChannel channel) throws IOException {
        channel.update(65536);
    }

    private void streamEnd() {
        this.complete = true;
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        if (this.callback != null) {
            this.invokeCallback();
        }
        if (this.count > 0L && this.res != null) {
            this.res.setCount(this.count);
        }
        this.streamEnd();
    }

    public void releaseResources() {
        this.streamEnd();
    }

    public void failed(Exception exception) {
        if (!this.complete) {
            this.logger.error("======== exception: " + String.valueOf(this.stream) + " - " + this.count + " : " + exception.getMessage(), exception);
        }
    }
}

