/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.slf4j.Logger;

public class ConnettoreHTTPCORECustomConnectingIOReactor
extends DefaultConnectingIOReactor {
    private ExecutorService executorService;
    private Logger log;

    public ConnettoreHTTPCORECustomConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback, Logger log) {
        super(eventHandlerFactory, config, sessionShutdownCallback);
        this.init(log);
    }

    public ConnettoreHTTPCORECustomConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, Logger log) {
        super(eventHandlerFactory);
        this.init(log);
    }

    private void init(Logger log) {
        int size = Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newFixedThreadPool(size);
        this.log = log;
    }

    public void startReactor() {
        this.executorService.submit(() -> {
            try {
                this.start();
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void shutdownReactor() {
        try {
            this.executorService.shutdown();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

