/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5;

import java.net.URL;
import java.util.List;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.connettori.ConnettoreHttpPoolParams;

public class ConnettoreHttpPoolParamsBuilder {
    private ConnettoreHttpPoolParamsBuilder() {
    }

    public static ConnettoreHttpPoolParams newConnettoreHttpPoolParams(OpenSPCoop2Properties openspcoopProperties, URL url, List<Proprieta> proprietaPorta) {
        ConnettoreHttpPoolParams c = new ConnettoreHttpPoolParams();
        String host = url.getHost();
        int port = url.getPort();
        Integer maxTotal = openspcoopProperties.getBIOConfigSyncClientMaxTotal(host, port);
        maxTotal = CostantiProprieta.getConnettoriConnectionPoolMaxTotal(proprietaPorta, maxTotal);
        c.setMaxTotal(maxTotal);
        Integer defaultMaxPerRoute = openspcoopProperties.getBIOConfigSyncClientMaxPerRoute(host, port);
        defaultMaxPerRoute = CostantiProprieta.getConnettoriConnectionPoolMaxPerRoute(proprietaPorta, defaultMaxPerRoute);
        c.setDefaultMaxPerRoute(defaultMaxPerRoute);
        Integer validateAfterInactivityDefault = openspcoopProperties.getBIOConfigSyncClientValidateAfterInactivity(host, port);
        Integer validateAfterInactivity = CostantiProprieta.getConnettoriConnectionPoolValidateAfterInactivity(proprietaPorta, validateAfterInactivityDefault);
        c.setValidateAfterInactivity(validateAfterInactivity);
        return c;
    }
}

