/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Date;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.utils.date.DateManager;

public abstract class AbstractConnettoreConnection<T> {
    private Date created = DateManager.getDate();
    private Date updated = DateManager.getDate();
    protected T httpclient;
    private boolean expired = false;
    protected String key = null;
    protected int expireUnusedAfterSeconds = -1;
    protected int closeUnusedAfterSeconds = -1;

    protected AbstractConnettoreConnection(String key, T client, int expireUnusedAfterSeconds, int closeUnusedAfterSeconds) {
        this.key = key;
        this.httpclient = client;
        this.expireUnusedAfterSeconds = expireUnusedAfterSeconds;
        this.closeUnusedAfterSeconds = closeUnusedAfterSeconds;
    }

    public abstract String getStatus();

    public abstract void close() throws ConnettoreException;

    public T getHttpclient() {
        return this.httpclient;
    }

    public void refresh() {
        if (this.expired) {
            return;
        }
        if (this.updated == null) {
            this.updated = DateManager.getDate();
            return;
        }
        this.checkExpire();
        if (this.expired) {
            return;
        }
        this.updated = DateManager.getDate();
    }

    public void checkExpire() {
        int seconds = this.expireUnusedAfterSeconds;
        int ms = seconds * 1000;
        long diff = DateManager.getTimeMillis() - this.updated.getTime();
        if (diff > (long)ms) {
            this.expired = true;
        }
    }

    public boolean isReadyForClose() {
        if (!this.expired) {
            return false;
        }
        int seconds = this.closeUnusedAfterSeconds;
        int ms = seconds * 1000;
        long diff = DateManager.getTimeMillis() - this.updated.getTime();
        return diff > (long)ms;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public boolean isExpired() {
        return this.expired;
    }
}

