/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.cache;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDConnettore;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.core.GestoreRichieste;
import org.openspcoop2.pdd.core.autenticazione.GestoreAutenticazione;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazione;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.GestoreLoadBalancerCaching;
import org.openspcoop2.pdd.core.cache.AttributeAuthorityCacheCleaner;
import org.openspcoop2.pdd.core.cache.AutenticazioneCacheCleaner;
import org.openspcoop2.pdd.core.cache.AutorizzazioneCacheCleaner;
import org.openspcoop2.pdd.core.cache.ConfigurazioneCacheCleaner;
import org.openspcoop2.pdd.core.cache.GestoreLoadBalancerCacheCleaner;
import org.openspcoop2.pdd.core.cache.GestoreRichiesteCacheCleaner;
import org.openspcoop2.pdd.core.cache.GestoreTokenCacheCleaner;
import org.openspcoop2.pdd.core.cache.ICacheCleaner;
import org.openspcoop2.pdd.core.cache.RegistroServiziCacheCleaner;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.protocol.registry.RegistroServiziReader;

public class GestoreCacheCleaner {
    private static List<ICacheCleaner> listCacheCleaner = new ArrayList<ICacheCleaner>();
    private static DriverRegistroServiziDB driverRegistroDB = null;
    private static DriverConfigurazioneDB driverConfigDB = null;

    private GestoreCacheCleaner() {
    }

    public static void initialize() throws Exception {
        IDriverConfigurazioneGet driver;
        if (GestoreRichieste.isCacheAbilitata()) {
            listCacheCleaner.add(new GestoreRichiesteCacheCleaner());
        }
        if (RegistroServiziReader.isCacheAbilitata()) {
            listCacheCleaner.add(new RegistroServiziCacheCleaner());
        }
        if (ConfigurazionePdDReader.isCacheAbilitata()) {
            listCacheCleaner.add(new ConfigurazioneCacheCleaner());
        }
        if (GestoreAutenticazione.isCacheAbilitata()) {
            listCacheCleaner.add(new AutenticazioneCacheCleaner());
        }
        if (GestoreAutorizzazione.isCacheAbilitata()) {
            listCacheCleaner.add(new AutorizzazioneCacheCleaner());
        }
        if (GestoreToken.isGestioneTokenCacheAbilitata()) {
            listCacheCleaner.add(new GestoreTokenCacheCleaner());
        }
        if (GestoreToken.isAttributeAuthorityCacheAbilitata()) {
            listCacheCleaner.add(new AttributeAuthorityCacheCleaner());
        }
        if (GestoreLoadBalancerCaching.isCacheAbilitata()) {
            listCacheCleaner.add(new GestoreLoadBalancerCacheCleaner());
        }
        for (IDriverRegistroServiziGet driver2 : RegistroServiziReader.getDriverRegistroServizi().values()) {
            if (!(driver2 instanceof DriverRegistroServiziDB)) continue;
            driverRegistroDB = (DriverRegistroServiziDB)driver2;
            break;
        }
        if ((driver = ConfigurazionePdDReader.getDriverConfigurazionePdD()) instanceof DriverConfigurazioneDB) {
            driverConfigDB = (DriverConfigurazioneDB)driver;
        }
    }

    public static void removeAccordoCooperazione(long id) throws Exception {
        AccordoCooperazione ac;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && (ac = driverRegistroDB.getAccordoCooperazione(id)) != null) {
            IDAccordoCooperazione idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(ac);
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeAccordoCooperazione(idAccordoCooperazione);
            }
        }
    }

    public static void removeAccordoServizioParteComune(long id) throws Exception {
        AccordoServizioParteComuneSintetico as;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && (as = driverRegistroDB.getAccordoServizioParteComuneSintetico(id)) != null) {
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeApi(idAccordo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeErogazione(long id) throws Exception {
        AccordoServizioParteSpecifica as;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && driverConfigDB != null && (as = driverRegistroDB.getAccordoServizioParteSpecifica(id, false)) != null) {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(as);
            List idPorteApplicative = null;
            ArrayList<IDConnettore> idConnettori = null;
            ArrayList<IDServizioApplicativo> idServiziApplicativiErogatori = null;
            Connection con = null;
            try {
                con = driverConfigDB.getConnection("getIDPorteApplicativeAssociate");
                idPorteApplicative = DBMappingUtils.getIDPorteApplicativeAssociate((IDServizio)idServizio, (Connection)con, (String)driverConfigDB.getTipoDB());
            }
            finally {
                driverConfigDB.releaseConnection(con);
            }
            if (idPorteApplicative != null && !idPorteApplicative.isEmpty()) {
                for (IDPortaApplicativa idPortaApplicativa : idPorteApplicative) {
                    PortaApplicativa pa = driverConfigDB.getPortaApplicativa(idPortaApplicativa);
                    if (idServiziApplicativiErogatori == null) {
                        idServiziApplicativiErogatori = new ArrayList<IDServizioApplicativo>();
                    }
                    for (PortaApplicativaServizioApplicativo paSa : pa.getServizioApplicativoList()) {
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(idServizio.getSoggettoErogatore());
                        idSA.setNome(paSa.getNome());
                        idServiziApplicativiErogatori.add(idSA);
                    }
                    if (pa.getBehaviour() == null || pa.sizeServizioApplicativoList() <= 0) continue;
                    if (idConnettori == null) {
                        idConnettori = new ArrayList<IDConnettore>();
                    }
                    for (PortaApplicativaServizioApplicativo paSa : pa.getServizioApplicativoList()) {
                        IDConnettore idConnettore = new IDConnettore();
                        idConnettore.setIdSoggettoProprietario(idServizio.getSoggettoErogatore());
                        idConnettore.setNome(paSa.getNome());
                        idConnettore.setNomeConnettore(paSa.getDatiConnettore() != null && paSa.getDatiConnettore().getNome() != null ? paSa.getDatiConnettore().getNome() : "Default");
                        idConnettori.add(idConnettore);
                    }
                }
            }
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeErogazione(idServizio);
                if (idPorteApplicative != null && !idPorteApplicative.isEmpty()) {
                    for (IDPortaApplicativa idPortaApplicativa : idPorteApplicative) {
                        iCacheCleaner.removePortaApplicativa(idPortaApplicativa);
                    }
                }
                if (idServiziApplicativiErogatori != null && !idServiziApplicativiErogatori.isEmpty()) {
                    for (IDServizioApplicativo idSA : idServiziApplicativiErogatori) {
                        iCacheCleaner.removeApplicativo(idSA);
                    }
                }
                if (idConnettori == null || idConnettori.isEmpty()) continue;
                for (IDConnettore idConnettore : idConnettori) {
                    iCacheCleaner.removeConnettore(idConnettore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFruizione(long id) throws Exception {
        Fruitore fruitore;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && driverConfigDB != null && (fruitore = driverRegistroDB.getServizioFruitore(id)) != null) {
            AccordoServizioParteSpecifica as = driverRegistroDB.getAccordoServizioParteSpecifica(fruitore.getIdServizio().longValue(), false);
            IDSoggetto idFruitore = driverRegistroDB.getIdSoggetto(fruitore.getIdSoggetto().longValue());
            if (as != null) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(as);
                List idPorteDelegate = null;
                Connection con = null;
                try {
                    con = driverConfigDB.getConnection("getIDPorteApplicativeAssociate");
                    idPorteDelegate = DBMappingUtils.getIDPorteDelegateAssociate((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)driverConfigDB.getTipoDB());
                }
                finally {
                    driverConfigDB.releaseConnection(con);
                }
                for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                    iCacheCleaner.removeFruizione(idFruitore, idServizio);
                    if (idPorteDelegate == null || idPorteDelegate.isEmpty()) continue;
                    for (IDPortaDelegata idPortaDelegata : idPorteDelegate) {
                        iCacheCleaner.removePortaDelegata(idPortaDelegata);
                    }
                }
            }
        }
    }

    public static void removeSoggetto(long id) throws Exception {
        Soggetto soggetto;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && (soggetto = driverRegistroDB.getSoggetto(id)) != null) {
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            String portaDominio = soggetto.getPortaDominio();
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeSoggetto(idSoggetto);
                if (portaDominio == null) continue;
                iCacheCleaner.removePdd(portaDominio);
            }
        }
    }

    public static void removeApplicativo(long id) throws Exception {
        ServizioApplicativo sa;
        if (!listCacheCleaner.isEmpty() && driverConfigDB != null && (sa = driverConfigDB.getServizioApplicativo(id)) != null) {
            IDSoggetto idSoggetto = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(idSoggetto);
            idSA.setNome(sa.getNome());
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeApplicativo(idSA);
            }
        }
    }

    public static void removeRuolo(long id) throws Exception {
        Ruolo ruolo;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && (ruolo = driverRegistroDB.getRuolo(id)) != null) {
            IDRuolo idRuolo = new IDRuolo(ruolo.getNome());
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeRuolo(idRuolo);
            }
        }
    }

    public static void removeScope(long id) throws Exception {
        Scope scope;
        if (!listCacheCleaner.isEmpty() && driverRegistroDB != null && (scope = driverRegistroDB.getScope(id)) != null) {
            IDScope idScope = new IDScope(scope.getNome());
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeScope(idScope);
            }
        }
    }

    public static void removeGenericProperties(long id) throws Exception {
        GenericProperties gp;
        if (!listCacheCleaner.isEmpty() && driverConfigDB != null && (gp = driverConfigDB.getGenericProperties(id)) != null) {
            IDGenericProperties idGP = new IDGenericProperties();
            idGP.setTipologia(gp.getTipologia());
            idGP.setNome(gp.getNome());
            for (ICacheCleaner iCacheCleaner : listCacheCleaner) {
                iCacheCleaner.removeGenericProperties(idGP);
            }
        }
    }
}

