/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver;

import java.util.ArrayList;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.behaviour.AbstractBehaviour;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardTo;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToFilter;
import org.openspcoop2.pdd.core.behaviour.BehaviourResponseTo;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneMultiDeliver;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MultiDeliverUtils;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalFilterResult;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.slf4j.Logger;

public class MultiDeliverBehaviour
extends AbstractBehaviour
implements IBehaviour {
    private TipoBehaviour bt;
    private IState state;

    public MultiDeliverBehaviour(TipoBehaviour bt, IState state) {
        this.bt = bt;
        this.state = state;
    }

    public TipoBehaviour getBt() {
        return this.bt;
    }

    @Override
    public Behaviour behaviour(GestoreMessaggi gestoreMessaggioRichiesta, Busta busta, PortaApplicativa pa, RequestInfo requestInfo) throws BehaviourException, BehaviourEmitDiagnosticException {
        try {
            ConfigurazioneMultiDeliver configurazione = MultiDeliverUtils.read(pa);
            ArrayList<IDServizioApplicativo> listaServiziApplicativiAll = new ArrayList<IDServizioApplicativo>();
            ArrayList<IDServizioApplicativo> listaServiziApplicativi_consegnaSenzaRisposta = new ArrayList<IDServizioApplicativo>();
            IDServizioApplicativo idServizioApplicativoResponder = null;
            for (PortaApplicativaServizioApplicativo servizioApplicativo : pa.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                idSA.setNome(servizioApplicativo.getNome());
                listaServiziApplicativiAll.add(idSA);
                if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)servizioApplicativo.getDatiConnettore().getStato())) continue;
                if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)this.bt)) {
                    Object nomeConnettore = "Default";
                    if (servizioApplicativo.getDatiConnettore() != null) {
                        nomeConnettore = servizioApplicativo.getDatiConnettore().getNome();
                    }
                    if (configurazione.getTransazioneSincrona_nomeConnettore() != null && configurazione.getTransazioneSincrona_nomeConnettore().equals(nomeConnettore)) {
                        idServizioApplicativoResponder = idSA;
                        continue;
                    }
                    listaServiziApplicativi_consegnaSenzaRisposta.add(idSA);
                    continue;
                }
                listaServiziApplicativi_consegnaSenzaRisposta.add(idSA);
            }
            if (!listaServiziApplicativi_consegnaSenzaRisposta.isEmpty()) {
                Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
                OpenSPCoop2Message msg = null;
                try {
                    msg = gestoreMessaggioRichiesta.getMessage();
                }
                catch (Exception e) {
                    throw new BehaviourException(e.getMessage(), e);
                }
                ConditionalFilterResult filterResult = ConditionalUtils.filter(pa, msg, busta, requestInfo, this.getPddContext(), this.msgDiag, log, this.bt, this.state);
                if (filterResult != null) {
                    listaServiziApplicativi_consegnaSenzaRisposta.clear();
                    for (PortaApplicativaServizioApplicativo servizioApplicativo : filterResult.getListServiziApplicativi()) {
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)servizioApplicativo.getDatiConnettore().getStato())) continue;
                        String nomeConnettore = "Default";
                        if (servizioApplicativo.getDatiConnettore() != null) {
                            nomeConnettore = servizioApplicativo.getDatiConnettore().getNome();
                        }
                        if (configurazione.getTransazioneSincrona_nomeConnettore() != null && configurazione.getTransazioneSincrona_nomeConnettore().equals(nomeConnettore)) continue;
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                        idSA.setNome(servizioApplicativo.getNome());
                        listaServiziApplicativi_consegnaSenzaRisposta.add(idSA);
                    }
                }
            }
            Behaviour behaviour = new Behaviour();
            behaviour.setApplicativeSyncResponder(idServizioApplicativoResponder);
            BehaviourForwardTo forwardTo = new BehaviourForwardTo();
            if (idServizioApplicativoResponder != null) {
                boolean connettoriPerNotifiche;
                boolean bl = connettoriPerNotifiche = listaServiziApplicativi_consegnaSenzaRisposta.size() > 0;
                if (connettoriPerNotifiche) {
                    this.getPddContext().addObject(Costanti.CONSEGNA_MULTIPLA_SINCRONA_CONFIGURAZIONE, configurazione);
                }
                this.getPddContext().addObject(CostantiPdD.CONNETTORE_MULTIPLO_SELEZIONATO, idServizioApplicativoResponder.getNome());
            }
            boolean forceSalvataggioMessaggio = false;
            if (listaServiziApplicativi_consegnaSenzaRisposta.size() == 1 && idServizioApplicativoResponder == null || listaServiziApplicativi_consegnaSenzaRisposta.size() == 0 && idServizioApplicativoResponder != null) {
                IDServizioApplicativo idSA = null;
                if (idServizioApplicativoResponder != null) {
                    idSA = idServizioApplicativoResponder;
                } else {
                    idSA = (IDServizioApplicativo)listaServiziApplicativi_consegnaSenzaRisposta.get(0);
                    this.getPddContext().addObject(CostantiPdD.CONNETTORE_MULTIPLO_SELEZIONATO, idSA.getNome());
                }
                ServizioApplicativo sa = null;
                boolean uniqueSA_integrationManager = false;
                boolean uniqueSA_connettore = false;
                try {
                    sa = ConfigurazionePdDManager.getInstance().getServizioApplicativo(idSA, requestInfo);
                    uniqueSA_integrationManager = ConfigurazionePdDManager.getInstance().invocazioneServizioConGetMessage(sa);
                    uniqueSA_connettore = ConfigurazionePdDManager.getInstance().invocazioneServizioConConnettore(sa);
                }
                catch (Exception e) {
                    throw new BehaviourException(e.getMessage(), e);
                }
                if ((TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)this.bt) || TipoBehaviour.CONSEGNA_CONDIZIONALE.equals((Object)this.bt)) && !uniqueSA_connettore) {
                    if (uniqueSA_integrationManager) {
                        throw new BehaviourEmitDiagnosticException(this.msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.servizioSincrono.consegnaIntegrationManager");
                    }
                    throw new BehaviourEmitDiagnosticException(this.msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.servizioSincrono.consegnaNonTrasparente");
                }
                forceSalvataggioMessaggio = uniqueSA_integrationManager && uniqueSA_connettore;
            }
            boolean saveMessage = false;
            if (forceSalvataggioMessaggio) {
                saveMessage = true;
            } else if (idServizioApplicativoResponder != null) {
                saveMessage = listaServiziApplicativi_consegnaSenzaRisposta.size() > 0;
            } else if (TipoBehaviour.CONSEGNA_MULTIPLA.equals((Object)this.bt)) {
                saveMessage = listaServiziApplicativi_consegnaSenzaRisposta.size() > 0;
            } else {
                boolean bl = saveMessage = listaServiziApplicativi_consegnaSenzaRisposta.size() > 1;
            }
            if (saveMessage) {
                OpenSPCoop2Message msg = null;
                try {
                    msg = gestoreMessaggioRichiesta.getMessage();
                }
                catch (Exception e) {
                    throw new BehaviourException(e.getMessage(), e);
                }
                forwardTo.setMessage(msg);
                if (idServizioApplicativoResponder == null) {
                    BehaviourResponseTo responseTo = new BehaviourResponseTo();
                    responseTo.setResponseTo(true);
                    behaviour.setResponseTo(responseTo);
                    OpenSPCoop2MessageFactory factory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                    OpenSPCoop2Message replyTo = factory.createEmptyMessage(msg != null ? msg.getMessageType() : MessageType.BINARY, MessageRole.RESPONSE);
                    behaviour.getResponseTo().setMessage(replyTo);
                }
            }
            BehaviourForwardToFilter filter = new BehaviourForwardToFilter();
            for (IDServizioApplicativo idServizioApplicativo : listaServiziApplicativi_consegnaSenzaRisposta) {
                filter.getAccessListServiziApplicativi().add(idServizioApplicativo);
            }
            if (listaServiziApplicativi_consegnaSenzaRisposta.size() <= 0) {
                filter.setDenyListServiziApplicativi(listaServiziApplicativiAll);
            }
            forwardTo.setFilter(filter);
            behaviour.getForwardTo().add(forwardTo);
            return behaviour;
        }
        catch (BehaviourEmitDiagnosticException e) {
            throw e;
        }
        catch (BehaviourException e) {
            throw e;
        }
    }
}

