/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativaBehaviour;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.AbstractBehaviour;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerBehaviour;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MultiDeliverBehaviour;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;

public class BehaviourLoader {
    public static IBehaviour newInstance(PortaApplicativaBehaviour behaviour, MsgDiagnostico msgDiag, PdDContext pddContext, IProtocolFactory<?> protocolFactory, IState state) throws CoreException {
        if (behaviour == null || behaviour.getNome() == null || "".equals(behaviour.getNome())) {
            throw new CoreException("Behaviour undefined");
        }
        IBehaviour behaviourImpl = null;
        String tipoDiagBehaviour = null;
        try {
            TipoBehaviour bt = TipoBehaviour.toEnumConstant((String)behaviour.getNome(), (boolean)false);
            switch (bt) {
                case CONSEGNA_MULTIPLA: 
                case CONSEGNA_CONDIZIONALE: 
                case CONSEGNA_CON_NOTIFICHE: {
                    behaviourImpl = new MultiDeliverBehaviour(bt, state);
                    tipoDiagBehaviour = bt.getLabel();
                    break;
                }
                case CONSEGNA_LOAD_BALANCE: {
                    behaviourImpl = new LoadBalancerBehaviour(state);
                    tipoDiagBehaviour = bt.getLabel();
                    break;
                }
                case CUSTOM: {
                    behaviourImpl = PddPluginLoader.getInstance().newBehaviour(behaviour.getNome());
                    tipoDiagBehaviour = behaviour.getNome();
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
        if (behaviourImpl == null) {
            throw new CoreException("Init Behaviour '" + behaviour.getNome() + "' failed");
        }
        if (msgDiag != null) {
            msgDiag.addKeyword("@TIPO_BEHAVIOUR@", tipoDiagBehaviour);
        }
        behaviourImpl.init(pddContext, protocolFactory, new Object[0]);
        if (behaviourImpl instanceof AbstractBehaviour) {
            ((AbstractBehaviour)behaviourImpl).initMsgDiagnostico(msgDiag);
        }
        return behaviourImpl;
    }
}

