/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pd;

import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutorizzazioneAuthenticated
extends AbstractAutorizzazioneBase {
    @Override
    public EsitoAutorizzazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutorizzazioneException {
        EsitoAutorizzazionePortaDelegata esito = new EsitoAutorizzazionePortaDelegata();
        if (datiInvocazione.getIdServizioApplicativo() == null) {
            throw new AutorizzazioneException("Identit\u00e0 servizio applicativo non disponibile; tale informazione \u00e8 richiesta dall'autorizzazione");
        }
        String servizioApplicativo = datiInvocazione.getIdServizioApplicativo().getNome();
        try {
            if (!ConfigurazionePdDManager.getInstance(datiInvocazione.getState()).autorizzazione(datiInvocazione.getPd(), servizioApplicativo)) {
                esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(servizioApplicativo));
                esito.setAutorizzato(false);
                return esito;
            }
        }
        catch (DriverConfigurazioneNotFound e) {
            esito.setErroreIntegrazione(IntegrationFunctionError.NOT_FOUND, ErroriIntegrazione.ERRORE_401_PORTA_INESISTENTE.getErrore401_PortaInesistente(e.getMessage(), servizioApplicativo));
            esito.setAutorizzato(false);
            return esito;
        }
        catch (DriverConfigurazioneException e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutorizzazioneOpenSPCoop non riuscita", (Throwable)e);
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
            return esito;
        }
        esito.setAutorizzato(true);
        return esito;
    }
}

