/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pd;

import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneRoles;
import org.openspcoop2.pdd.core.autorizzazione.pd.AutorizzazioneAuthenticated;
import org.openspcoop2.pdd.core.autorizzazione.pd.AutorizzazioneExternalRoles;
import org.openspcoop2.pdd.core.autorizzazione.pd.AutorizzazioneInternalRoles;
import org.openspcoop2.pdd.core.autorizzazione.pd.AutorizzazioneRoles;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;

abstract class AbstractAutorizzazioneAuthenticatedRoles
extends AbstractAutorizzazioneBase {
    private boolean checkRuoloRegistro;
    private boolean checkRuoloEsterno;
    private String nomeAutorizzazione;

    protected AbstractAutorizzazioneAuthenticatedRoles(boolean checkRuoloRegistro, boolean checkRuoloEsterno, String nomeAutorizzazione) {
        this.checkRuoloRegistro = checkRuoloRegistro;
        this.checkRuoloEsterno = checkRuoloEsterno;
        this.nomeAutorizzazione = nomeAutorizzazione;
    }

    @Override
    public EsitoAutorizzazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutorizzazioneException {
        EsitoAutorizzazionePortaDelegata esitoAuth = null;
        if (datiInvocazione.getIdServizioApplicativo() != null) {
            AutorizzazioneAuthenticated auth = new AutorizzazioneAuthenticated();
            auth.init(this.getPddContext(), this.getProtocolFactory(), this.getArgs());
            esitoAuth = auth.process(datiInvocazione);
            if (esitoAuth.isAutorizzato()) {
                return esitoAuth;
            }
        }
        AbstractAutorizzazioneRoles authRuoli = null;
        authRuoli = this.checkRuoloRegistro && this.checkRuoloEsterno ? new AutorizzazioneRoles() : (this.checkRuoloRegistro ? new AutorizzazioneInternalRoles() : new AutorizzazioneExternalRoles());
        authRuoli.init(this.getPddContext(), this.getProtocolFactory(), this.getArgs());
        EsitoAutorizzazionePortaDelegata esitoAuthRoles = authRuoli.process(datiInvocazione);
        if (esitoAuthRoles.isAutorizzato()) {
            return esitoAuthRoles;
        }
        if (esitoAuth != null && !"Anonimo".equals(datiInvocazione.getIdServizioApplicativo().getNome())) {
            return esitoAuth;
        }
        return esitoAuthRoles;
    }
}

