/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import java.util.List;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazioneContenutiBuiltIn;
import org.openspcoop2.pdd.core.autorizzazione.pa.AbstractAutorizzazioneContenutoBase;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutorizzazioneContenutoBuiltIn
extends AbstractAutorizzazioneContenutoBase {
    @Override
    public EsitoAutorizzazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        EsitoAutorizzazionePortaApplicativa esito = new EsitoAutorizzazionePortaApplicativa();
        try {
            if (datiInvocazione.getPa() == null) {
                throw new Exception("Porta Applicativa non presente");
            }
            List regole = datiInvocazione.getPa().getProprietaAutorizzazioneContenutoList();
            GestoreAutorizzazioneContenutiBuiltIn gestore = new GestoreAutorizzazioneContenutiBuiltIn();
            gestore.process(msg, datiInvocazione, this.getPddContext(), regole);
            if (!gestore.isAutorizzato()) {
                IDServizioApplicativo idSA = datiInvocazione.getIdentitaServizioApplicativoFruitore();
                IDSoggetto soggettoFruitore = datiInvocazione.getIdSoggettoFruitore();
                Object mittente = null;
                if (idSA != null && idSA.getNome() != null) {
                    IDSoggetto soggettoProprietario = null;
                    if (idSA.getIdSoggettoProprietario() != null) {
                        soggettoProprietario = idSA.getIdSoggettoProprietario();
                    } else if (soggettoFruitore != null) {
                        soggettoProprietario = soggettoFruitore;
                    }
                    mittente = soggettoProprietario != null ? "L'applicativo " + idSA.getNome() + " (" + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + ")" : "L'applicativo " + idSA.getNome();
                } else {
                    mittente = soggettoFruitore != null ? "Il soggetto " + soggettoFruitore.getTipo() + "/" + soggettoFruitore.getNome() : "Il chiamante";
                }
                String errore = (String)mittente + " non \u00e8 autorizzato ad invocare l'API";
                esito.setErroreCooperazione(IntegrationFunctionError.CONTENT_AUTHORIZATION_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setAutorizzato(false);
                esito.setDetails(gestore.getErrorMessage());
            } else {
                esito.setAutorizzato(true);
            }
            return esito;
        }
        catch (Exception e) {
            esito.setEccezioneProcessamento(e);
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Autorizzazione per contenuto non riuscita", (Throwable)e);
            throw new AutorizzazioneException("Errore inatteso durante la gestione dell'autorizzazione per contenuti: " + e.getMessage(), e);
        }
    }
}

