/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pd;

import java.security.cert.CertStore;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pd.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.EsitoAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.transport.http.OCSPResponseException;

public class AutenticazioneSsl
extends AbstractAutenticazioneBase {
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public EsitoAutenticazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaDelegata esito = new EsitoAutenticazionePortaDelegata();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazioneHttpsWWWAuthenticateConfig();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        IDSoggetto soggettoFruitore = null;
        if (datiInvocazione.getPd() != null) {
            soggettoFruitore = new IDSoggetto(datiInvocazione.getPd().getTipoSoggettoProprietario(), datiInvocazione.getPd().getNomeSoggettoProprietario());
        }
        Credenziali credenziali = datiInvocazione.getInfoConnettoreIngresso().getCredenziali();
        String subject = credenziali.getSubject();
        String issuer = credenziali.getIssuer();
        CertificateInfo certificate = null;
        if (credenziali.getCertificate() != null) {
            certificate = credenziali.getCertificate().getCertificate();
        }
        RequestInfo requestInfo = datiInvocazione.getRequestInfo();
        if (subject == null || "".equals(subject)) {
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaSsl("credenziali non fornite", subject));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        if (credenziali.getCertificate() != null) {
            GestoreOCSPValidator ocspValidator;
            block47: {
                CertStore trustStoreCertificatiX509crls;
                KeyStore trustStoreCertificatiX509;
                boolean checkValid;
                block46: {
                    certificate = credenziali.getCertificate().getCertificate();
                    List proprieta = null;
                    if (datiInvocazione.getPd() != null) {
                        proprieta = datiInvocazione.getPd().getProprietaList();
                    }
                    checkValid = false;
                    boolean trustStore = false;
                    trustStoreCertificatiX509 = null;
                    trustStoreCertificatiX509crls = null;
                    ocspValidator = null;
                    try {
                        checkValid = CostantiProprieta.isAutenticazioneHttpsValidityCheck(proprieta, op2Properties.isAutenticazioneHttpsPortaDelegataValidityCheck());
                        trustStore = CostantiProprieta.isAutenticazioneHttpsTrustStore(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststorePath());
                        if (!trustStore) break block46;
                        String path = CostantiProprieta.getAutenticazioneHttpsTrustStorePath(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststorePath());
                        if (path != null) {
                            try {
                                String password = CostantiProprieta.getAutenticazioneHttpsTrustStorePassword(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststorePassword());
                                String type = CostantiProprieta.getAutenticazioneHttpsTrustStoreType(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststoreType());
                                trustStoreCertificatiX509 = GestoreKeystoreCaching.getMerlinTruststore(requestInfo, path, type, password).getTrustStore();
                            }
                            catch (Exception e) {
                                throw new CoreException("Errore durante la lettura del truststore indicato (" + path + "): " + e.getMessage());
                            }
                        }
                        if (trustStoreCertificatiX509 == null) break block46;
                        String crl = CostantiProprieta.getAutenticazioneHttpsTrustStoreCRLs(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststoreCRLs());
                        boolean crlByOcsp = false;
                        String ocspPolicy = CostantiProprieta.getAutenticazioneHttpsTrustStoreOCSPPolicy(proprieta, op2Properties.getAutenticazioneHttpsPortaDelegataTruststoreOCSPPolicy());
                        if (ocspPolicy != null) {
                            GestoreOCSPValidator gOcspValidator;
                            LoggerBuffer lb = new LoggerBuffer();
                            lb.setLogDebug(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                            lb.setLogError(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                            GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                            try {
                                ocspValidator = new GestoreOCSPValidator(requestInfo, lb, trustStoreCertificatiX509, crl, ocspPolicy, (IOCSPResourceReader)ocspResourceReader);
                            }
                            catch (Exception e) {
                                throw new CoreException("Errore durante l'inizializzazione del gestore della policy OCSP (" + ocspPolicy + "): " + e.getMessage());
                            }
                            if (ocspValidator != null && (gOcspValidator = ocspValidator).getOcspConfig() != null) {
                                crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                            }
                        }
                        if (crl == null || crlByOcsp) break block46;
                        try {
                            trustStoreCertificatiX509crls = GestoreKeystoreCaching.getCRLCertstore(requestInfo, crl).getCertStore();
                        }
                        catch (Exception e) {
                            throw new CoreException("Errore durante la lettura delle CRLs (" + crl + "): " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        if (this.logError) {
                            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneSsl non riuscita", (Throwable)e);
                        }
                        esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        esito.setClientIdentified(false);
                        esito.setEccezioneProcessamento(e);
                        return esito;
                    }
                }
                if (checkValid && trustStoreCertificatiX509crls == null) {
                    try {
                        certificate.checkValid();
                    }
                    catch (Exception e) {
                        esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaSsl("credenziali fornite non corrette: " + e.getMessage(), subject));
                        esito.setClientAuthenticated(false);
                        esito.setClientIdentified(false);
                        if (wwwAuthenticateConfig != null) {
                            esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                        }
                        return esito;
                    }
                }
                if (trustStoreCertificatiX509 != null) {
                    try {
                        if (!certificate.isVerified(trustStoreCertificatiX509, true)) {
                            throw new CoreException("Certificato non verificabile rispetto alle CA conosciute");
                        }
                        if (trustStoreCertificatiX509crls == null) break block47;
                        try {
                            certificate.checkValid(trustStoreCertificatiX509crls, trustStoreCertificatiX509);
                        }
                        catch (Throwable t) {
                            throw new CoreException("Certificato non valido: " + t.getMessage());
                        }
                    }
                    catch (Exception e) {
                        esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaSsl("credenziali fornite non corrette: " + e.getMessage(), subject));
                        esito.setClientAuthenticated(false);
                        esito.setClientIdentified(false);
                        if (wwwAuthenticateConfig != null) {
                            esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                        }
                        return esito;
                    }
                }
            }
            if (ocspValidator != null) {
                try {
                    ocspValidator.valid(certificate.getCertificate());
                }
                catch (Throwable t) {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaSsl("credenziali fornite non corrette: " + t.getMessage(), subject));
                    esito.setClientAuthenticated(false);
                    esito.setClientIdentified(false);
                    if (!(t instanceof OCSPResponseException)) {
                        esito.setNoCache(true);
                    }
                    if (wwwAuthenticateConfig != null) {
                        esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                    }
                    return esito;
                }
            }
        }
        esito.setClientAuthenticated(true);
        esito.setCredential(subject);
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
            ConfigurazioneFiltroServiziApplicativi filtroHttps = ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps();
            if (certificate != null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, true, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null && certificate != null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, false, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, issuer, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, null, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo != null && soggettoFruitore == null) {
                soggettoFruitore = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneSsl non riuscita", (Throwable)e);
            }
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idServizioApplicativo == null) {
            esito.setClientIdentified(false);
        } else {
            if (OpenSPCoop2Properties.getInstance().isAutenticazioneHttpsPortaDelegataCheckSoggettiProprietari() && !idServizioApplicativo.getIdSoggettoProprietario().equals((Object)soggettoFruitore)) {
                esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaSsl("soggetto proprietario (" + String.valueOf(idServizioApplicativo.getIdSoggettoProprietario()) + ") dell'applicativo identificato (" + idServizioApplicativo.getNome() + ") differente dal soggetto proprietario della porta invocata (" + String.valueOf(soggettoFruitore) + ")", subject));
                esito.setClientIdentified(false);
                return esito;
            }
            esito.setClientIdentified(true);
            esito.setIdServizioApplicativo(idServizioApplicativo);
        }
        return esito;
    }
}

