/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pa;

import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.ApiKeyUtilities;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneUtils;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazioneApiKey;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pa.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.crypt.CryptConfig;

public class AutenticazioneApiKey
extends AbstractAutenticazioneBase {
    private boolean header = true;
    private boolean cookie = true;
    private boolean queryParameter = true;
    private String nomeHeaderApiKey = null;
    private String nomeCookieApiKey = null;
    private String nomeQueryParameterApiKey = null;
    private boolean appId = false;
    private String nomeHeaderAppId = null;
    private String nomeCookieAppId = null;
    private String nomeQueryParameterAppId = null;
    private boolean cleanApiKey = true;
    private boolean cleanAppId = true;
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public void initParametri(ParametriAutenticazione parametri) throws AutenticazioneException {
        super.initParametri(parametri);
        ParametriAutenticazioneApiKey authApiKey = new ParametriAutenticazioneApiKey(this.parametri);
        BooleanNullable bNullable = authApiKey.getHeader();
        if (bNullable != null && bNullable.getValue() != null) {
            this.header = bNullable.getValue();
        }
        if ((bNullable = authApiKey.getCookie()) != null && bNullable.getValue() != null) {
            this.cookie = bNullable.getValue();
        }
        if ((bNullable = authApiKey.getQueryParameter()) != null && bNullable.getValue() != null) {
            this.queryParameter = bNullable.getValue();
        }
        this.nomeHeaderApiKey = authApiKey.getNomeHeaderApiKey();
        this.nomeCookieApiKey = authApiKey.getNomeCookieApiKey();
        this.nomeQueryParameterApiKey = authApiKey.getNomeQueryParameterApiKey();
        bNullable = authApiKey.getAppId();
        if (bNullable != null && bNullable.getValue() != null) {
            this.appId = bNullable.getValue();
        }
        if (this.appId) {
            this.nomeHeaderAppId = authApiKey.getNomeHeaderAppId();
            this.nomeCookieAppId = authApiKey.getNomeCookieAppId();
            this.nomeQueryParameterAppId = authApiKey.getNomeQueryParameterAppId();
        }
        if ((bNullable = authApiKey.getCleanApiKey()) != null && bNullable.getValue() != null) {
            this.cleanApiKey = bNullable.getValue();
        }
        if (this.appId && (bNullable = authApiKey.getCleanAppId()) != null && bNullable.getValue() != null) {
            this.cleanAppId = bNullable.getValue();
        }
    }

    @Override
    public String getSuffixKeyAuthenticationResultInCache(DatiInvocazionePortaApplicativa datiInvocazione) {
        if (datiInvocazione == null) {
            return null;
        }
        try {
            String apiKey = ApiKeyUtilities.getKey(true, this.header, this.cookie, this.queryParameter, this.nomeHeaderApiKey, this.nomeCookieApiKey, this.nomeQueryParameterApiKey, datiInvocazione.getInfoConnettoreIngresso(), this.getPddContext(), false, new StringBuilder());
            if (apiKey == null) {
                return null;
            }
            if (this.appId) {
                String appId = ApiKeyUtilities.getKey(false, this.header, this.cookie, this.queryParameter, this.nomeHeaderAppId, this.nomeCookieAppId, this.nomeQueryParameterAppId, datiInvocazione.getInfoConnettoreIngresso(), this.getPddContext(), false, new StringBuilder());
                if (appId == null) {
                    return null;
                }
                return "multipleApiKey-" + appId + "." + apiKey;
            }
            return "apiKey-" + apiKey;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public EsitoAutenticazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        StringBuilder fullCredential = new StringBuilder();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazioneApiKeyWWWAuthenticateConfig();
        String apiKey = null;
        try {
            apiKey = ApiKeyUtilities.getKey(true, this.header, this.cookie, this.queryParameter, this.nomeHeaderApiKey, this.nomeCookieApiKey, this.nomeQueryParameterApiKey, datiInvocazione != null ? datiInvocazione.getInfoConnettoreIngresso() : null, this.getPddContext(), true, fullCredential);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneApiKey non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        if (apiKey == null || "".equals(apiKey)) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        String appId = null;
        if (this.appId) {
            try {
                appId = ApiKeyUtilities.getKey(false, this.header, this.cookie, this.queryParameter, this.nomeHeaderAppId, this.nomeCookieAppId, this.nomeQueryParameterAppId, datiInvocazione != null ? datiInvocazione.getInfoConnettoreIngresso() : null, this.getPddContext(), true, fullCredential);
            }
            catch (Exception e) {
                if (this.logError) {
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneApiKey (AppId) non riuscita", (Throwable)e);
                }
                esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
                esito.setClientAuthenticated(false);
                esito.setClientIdentified(false);
                esito.setFullCredential(fullCredential.toString());
                if (wwwAuthenticateConfig != null) {
                    esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
                }
                return esito;
            }
            if (appId == null || "".equals(appId)) {
                esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
                esito.setClientAuthenticated(false);
                esito.setClientIdentified(false);
                esito.setFullCredential(fullCredential.toString());
                if (wwwAuthenticateConfig != null) {
                    esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
                }
                return esito;
            }
        }
        esito.setFullCredential(fullCredential.toString());
        String identitaAutenticata = null;
        String password = null;
        try {
            if (this.appId) {
                identitaAutenticata = appId;
                password = ApiKeyUtilities.decodeMultipleApiKey(apiKey);
            } else {
                String[] decodedApiKey = ApiKeyUtilities.decodeApiKey(apiKey);
                identitaAutenticata = decodedApiKey[0];
                password = decodedApiKey[1];
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneApiKey (appId:" + this.appId + ") fallita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
            }
            return esito;
        }
        CryptConfig cryptConfigApplicativi = op2Properties.getCryptConfigAutenticazioneApplicativi();
        CryptConfig cryptConfigSoggetti = op2Properties.getCryptConfigAutenticazioneSoggetti();
        esito.setCredential(identitaAutenticata);
        IDSoggetto idSoggetto = null;
        try {
            RegistroServiziManager registroServiziManager = datiInvocazione != null ? RegistroServiziManager.getInstance((IState)datiInvocazione.getState()) : RegistroServiziManager.getInstance();
            idSoggetto = registroServiziManager.getIdSoggettoByCredenzialiApiKey(identitaAutenticata, password, this.appId, cryptConfigSoggetti, null);
        }
        catch (DriverRegistroServiziNotFound notFound) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("AutenticazioneApiKey (appId:" + this.appId + ") non ha trovato risultati", (Throwable)notFound);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneApiKey (appId:" + this.appId + ") non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            ConfigurazionePdDManager configurazionePdDManager;
            if (idSoggetto == null && this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && (idServizioApplicativo = (configurazionePdDManager = datiInvocazione != null ? ConfigurazionePdDManager.getInstance(datiInvocazione.getState()) : ConfigurazionePdDManager.getInstance()).getIdServizioApplicativoByCredenzialiApiKey(identitaAutenticata, password, this.appId, cryptConfigApplicativi)) != null && idSoggetto == null) {
                idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneApiKey (appId:" + this.appId + ") (Applicativi) non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idSoggetto == null) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
            }
            return esito;
        }
        esito.setClientAuthenticated(true);
        esito.setClientIdentified(true);
        esito.setIdSoggetto(idSoggetto);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }

    @Override
    public void cleanPostAuth(OpenSPCoop2Message message) throws AutenticazioneException {
        AutenticazioneUtils.finalizeProcessApiKey(message, this.header, this.cookie, this.queryParameter, this.nomeHeaderApiKey, this.nomeCookieApiKey, this.nomeQueryParameterApiKey, this.cleanApiKey);
        if (this.appId) {
            AutenticazioneUtils.finalizeProcessApiKey(message, this.header, this.cookie, this.queryParameter, this.nomeHeaderAppId, this.nomeCookieAppId, this.nomeQueryParameterAppId, this.cleanAppId);
        }
    }
}

