/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.io.Serializable;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.utils.BooleanNullable;

public class ParametriAutenticazionePrincipal
extends ParametriAutenticazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TIPO_AUTENTICAZIONE = "tipoAutenticazione";
    public static final String NOME = "nome";
    public static final String PATTERN = "pattern";
    public static final String CLEAN_PRINCIPAL = "cleanPrincipal";
    public static final String CLEAN_PRINCIPAL_TRUE = "true";
    public static final String CLEAN_PRINCIPAL_FALSE = "false";
    public static final String TOKEN_CLAIM = "claim";
    public static final String TOKEN_CLAIM_ISSUER = "issuer";
    public static final String TOKEN_CLAIM_SUBJECT = "subject";
    public static final String TOKEN_CLAIM_CLIENT_ID = "clientId";
    public static final String TOKEN_CLAIM_USERNAME = "username";
    public static final String TOKEN_CLAIM_EMAIL = "eMail";
    public static final String TOKEN_CLAIM_CUSTOM = "custom";

    public ParametriAutenticazionePrincipal(ParametriAutenticazione parametri) {
        super(parametri);
    }

    public TipoAutenticazionePrincipal getTipoAutenticazione() {
        String valore = this.get(TIPO_AUTENTICAZIONE);
        if (valore == null || "".equals(valore)) {
            return null;
        }
        return TipoAutenticazionePrincipal.toEnumConstant((String)valore);
    }

    public String getNome() {
        String valore = this.get(NOME);
        if (valore == null || "".equals(valore)) {
            return null;
        }
        return valore;
    }

    public String getPattern() {
        String valore = this.get(PATTERN);
        if (valore == null || "".equals(valore)) {
            return null;
        }
        return valore;
    }

    public BooleanNullable getCleanPrincipal() {
        String valore = this.get(CLEAN_PRINCIPAL);
        if (valore == null || "".equals(valore)) {
            return BooleanNullable.NULL();
        }
        if (CLEAN_PRINCIPAL_FALSE.equalsIgnoreCase(valore)) {
            return BooleanNullable.FALSE();
        }
        if (CLEAN_PRINCIPAL_TRUE.equalsIgnoreCase(valore)) {
            return BooleanNullable.TRUE();
        }
        return BooleanNullable.NULL();
    }

    public TipoCredenzialeMittente getTokenClaim() {
        String valore = this.get(TOKEN_CLAIM);
        if (valore == null || "".equals(valore)) {
            return null;
        }
        if (TOKEN_CLAIM_ISSUER.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TOKEN_ISSUER;
        }
        if (TOKEN_CLAIM_SUBJECT.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TOKEN_SUBJECT;
        }
        if (TOKEN_CLAIM_CLIENT_ID.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TOKEN_CLIENT_ID;
        }
        if (TOKEN_CLAIM_USERNAME.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TOKEN_USERNAME;
        }
        if (TOKEN_CLAIM_EMAIL.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TOKEN_EMAIL;
        }
        if (TOKEN_CLAIM_CUSTOM.equalsIgnoreCase(valore)) {
            return TipoCredenzialeMittente.TRASPORTO;
        }
        return null;
    }
}

