/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;

public class ParametriAutenticazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String separator = "@@@";
    private static final String separator_line = "@#@";
    protected HashMap<String, String> map = new HashMap();

    public ParametriAutenticazione() {
    }

    public ParametriAutenticazione(List<Proprieta> list) {
        if (list != null && !list.isEmpty()) {
            for (Proprieta proprieta : list) {
                this.map.put(proprieta.getNome(), proprieta.getValore());
            }
        }
    }

    public ParametriAutenticazione(ParametriAutenticazione p) {
        if (p != null && p.map != null) {
            this.map = p.map;
        }
    }

    public ParametriAutenticazione(String dbValue) throws AutenticazioneException {
        if (dbValue != null) {
            if (!dbValue.contains(separator)) {
                throw new AutenticazioneException("Formato errato");
            }
            if (dbValue.contains(separator_line)) {
                String[] linee = dbValue.split(separator_line);
                if (linee == null || linee.length <= 0) {
                    throw new AutenticazioneException("Formato errato (linea senza valori?)");
                }
                for (int i = 0; i < linee.length; ++i) {
                    String linea = linee[i];
                    String[] tmp = linea.split(separator);
                    if (tmp == null || tmp.length != 2) {
                        throw new AutenticazioneException("Formato errato (coppia non presente?)");
                    }
                    this.map.put(tmp[0], tmp[1]);
                }
            } else {
                String[] tmp = dbValue.split(separator);
                if (tmp == null || tmp.length != 2) {
                    throw new AutenticazioneException("Formato errato (coppia non presente?)");
                }
                this.map.put(tmp[0], tmp[1]);
            }
        }
    }

    public void add(String nome, String valore) {
        this.map.put(nome, valore);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String convertToDBValue() {
        if (this.map.isEmpty()) {
            return null;
        }
        StringBuilder bf = new StringBuilder();
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            if (bf.length() > 0) {
                bf.append(separator_line);
            }
            String key = it.next();
            String value = this.map.get(key);
            bf.append(key).append(separator).append(value);
        }
        return bf.toString();
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "";
        }
        StringBuilder bf = new StringBuilder();
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            String key = it.next();
            String value = this.map.get(key);
            bf.append(key).append("=").append(value);
        }
        return bf.toString();
    }
}

