/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.util.Map;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.utils.transport.TransportUtils;

public class AutenticazioneUtils {
    public static void finalizeProcessHeaderAuthorization(OpenSPCoop2Message message, boolean clean) throws AutenticazioneException {
        try {
            String headerValue;
            if (message.getTransportRequestContext() != null && message.getTransportRequestContext().getHeaders() != null && (headerValue = message.getTransportRequestContext().getHeaderFirstValue("Authorization")) != null) {
                message.getTransportRequestContext().removeHeader("Authorization");
                if (!clean) {
                    message.forceTransportHeader("Authorization", headerValue);
                }
            }
        }
        catch (Throwable t) {
            throw new AutenticazioneException("Clean Header Authorization failed: " + t.getMessage(), t);
        }
    }

    public static void finalizeProcessPrincipal(OpenSPCoop2Message message, TipoAutenticazionePrincipal tipoAutenticazionePrincipal, String nome, boolean clean) throws AutenticazioneException {
        try {
            switch (tipoAutenticazionePrincipal) {
                case CONTAINER: 
                case INDIRIZZO_IP: 
                case INDIRIZZO_IP_X_FORWARDED_FOR: 
                case URL: 
                case TOKEN: {
                    break;
                }
                case HEADER: {
                    if (nome == null || message.getTransportRequestContext() == null || message.getTransportRequestContext().getHeaders() == null) break;
                    String headerValue = message.getTransportRequestContext().getHeaderFirstValue(nome);
                    if (headerValue != null) {
                        message.getTransportRequestContext().removeHeader(nome);
                        if (!clean) {
                            message.forceTransportHeader(nome, headerValue);
                        }
                    }
                    break;
                }
                case FORM: {
                    String propertyValue;
                    if (message.getTransportRequestContext() == null || message.getTransportRequestContext().getParameters() == null || (propertyValue = message.getTransportRequestContext().getParameterFirstValue(nome)) == null) break;
                    message.getTransportRequestContext().removeParameter(nome);
                    if (clean) break;
                    message.forceUrlProperty(nome, propertyValue);
                }
            }
        }
        catch (Throwable t) {
            throw new AutenticazioneException("Clean Principal failed: " + t.getMessage(), t);
        }
    }

    public static void finalizeProcessApiKey(OpenSPCoop2Message message, boolean header, boolean cookie, boolean queryParameter, String nomeHeader, String nomeCookie, String nomeQueryParameter, boolean clean) throws AutenticazioneException {
        String propertyValue;
        String headerValue;
        if (header && nomeHeader != null && message.getTransportRequestContext() != null && message.getTransportRequestContext().getHeaders() != null && (headerValue = message.getTransportRequestContext().getHeaderFirstValue(nomeHeader)) != null) {
            message.getTransportRequestContext().removeHeader(nomeHeader);
            if (!clean) {
                message.forceTransportHeader(nomeHeader, headerValue);
            }
        }
        if (cookie && nomeCookie != null && message.getTransportRequestContext() != null && message.getTransportRequestContext().getHeaders() != null && (headerValue = message.getTransportRequestContext().getHeaderFirstValue("Cookie")) != null) {
            message.getTransportRequestContext().removeHeader("Cookie");
            if (!clean) {
                TransportUtils.setHeader((Map)message.getTransportRequestContext().getHeaders(), (String)"Cookie", (String)headerValue);
                message.forceTransportHeader("Cookie", headerValue);
            } else {
                String[] tmp = headerValue.split(";");
                StringBuilder sb = new StringBuilder();
                if (tmp != null && tmp.length > 0) {
                    for (int i = 0; i < tmp.length; ++i) {
                        String name;
                        String cNameValue = tmp[i];
                        String[] c = cNameValue.split("=");
                        if (c == null || c.length <= 0 || nomeCookie.equalsIgnoreCase(name = c[0])) continue;
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(cNameValue);
                    }
                }
                if (sb.length() > 0) {
                    TransportUtils.setHeader((Map)message.getTransportRequestContext().getHeaders(), (String)"Cookie", (String)sb.toString());
                }
            }
        }
        if (queryParameter && message.getTransportRequestContext() != null && message.getTransportRequestContext().getParameters() != null && (propertyValue = message.getTransportRequestContext().getParameterFirstValue(nomeQueryParameter)) != null) {
            message.getTransportRequestContext().removeParameter(nomeQueryParameter);
            if (!clean) {
                message.forceUrlProperty(nomeQueryParameter, propertyValue);
            }
        }
    }
}

