/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.utils.crypt.PasswordGenerator;
import org.openspcoop2.utils.io.Base64Utilities;

public class ApiKeyUtilities {
    private static final String SOGGETTO_SEPARATOR = ".";
    public static final String APPLICATIVO_SOGGETTO_SEPARATOR = "@";
    private static final int MAX_ALREADY_EXISTS = 5000;
    private static final String SEPARATOR_ALREADY_EXISTS = ".";
    private static final String PREFIX_SEPARATOR_API_KEY = ".";
    private static final String PREFIX_SEPARATOR_API_KEY_REGEXP = "\\.";

    public static String getKey(boolean apiKey, boolean header, boolean cookie, boolean queryParameter, String nomeHeader, String nomeCookie, String nomeQueryParameter, InfoConnettoreIngresso infoConnettore, PdDContext pddContext, boolean throwException, StringBuilder fullCredential) throws AutenticazioneException {
        String tipo = apiKey ? "ApiKey" : "AppId";
        String key = null;
        if (queryParameter) {
            if (nomeQueryParameter == null && throwException) {
                throw new AutenticazioneException("Nome del parametro della query, da cui estrarre l'" + tipo + ", non indicato");
            }
            if (nomeQueryParameter != null && infoConnettore != null && infoConnettore.getUrlProtocolContext() != null && (key = infoConnettore.getUrlProtocolContext().getParameterFirstValue(nomeQueryParameter)) != null && "".equals(key.trim())) {
                key = null;
            }
        }
        if (key != null) {
            if (fullCredential.length() > 0) {
                fullCredential.append("\n");
            }
            fullCredential.append(tipo).append(" (query) '").append(nomeQueryParameter);
            if (!apiKey) {
                fullCredential.append(": ").append(key);
            }
            fullCredential.append("'");
            return key;
        }
        if (header) {
            if (nomeHeader == null && throwException) {
                throw new AutenticazioneException("Nome dell'header, da cui estrarre l'" + tipo + ", non indicato");
            }
            if (nomeHeader != null && infoConnettore != null && infoConnettore.getUrlProtocolContext() != null && (key = infoConnettore.getUrlProtocolContext().getHeaderFirstValue(nomeHeader)) != null && "".equals(key.trim())) {
                key = null;
            }
        }
        if (key != null) {
            if (fullCredential.length() > 0) {
                fullCredential.append("\n");
            }
            fullCredential.append(tipo).append(" (http) '").append(nomeHeader);
            if (!apiKey) {
                fullCredential.append(": ").append(key);
            }
            fullCredential.append("'");
            return key;
        }
        if (cookie) {
            if (nomeCookie == null && throwException) {
                throw new AutenticazioneException("Nome del cookie, da cui estrarre l'" + tipo + ", non indicato");
            }
            if (nomeCookie != null && infoConnettore != null && infoConnettore.getUrlProtocolContext() != null && (key = infoConnettore.getUrlProtocolContext().getCookieValue(nomeCookie)) != null && "".equals(key.trim())) {
                key = null;
            }
        }
        if (key != null) {
            if (fullCredential.length() > 0) {
                fullCredential.append("\n");
            }
            fullCredential.append(tipo).append(" (cookie) '").append(nomeCookie);
            if (!apiKey) {
                fullCredential.append(": ").append(key);
            }
            fullCredential.append("'");
            return key;
        }
        if (throwException) {
            throw new AutenticazioneException(tipo + " non presente nella richiesta");
        }
        return null;
    }

    public static String toAppId(String protocollo, IDSoggetto idSoggetto, boolean multipleApiKeys, DriverRegistroServiziDB driver) throws Exception {
        String appId = ApiKeyUtilities._toAppId(protocollo, idSoggetto);
        if (!ApiKeyUtilities._existsAppId(appId, multipleApiKeys, idSoggetto, driver)) {
            return appId;
        }
        for (int i = 2; i < 5000; ++i) {
            IDSoggetto idSoggettoAlreadyExists = new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome() + "." + i);
            String appIdAlreadyExists = ApiKeyUtilities._toAppId(protocollo, idSoggettoAlreadyExists);
            if (ApiKeyUtilities._existsAppId(appIdAlreadyExists, multipleApiKeys, idSoggetto, driver)) continue;
            return appIdAlreadyExists;
        }
        throw new Exception("Generazione appId univoco non riuscita dopo 5000 tentativi");
    }

    private static String _toAppId(String protocollo, IDSoggetto idSoggetto) throws Exception {
        if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
            throw new Exception("Identificativo soggetto non definito");
        }
        return idSoggetto.getNome() + "." + idSoggetto.getTipo();
    }

    private static boolean _existsAppId(String appId, boolean multipleApiKeys, IDSoggetto idSoggetto, DriverRegistroServiziDB driver) throws Exception {
        Soggetto soggetto = driver.soggettoWithCredenzialiApiKey(appId, multipleApiKeys);
        if (soggetto == null) {
            return false;
        }
        boolean isSame = false;
        if (soggetto.getTipo().equals(idSoggetto.getTipo()) && soggetto.getNome().equals(idSoggetto.getNome())) {
            isSame = true;
        }
        return !isSame;
    }

    public static String toAppId(String protocollo, IDServizioApplicativo idSA, boolean multipleApiKeys, DriverConfigurazioneDB driver) throws Exception {
        String appId = ApiKeyUtilities._toAppId(protocollo, idSA.getNome(), idSA.getIdSoggettoProprietario());
        if (!ApiKeyUtilities._existsAppId(appId, multipleApiKeys, idSA, driver)) {
            return appId;
        }
        for (int i = 2; i < 5000; ++i) {
            String appIdAlreadyExists = ApiKeyUtilities._toAppId(protocollo, idSA.getNome() + "." + i, idSA.getIdSoggettoProprietario());
            if (ApiKeyUtilities._existsAppId(appIdAlreadyExists, multipleApiKeys, idSA, driver)) continue;
            return appIdAlreadyExists;
        }
        throw new Exception("Generazione appId univoco non riuscita dopo 5000 tentativi");
    }

    private static String _toAppId(String protocollo, String nomeSA, IDSoggetto idSoggetto) throws Exception {
        return nomeSA + APPLICATIVO_SOGGETTO_SEPARATOR + ApiKeyUtilities._toAppId(protocollo, idSoggetto);
    }

    private static boolean _existsAppId(String appId, boolean multipleApiKeys, IDServizioApplicativo idSA, DriverConfigurazioneDB driver) throws Exception {
        List saList = driver.servizioApplicativoWithCredenzialiApiKeyList(appId, multipleApiKeys);
        if (saList == null || saList.isEmpty()) {
            return false;
        }
        boolean isSame = false;
        for (ServizioApplicativo servizioApplicativo : saList) {
            if (!servizioApplicativo.getNome().equals(idSA.getNome()) || !servizioApplicativo.getTipoSoggettoProprietario().equals(idSA.getIdSoggettoProprietario().getTipo()) || !servizioApplicativo.getNomeSoggettoProprietario().equals(idSA.getIdSoggettoProprietario().getNome())) continue;
            isSame = true;
            break;
        }
        return !isSame;
    }

    private static String getPrefixForApiKey(String protocollo, IDSoggetto idSoggetto, DriverRegistroServiziDB driver) throws Exception {
        boolean multipleApiKeys = false;
        String appId = ApiKeyUtilities.toAppId(protocollo, idSoggetto, multipleApiKeys, driver);
        return Base64Utilities.encodeAsString((byte[])appId.getBytes()) + ".";
    }

    public static ApiKey newApiKey(String protocollo, IDSoggetto idSoggetto, int length, DriverRegistroServiziDB driver) throws Exception {
        ApiKey apiKey = new ApiKey();
        String password = ApiKeyUtilities.getPassword(length);
        String apiKeyToken = ApiKeyUtilities.getPrefixForApiKey(protocollo, idSoggetto, driver) + Base64Utilities.encodeAsString((byte[])password.getBytes());
        apiKey.setApiKey(apiKeyToken);
        apiKey.setPassword(password);
        return apiKey;
    }

    private static String getPrefixForApiKey(String protocollo, IDServizioApplicativo idSA, DriverConfigurazioneDB driver) throws Exception {
        boolean multipleApiKeys = false;
        String appId = ApiKeyUtilities.toAppId(protocollo, idSA, multipleApiKeys, driver);
        return Base64Utilities.encodeAsString((byte[])appId.getBytes()) + ".";
    }

    public static ApiKey newApiKey(String protocollo, IDServizioApplicativo idSA, int length, DriverConfigurazioneDB driver) throws Exception {
        ApiKey apiKey = new ApiKey();
        String password = ApiKeyUtilities.getPassword(length);
        String apiKeyToken = ApiKeyUtilities.getPrefixForApiKey(protocollo, idSA, driver) + Base64Utilities.encodeAsString((byte[])password.getBytes());
        apiKey.setApiKey(apiKeyToken);
        apiKey.setPassword(password);
        return apiKey;
    }

    public static String encodeApiKey(String appId, String password) throws Exception {
        return Base64Utilities.encodeAsString((byte[])appId.getBytes()) + "." + Base64Utilities.encodeAsString((byte[])password.getBytes());
    }

    public static String[] decodeApiKey(String apiKeyBase64) throws Exception {
        if (!apiKeyBase64.contains(".")) {
            throw new Exception("Formato non corretto");
        }
        String[] tmp = apiKeyBase64.split(PREFIX_SEPARATOR_API_KEY_REGEXP);
        if (tmp == null || tmp.length != 2) {
            throw new Exception("Formato non corretto (.)");
        }
        try {
            tmp[0] = new String(Base64Utilities.decode((String)tmp[0]));
        }
        catch (Exception e) {
            throw new Exception("Formato non corretto (appId)", e);
        }
        try {
            tmp[1] = new String(Base64Utilities.decode((String)tmp[1]));
        }
        catch (Exception e) {
            throw new Exception("Formato non corretto (appKey)", e);
        }
        return tmp;
    }

    public static ApiKey newMultipleApiKey(int length) throws Exception {
        ApiKey apiKey = new ApiKey();
        String password = ApiKeyUtilities.getPassword(length);
        String apiKeyToken = ApiKeyUtilities.encodeMultipleApiKey(password);
        apiKey.setApiKey(apiKeyToken);
        apiKey.setPassword(password);
        return apiKey;
    }

    public static String decodeMultipleApiKey(String apiKeyBase64) throws Exception {
        return new String(Base64Utilities.decode((String)apiKeyBase64));
    }

    public static String encodeMultipleApiKey(String password) throws Exception {
        return Base64Utilities.encodeAsString((byte[])password.getBytes());
    }

    private static String getPassword(int length) throws Exception {
        PasswordGenerator pwdGenerator = PasswordGenerator.DEFAULT;
        return pwdGenerator.generate(length);
    }
}

