/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.IPdDContextSerializer;
import org.openspcoop2.pdd.core.JMSReceiver;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.SavedMessage;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.skeleton.IdentificativoIM;
import org.openspcoop2.pdd.services.skeleton.MessaggioIM;
import org.openspcoop2.pdd.timers.TimerConsegnaContenutiApplicativiThread;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.DaylightSavingUtils;
import org.openspcoop2.utils.date.TimeTransitionType;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.semaphore.ISemaphoreEventGenerator;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreLogEventGenerator;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.slf4j.Logger;

public class GestoreMessaggi {
    private Logger log = null;
    private IOpenSPCoopState openspcoopstate = null;
    private boolean isRichiesta = false;
    private boolean readyForDrop = false;
    private boolean portaDiTipoStateless = false;
    private boolean routingStateless;
    private boolean oneWayVersione11 = false;
    public static final String MESSAGGI = "MESSAGGI";
    public static final String MESSAGGI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String MESSAGGI_COLUMN_TIPO_MESSAGGIO = "TIPO";
    public static final String MESSAGGI_COLUMN_RIFERIMENTO_MSG = "RIFERIMENTO_MSG";
    public static final String MESSAGGI_COLUMN_ORA_REGISTRAZIONE = "ORA_REGISTRAZIONE";
    public static final String MESSAGGI_COLUMN_PROPRIETARIO = "PROPRIETARIO";
    public static final String MESSAGGI_COLUMN_PROTOCOLLO = "PROTOCOLLO";
    public static final String MESSAGGI_COLUMN_ID_TRANSAZIONE = "id_transazione";
    public static final String MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RICHIESTA = "CORRELAZIONE_APPLICATIVA";
    public static final String MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RISPOSTA = "CORRELAZIONE_RISPOSTA";
    public static final String MSG_SERVIZI_APPLICATIVI = "MSG_SERVIZI_APPLICATIVI";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_TIPO = "TIPO";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO = "SERVIZIO_APPLICATIVO";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_ORA_REGISTRAZIONE = "ORA_REGISTRAZIONE";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_INTEGRATION_MANAGER = "INTEGRATION_MANAGER";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_LOCK_CONSEGNA = "LOCK_CONSEGNA";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_ATTESA_ESITO = "ATTESA_ESITO";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_ERRORE_PROCESSAMENTO_COMPACT = "ERRORE_PROCESSAMENTO_COMPACT";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_TIPO_CONSEGNA = "TIPO_CONSEGNA";
    public static final String DEFINIZIONE_MESSAGGI = "DEFINIZIONE_MESSAGGI";
    public static final String DEFINIZIONE_MESSAGGI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String DEFINIZIONE_MESSAGGI_COLUMN_TIPO_MESSAGGIO = "TIPO";
    public static final String DEFINIZIONE_MESSAGGI_COLUMN_ORA_REGISTRAZIONE = "ORA_REGISTRAZIONE";
    public static final String CONSEGNA_TRAMITE_CONNETTORE = "Connettore";
    public static final String CONSEGNA_TRAMITE_CONNECTION_REPLY = "ConnectionReply";
    public static final String CONSEGNA_TRAMITE_INTEGRATION_MANAGER = "IntegrationManager";
    private static Random _rnd = null;
    private MsgDiagnostico msgDiag;
    private String idBusta;
    private String workDir;
    private String tipo;
    private OpenSPCoop2Properties propertiesReader;
    private static final String GESTORE_MESSAGGI_CACHE_NAME = "gestoreMessaggi";
    private static Cache cacheMappingGestoreMessaggi = null;
    private static String cluster_id = null;
    private PdDContext pddContext = null;
    private IProtocolFactory<?> protocolFactory = null;
    private String idTransazione;
    private Map<String, String> tableProprietariMessaggiGestiti;
    private Map<String, Boolean> tableMessaggiGestiti;
    private static IJDBCAdapter adapter = null;
    private static boolean adapterInitialized = false;
    private static IPdDContextSerializer pddContextSerializer = null;
    private static boolean pddContextSerializerInitialized = false;
    private boolean deleted = false;
    public static final String NUMERO_RISPEDIZIONE = "[spedizione n.";
    private static StringBuilder LOCK = new StringBuilder();
    private static String LOCK_MODULO = null;
    private static final int LOCK_NUMBER_OF_PERMITS = 1;
    private static final boolean LOCK_FAIR_FIFO = true;
    private static java.util.concurrent.Semaphore LOCK_SEMAPHORE = new java.util.concurrent.Semaphore(1, true);

    public IOpenSPCoopState getOpenspcoopstate() {
        return this.openspcoopstate;
    }

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (_rnd == null) {
            GestoreMessaggi.initRandom();
        }
        return _rnd;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public static void resetCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                cacheMappingGestoreMessaggi.clear();
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws GestoreMessaggiException {
        try {
            if (cacheMappingGestoreMessaggi != null) {
                return cacheMappingGestoreMessaggi.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new GestoreMessaggiException("Visualizzazione Statistiche riguardante la cache dei messaggi gestiti non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        GestoreMessaggi._abilitaCache();
    }

    private static synchronized void _abilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi == null) {
            try {
                cacheMappingGestoreMessaggi = new Cache(CacheType.JCS, GESTORE_MESSAGGI_CACHE_NAME);
                cacheMappingGestoreMessaggi.build();
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        try {
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString();
            GestoreMessaggi.initCacheGestoreMessaggi(CacheType.JCS, (int)dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, null, null);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi == null) {
            throw new GestoreMessaggiException("Cache gia' disabilitata");
        }
        GestoreMessaggi._disabilitaCache();
    }

    private static synchronized void _disabilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                cacheMappingGestoreMessaggi.clear();
                cacheMappingGestoreMessaggi = null;
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheMappingGestoreMessaggi != null;
    }

    public static String listKeysCache(String separator) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                return cacheMappingGestoreMessaggi.printKeys(separator);
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
        throw new GestoreMessaggiException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                Object o = cacheMappingGestoreMessaggi.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
        throw new GestoreMessaggiException("Cache non abilitata");
    }

    public static void removeObjectCache(String key) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        } else {
            throw new GestoreMessaggiException("Cache non abilitata");
        }
    }

    public static void initialize() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        if (properties.isAbilitataCacheGestoreMessaggi()) {
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
            int dimensioneCache = properties.getDimensioneCacheGestoreMessaggi();
            String algoritmoCache = properties.getAlgoritmoCacheGestoreMessaggi();
            long itemIdleTime = properties.getItemIdleTimeCacheGestoreMessaggi();
            long itemLifeSecond = properties.getItemLifeSecondCacheGestoreMessaggi();
            CacheType cacheType = properties.getCacheTypeMessage();
            GestoreMessaggi.initCacheGestoreMessaggi(cacheType, dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, log, logConsole);
        }
    }

    public static void initCacheGestoreMessaggi(CacheType cacheType, int dimensioneCache, String algoritmoCache, long itemIdleTime, long itemLifeSecond, Logger log, Logger logConsole) throws Exception {
        if (log != null) {
            log.info("Inizializzazione cache gestoreMessaggi");
        }
        if (logConsole != null) {
            logConsole.info("Inizializzazione cache gestoreMessaggi");
        }
        cacheMappingGestoreMessaggi = new Cache(cacheType, GESTORE_MESSAGGI_CACHE_NAME);
        String msg = null;
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Gestore Messaggi) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info(msg);
                    }
                    if (logConsole != null) {
                        logConsole.info(msg);
                    }
                    cacheMappingGestoreMessaggi.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage());
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Gestore Messaggi) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info(msg);
                }
                if (logConsole != null) {
                    logConsole.info(msg);
                }
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheMappingGestoreMessaggi.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheMappingGestoreMessaggi.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (itemIdleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (Gestore Messaggi) impostato al valore: " + itemIdleTime;
                if (log != null) {
                    log.info(msg);
                }
                if (logConsole != null) {
                    logConsole.info(msg);
                }
                cacheMappingGestoreMessaggi.setItemIdleTime(itemIdleTime);
            }
            catch (Exception error) {
                throw new DriverConfigurazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage());
            }
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (Gestore Messaggi) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            if (logConsole != null) {
                logConsole.info(msg);
            }
            cacheMappingGestoreMessaggi.setItemLifeTime(itemLifeSecond);
        }
        catch (Exception error) {
            throw new DriverConfigurazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage());
        }
        cacheMappingGestoreMessaggi.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cacheMappingGestoreMessaggi == null) {
            throw new UtilsException("Cache disabled");
        }
        cacheMappingGestoreMessaggi.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cacheMappingGestoreMessaggi == null) {
            throw new UtilsException("Cache disabled");
        }
        return cacheMappingGestoreMessaggi.isDisableSyncronizedGet();
    }

    public static String cacheToString() throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            StringBuilder bf = new StringBuilder();
            bf.append("Cache GestoreMessaggi: " + cacheMappingGestoreMessaggi.printStats(" "));
            return bf.toString();
        }
        return "Cache non abilitata";
    }

    public static void addIntoCache_MappingRifMsgToId(MsgDiagnostico msgDiag, String tipoMessaggio, String riferimentoMessaggio, String idBusta) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            cacheMappingGestoreMessaggi.put(key, (Serializable)((Object)idBusta));
        }
    }

    public static String getFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get("mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio);
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_Proprietario(MsgDiagnostico msgDiag, String tipoMessaggio, String idBusta, String proprietario) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = proprietario;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBuste")) {
                prop = "RicezioneBuste";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idBusta + ")";
            cacheMappingGestoreMessaggi.put(key, (Serializable)((Object)proprietario));
        }
    }

    public static String getFromCache_Proprietario(String idModulo, String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = idModulo;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBuste")) {
                prop = "RicezioneBuste";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idBusta + ")";
            Object obj = cacheMappingGestoreMessaggi.get(key);
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_Proprietario(String modulo, String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "proprietario_to" + modulo + "_(" + tipoMessaggio + "_" + idBusta + ")";
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_existsMessage(MsgDiagnostico msgDiag, String tipoMessaggio, String idBusta) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idBusta;
            cacheMappingGestoreMessaggi.put(key, (Serializable)Boolean.valueOf(true));
        }
    }

    public static boolean getFromCache_existsMessage(String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get("existsMessage_" + tipoMessaggio + "_" + idBusta);
            if (obj != null) {
                return (Boolean)obj;
            }
            return false;
        }
        return false;
    }

    public static void deleteFromCache_existsMessage(String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idBusta;
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addProprietarioIntoTable(String tipo, String idBusta, String proprietario) {
        this.tableProprietariMessaggiGestiti.put(tipo + "@" + idBusta, proprietario);
    }

    public void addProprietariMsgGestitiFromTable(Map<String, String> t) throws UtilsException {
        this.tableProprietariMessaggiGestiti.putAll(t);
    }

    public Map<String, String> getTableProprietariMessaggiGestiti() {
        return this.tableProprietariMessaggiGestiti;
    }

    public void addProprietariIntoCache_readFromTable(String modulo, String descrizione, String idBustaRichiestaCorrelata, boolean router) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        for (String key : this.tableProprietariMessaggiGestiti.keySet()) {
            String[] idTipo = key.split("@");
            String value = this.tableProprietariMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_Proprietario(this.msgDiag, idTipo[0], idTipo[1], value);
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
                if ("GestoreMessaggi".equals(value)) {
                    this.puliziaCache(modulo, this.idBusta, this.tipo, idBustaRichiestaCorrelata, router);
                    continue;
                }
                this.puliziaCacheAltriProprietari(modulo, this.idBusta, this.tipo);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_Proprietario(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value);
                this.log.error("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita", (Throwable)e);
            }
        }
    }

    public void puliziaCacheAltriProprietari(String moduloVecchio, String idBusta, String tipo) {
        if (moduloVecchio.indexOf("RicezioneContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idBusta);
        } else if (moduloVecchio.indexOf("Imbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idBusta);
        } else if (moduloVecchio.indexOf("InoltroBuste") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
        } else if (moduloVecchio.indexOf("SbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idBusta);
        } else if (moduloVecchio.indexOf("RicezioneBuste") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
        } else if (moduloVecchio.indexOf("Sbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idBusta);
        } else if (moduloVecchio.indexOf("ConsegnaContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idBusta);
        } else if (moduloVecchio.indexOf("InoltroRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposte", tipo, idBusta);
        } else if (moduloVecchio.indexOf("ImbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idBusta);
        }
    }

    public void puliziaCache(String modulo, String idBusta, String tipo, String idBustaRichiesta, boolean router) {
        try {
            GestoreMessaggi.deleteFromCache_existsMessage(tipo, idBusta);
            if (idBustaRichiesta != null) {
                GestoreMessaggi.deleteFromCache_idFromRifMsgMapping(tipo, idBustaRichiesta);
            }
            if (router) {
                if (idBustaRichiesta == null) {
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
                }
            } else if (idBustaRichiesta == null) {
                if ("OUTBOX".equals(tipo)) {
                    GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idBusta);
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idBusta);
                    GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idBusta);
                }
            } else if ("INBOX".equals(tipo)) {
                GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idBusta);
            } else {
                GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposte", tipo, idBusta);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.puliziaCache(Modulo:" + modulo + ",Per:" + idBusta + "/" + tipo + ",Router:" + router);
            this.log.error("Pulizia della cache non riuscita (Modulo:" + modulo + ") per [" + idBusta + "/" + tipo + "] router[" + router + "]", (Throwable)e);
        }
    }

    private void addMessaggioIntoTable(String tipo, String idBusta) {
        this.tableMessaggiGestiti.put(tipo + "@" + idBusta, true);
    }

    public void addMsgGestitiFromTable(Map<String, Boolean> t) throws UtilsException {
        this.tableMessaggiGestiti.putAll(t);
    }

    public Map<String, Boolean> getTableMessaggiGestiti() {
        return this.tableMessaggiGestiti;
    }

    public void addMessaggiIntoCache_readFromTable(String modulo, String descrizione) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        for (String key : this.tableMessaggiGestiti.keySet()) {
            String[] idTipo = key.split("@");
            Boolean value = this.tableMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_existsMessage(this.msgDiag, idTipo[0], idTipo[1]);
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_existsMessage(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value);
                this.log.error("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita", (Throwable)e);
            }
        }
    }

    private static synchronized void initAdapter(Logger log, OpenSPCoop2Properties propertiesReader) {
        if (!adapterInitialized) {
            if (!propertiesReader.isRepositoryOnFS()) {
                try {
                    String jdbcAdapter = propertiesReader.getRepositoryJDBCAdapter();
                    if (propertiesReader.getDatabaseType() != null && TipiDatabase.DEFAULT.equals(jdbcAdapter)) {
                        adapter = JDBCAdapterFactory.createJDBCAdapter((String)propertiesReader.getDatabaseType());
                    } else {
                        ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                        String adapterClass = classNameProperties.getJDBCAdapter(jdbcAdapter);
                        if (adapterClass == null) {
                            log.error("Inizializzione GestoreMessaggi non riuscita: AdapterClass non registrata [" + propertiesReader.getRepositoryJDBCAdapter() + "]");
                        }
                        Loader loader = Loader.getInstance();
                        adapter = (IJDBCAdapter)loader.newInstance(adapterClass);
                    }
                }
                catch (Exception e) {
                    log.error("Inizializzione GestoreMessaggi non riuscita: AdapterClass non trovata [" + propertiesReader.getRepositoryJDBCAdapter() + "]:" + e.getMessage(), (Throwable)e);
                }
            }
            adapterInitialized = true;
        }
    }

    private static synchronized void initPddContextSerializer(Logger log, OpenSPCoop2Properties propertiesReader) {
        if (!pddContextSerializerInitialized) {
            String pddContextSerializerClass = propertiesReader.getPddContextSerializer();
            if (pddContextSerializerClass != null && !"none".equals(pddContextSerializerClass)) {
                try {
                    Loader loader = Loader.getInstance();
                    pddContextSerializer = (IPdDContextSerializer)loader.newInstance(pddContextSerializerClass);
                }
                catch (Exception e) {
                    log.error("Inizializzione GestoreMessaggi non riuscita: IPdDContextSerializer non trovata [" + pddContextSerializerClass + "]:" + e.getMessage(), (Throwable)e);
                }
            }
            pddContextSerializerInitialized = true;
        }
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, null, null, OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, Logger alog, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, null, null, alog, msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idBusta, String tipo, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, idBusta, tipo, Configurazione.getLibraryLog(), msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idBusta, String tipo, Logger alog, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this.openspcoopstate = openspcoopstate;
        this.isRichiesta = isRichiesta;
        this.tableProprietariMessaggiGestiti = new ConcurrentHashMap<String, String>();
        this.tableMessaggiGestiti = new ConcurrentHashMap<String, Boolean>();
        this.idBusta = idBusta;
        this.tipo = tipo;
        this.propertiesReader = OpenSPCoop2Properties.getInstance();
        this.msgDiag = msgDiag;
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(GestoreMessaggi.class);
        if (!this.propertiesReader.isRepositoryOnFS()) {
            if (!adapterInitialized) {
                GestoreMessaggi.initAdapter(this.log, this.propertiesReader);
            }
        } else {
            this.workDir = this.propertiesReader.getRepositoryDirectory();
        }
        if (!pddContextSerializerInitialized) {
            GestoreMessaggi.initPddContextSerializer(this.log, this.propertiesReader);
        }
        cluster_id = this.propertiesReader.getClusterId(false);
        this.pddContext = pddContext;
        try {
            if (this.pddContext != null) {
                this.idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
                this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.pddContext.getObject(Costanti.PROTOCOL_NAME));
            }
        }
        catch (Exception e) {
            this.log.error("Inizializzione GestoreMessaggi non riuscita [ProtocoFactoryManager.getInstance]:" + e.getMessage(), (Throwable)e);
        }
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    private String getColonnaSQL(String idNodo) throws SQLException {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return "MOD_RICEZ_CONT_APPLICATIVI";
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return "MOD_CONSEGNA_CONT_APPLICATIVI";
        }
        if (idNodo.startsWith("RicezioneBuste")) {
            return "MOD_RICEZ_BUSTE";
        }
        if ("InoltroBuste".equals(idNodo)) {
            return "MOD_INOLTRO_BUSTE";
        }
        if ("InoltroRisposte".equals(idNodo)) {
            return "MOD_INOLTRO_RISPOSTE";
        }
        if ("Imbustamento".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO";
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO_RISPOSTE";
        }
        if ("Sbustamento".equals(idNodo)) {
            return "MOD_SBUSTAMENTO";
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return "MOD_SBUSTAMENTO_RISPOSTE";
        }
        throw new SQLException("Traduzione IDModulo->ColonnaSQL per modulo [" + idNodo + "] non possibile");
    }

    public void registraMessaggio(OpenSPCoop2Message message, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, null, false, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        this.registraMessaggio(message, null, false, correlazioneApplicativaRichiesta, correlazioneApplicativaRisposta);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Date oraRegistrazione, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, false, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Date oraRegistrazione, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, false, correlazioneApplicativaRichiesta, correlazioneApplicativaRisposta);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Date oraRegistrazione, boolean salvaNelloStateless, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, salvaNelloStateless, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Date oraRegistrazione, boolean salvaNelloStateless, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        StateMessage stato;
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : new Timestamp(oraRegistrazione.getTime());
        boolean gestisciInfoGenericheDB = true;
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgIngresso(oraRegistrazioneT);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgRisposta(oraRegistrazioneT);
            }
            ((OpenSPCoopStateless)this.openspcoopstate).setIDCorrelazioneApplicativa(correlazioneApplicativaRichiesta);
            ((OpenSPCoopStateless)this.openspcoopstate).setIDCorrelazioneApplicativaRisposta(correlazioneApplicativaRisposta);
            ((OpenSPCoopStateless)this.openspcoopstate).setPddContext(this.pddContext);
            if (!this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setRispostaMsg(message);
                return;
            }
            if (!this.oneWayVersione11 || this.routingStateless) {
                gestisciInfoGenericheDB = false;
            }
        }
        StateMessage stateMessage = stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        if (gestisciInfoGenericheDB) {
            Connection connectionDB = stato.getConnectionDB();
            Statement pstmt = null;
            try {
                Object o;
                StringBuilder fieldNamesPdDContext = new StringBuilder();
                StringBuilder fieldValuesPdDContext = new StringBuilder();
                Map<String, String> contextSerializerParameters = null;
                ArrayList<Object> objectSerializer = new ArrayList<Object>();
                if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    for (String keyword : contextSerializerParameters.keySet()) {
                        MapKey mapKey = org.openspcoop2.utils.Map.newMapKey((String)keyword);
                        o = this.pddContext.getObject(mapKey);
                        if (o == null) continue;
                        fieldNamesPdDContext.append(" , ");
                        fieldValuesPdDContext.append(" , ");
                        fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                        fieldValuesPdDContext.append("?");
                        if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                            throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                        }
                        objectSerializer.add(o);
                    }
                }
                StringBuilder query = new StringBuilder();
                query.append("INSERT INTO ");
                query.append(MESSAGGI);
                query.append("(ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, CORRELAZIONE_APPLICATIVA, CORRELAZIONE_RISPOSTA, PROTOCOLLO, id_transazione" + fieldNamesPdDContext.toString() + ") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?" + fieldValuesPdDContext.toString() + ")");
                pstmt = connectionDB.prepareStatement(query.toString());
                int index = 1;
                pstmt.setString(index++, this.idBusta);
                pstmt.setString(index++, this.tipo);
                pstmt.setTimestamp(index++, oraRegistrazioneT);
                pstmt.setTimestamp(index++, oraRegistrazioneT);
                pstmt.setTimestamp(index++, oraRegistrazioneT);
                pstmt.setString(index++, cluster_id);
                pstmt.setString(index++, correlazioneApplicativaRichiesta);
                pstmt.setString(index++, correlazioneApplicativaRisposta);
                pstmt.setString(index++, this.protocolFactory.getProtocol());
                pstmt.setString(index++, this.idTransazione);
                for (int i = 0; i < objectSerializer.size(); ++i) {
                    o = objectSerializer.get(i);
                    if (o instanceof String) {
                        pstmt.setString(index++, o.toString());
                        continue;
                    }
                    if (o instanceof Long) {
                        pstmt.setLong(index++, (Long)o);
                        continue;
                    }
                    if (!(o instanceof Timestamp)) continue;
                    pstmt.setTimestamp(index++, (Timestamp)o);
                }
                stato.getPreparedStatement().put("INSERT (MSG_OP_STEP1) registraMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
                this.addMessaggioIntoTable(this.tipo, this.idBusta);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (message != null) {
            SavedMessage msgSoap = null;
            try {
                msgSoap = new SavedMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                boolean consume = true;
                msgSoap.save(message, this.isRichiesta, salvaNelloStateless, consume, oraRegistrazioneT);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public Timestamp registraInformazioniMessaggio_statelessEngine(Date oraRegistrazione, String proprietarioMessaggio, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        return this.registraInformazioniMessaggio_statelessEngine(oraRegistrazione, proprietarioMessaggio, null, correlazioneApplicativaRichiesta, null);
    }

    public Timestamp registraInformazioniMessaggio_statelessEngine(Date oraRegistrazione, String proprietarioMessaggio, String riferimentoMessaggio, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : new Timestamp(oraRegistrazione.getTime());
        StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stato.getConnectionDB();
        Statement pstmt = null;
        try {
            Object o;
            StringBuilder fieldNamesPdDContext = new StringBuilder();
            StringBuilder fieldValuesPdDContext = new StringBuilder();
            Map<String, String> contextSerializerParameters = null;
            ArrayList<Object> objectSerializer = new ArrayList<Object>();
            if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                for (String keyword : contextSerializerParameters.keySet()) {
                    MapKey mapKey = org.openspcoop2.utils.Map.newMapKey((String)keyword);
                    o = this.pddContext.getObject(mapKey);
                    if (o == null) continue;
                    fieldNamesPdDContext.append(" , ");
                    fieldValuesPdDContext.append(" , ");
                    fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                    fieldValuesPdDContext.append("?");
                    if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                        throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                    }
                    objectSerializer.add(o);
                }
            }
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO ");
            query.append(MESSAGGI);
            query.append("(ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, PROPRIETARIO, CORRELAZIONE_APPLICATIVA, CORRELAZIONE_RISPOSTA, PROTOCOLLO, id_transazione ");
            if (riferimentoMessaggio != null) {
                query.append(", RIFERIMENTO_MSG");
            }
            query.append(fieldNamesPdDContext.toString());
            query.append(") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ");
            if (riferimentoMessaggio != null) {
                query.append(", ?");
            }
            query.append((CharSequence)fieldValuesPdDContext);
            query.append(" )");
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, this.idBusta);
            pstmt.setString(index++, this.tipo);
            pstmt.setTimestamp(index++, oraRegistrazioneT);
            pstmt.setTimestamp(index++, oraRegistrazioneT);
            pstmt.setTimestamp(index++, oraRegistrazioneT);
            pstmt.setString(index++, cluster_id);
            pstmt.setString(index++, proprietarioMessaggio);
            pstmt.setString(index++, correlazioneApplicativaRichiesta);
            pstmt.setString(index++, correlazioneApplicativaRisposta);
            pstmt.setString(index++, this.protocolFactory.getProtocol());
            pstmt.setString(index++, this.idTransazione);
            if (riferimentoMessaggio != null) {
                pstmt.setString(index++, riferimentoMessaggio);
            }
            for (int i = 0; i < objectSerializer.size(); ++i) {
                o = objectSerializer.get(i);
                if (o instanceof String) {
                    pstmt.setString(index++, o.toString());
                    continue;
                }
                if (o instanceof Long) {
                    pstmt.setLong(index++, (Long)o);
                    continue;
                }
                if (!(o instanceof Timestamp)) continue;
                pstmt.setTimestamp(index++, (Timestamp)o);
            }
            stato.getPreparedStatement().put("INSERT (MSG_OP_STEP1) registraMessaggioOpenSPCoop(stateless engine) " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
            this.addMessaggioIntoTable(this.tipo, this.idBusta);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (stateless engine) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return oraRegistrazioneT;
    }

    public void registraMessaggio_statelessEngine(OpenSPCoop2Message message, boolean consumeMessage, Timestamp oraRegistrazioneT) throws GestoreMessaggiException {
        if (message != null) {
            StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            SavedMessage msgSoap = null;
            try {
                msgSoap = new SavedMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgSoap.save(message, this.isRichiesta, false, consumeMessage, oraRegistrazioneT);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraRisposta_statelessEngine(String identificativo, OpenSPCoop2Message message, boolean consumeMessage) throws GestoreMessaggiException {
        if (message != null) {
            String id = identificativo != null ? identificativo : this.idBusta;
            StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            SavedMessage msgSoap = null;
            try {
                msgSoap = new SavedMessage(id, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgSoap.updateResponse(message, consumeMessage);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento (SoapMessage) " + this.tipo + "/" + id + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraTransactionContext_statelessEngine(String identificativo, Context context) throws GestoreMessaggiException {
        if (context != null) {
            String id = identificativo != null ? identificativo : this.idBusta;
            StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            SavedMessage msgSoap = null;
            try {
                msgSoap = new SavedMessage(id, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgSoap.updateTransactionContext(context);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento (TransactionContext) " + this.tipo + "/" + id + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraDestinatarioMessaggio(String serv, boolean sbustamentoSOAP, boolean sbustamentoInfoProtocol, boolean integrationManager, String tipoConsegna, Timestamp oraRegistrazioneMessaggio, String nomePorta, boolean attesaEsito, boolean impostaPerConsegnaTimerContenutiApplicativi, String coda, String priorita, boolean schedulingNonAttivo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("INSERT INTO ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                String columnCoda = "";
                String valueCoda = "";
                String columnPriorita = "";
                String valuePriorita = "";
                String columnErroreProcessamento = "";
                String valueErroreProcessamento = "";
                String columnLockConsegna = "";
                String valueLockConsegna = "";
                if (coda != null) {
                    columnCoda = ",CODA";
                    valueCoda = ", ?";
                }
                if (priorita != null) {
                    columnPriorita = ",PRIORITA";
                    valuePriorita = ", ?";
                }
                if (impostaPerConsegnaTimerContenutiApplicativi) {
                    columnErroreProcessamento = ",ERRORE_PROCESSAMENTO,ERRORE_PROCESSAMENTO_COMPACT";
                    valueErroreProcessamento = ", ? , ?";
                }
                if (schedulingNonAttivo) {
                    columnLockConsegna = ",LOCK_CONSEGNA";
                    valueLockConsegna = ", ?";
                }
                query.append("(ID_MESSAGGIO,SERVIZIO_APPLICATIVO,SBUSTAMENTO_SOAP,SBUSTAMENTO_INFO_PROTOCOL,INTEGRATION_MANAGER,TIPO_CONSEGNA,ORA_REGISTRAZIONE,RISPEDIZIONE,NOME_PORTA,ATTESA_ESITO" + columnCoda + columnPriorita + columnErroreProcessamento + columnLockConsegna + ") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?" + valueCoda + valuePriorita + valueErroreProcessamento + valueLockConsegna + ")");
                pstmt = connectionDB.prepareStatement(query.toString());
                int index = 1;
                pstmt.setString(index++, this.idBusta);
                pstmt.setString(index++, serv);
                if (sbustamentoSOAP) {
                    pstmt.setInt(index++, 1);
                } else {
                    pstmt.setInt(index++, 0);
                }
                if (sbustamentoInfoProtocol) {
                    pstmt.setInt(index++, 1);
                } else {
                    pstmt.setInt(index++, 0);
                }
                if (integrationManager) {
                    pstmt.setInt(index++, 1);
                } else {
                    pstmt.setInt(index++, 0);
                }
                pstmt.setString(index++, tipoConsegna);
                pstmt.setTimestamp(index++, oraRegistrazioneMessaggio);
                pstmt.setTimestamp(index++, oraRegistrazioneMessaggio);
                pstmt.setString(index++, nomePorta);
                if (attesaEsito) {
                    pstmt.setInt(index++, 1);
                } else {
                    pstmt.setInt(index++, 0);
                }
                if (coda != null) {
                    pstmt.setString(index++, coda);
                }
                if (priorita != null) {
                    pstmt.setString(index++, priorita);
                }
                if (impostaPerConsegnaTimerContenutiApplicativi) {
                    pstmt.setString(index++, "TimerConsegnaContenutiApplicativi");
                    pstmt.setString(index++, "TimerConsegnaContenutiApplicativi");
                }
                if (schedulingNonAttivo) {
                    pstmt.setTimestamp(index++, TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA);
                }
                stateMSG.getPreparedStatement().put("INSERT (MSG_OP_STEP2) registraDestinatarioMessaggioOpenSPCoop[" + serv + "][" + this.idBusta + "]", (PreparedStatement)pstmt);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione destinatario Messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con IState non valido");
        }
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, false, false);
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, searchForRiferimentoMsg, false);
    }

    private void aggiornaProprietarioMessaggio_engine(String nodoOpenSPCoop, boolean searchForRiferimentoMsg, boolean executePreparedStatement) throws GestoreMessaggiException {
        if (this.deleted) {
            return;
        }
        boolean stateful = this.openspcoopstate instanceof OpenSPCoopStateful;
        if (!stateful) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioRequestMsgLib(nodoOpenSPCoop);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioResponseMsgLib(nodoOpenSPCoop);
            }
        }
        if (stateful || this.readyForDrop || this.oneWayVersione11) {
            StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET PROPRIETARIO=? WHERE ");
                String tipoMessaggio = null;
                if (searchForRiferimentoMsg) {
                    tipoMessaggio = "OUTBOX".equals(this.tipo) ? "INBOX" : "OUTBOX";
                    query.append(" RIFERIMENTO_MSG=? AND TIPO=? ");
                } else {
                    tipoMessaggio = this.tipo;
                    query.append(" ID_MESSAGGIO=? AND TIPO=? ");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, nodoOpenSPCoop);
                pstmt.setString(2, this.idBusta);
                pstmt.setString(3, tipoMessaggio);
                if (executePreparedStatement) {
                    pstmt.executeUpdate();
                    pstmt.close();
                } else {
                    stateMsg.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
                }
                this.addProprietarioIntoTable(this.tipo, this.idBusta, nodoOpenSPCoop);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento proprietario Messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if ("GestoreMessaggi".equals(nodoOpenSPCoop)) {
            this.deleted = true;
        }
    }

    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio) throws GestoreMessaggiException {
        this.aggiornaRiferimentoMessaggio(riferimentoMessaggio, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio, boolean saveIntoDB) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || saveIntoDB) {
            StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = state.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET RIFERIMENTO_MSG=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, riferimentoMessaggio);
                pstmt.setString(2, this.idBusta);
                pstmt.setString(3, this.tipo);
                state.getPreparedStatement().put("UPDATE aggiornaRiferimentoMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
                if (cacheMappingGestoreMessaggi == null) return;
                try {
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idBusta + "] ...");
                    GestoreMessaggi.addIntoCache_MappingRifMsgToId(this.msgDiag, this.tipo, riferimentoMessaggio, this.idBusta);
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idBusta + "] effettuata.");
                    return;
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_MappingRifMsgToId(Per:" + this.tipo + "/" + riferimentoMessaggio + ",Value:" + this.idBusta);
                }
                return;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento riferimento messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) return;
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void aggiornaErroreProcessamentoMessaggio(String motivoErrore, String servizioApplicativo) throws GestoreMessaggiException {
        this.aggiornaErroreProcessamentoMessaggio(motivoErrore, servizioApplicativo, true);
    }

    public boolean aggiornaErroreProcessamentoMessaggio(String motivoErrore, String servizioApplicativo, boolean throwExceptionConnectionNull) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (connectionDB == null) {
                if (throwExceptionConnectionNull) {
                    throw new GestoreMessaggiException("Connessione non disponibile");
                }
                return false;
            }
            String motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            String prefix = "";
            if (motivoErroreGiaRegistrato != null && motivoErroreGiaRegistrato.startsWith(NUMERO_RISPEDIZIONE)) {
                int index = motivoErroreGiaRegistrato.indexOf("]");
                prefix = motivoErroreGiaRegistrato.substring(0, index + 2);
                motivoErroreGiaRegistrato = motivoErroreGiaRegistrato.substring(index + 2);
            }
            if (motivoErroreGiaRegistrato == null || !motivoErroreGiaRegistrato.equals(motivoErrore)) {
                Statement pstmt = null;
                try {
                    StringBuilder query = new StringBuilder();
                    query.append("UPDATE ");
                    if (servizioApplicativo == null) {
                        query.append(MESSAGGI);
                        query.append(" SET ERRORE_PROCESSAMENTO=? WHERE ID_MESSAGGIO = ?");
                    } else {
                        query.append(MSG_SERVIZI_APPLICATIVI);
                        query.append(" SET ERRORE_PROCESSAMENTO=?, ERRORE_PROCESSAMENTO_COMPACT=? WHERE ID_MESSAGGIO = ?");
                    }
                    if (servizioApplicativo != null) {
                        query.append(" AND SERVIZIO_APPLICATIVO=?");
                    } else {
                        query.append(" AND TIPO=?");
                    }
                    pstmt = connectionDB.prepareStatement(query.toString());
                    int index = 1;
                    this.log.debug("UPDATE ERRORE PROCESSAMENTO TIPO-1 [" + prefix + "][" + motivoErrore + "] tipo[" + this.tipo + "] sa[" + servizioApplicativo + "]");
                    pstmt.setString(index++, prefix + motivoErrore);
                    if (servizioApplicativo != null) {
                        if (motivoErrore != null && motivoErrore.length() >= 200) {
                            pstmt.setString(index++, motivoErrore.substring(0, 200) + " ...");
                        } else {
                            pstmt.setString(index++, motivoErrore);
                        }
                    }
                    pstmt.setString(index++, this.idBusta);
                    if (servizioApplicativo != null) {
                        pstmt.setString(index++, servizioApplicativo);
                    } else {
                        pstmt.setString(index++, this.tipo);
                    }
                    pstmt.execute();
                    pstmt.close();
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.log.error(errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            return true;
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return false;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void aggiungiMessaggioSerializzato(IJDBCAdapter adapter, byte[] msgByte) throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(MESSAGGI);
            query.append(" SET msg_bytes=? WHERE id_messaggio= ? and tipo= ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            adapter.setBinaryData((PreparedStatement)pstmt, 1, msgByte);
            pstmt.setString(2, this.idBusta);
            pstmt.setString(3, this.tipo);
            stateMsg.getPreparedStatement().put("UPDATE aggiungiMessaggioSerializzatoInMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void ripristinaMessaggio() throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        PreparedStatement pstmt = null;
        String sql = "UPDATE MESSAGGI SET scheduling=0 where id_messaggio=? AND tipo=?";
        try {
            pstmt = connectionDB.prepareStatement(sql);
            pstmt.setString(1, this.idBusta);
            pstmt.setString(2, this.tipo);
            pstmt.execute();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggiornaDataRispedizione(Timestamp dataRispedizione, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Object motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            Statement pstmt = null;
            try {
                boolean updateErroreProcessamento = true;
                int numeroSpedizione = 0;
                if (motivoErroreGiaRegistrato == null) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] ";
                    numeroSpedizione = 1;
                } else if (!((String)motivoErroreGiaRegistrato).startsWith(NUMERO_RISPEDIZIONE)) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] " + (String)motivoErroreGiaRegistrato;
                    numeroSpedizione = 1;
                } else {
                    if (this.pddContext != null && this.pddContext.containsKey(CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_NUMERO_TENTATIVI_RICONSEGNA_UPDATED)) {
                        updateErroreProcessamento = false;
                        numeroSpedizione = (Integer)this.pddContext.getObject(CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_NUMERO_TENTATIVI_RICONSEGNA_UPDATED);
                    }
                    if (updateErroreProcessamento) {
                        int indexNumber = ((String)motivoErroreGiaRegistrato).indexOf("]");
                        if (indexNumber == -1) {
                            throw new GestoreMessaggiException("Errore processamento corrotto (] non presente)");
                        }
                        try {
                            StringBuilder bf = new StringBuilder();
                            int j = indexNumber - 1;
                            while (((String)motivoErroreGiaRegistrato).charAt(j) != '.') {
                                bf.append(((String)motivoErroreGiaRegistrato).charAt(j));
                                --j;
                            }
                            bf.reverse();
                            numeroSpedizione = Integer.parseInt(bf.toString());
                            String oldMotivo = ((String)motivoErroreGiaRegistrato).substring(indexNumber + 2);
                            motivoErroreGiaRegistrato = NUMERO_RISPEDIZIONE + ++numeroSpedizione + "] " + oldMotivo;
                        }
                        catch (Exception e) {
                            throw new GestoreMessaggiException("Aggiornamento numero spedizione non riuscito: " + e.getMessage(), e);
                        }
                    }
                }
                long spedizione = dataRispedizione.getTime();
                if (this.propertiesReader.isRitardoConsegnaAbilitato() && numeroSpedizione > 1) {
                    long limite;
                    long ritardoEsponenziale = this.propertiesReader.getRitardoConsegnaEsponenziale();
                    long ritardo = 1L;
                    boolean moltiplicazione = this.propertiesReader.isRitardoConsegnaEsponenzialeConMoltiplicazione();
                    if (!moltiplicazione) {
                        ritardo = 0L;
                    }
                    if ((limite = (long)(numeroSpedizione - 1)) > this.propertiesReader.getRitardoConsegnaEsponenzialeLimite()) {
                        limite = this.propertiesReader.getRitardoConsegnaEsponenzialeLimite();
                    }
                    int i = 0;
                    while ((long)i < limite) {
                        ritardo = moltiplicazione ? (ritardo *= ritardoEsponenziale) : (ritardo += ritardoEsponenziale);
                        ++i;
                    }
                    spedizione += ritardo * 1000L;
                }
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                if (servizioApplicativo != null) {
                    query.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    query.append(MESSAGGI);
                }
                query.append(" SET RISPEDIZIONE=?");
                if (updateErroreProcessamento) {
                    query.append(", ERRORE_PROCESSAMENTO=?");
                }
                query.append(" WHERE  ID_MESSAGGIO = ?");
                if (servizioApplicativo != null) {
                    query.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    query.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                Timestamp t = new Timestamp(spedizione);
                int index = 1;
                pstmt.setTimestamp(index++, t);
                if (updateErroreProcessamento) {
                    this.log.debug("UPDATE ERRORE PROCESSAMENTO TIPO-2 [" + (String)motivoErroreGiaRegistrato + "] tipo[" + this.tipo + "] sa[" + servizioApplicativo + "]");
                    pstmt.setString(index++, (String)motivoErroreGiaRegistrato);
                }
                pstmt.setString(index++, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmt.setString(index++, servizioApplicativo);
                } else {
                    pstmt.setString(index++, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
                if (!updateErroreProcessamento || this.pddContext == null) return;
                this.pddContext.addObject(CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_NUMERO_TENTATIVI_RICONSEGNA_UPDATED, numeroSpedizione);
                return;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento data rispedizione Messaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) return;
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS) throws GestoreMessaggiException {
        this.aggiornaIDHeaderJMS(nodoOpenSPCoop, idHeaderJMS, null);
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "UPDATE MSG_SERVIZI_APPLICATIVI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_MESSAGGIO = ? AND SERVIZIO_APPLICATIVO=?" : "UPDATE MESSAGGI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_MESSAGGIO = ? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idHeaderJMS);
                pstmt.setString(2, this.idBusta);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(3, servizioApplicativo);
                } else {
                    pstmt.setString(3, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento IDHeaderJMS " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, false);
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, onlyCache);
    }

    public String getProprietario(String idModulo) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, false);
    }

    public String getProprietario(String idModulo, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, onlyCache);
    }

    private String getProprietario(String idModulo, boolean serializable, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && !this.oneWayVersione11) {
            return this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioRequestMsgLib() : ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib();
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("getProprietario, read from cache...");
                    String proprietario = GestoreMessaggi.getFromCache_Proprietario(idModulo, this.tipo, this.idBusta);
                    if (proprietario != null) {
                        return proprietario;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error getProprietario (Cache) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                    this.log.error(errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("getProprietario, read from DB...");
            if (!serializable) {
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                String value = null;
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString(MESSAGGI_COLUMN_PROPRIETARIO);
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return value;
            }
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                JDBCUtilities.setTransactionIsolationSerializable((String)this.propertiesReader.getDatabaseType(), (Connection)connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(setIsolation) " + this.tipo + "/" + this.idBusta + ": " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            boolean getProprietarioOK = false;
            String value = null;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!getProprietarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString(MESSAGGI_COLUMN_PROPRIETARIO);
                    }
                    rs.close();
                    pstmt.close();
                    connectionDB.commit();
                    getProprietarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (getProprietarioOK) continue;
                try {
                    Utilities.sleep((long)GestoreMessaggi.getRandom().nextInt(checkInterval));
                }
                catch (Exception e) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateMSG.updateConnection(connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(ripristinoIsolation) " + this.tipo + "/" + this.idBusta + ": " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            return value;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop) throws GestoreMessaggiException {
        return this.getIDJMSRicevuto(nodoOpenSPCoop, null);
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?" : "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString(this.getColonnaSQL(nodoOpenSPCoop));
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get IDHeaderJMS " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessage_onlyCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, true, false);
    }

    public boolean existsMessage_onlyCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, true, false);
    }

    public boolean existsMessage_noCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, true);
    }

    public boolean existsMessage_noCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, true);
    }

    public boolean existsMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, false);
    }

    public boolean existsMessage() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, false);
    }

    private boolean existsMessage_engine(boolean searchForRiferimentoMsg, boolean onlyCache, boolean noCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && (!this.oneWayVersione11 || this.routingStateless)) {
            return false;
        }
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMSG.getConnectionDB();
        String idBustaSearch = this.idBusta;
        if (searchForRiferimentoMsg) {
            try {
                idBustaSearch = this.mapRiferimentoIntoIDBusta();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idBustaSearch == null) {
                return false;
            }
        }
        if (cacheMappingGestoreMessaggi != null && !noCache) {
            try {
                this.msgDiag.highDebug("existsMessage, read from cache ID[" + idBustaSearch + "]...");
                Boolean value = GestoreMessaggi.getFromCache_existsMessage(this.tipo, idBustaSearch);
                if (value != null && value.booleanValue()) {
                    return true;
                }
                if (onlyCache) {
                    return false;
                }
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage (Cache) " + this.tipo + "/" + idBustaSearch + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                return false;
            }
        }
        this.msgDiag.highDebug("existsMessage, read from DB ID[" + idBustaSearch + "]...");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT ID_MESSAGGIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, idBustaSearch);
            pstmt.setString(2, this.tipo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rs.close();
                pstmt.close();
                return true;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore existsMessage " + this.tipo + "/" + idBustaSearch + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg, (Throwable)e);
            return false;
        }
    }

    public OpenSPCoop2Message getMessage() throws GestoreMessaggiException {
        return this.getMessage(null);
    }

    public OpenSPCoop2Message getMessage(Date oraRegistrazione) throws GestoreMessaggiException {
        return this.getMessage(false, oraRegistrazione);
    }

    public OpenSPCoop2Message getMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.getMessage(searchForRiferimentoMsg, null);
    }

    public OpenSPCoop2Message getMessage(boolean searchForRiferimentoMsg, Date oraRegistrazione) throws GestoreMessaggiException {
        OpenSPCoop2Message msg = null;
        String idBustaSearch = this.idBusta;
        if (searchForRiferimentoMsg) {
            idBustaSearch = this.mapRiferimentoIntoIDBusta();
        }
        SavedMessage soapMsg = null;
        try {
            soapMsg = new SavedMessage(idBustaSearch, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            msg = soapMsg.read(this.isRichiesta, this.portaDiTipoStateless || this.routingStateless, oraRegistrazione);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return msg;
    }

    public OpenSPCoop2Message getResponseMessage(boolean updateTransportRequest, boolean throwExceptionIfNotExists) throws GestoreMessaggiException {
        return this.getResponseMessage(null, updateTransportRequest, throwExceptionIfNotExists);
    }

    public OpenSPCoop2Message getResponseMessage(Date oraRegistrazione, boolean updateTransportRequest, boolean throwExceptionIfNotExists) throws GestoreMessaggiException {
        OpenSPCoop2Message msg = null;
        String idBustaSearch = this.idBusta;
        SavedMessage soapMsg = null;
        try {
            soapMsg = new SavedMessage(idBustaSearch, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            msg = soapMsg.readResponse(oraRegistrazione, throwExceptionIfNotExists);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        try {
            if (updateTransportRequest && msg.getTransportResponseContext() != null && msg.getTransportResponseContext().getHeaders() != null && !msg.getTransportResponseContext().getHeaders().isEmpty()) {
                if (msg.getTransportRequestContext() == null) {
                    msg.setTransportRequestContext(new TransportRequestContext());
                }
                if (msg.getTransportRequestContext().getHeaders() == null) {
                    msg.getTransportRequestContext().setHeaders(msg.getTransportResponseContext().getHeaders());
                } else if (msg.getTransportRequestContext().getHeaders().isEmpty()) {
                    msg.getTransportRequestContext().getHeaders().putAll(msg.getTransportResponseContext().getHeaders());
                } else {
                    for (String hdr : msg.getTransportResponseContext().getHeaders().keySet()) {
                        List vResponse = msg.getTransportResponseContext().getHeaderValues(hdr);
                        if (vResponse == null || vResponse.isEmpty()) continue;
                        List vRequest = msg.getTransportRequestContext().getHeaderValues(hdr);
                        if (vRequest == null || vRequest.isEmpty()) {
                            msg.getTransportRequestContext().getHeaders().put(hdr, vResponse);
                            continue;
                        }
                        for (String v : vResponse) {
                            if (vRequest.contains(v)) continue;
                            vRequest.add(v);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getMessage " + this.tipo + "/" + this.idBusta + " (fixTransportRequest): " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return msg;
    }

    public Context getSyncTransactionContext() throws GestoreMessaggiException {
        return this.getSyncTransactionContext(null);
    }

    public Context getSyncTransactionContext(Date oraRegistrazione) throws GestoreMessaggiException {
        Context context = null;
        String idBustaSearch = this.idBusta;
        SavedMessage soapMsg = null;
        try {
            soapMsg = new SavedMessage(idBustaSearch, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            context = soapMsg.readTransactionContext(oraRegistrazione);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getSyncTransactionContext " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return context;
    }

    public String mapRiferimentoIntoIDBusta() throws GestoreMessaggiException {
        return this.mapRiferimentoIntoIDBusta(false);
    }

    public String mapRiferimentoIntoIDBusta(boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("mapRiferimentoIntoIDBusta, read from cache ...");
                    String id = GestoreMessaggi.getFromCache_idFromRifMsgMapping(this.tipo, this.idBusta);
                    if (id != null) {
                        return id;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDBusta (Cache) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                    this.log.error(errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("mapRiferimentoIntoIDBusta, read from DB ...");
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ID_MESSAGGIO FROM MESSAGGI WHERE RIFERIMENTO_MSG=? AND TIPO=? AND PROPRIETARIO IS NOT NULL AND PROPRIETARIO != ? ORDER BY ORA_REGISTRAZIONE DESC";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString("ID_MESSAGGIO");
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDBusta " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getErroreProcessamentoMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            String motivoErroreGiaRegistrato = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT ERRORE_PROCESSAMENTO FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?" : "SELECT ERRORE_PROCESSAMENTO FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO = ? AND SERVIZIO_APPLICATIVO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    motivoErroreGiaRegistrato = rs.getString("ERRORE_PROCESSAMENTO");
                }
                rs.close();
                pstmtRead.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getErroreProcessamentoMessaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return motivoErroreGiaRegistrato;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getOraRegistrazioneMessaggio() throws GestoreMessaggiException {
        Timestamp t = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    t = rs.getTimestamp("ORA_REGISTRAZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora registrazione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getOraRegistrazioneMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            t = this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgIngresso() : ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgRisposta();
            if (t == null) {
                throw new GestoreMessaggiException("Ora registrazione non registrata");
            }
            return t;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getDataRispedizioneMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RISPEDIZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                Timestamp t = null;
                if (rs.next()) {
                    t = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora rispedizione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getDataRispedizioneMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isPrimaConsegna(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT MESSAGGI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?" : "SELECT MSG_SERVIZI_APPLICATIVI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO AND MESSAGGI.ID_MESSAGGIO= ? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MESSAGGI.TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                    pstmtRead.setString(3, "INBOX");
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                Timestamp oraRegistrazione = null;
                Timestamp rispedizione = null;
                if (rs.next()) {
                    oraRegistrazione = rs.getTimestamp("ORA_REGISTRAZIONE");
                    rispedizione = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (oraRegistrazione == null) {
                    this.log.error("OraRegistrazione is null");
                }
                if (rispedizione == null) {
                    this.log.error("Rispedizione is null");
                }
                return oraRegistrazione != null && rispedizione != null && oraRegistrazione.compareTo(rispedizione) == 0;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isPrimaConsegna " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isRiconsegnaMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (this.isPrimaConsegna(servizioApplicativo)) {
                return true;
            }
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuilder bf = new StringBuilder();
                bf.append("SELECT RISPEDIZIONE FROM ");
                if (servizioApplicativo != null) {
                    bf.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    bf.append(MESSAGGI);
                }
                bf.append(" WHERE ID_MESSAGGIO=?");
                if (servizioApplicativo != null) {
                    bf.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    bf.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                Timestamp riconsegna = null;
                if (rs.next()) {
                    riconsegna = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmt.close();
                Timestamp now = DateManager.getTimestamp();
                if (riconsegna == null) {
                    this.log.error("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idBusta + "], riconsegna is null? query[" + bf.toString() + "] sa[" + servizioApplicativo + "]");
                    throw new Exception("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idBusta + "]");
                }
                if (riconsegna.before(now)) {
                    return true;
                }
                this.log.debug("Riconsegna messaggio prematura [" + this.tipo + "/" + this.idBusta + "] RICONSEGNA[" + riconsegna.toString() + "] < NOW[" + now.toString() + "] == false");
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isRiconsegnaMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return true;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getRiferimentoMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RIFERIMENTO_MSG FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get RIFERIMENTO_MSG " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDCorrelazioneApplicativa() throws GestoreMessaggiException {
        String id = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT CORRELAZIONE_APPLICATIVA FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    id = rs.getString(MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RICHIESTA);
                }
                rs.close();
                pstmtRead.close();
                if (id == null) {
                    throw new Exception("ID di CorrelazioneApplicativa non registrata");
                }
                return id;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getIDCorrelazioneApplicativa " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!e.getMessage().equals("ID di CorrelazioneApplicativa non registrata")) {
                    this.log.error(errorMsg, (Throwable)e);
                } else {
                    this.log.debug(errorMsg);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativa();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDCorrelazioneApplicativaRisposta() throws GestoreMessaggiException {
        String id = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT CORRELAZIONE_RISPOSTA FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    id = rs.getString(MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RISPOSTA);
                }
                rs.close();
                pstmtRead.close();
                if (id == null) {
                    throw new Exception("ID di CorrelazioneApplicativaRisposta non registrata");
                }
                return id;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getIDCorrelazioneApplicativaRisposta " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!e.getMessage().equals("ID di CorrelazioneApplicativaRisposta non registrata")) {
                    this.log.error(errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
                this.log.debug(errorMsg);
                return null;
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativaRisposta();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public PdDContext getPdDContext() throws GestoreMessaggiException {
        return this.getPdDContext(false);
    }

    public PdDContext getPdDContext(boolean saveInInstance) throws GestoreMessaggiException {
        if (this.openspcoopstate == null) {
            return this.pddContext;
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtRead = null;
            ResultSet rs = null;
            try {
                Map<String, String> contextSerializerParameters;
                StringBuilder fieldNamesPdDContext_db = new StringBuilder();
                HashMap<String, String> mapping = new HashMap<String, String>();
                if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    for (String string : contextSerializerParameters.keySet()) {
                        if (fieldNamesPdDContext_db.length() > 0) {
                            fieldNamesPdDContext_db.append(" , ");
                        }
                        String nomeDB = contextSerializerParameters.get(string);
                        fieldNamesPdDContext_db.append(nomeDB);
                        mapping.put(nomeDB, string);
                    }
                }
                if (fieldNamesPdDContext_db.length() != 0) {
                    fieldNamesPdDContext_db.append(" , ");
                }
                fieldNamesPdDContext_db.append(MESSAGGI_COLUMN_PROTOCOLLO);
                mapping.put(MESSAGGI_COLUMN_PROTOCOLLO, (String)((Object)Costanti.PROTOCOL_NAME.getValue()));
                PdDContext pddContext = new PdDContext();
                if (mapping.size() <= 0) {
                    return pddContext;
                }
                String query = "SELECT id_transazione, " + fieldNamesPdDContext_db.toString() + " FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    for (String keyDB : mapping.keySet()) {
                        Object object = rs.getObject(keyDB);
                        String key = (String)mapping.get(keyDB);
                        MapKey mapKey = org.openspcoop2.utils.Map.newMapKey((String)key);
                        pddContext.addObject(mapKey, object);
                    }
                    String string = rs.getString(MESSAGGI_COLUMN_ID_TRANSAZIONE);
                    if (string != null) {
                        pddContext.addObject(Costanti.ID_TRANSAZIONE, string);
                    }
                } else {
                    throw new Exception("Messaggio non trovato");
                }
                rs.close();
                pstmtRead.close();
                if (saveInInstance) {
                    this.pddContext = pddContext;
                }
                return pddContext;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getPdDContext " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!e.getMessage().equals("Messaggio non trovato")) {
                    this.log.error(errorMsg, (Throwable)e);
                } else {
                    this.log.debug(errorMsg, (Throwable)e);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getPddContext();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public MessaggioIM readMessageForSIL(String servizioApplicativo, Date oraRegistrazione) throws GestoreMessaggiException {
        return this.readMessageForSIL(servizioApplicativo, false, oraRegistrazione);
    }

    public MessaggioIM readMessageForSIL(String servizioApplicativo, boolean searchForRiferimentoMsg, Date oraRegistrazione) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                Object query = null;
                if (Configurazione.getSqlQueryObjectType() == null) {
                    query = "SELECT MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER as authIM, MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_SOAP as sbSoap, MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_INFO_PROTOCOL as sbProtocol MESSAGGI.RIFERIMENTO_MSG as rifMsg, MESSAGGI.id_transazione as idtransazione, MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO as sa, MSG_SERVIZI_APPLICATIVI.NOME_PORTA as nomePorta, MESSAGGI.ORA_REGISTRAZIONE as oramess  FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE ";
                    if (oraRegistrazione != null) {
                        query = (String)query + "(MSG_SERVIZI_APPLICATIVI.ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ";
                        query = (String)query + "(MESSAGGI.ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ";
                    }
                    query = (String)query + "MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO AND MESSAGGI.PROPRIETARIO=?";
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI, "m");
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI, "sa");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_INTEGRATION_MANAGER, "authIM");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_SOAP", "sbSoap");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_INFO_PROTOCOL", "sbProtocol");
                    sqlQueryObject.addSelectAliasField("m", MESSAGGI_COLUMN_RIFERIMENTO_MSG, "rifMsg");
                    sqlQueryObject.addSelectAliasField("m", MESSAGGI_COLUMN_ID_TRANSAZIONE, "idtransazione");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO, "sa");
                    sqlQueryObject.addSelectAliasField("sa", "NOME_PORTA", "nomePorta");
                    sqlQueryObject.addSelectAliasField("m", "ORA_REGISTRAZIONE", "oramess");
                    if (oraRegistrazione != null) {
                        sqlQueryObject.addWhereBetweenCondition("sa.ORA_REGISTRAZIONE", false, "?", "?");
                        sqlQueryObject.addWhereBetweenCondition("m.ORA_REGISTRAZIONE", false, "?", "?");
                    }
                    sqlQueryObject.addWhereCondition("sa.ID_MESSAGGIO=?");
                    sqlQueryObject.addWhereCondition("sa.SERVIZIO_APPLICATIVO=?");
                    sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=sa.ID_MESSAGGIO");
                    sqlQueryObject.addWhereCondition("m.PROPRIETARIO=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    query = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement((String)query);
                int index = 1;
                Timestamp leftValue = null;
                Timestamp rightValue = null;
                if (oraRegistrazione != null) {
                    leftValue = new Timestamp(oraRegistrazione.getTime() - 300000L);
                    rightValue = new Timestamp(oraRegistrazione.getTime() + 300000L);
                    pstmt.setTimestamp(index++, leftValue);
                    pstmt.setTimestamp(index++, rightValue);
                    pstmt.setTimestamp(index++, leftValue);
                    pstmt.setTimestamp(index++, rightValue);
                }
                pstmt.setString(index++, idBustaSearch);
                pstmt.setString(index++, servizioApplicativo);
                pstmt.setString(index++, "ConsegnaContenutiApplicativi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    MessaggioIM messaggio = new MessaggioIM();
                    messaggio.setAuthorized(rs.getInt("authIM") == 1);
                    messaggio.setSbustamentoSoap(rs.getInt("sbSoap") == 1);
                    messaggio.setSbustamentoInformazioniProtocollo(rs.getInt("sbProtocol") == 1);
                    messaggio.setRiferimentoMessaggio(rs.getString("rifMsg"));
                    messaggio.setIdentificativoRichiesta(idBustaSearch);
                    messaggio.setIdTransazione(rs.getString("idtransazione"));
                    messaggio.setServizioApplicativo(rs.getString("sa"));
                    messaggio.setOraRegistrazione(rs.getTimestamp("oramess"));
                    messaggio.setNomePorta(rs.getString("nomePorta"));
                    rs.close();
                    pstmt.close();
                    return messaggio;
                }
                rs.close();
                pstmt.close();
                return null;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error readMessageForSIL " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageForSIL(String servizioApplicativo) throws GestoreMessaggiException {
        return this.existsMessageForSIL(servizioApplicativo, false);
    }

    public boolean existsMessageForSIL(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                Object query = "SELECT * FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE ";
                query = (String)query + "MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO AND MESSAGGI.PROPRIETARIO=?";
                pstmt = connectionDB.prepareStatement((String)query);
                int index = 1;
                pstmt.setString(index++, idBustaSearch);
                pstmt.setString(index++, servizioApplicativo);
                pstmt.setString(index++, "ConsegnaContenutiApplicativi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean checkAutorizzazione(String servizioApplicativo) throws GestoreMessaggiException {
        return this.checkAutorizzazione(servizioApplicativo, false);
    }

    public boolean checkAutorizzazione(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT INTEGRATION_MANAGER FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean auth = false;
                if (rs.next() && rs.getInt(MSG_SERVIZI_APPLICATIVI_COLUMN_INTEGRATION_MANAGER) == 1) {
                    auth = true;
                }
                rs.close();
                pstmt.close();
                return auth;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean sbustamentoSOAP(String servizioApplicativo) throws GestoreMessaggiException {
        return this.sbustamentoSOAP(servizioApplicativo, false);
    }

    public boolean sbustamentoSOAP(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT SBUSTAMENTO_SOAP FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean sbustamento = false;
                if (rs.next() && rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                    sbustamento = true;
                }
                rs.close();
                pstmt.close();
                return sbustamento;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error getSbustamentoSoap " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean sbustamentoInformazioniProtocollo(String servizioApplicativo) throws GestoreMessaggiException {
        return this.sbustamentoInformazioniProtocollo(servizioApplicativo, false);
    }

    public boolean sbustamentoInformazioniProtocollo(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT SBUSTAMENTO_INFO_PROTOCOL FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean sbustamento = false;
                if (rs.next() && rs.getInt("SBUSTAMENTO_INFO_PROTOCOL") == 1) {
                    sbustamento = true;
                }
                rs.close();
                pstmt.close();
                return sbustamento;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error getSbustamentoSoap " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageInProcessamento() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(false);
    }

    public boolean existsMessageInProcessamentoByReference() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(true);
    }

    private boolean existsMessageInProcessamento(boolean rifMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuilder bf = new StringBuilder();
                bf.append("SELECT ID_MESSAGGIO FROM ");
                bf.append(MESSAGGI);
                bf.append(" WHERE ");
                if (!rifMsg) {
                    bf.append("ID_MESSAGGIO=?");
                } else {
                    bf.append("RIFERIMENTO_MSG=?");
                }
                bf.append(" AND TIPO=? AND PROPRIETARIO<>?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore existsMessageInProcessamento " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                return false;
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, null, null, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, null, null, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, null, null, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, null);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, azione);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, azione);
    }

    public List<IdentificativoIM> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, azione);
    }

    private List<IdentificativoIM> getIDMessaggi_ServizioApplicativo_engine(String servizioApplicativo, int counterParam, int offset, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            ArrayList<IdentificativoIM> ids = new ArrayList<IdentificativoIM>();
            String queryString = null;
            try {
                Integer defaultV;
                int limit = counterParam;
                if (limit <= 0 && (defaultV = this.propertiesReader.getIntegrationManagerIdsLimit()) != null && defaultV > 0) {
                    limit = defaultV;
                }
                queryString = this.getQueryStringGetAllMessagesId(servizioApplicativo, limit, offset, tipoServizio, servizio, azione, true);
                pstmt = connectionDB.prepareStatement(queryString);
                this.setPreparedStatementGetAllMessagesId((PreparedStatement)pstmt, servizioApplicativo, tipoServizio, servizio, azione, null);
                rs = pstmt.executeQuery();
                Timestamp minDate = null;
                if (rs.next()) {
                    minDate = rs.getTimestamp("MinOraRegistrazione");
                }
                rs.close();
                pstmt.close();
                if (minDate != null) {
                    queryString = this.getQueryStringGetAllMessagesId(servizioApplicativo, limit, offset, tipoServizio, servizio, azione, false);
                    pstmt = connectionDB.prepareStatement(queryString);
                    this.setPreparedStatementGetAllMessagesId((PreparedStatement)pstmt, servizioApplicativo, tipoServizio, servizio, azione, minDate);
                    rs = pstmt.executeQuery();
                    int countLimit = 0;
                    while (rs.next()) {
                        IdentificativoIM idIM = new IdentificativoIM(rs.getString("IdMsgServizioApplicativo"), rs.getTimestamp("OraMessaggio"));
                        ids.add(idIM);
                        if (limit < 0 || Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                        break;
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.getIDMessaggi_ServizioApplicativo_engine] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return ids;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    private String getQueryStringGetAllMessagesId(String servizioApplicativo, int counter, int offset, String tipoServizio, String servizio, String azione, boolean findMinDate) throws Exception {
        String queryString = null;
        if (Configurazione.getSqlQueryObjectType() == null) {
            if (offset >= 0) {
                throw new GestoreMessaggiException("La funzione di ricerca tramite offset e limit non e' utilizzabile se nella configurazione della PdD non viene specificato il tipo di database");
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            if (findMinDate) {
                query.append("MIN(");
                query.append(MESSAGGI);
                query.append(".ORA_REGISTRAZIONE) as MinOraRegistrazione ");
            } else {
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append(".ID_MESSAGGIO as IdMsgServizioApplicativo, ");
                query.append(MESSAGGI);
                query.append(".ORA_REGISTRAZIONE as OraMessaggio ");
            }
            query.append(" FROM ");
            query.append(MSG_SERVIZI_APPLICATIVI);
            query.append(",");
            query.append(MESSAGGI);
            if (tipoServizio != null || servizio != null || azione != null) {
                query.append(",");
                query.append("REPOSITORY_BUSTE");
            }
            query.append(" WHERE ");
            query.append(MSG_SERVIZI_APPLICATIVI);
            query.append(".ID_MESSAGGIO=");
            query.append(MESSAGGI);
            query.append(".ID_MESSAGGIO AND ");
            if (tipoServizio != null || servizio != null || azione != null) {
                query.append("REPOSITORY_BUSTE");
                query.append(".ID_MESSAGGIO=");
                query.append(MESSAGGI);
                query.append(".ID_MESSAGGIO AND ");
                query.append("REPOSITORY_BUSTE");
                query.append(".TIPO=");
                query.append(MESSAGGI);
                query.append(".TIPO AND ");
            }
            query.append(MSG_SERVIZI_APPLICATIVI);
            query.append(".SERVIZIO_APPLICATIVO=? AND ");
            query.append(MSG_SERVIZI_APPLICATIVI);
            query.append(".INTEGRATION_MANAGER=1 AND ");
            query.append(MESSAGGI);
            query.append(".TIPO=? AND ");
            query.append(MESSAGGI);
            query.append(".PROPRIETARIO=? ");
            if (!findMinDate) {
                query.append("AND ");
                query.append(MESSAGGI);
                query.append(".ORA_REGISTRAZIONE>=? ");
            }
            if (tipoServizio != null) {
                query.append("AND ");
                query.append("REPOSITORY_BUSTE");
                query.append(".TIPO_SERVIZIO=? ");
            }
            if (servizio != null) {
                query.append("AND ");
                query.append("REPOSITORY_BUSTE");
                query.append(".SERVIZIO=? ");
            }
            if (azione != null) {
                query.append("AND ");
                query.append("REPOSITORY_BUSTE");
                query.append(".AZIONE=? ");
            }
            if (!findMinDate) {
                query.append("ORDER BY ");
                query.append(MESSAGGI);
                query.append(".ORA_REGISTRAZIONE,");
                query.append(MESSAGGI);
                query.append(".ID_MESSAGGIO");
            }
            queryString = query.toString();
        } else {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
            sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
            sqlQueryObject.addFromTable(MESSAGGI);
            if (tipoServizio != null || servizio != null || azione != null) {
                sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            }
            if (findMinDate) {
                sqlQueryObject.addSelectMinField("MESSAGGI.ORA_REGISTRAZIONE", "MinOraRegistrazione");
            } else {
                sqlQueryObject.addSelectAliasField(MSG_SERVIZI_APPLICATIVI, "ID_MESSAGGIO", "IdMsgServizioApplicativo");
                sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_MESSAGGIO", "IdBustaMessaggio");
                sqlQueryObject.addSelectAliasField(MESSAGGI, "TIPO", "TipoMessaggio");
                sqlQueryObject.addSelectAliasField(MESSAGGI, "ORA_REGISTRAZIONE", "OraMessaggio");
                sqlQueryObject.addSelectField(MESSAGGI, MESSAGGI_COLUMN_PROPRIETARIO);
                sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO);
                sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, MSG_SERVIZI_APPLICATIVI_COLUMN_INTEGRATION_MANAGER);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO");
            if (tipoServizio != null || servizio != null || azione != null) {
                if (!findMinDate) {
                    sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", "ID_MESSAGGIO", "IdBustaRepositoryBuste");
                    sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", "TIPO", "TipoBustaRepositoryBuste");
                    sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", "ORA_REGISTRAZIONE", "OraRepositoryBuste");
                }
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO");
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO=MESSAGGI.TIPO");
            }
            sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=?");
            sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=1");
            sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
            sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO=?");
            if (!findMinDate) {
                sqlQueryObject.addWhereCondition("MESSAGGI.ORA_REGISTRAZIONE>=?");
            }
            if (tipoServizio != null) {
                if (!findMinDate) {
                    sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_SERVIZIO");
                }
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO=?");
            }
            if (servizio != null) {
                if (!findMinDate) {
                    sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "SERVIZIO");
                }
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO=?");
            }
            if (azione != null) {
                if (!findMinDate) {
                    sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "AZIONE");
                }
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE=?");
            }
            if (!findMinDate) {
                sqlQueryObject.addOrderBy("OraMessaggio");
                sqlQueryObject.addOrderBy("IdBustaMessaggio");
                sqlQueryObject.setSortType(true);
                if (counter >= 0) {
                    sqlQueryObject.setLimit(counter);
                }
                if (offset >= 0) {
                    sqlQueryObject.setOffset(offset);
                }
            }
            queryString = sqlQueryObject.createSQLQuery();
        }
        return queryString;
    }

    private void setPreparedStatementGetAllMessagesId(PreparedStatement pstmt, String servizioApplicativo, String tipoServizio, String servizio, String azione, Timestamp minDate) throws Exception {
        pstmt.setString(1, servizioApplicativo);
        pstmt.setString(2, "INBOX");
        pstmt.setString(3, "ConsegnaContenutiApplicativi");
        int indexPstmt = 4;
        if (minDate != null) {
            pstmt.setTimestamp(indexPstmt, minDate);
            ++indexPstmt;
        }
        if (tipoServizio != null) {
            pstmt.setString(indexPstmt, tipoServizio);
            ++indexPstmt;
        }
        if (servizio != null) {
            pstmt.setString(indexPstmt, servizio);
            ++indexPstmt;
        }
        if (azione != null) {
            pstmt.setString(indexPstmt, azione);
            ++indexPstmt;
        }
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        this.eliminaDestinatarioMessaggio_serializable(servizioApplicativo, riferimentoMessaggio, 60000L, 100);
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                JDBCUtilities.setTransactionIsolationSerializable((String)this.propertiesReader.getDatabaseType(), (Connection)connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (setIsolation)" + this.idBusta + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            boolean deleteDestinatarioOK = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteDestinatarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                PreparedStatement pstmtDeleteSIL = null;
                try {
                    String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                    pstmtDeleteSIL = connectionDB.prepareStatement(query);
                    pstmtDeleteSIL.setString(1, this.idBusta);
                    pstmtDeleteSIL.setString(2, servizioApplicativo);
                    pstmtDeleteSIL.executeUpdate();
                    pstmtDeleteSIL.close();
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteDestinatarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtDeleteSIL != null) {
                            pstmtDeleteSIL.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (deleteDestinatarioOK) continue;
                try {
                    Utilities.sleep((long)GestoreMessaggi.getRandom().nextInt(checkInterval));
                }
                catch (Exception e) {}
            }
            boolean deleteRiferimentoMsgOK = false;
            boolean eliminazioneRifCompleta = false;
            scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteRiferimentoMsgOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmtUpdateMsg = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    String query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    rs = pstmt.executeQuery();
                    eliminazioneRifCompleta = !rs.next();
                    rs.close();
                    pstmt.close();
                    if (eliminazioneRifCompleta) {
                        StringBuilder queryUpdate = new StringBuilder();
                        queryUpdate.append("UPDATE ");
                        queryUpdate.append(MESSAGGI);
                        queryUpdate.append(" SET PROPRIETARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                        pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                        pstmtUpdateMsg.setString(1, "GestoreMessaggi");
                        pstmtUpdateMsg.setString(2, this.idBusta);
                        pstmtUpdateMsg.setString(3, "INBOX");
                        pstmtUpdateMsg.execute();
                        pstmtUpdateMsg.close();
                        this.addProprietarioIntoTable("INBOX", this.idBusta, "GestoreMessaggi");
                    }
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteRiferimentoMsgOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtUpdateMsg != null) {
                            pstmtUpdateMsg.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!deleteRiferimentoMsgOK) {
                    try {
                        Utilities.sleep((long)GestoreMessaggi.getRandom().nextInt(checkInterval));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!eliminazioneRifCompleta) continue;
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio_serializable", riferimentoMessaggio, false);
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateful.updateConnection(connectionDB);
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateful);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateful);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (ripristinoIsolation)" + this.idBusta + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void eliminaDestinatarioMessaggio(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        this.eliminaDestinatarioMessaggio(servizioApplicativo, riferimentoMessaggio, null);
    }

    public void eliminaDestinatarioMessaggio(String servizioApplicativo, String riferimentoMessaggio, Date oraRegistrazione) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Timestamp leftValue = null;
            Timestamp rightValue = null;
            if (oraRegistrazione != null) {
                leftValue = new Timestamp(oraRegistrazione.getTime() - 300000L);
                rightValue = new Timestamp(oraRegistrazione.getTime() + 300000L);
            }
            Statement pstmtDeleteSIL = null;
            try {
                Object query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ";
                if (oraRegistrazione != null) {
                    query = (String)query + "( ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ";
                }
                query = (String)query + " ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmtDeleteSIL = connectionDB.prepareStatement((String)query);
                int index = 1;
                if (oraRegistrazione != null) {
                    pstmtDeleteSIL.setTimestamp(index++, leftValue);
                    pstmtDeleteSIL.setTimestamp(index++, rightValue);
                }
                pstmtDeleteSIL.setString(index++, this.idBusta);
                pstmtDeleteSIL.setString(index++, servizioApplicativo);
                pstmtDeleteSIL.executeUpdate();
                pstmtDeleteSIL.close();
            }
            catch (Exception e) {
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO: " + e.getMessage();
                this.log.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
            Statement pstmtUpdateMsg = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                Object query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ";
                if (oraRegistrazione != null) {
                    query = (String)query + "( ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ";
                }
                query = (String)query + "ID_MESSAGGIO=?";
                pstmt = connectionDB.prepareStatement((String)query);
                int index = 1;
                if (oraRegistrazione != null) {
                    pstmt.setTimestamp(index++, leftValue);
                    pstmt.setTimestamp(index++, rightValue);
                }
                pstmt.setString(index++, this.idBusta);
                rs = pstmt.executeQuery();
                boolean eliminazioneRifCompleta = !rs.next();
                rs.close();
                pstmt.close();
                if (eliminazioneRifCompleta) {
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateMSG, this.isRichiesta, this.protocolFactory);
                    repositoryBuste.eliminaUtilizzoPdDFromInBox(this.idBusta, oraRegistrazione);
                    if (this.oneWayVersione11) {
                        repositoryBuste.eliminaBustaStatelessFromInBox(this.idBusta, oraRegistrazione);
                    }
                    StringBuilder queryUpdate = new StringBuilder();
                    queryUpdate.append("UPDATE ");
                    queryUpdate.append(MESSAGGI);
                    queryUpdate.append(" SET PROPRIETARIO=? WHERE ");
                    if (oraRegistrazione != null) {
                        queryUpdate.append("(ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ");
                    }
                    queryUpdate.append("ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                    index = 1;
                    pstmtUpdateMsg.setString(index++, "GestoreMessaggi");
                    if (oraRegistrazione != null) {
                        pstmtUpdateMsg.setTimestamp(index++, leftValue);
                        pstmtUpdateMsg.setTimestamp(index++, rightValue);
                    }
                    pstmtUpdateMsg.setString(index++, this.idBusta);
                    pstmtUpdateMsg.setString(index++, "INBOX");
                    stateMSG.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmtUpdateMsg);
                    this.addProprietarioIntoTable("INBOX", this.idBusta, "GestoreMessaggi");
                    boolean oldValue = false;
                    if (this.oneWayVersione11) {
                        oldValue = ((OpenSPCoopStateless)this.openspcoopstate).isUseConnection();
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(true);
                    }
                    this.openspcoopstate.commit();
                    if (this.oneWayVersione11) {
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(oldValue);
                    }
                }
                if (eliminazioneRifCompleta) {
                    this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio", riferimentoMessaggio, false);
                }
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateMSG);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateMSG);
            }
            catch (Exception e) {
                try {
                    if (pstmtUpdateMsg != null) {
                        pstmtUpdateMsg.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO, STEP 2: " + e.getMessage();
                this.log.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public static int abilitaSchedulingMessaggiDaRiconsegnareIntoBox(String servizioApplicativo, boolean checkEliminazioneLogica, Logger loggerSql, Connection connectionDB, boolean debug) throws GestoreMessaggiException {
        return GestoreMessaggi._updateLockConsegnaMessaggiDaRiconsegnareIntoBox(servizioApplicativo, true, checkEliminazioneLogica, loggerSql, connectionDB, debug);
    }

    public static int disabilitaSchedulingMessaggiDaRiconsegnareIntoBox(String servizioApplicativo, boolean checkEliminazioneLogica, Logger loggerSql, Connection connectionDB, boolean debug) throws GestoreMessaggiException {
        return GestoreMessaggi._updateLockConsegnaMessaggiDaRiconsegnareIntoBox(servizioApplicativo, false, checkEliminazioneLogica, loggerSql, connectionDB, debug);
    }

    private static int _updateLockConsegnaMessaggiDaRiconsegnareIntoBox(String servizioApplicativo, boolean abilitaScheduling, boolean checkEliminazioneLogica, Logger loggerSql, Connection connectionDB, boolean debug) throws GestoreMessaggiException {
        String idOperazione = abilitaScheduling ? "abilitaSchedulingNotificheAsincrone" : "disabilitaSchedulingNotificheAsincrone";
        Statement pstmt = null;
        String updateString = null;
        try {
            String tipoDatabase = Configurazione.getSqlQueryObjectType();
            if (tipoDatabase == null) {
                throw new GestoreMessaggiException("Funzionalit\u00e0 supportata solamente se viene definito il tipo di database");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addSelectField("ID_MESSAGGIO");
            sqlQueryObject.addFromTable(MESSAGGI);
            sqlQueryObject.addWhereCondition("PROPRIETARIO<>?");
            sqlQueryObject.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectMsgServiziApplicativi = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectMsgServiziApplicativi.addUpdateTable(MSG_SERVIZI_APPLICATIVI);
            sqlQueryObjectMsgServiziApplicativi.addUpdateField(MSG_SERVIZI_APPLICATIVI_COLUMN_LOCK_CONSEGNA, "?");
            sqlQueryObjectMsgServiziApplicativi.addWhereCondition("SERVIZIO_APPLICATIVO=?");
            if (checkEliminazioneLogica) {
                sqlQueryObjectMsgServiziApplicativi.addWhereCondition("TIPO=?");
                sqlQueryObjectMsgServiziApplicativi.addWhereINSelectSQLCondition(false, "ID_MESSAGGIO", sqlQueryObject);
                sqlQueryObjectMsgServiziApplicativi.setANDLogicOperator(true);
            }
            if (abilitaScheduling) {
                sqlQueryObjectMsgServiziApplicativi.addWhereCondition("LOCK_CONSEGNA=?");
            } else {
                sqlQueryObjectMsgServiziApplicativi.addWhereCondition(false, new String[]{"LOCK_CONSEGNA is null", "LOCK_CONSEGNA<>?"});
            }
            sqlQueryObjectMsgServiziApplicativi.setANDLogicOperator(true);
            updateString = sqlQueryObjectMsgServiziApplicativi.createSQLUpdate();
            pstmt = connectionDB.prepareStatement(updateString);
            int index = 1;
            ArrayList<String> params = new ArrayList<String>();
            if (abilitaScheduling) {
                pstmt.setTimestamp(index++, null);
                params.add("null");
            } else {
                pstmt.setTimestamp(index++, TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA);
                params.add(DateUtils.getSimpleDateFormatMs().format(TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA));
            }
            pstmt.setString(index++, servizioApplicativo);
            params.add(servizioApplicativo);
            if (checkEliminazioneLogica) {
                pstmt.setString(index++, "INBOX");
                params.add("INBOX");
                pstmt.setString(index++, "GestoreMessaggi");
                params.add("GestoreMessaggi");
            }
            pstmt.setTimestamp(index++, TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA);
            params.add(DateUtils.getSimpleDateFormatMs().format(TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA));
            long startDateSQLCommand = DateManager.getTimeMillis();
            String comandoSql = null;
            if (debug) {
                comandoSql = DBUtils.formatSQLString((String)updateString, (Object[])params.toArray());
                loggerSql.debug("[UPDATE] (Messaggi." + idOperazione + ") [" + comandoSql + "] ...");
            }
            int result = pstmt.executeUpdate();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long diffSQLCommand = endDateSQLCommand - startDateSQLCommand;
            if (debug) {
                loggerSql.debug("[UPDATE] (Messaggi." + idOperazione + ") [" + comandoSql + "] [row:" + result + "] effettuato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diffSQLCommand, (boolean)true));
            }
            int n = result;
            return n;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreMessaggi." + idOperazione + "] errore, queryString[" + updateString + "]: " + e.getMessage();
            loggerSql.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<MessaggioServizioApplicativo> readMessaggiDaRiconsegnareIntoBoxByPriorita(int limit, boolean verificaPresenzaMessaggiDaRispedire, boolean calcolaDataMinimaMessaggiRispedire, Integer secondiAnzianitaPerIniziareSpedireNuovoMessaggio, Date riconsegna, int presaInConsegnaMaxLife, boolean debug, RunnableLogger loggerSql, String coda, String priorita) throws GestoreMessaggiException {
        return this._readMessaggiDaRiconsegnareIntoBox(limit, verificaPresenzaMessaggiDaRispedire, calcolaDataMinimaMessaggiRispedire, secondiAnzianitaPerIniziareSpedireNuovoMessaggio, riconsegna, presaInConsegnaMaxLife, debug, loggerSql, coda, priorita, new String[0]);
    }

    public List<MessaggioServizioApplicativo> readMessaggiDaRiconsegnareIntoBoxByServiziApplicativPrioritari(int limit, boolean verificaPresenzaMessaggiDaRispedire, boolean calcolaDataMinimaMessaggiRispedire, Integer secondiAnzianitaPerIniziareSpedireNuovoMessaggio, Date riconsegna, int presaInConsegnaMaxLife, boolean debug, RunnableLogger loggerSql, String coda, String ... serviziApplicativiPrioritari) throws GestoreMessaggiException {
        return this._readMessaggiDaRiconsegnareIntoBox(limit, verificaPresenzaMessaggiDaRispedire, calcolaDataMinimaMessaggiRispedire, secondiAnzianitaPerIniziareSpedireNuovoMessaggio, riconsegna, presaInConsegnaMaxLife, debug, loggerSql, coda, null, serviziApplicativiPrioritari);
    }

    private List<MessaggioServizioApplicativo> _readMessaggiDaRiconsegnareIntoBox(int limit, boolean verificaPresenzaMessaggiDaRispedire, boolean calcolaDataMinimaMessaggiRispedire, Integer secondiAnzianitaPerIniziareSpedireNuovoMessaggio, Date riconsegna, int presaInConsegnaMaxLife, boolean debug, RunnableLogger loggerSql, String coda, String priorita, String ... serviziApplicativiPrioritari) throws GestoreMessaggiException {
        boolean verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi = true;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            String errorMsg;
            long diffSQLCommand;
            String comandoSql;
            Timestamp futuroPlusHour;
            Timestamp anzianita;
            String queryString;
            ResultSet rs;
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<MessaggioServizioApplicativo> idMsg = new ArrayList<MessaggioServizioApplicativo>();
            Date dataRilascioLock = new Date(DateManager.getTimeMillis() - (long)this.propertiesReader.getTimerConsegnaContenutiApplicativiPresaInConsegnaMaxLife());
            String tipo = "INBOX";
            Date dataAttualeVerificaNow = DateManager.getDate();
            boolean checkOraLegale = OpenSPCoop2Properties.getInstance().isTimerConsegnaContenutiApplicativiSchedulingCheckPassaggioOraLegaleVersoOraSolare();
            boolean isMinutiMancantiPassaggioOraLegaleVersoOraSolare = false;
            if (checkOraLegale) {
                isMinutiMancantiPassaggioOraLegaleVersoOraSolare = GestoreMessaggi.isMinutiMancantiPassaggioOraLegaleVersoOraSolare(debug, loggerSql, dataAttualeVerificaNow, 60);
            }
            if (debug) {
                loggerSql.debug("[QUERY] Parametri ricerca (coda:" + coda + " priorita:" + priorita + "): verificaPresenzaMessaggiDaRispedire:" + verificaPresenzaMessaggiDaRispedire + " calcolaDataMinimaMessaggiRispedire:" + calcolaDataMinimaMessaggiRispedire + " isMinutiMancantiPassaggioOraLegaleVersoOraSolare:" + isMinutiMancantiPassaggioOraLegaleVersoOraSolare);
            }
            Timestamp dataMinima = null;
            if (verificaPresenzaMessaggiDaRispedire && calcolaDataMinimaMessaggiRispedire) {
                Statement pstmt = null;
                rs = null;
                queryString = null;
                try {
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        StringBuilder query = new StringBuilder();
                        query.append("SELECT min(MESSAGGI.ORA_REGISTRAZIONE as minOraMess ");
                        query.append(" FROM ");
                        query.append(MESSAGGI);
                        query.append(",");
                        query.append(MSG_SERVIZI_APPLICATIVI);
                        query.append(" WHERE ");
                        if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                            if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                                query.append("(");
                                query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<=? ");
                                query.append(" OR ");
                                query.append("(");
                                query.append(MESSAGGI).append(".ORA_REGISTRAZIONE>? ");
                                query.append(" AND ");
                                query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<? ");
                                query.append(")");
                                query.append(")");
                                query.append(" AND ");
                            } else {
                                query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<=? ").append(" AND ");
                            }
                        }
                        query.append(" ");
                        query.append(MESSAGGI);
                        query.append(".ID_MESSAGGIO=");
                        query.append(MSG_SERVIZI_APPLICATIVI);
                        query.append(".ID_MESSAGGIO AND ");
                        query.append(" ").append(MESSAGGI).append(".TIPO=? AND ").append(MESSAGGI).append(".PROPRIETARIO=? ");
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".TIPO_CONSEGNA=? ");
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ATTESA_ESITO=? ");
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".CODA=? ");
                        if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                            query.append(" AND (");
                            if (serviziApplicativiPrioritari.length == 1) {
                                query.append(MSG_SERVIZI_APPLICATIVI).append(".SERVIZIO_APPLICATIVO=?");
                            } else {
                                query.append(MSG_SERVIZI_APPLICATIVI).append(".SERVIZIO_APPLICATIVO IN (");
                                for (int i = 0; i < serviziApplicativiPrioritari.length; ++i) {
                                    if (i > 0) {
                                        query.append(",");
                                    }
                                    query.append(serviziApplicativiPrioritari[i]);
                                }
                                query.append(") ");
                            }
                            query.append(")");
                        } else if (priorita != null) {
                            query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".PRIORITA=? ");
                        }
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO_COMPACT is not null ");
                        if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                            query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO_COMPACT <> ? ");
                        }
                        if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                            query.append(" AND (");
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                            query.append(" OR (");
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE=").append(MSG_SERVIZI_APPLICATIVI).append(".ORA_REGISTRAZIONE");
                            query.append(" AND ");
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                            query.append(") ");
                            query.append(") ");
                        } else {
                            query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                        }
                        query.append(" AND (").append(MSG_SERVIZI_APPLICATIVI).append(".LOCK_CONSEGNA is null ").append(" OR ").append(MSG_SERVIZI_APPLICATIVI).append(".LOCK_CONSEGNA < ? ").append(")");
                        queryString = query.toString();
                    } else {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                        sqlQueryObject.addFromTable(MESSAGGI, "m");
                        sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI, "sa");
                        sqlQueryObject.addSelectMinField("m", "ORA_REGISTRAZIONE", "minOraMess");
                        if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                            if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                                sqlQueryObject.addWhereCondition(false, new String[]{"m.ORA_REGISTRAZIONE<=?", "(m.ORA_REGISTRAZIONE>? AND m.ORA_REGISTRAZIONE<?)"});
                            } else {
                                sqlQueryObject.addWhereCondition("m.ORA_REGISTRAZIONE<=?");
                            }
                        }
                        sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=sa.ID_MESSAGGIO");
                        sqlQueryObject.addWhereCondition("m.TIPO=?");
                        sqlQueryObject.addWhereCondition("m.PROPRIETARIO=?");
                        sqlQueryObject.addWhereCondition("sa.TIPO_CONSEGNA=?");
                        sqlQueryObject.addWhereCondition("sa.ATTESA_ESITO=?");
                        sqlQueryObject.addWhereCondition("sa.CODA=?");
                        if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                            if (serviziApplicativiPrioritari.length == 1) {
                                sqlQueryObject.addWhereCondition("sa.SERVIZIO_APPLICATIVO=?");
                            } else {
                                sqlQueryObject.addWhereINCondition("sa.SERVIZIO_APPLICATIVO", true, serviziApplicativiPrioritari);
                            }
                        } else if (priorita != null) {
                            sqlQueryObject.addWhereCondition("sa.PRIORITA=?");
                        }
                        sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO_COMPACT is not null");
                        if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                            sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO_COMPACT <> ?");
                        }
                        if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                            sqlQueryObject.addWhereCondition(false, new String[]{"sa.RISPEDIZIONE<=?", "(sa.RISPEDIZIONE=sa.ORA_REGISTRAZIONE  AND sa.RISPEDIZIONE<=?)"});
                        } else {
                            sqlQueryObject.addWhereCondition("sa.RISPEDIZIONE<=?");
                        }
                        sqlQueryObject.addWhereCondition(false, new String[]{"sa.LOCK_CONSEGNA is null", "sa.LOCK_CONSEGNA < ?"});
                        sqlQueryObject.setANDLogicOperator(true);
                        queryString = sqlQueryObject.createSQLQuery();
                    }
                    pstmt = connectionDB.prepareStatement(queryString);
                    int index = 1;
                    ArrayList<Object> params = new ArrayList<Object>();
                    if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                        if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                            nowMillis = dataAttualeVerificaNow.getTime();
                            anzianita = new Timestamp(nowMillis - (long)(1000 * secondiAnzianitaPerIniziareSpedireNuovoMessaggio));
                            pstmt.setTimestamp(index++, anzianita);
                            params.add(DateUtils.getSimpleDateFormatMs().format(anzianita));
                            Timestamp futuro = new Timestamp(nowMillis);
                            pstmt.setTimestamp(index++, futuro);
                            params.add(DateUtils.getSimpleDateFormatMs().format(futuro));
                            futuroPlusHour = new Timestamp(nowMillis + 3600000L + 60005L);
                            pstmt.setTimestamp(index++, futuroPlusHour);
                            params.add(DateUtils.getSimpleDateFormatMs().format(futuroPlusHour));
                        } else {
                            nowMillis = DateManager.getTimeMillis();
                            anzianita = new Timestamp(nowMillis - (long)(1000 * secondiAnzianitaPerIniziareSpedireNuovoMessaggio));
                            pstmt.setTimestamp(index++, anzianita);
                            params.add(DateUtils.getSimpleDateFormatMs().format(anzianita));
                        }
                    }
                    pstmt.setString(index++, tipo);
                    params.add(tipo);
                    pstmt.setString(index++, "ConsegnaContenutiApplicativi");
                    params.add("ConsegnaContenutiApplicativi");
                    pstmt.setString(index++, CONSEGNA_TRAMITE_CONNETTORE);
                    params.add(CONSEGNA_TRAMITE_CONNETTORE);
                    pstmt.setInt(index++, 0);
                    params.add(0);
                    pstmt.setString(index++, coda);
                    params.add(coda);
                    if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                        if (serviziApplicativiPrioritari.length == 1) {
                            pstmt.setString(index++, serviziApplicativiPrioritari[0]);
                            params.add(serviziApplicativiPrioritari[0]);
                        }
                    } else if (priorita != null) {
                        pstmt.setString(index++, priorita);
                        params.add(priorita);
                    }
                    if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                        pstmt.setString(index++, "TimerConsegnaContenutiApplicativi");
                        params.add("TimerConsegnaContenutiApplicativi");
                    }
                    pstmt.setTimestamp(index++, new Timestamp(riconsegna.getTime()));
                    params.add(DateUtils.getSimpleDateFormatMs().format(riconsegna));
                    if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                        Timestamp futuroPlusHour2 = new Timestamp(riconsegna.getTime() + 3600000L + 60005L);
                        pstmt.setTimestamp(index++, new Timestamp(futuroPlusHour2.getTime()));
                        params.add(DateUtils.getSimpleDateFormatMs().format(futuroPlusHour2));
                    }
                    pstmt.setTimestamp(index++, new Timestamp(dataRilascioLock.getTime()));
                    params.add(DateUtils.getSimpleDateFormatMs().format(dataRilascioLock));
                    long startDateSQLCommand = DateManager.getTimeMillis();
                    comandoSql = null;
                    if (debug) {
                        comandoSql = DBUtils.formatSQLString((String)queryString, (Object[])params.toArray());
                        loggerSql.debug("[QUERY] (Messaggi.daRispedire.computeMinDate) [" + comandoSql + "] ...");
                    }
                    rs = pstmt.executeQuery();
                    long endDateSQLCommand = DateManager.getTimeMillis();
                    diffSQLCommand = endDateSQLCommand - startDateSQLCommand;
                    if (debug) {
                        loggerSql.debug("[QUERY] (Messaggi.daRispedire.computeMinDate) [" + comandoSql + "] effettuata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diffSQLCommand, (boolean)true));
                    }
                    if (rs.next()) {
                        dataMinima = rs.getTimestamp("minOraMess");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (dataMinima == null) {
                        loggerSql.debug("[QUERY] (Messaggi.daRispedire.computeMinDate) [" + comandoSql + "] dataMinima non trovata");
                        return idMsg;
                    }
                    if (debug) {
                        loggerSql.debug("[QUERY] (Messaggi.daRispedire.computeMinDate) [" + comandoSql + "] dataMinimaTrovata: " + DateUtils.getSimpleDateFormatMs().format(dataMinima));
                    }
                }
                catch (Throwable e) {
                    errorMsg = "[GestoreMessaggi.readMessaggiDaRiconsegnareIntoBox] errore durante il calcolo della data minima, queryString[" + queryString + "] : " + e.getMessage();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception startDateSQLCommand) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception startDateSQLCommand) {
                        // empty catch block
                    }
                    loggerSql.error(errorMsg, e);
                }
            }
            Statement pstmtMsgDaSpedire = null;
            rs = null;
            queryString = null;
            try {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT MESSAGGI.ID_MESSAGGIO as idmess, ");
                    query.append(" MESSAGGI.id_transazione as idtransazione, ");
                    query.append(" MESSAGGI.ORA_REGISTRAZIONE as oramess, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO as sa, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_SOAP as sbSoap, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_INFO_PROTOCOL as sbProtocol ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.NOME_PORTA as nomePorta ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.LOCK_CONSEGNA as saLock ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.CLUSTER_ID as saCluster ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.ATTESA_ESITO as attesa ");
                    query.append(" FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ");
                    if (verificaPresenzaMessaggiDaRispedire) {
                        if (dataMinima != null) {
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".ORA_REGISTRAZIONE>=? ").append(" AND ");
                            query.append(MESSAGGI).append(".ORA_REGISTRAZIONE>=? ").append(" AND ");
                        }
                    } else {
                        query.append(MSG_SERVIZI_APPLICATIVI).append(".ORA_REGISTRAZIONE>=? ").append(" AND ");
                        query.append(MESSAGGI).append(".ORA_REGISTRAZIONE>=? ").append(" AND ");
                    }
                    if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                        if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                            query.append("(");
                            query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<=? ");
                            query.append(" OR ");
                            query.append("(");
                            query.append(MESSAGGI).append(".ORA_REGISTRAZIONE>? ");
                            query.append(" AND ");
                            query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<? ");
                            query.append(")");
                            query.append(")");
                            query.append(" AND ");
                        } else {
                            query.append(MESSAGGI).append(".ORA_REGISTRAZIONE<=? ").append(" AND ");
                        }
                    }
                    query.append(" ");
                    query.append(MESSAGGI);
                    query.append(".ID_MESSAGGIO=");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_MESSAGGIO AND ");
                    query.append(" ").append(MESSAGGI).append(".TIPO=? AND ").append(MESSAGGI).append(".PROPRIETARIO=? ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".TIPO_CONSEGNA=? ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ATTESA_ESITO=? ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".CODA=? ");
                    if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                        query.append(" AND (");
                        if (serviziApplicativiPrioritari.length == 1) {
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".SERVIZIO_APPLICATIVO=?");
                        } else {
                            query.append(MSG_SERVIZI_APPLICATIVI).append(".SERVIZIO_APPLICATIVO IN (");
                            for (int i = 0; i < serviziApplicativiPrioritari.length; ++i) {
                                if (i > 0) {
                                    query.append(",");
                                }
                                query.append(serviziApplicativiPrioritari[i]);
                            }
                            query.append(") ");
                        }
                        query.append(")");
                    } else if (priorita != null) {
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".PRIORITA=? ");
                    }
                    if (verificaPresenzaMessaggiDaRispedire) {
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO_COMPACT is not null ");
                        if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                            query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO_COMPACT <> ? ");
                        }
                    } else {
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO_COMPACT = ? ");
                    }
                    if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                        query.append(" AND (");
                        query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                        query.append(" OR (");
                        query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE=").append(MSG_SERVIZI_APPLICATIVI).append(".ORA_REGISTRAZIONE");
                        query.append(" AND ");
                        query.append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                        query.append(") ");
                        query.append(") ");
                    } else {
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                    }
                    query.append(" AND (").append(MSG_SERVIZI_APPLICATIVI).append(".LOCK_CONSEGNA is null ").append(" OR ").append(MSG_SERVIZI_APPLICATIVI).append(".LOCK_CONSEGNA < ? ").append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI, "m");
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI, "sa");
                    sqlQueryObject.addSelectAliasField("m", "ID_MESSAGGIO", "idmess");
                    sqlQueryObject.addSelectAliasField("m", MESSAGGI_COLUMN_ID_TRANSAZIONE, "idtransazione");
                    sqlQueryObject.addSelectAliasField("m", "ORA_REGISTRAZIONE", "oramess");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO, "sa");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_SOAP", "sbSoap");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_INFO_PROTOCOL", "sbProtocol");
                    sqlQueryObject.addSelectAliasField("sa", "NOME_PORTA", "nomePorta");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_LOCK_CONSEGNA, "saLock");
                    sqlQueryObject.addSelectAliasField("sa", "CLUSTER_ID", "saCluster");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_ATTESA_ESITO, "attesa");
                    sqlQueryObject.addSelectAliasField("sa", "ID_MESSAGGIO", "saidmess");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_TIPO_CONSEGNA, "satipocons");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_ERRORE_PROCESSAMENTO_COMPACT, "saerrproccom");
                    sqlQueryObject.addSelectAliasField("sa", "RISPEDIZIONE", "sarisp");
                    sqlQueryObject.addSelectAliasField("sa", "CODA", "sacoda");
                    sqlQueryObject.addSelectAliasField("sa", "PRIORITA", "saprio");
                    sqlQueryObject.addSelectAliasField("m", "ORA_REGISTRAZIONE", "oramsg");
                    sqlQueryObject.addSelectAliasField("m", MESSAGGI_COLUMN_PROPRIETARIO, "propmsg");
                    sqlQueryObject.addSelectAliasField("m", "TIPO", "tipomsg");
                    if (verificaPresenzaMessaggiDaRispedire) {
                        if (dataMinima != null) {
                            sqlQueryObject.addWhereCondition("m.ORA_REGISTRAZIONE>=?");
                            sqlQueryObject.addWhereCondition("sa.ORA_REGISTRAZIONE>=?");
                        }
                    } else {
                        sqlQueryObject.addWhereCondition("m.ORA_REGISTRAZIONE>=?");
                        sqlQueryObject.addWhereCondition("sa.ORA_REGISTRAZIONE>=?");
                    }
                    if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                        if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                            sqlQueryObject.addWhereCondition(false, new String[]{"m.ORA_REGISTRAZIONE<=?", "(m.ORA_REGISTRAZIONE>? AND m.ORA_REGISTRAZIONE<?)"});
                        } else {
                            sqlQueryObject.addWhereCondition("m.ORA_REGISTRAZIONE<=?");
                        }
                    }
                    sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=sa.ID_MESSAGGIO");
                    sqlQueryObject.addWhereCondition("m.TIPO=?");
                    sqlQueryObject.addWhereCondition("m.PROPRIETARIO=?");
                    sqlQueryObject.addWhereCondition("sa.TIPO_CONSEGNA=?");
                    sqlQueryObject.addWhereCondition("sa.ATTESA_ESITO=?");
                    sqlQueryObject.addWhereCondition("sa.CODA=?");
                    if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                        if (serviziApplicativiPrioritari.length == 1) {
                            sqlQueryObject.addWhereCondition("sa.SERVIZIO_APPLICATIVO=?");
                        } else {
                            sqlQueryObject.addWhereINCondition("sa.SERVIZIO_APPLICATIVO", true, serviziApplicativiPrioritari);
                        }
                    } else if (priorita != null) {
                        sqlQueryObject.addWhereCondition("sa.PRIORITA=?");
                    }
                    if (verificaPresenzaMessaggiDaRispedire) {
                        sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO_COMPACT is not null");
                        if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                            sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO_COMPACT <> ?");
                        }
                    } else {
                        sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO_COMPACT = ?");
                    }
                    if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"sa.RISPEDIZIONE<=?", "(sa.RISPEDIZIONE=sa.ORA_REGISTRAZIONE  AND sa.RISPEDIZIONE<=?)"});
                    } else {
                        sqlQueryObject.addWhereCondition("sa.RISPEDIZIONE<=?");
                    }
                    sqlQueryObject.addWhereCondition(false, new String[]{"sa.LOCK_CONSEGNA is null", "sa.LOCK_CONSEGNA < ?"});
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("oramsg");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgDaSpedire = connectionDB.prepareStatement(queryString);
                int index = 1;
                ArrayList<Object> params = new ArrayList<Object>();
                if (verificaPresenzaMessaggiDaRispedire) {
                    if (dataMinima != null) {
                        pstmtMsgDaSpedire.setTimestamp(index++, dataMinima);
                        pstmtMsgDaSpedire.setTimestamp(index++, dataMinima);
                        params.add(DateUtils.getSimpleDateFormatMs().format(dataMinima));
                        params.add(DateUtils.getSimpleDateFormatMs().format(dataMinima));
                    }
                } else {
                    Timestamp now = new Timestamp(DateManager.getTimeMillis() - 86400000L);
                    pstmtMsgDaSpedire.setTimestamp(index++, now);
                    pstmtMsgDaSpedire.setTimestamp(index++, now);
                    params.add(DateUtils.getSimpleDateFormatMs().format(now));
                    params.add(DateUtils.getSimpleDateFormatMs().format(now));
                }
                if (secondiAnzianitaPerIniziareSpedireNuovoMessaggio != null && secondiAnzianitaPerIniziareSpedireNuovoMessaggio > 0) {
                    if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                        long nowMillis = dataAttualeVerificaNow.getTime();
                        anzianita = new Timestamp(nowMillis - (long)(1000 * secondiAnzianitaPerIniziareSpedireNuovoMessaggio));
                        pstmtMsgDaSpedire.setTimestamp(index++, anzianita);
                        params.add(DateUtils.getSimpleDateFormatMs().format(anzianita));
                        Timestamp futuro = new Timestamp(nowMillis);
                        pstmtMsgDaSpedire.setTimestamp(index++, futuro);
                        params.add(DateUtils.getSimpleDateFormatMs().format(futuro));
                        futuroPlusHour = new Timestamp(nowMillis + 3600000L + 60005L);
                        pstmtMsgDaSpedire.setTimestamp(index++, futuroPlusHour);
                        params.add(DateUtils.getSimpleDateFormatMs().format(futuroPlusHour));
                    } else {
                        Timestamp anzianita2 = new Timestamp(DateManager.getTimeMillis() - (long)(1000 * secondiAnzianitaPerIniziareSpedireNuovoMessaggio));
                        pstmtMsgDaSpedire.setTimestamp(index++, anzianita2);
                        params.add(DateUtils.getSimpleDateFormatMs().format(anzianita2));
                    }
                }
                pstmtMsgDaSpedire.setString(index++, tipo);
                params.add(tipo);
                pstmtMsgDaSpedire.setString(index++, "ConsegnaContenutiApplicativi");
                params.add("ConsegnaContenutiApplicativi");
                pstmtMsgDaSpedire.setString(index++, CONSEGNA_TRAMITE_CONNETTORE);
                params.add(CONSEGNA_TRAMITE_CONNETTORE);
                pstmtMsgDaSpedire.setInt(index++, 0);
                params.add(0);
                pstmtMsgDaSpedire.setString(index++, coda);
                params.add(coda);
                if (serviziApplicativiPrioritari != null && serviziApplicativiPrioritari.length > 0) {
                    if (serviziApplicativiPrioritari.length == 1) {
                        pstmtMsgDaSpedire.setString(index++, serviziApplicativiPrioritari[0]);
                        params.add(serviziApplicativiPrioritari[0]);
                    }
                } else if (priorita != null) {
                    pstmtMsgDaSpedire.setString(index++, priorita);
                    params.add(priorita);
                }
                if (verificaPresenzaMessaggiDaRispedire) {
                    if (!verificaPresenzaMessaggiDaRispedire_consideraAncheNuoviMessaggi) {
                        pstmtMsgDaSpedire.setString(index++, "TimerConsegnaContenutiApplicativi");
                        params.add("TimerConsegnaContenutiApplicativi");
                    }
                } else {
                    pstmtMsgDaSpedire.setString(index++, "TimerConsegnaContenutiApplicativi");
                    params.add("TimerConsegnaContenutiApplicativi");
                }
                pstmtMsgDaSpedire.setTimestamp(index++, new Timestamp(riconsegna.getTime()));
                params.add(DateUtils.getSimpleDateFormatMs().format(riconsegna));
                if (isMinutiMancantiPassaggioOraLegaleVersoOraSolare) {
                    Timestamp futuroPlusHour3 = new Timestamp(riconsegna.getTime() + 3600000L + 60005L);
                    pstmtMsgDaSpedire.setTimestamp(index++, new Timestamp(futuroPlusHour3.getTime()));
                    params.add(DateUtils.getSimpleDateFormatMs().format(futuroPlusHour3));
                }
                pstmtMsgDaSpedire.setTimestamp(index++, new Timestamp(dataRilascioLock.getTime()));
                params.add(DateUtils.getSimpleDateFormatMs().format(dataRilascioLock));
                long startDateSQLCommand = DateManager.getTimeMillis();
                comandoSql = null;
                if (debug) {
                    comandoSql = DBUtils.formatSQLString((String)queryString, (Object[])params.toArray());
                    loggerSql.debug("[QUERY] (Messaggi.daRispedire) [" + comandoSql + "] ...");
                }
                rs = pstmtMsgDaSpedire.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                diffSQLCommand = endDateSQLCommand - startDateSQLCommand;
                if (debug) {
                    loggerSql.debug("[QUERY] (Messaggi.daRispedire) [" + comandoSql + "] effettuata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diffSQLCommand, (boolean)true));
                }
                int countLimit = 0;
                while (rs.next()) {
                    MessaggioServizioApplicativo msg = new MessaggioServizioApplicativo();
                    msg.setIdTransazione(rs.getString("idtransazione"));
                    msg.setIdMessaggio(rs.getString("idmess"));
                    msg.setServizioApplicativo(rs.getString("sa"));
                    int sbSoap = rs.getInt("sbSoap");
                    msg.setSbustamentoSoap(sbSoap == 1);
                    int sbInfoProt = rs.getInt("sbProtocol");
                    msg.setSbustamentoInformazioniProtocollo(sbInfoProt == 1);
                    msg.setNomePorta(rs.getString("nomePorta"));
                    Timestamp oraRegistrazione = rs.getTimestamp("oramess");
                    msg.setOraRegistrazione(oraRegistrazione);
                    Timestamp dataPresaInConsegna = rs.getTimestamp("saLock");
                    msg.setDataPresaInConsegna(dataPresaInConsegna);
                    msg.setClusterIdPresaInConsegna(rs.getString("saCluster"));
                    int attesaTransazioneCapostipite = rs.getInt("attesa");
                    msg.setAttesaEsitoTransazioneCapostipite(attesaTransazioneCapostipite == 1);
                    idMsg.add(msg);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                rs = null;
                pstmtMsgDaSpedire.close();
                pstmtMsgDaSpedire = null;
                if (debug) {
                    loggerSql.debug("[QUERY] (Messaggi.daRispedire) [" + comandoSql + "] trovati risultati: " + idMsg.size());
                }
                return idMsg;
            }
            catch (Exception e) {
                errorMsg = "[GestoreMessaggi.readMessaggiDaRiconsegnareIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgDaSpedire != null) {
                        pstmtMsgDaSpedire.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                loggerSql.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public static boolean isMinutiMancantiPassaggioOraLegaleVersoOraSolare(boolean debug, RunnableLogger loggerSql, Date data, int minutes) {
        try {
            String format = DaylightSavingUtils.getOffsetFormat();
            String dataString = DateUtils.getSimpleDateFormat((String)format).format(data);
            TimeTransitionType type = DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset((String)dataString, (String)format);
            if (type != null && TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME.equals((Object)type)) {
                boolean result;
                long m = DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset((String)dataString, (String)format);
                boolean bl = result = m > -1L && m <= (long)minutes;
                if (debug) {
                    loggerSql.debug("(Messaggi.daRispedire) verifico data [" + dataString + "] minutes: " + m + "   Risultato: " + result);
                }
                return result;
            }
            return false;
        }
        catch (Throwable t) {
            loggerSql.error("Calcolo 'isMinutiMancantiPassaggioOraLegaleVersoOraSolare' fallito: " + t.getMessage(), t);
            return false;
        }
    }

    public MessaggioServizioApplicativo readInfoDestinatario(String applicativo, boolean debug, Logger log) throws GestoreMessaggiException {
        List<MessaggioServizioApplicativo> l = this._readInfoDestinatari(debug, log, applicativo);
        if (l != null && !l.isEmpty()) {
            if (l.size() == 1) {
                return l.get(0);
            }
            throw new GestoreMessaggiException("More than one result (" + l.size() + ")");
        }
        return null;
    }

    public List<MessaggioServizioApplicativo> readInfoDestinatari(boolean debug, Logger log) throws GestoreMessaggiException {
        return this._readInfoDestinatari(debug, log, null);
    }

    private List<MessaggioServizioApplicativo> _readInfoDestinatari(boolean debug, Logger log, String applicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<MessaggioServizioApplicativo> idMsg = new ArrayList<MessaggioServizioApplicativo>();
            Statement pstmtMsg = null;
            ResultSet rs = null;
            String queryString = null;
            String tipo = null;
            try {
                tipo = "INBOX";
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT MESSAGGI.ID_MESSAGGIO as idmess, ");
                    query.append(" MESSAGGI.id_transazione as idtransazione, ");
                    query.append(" MESSAGGI.ORA_REGISTRAZIONE as oramess, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO as sa, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_SOAP as sbSoap, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_INFO_PROTOCOL as sbProtocol ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.NOME_PORTA as nomePorta ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.LOCK_CONSEGNA as lock ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.CLUSTER_ID as cluster ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.ATTESA_ESITO as attesa ");
                    query.append(" FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ");
                    query.append(" ");
                    query.append(MESSAGGI);
                    query.append(".ID_MESSAGGIO=");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_MESSAGGIO AND ");
                    query.append(" ").append(MESSAGGI).append(".ID_MESSAGGIO=? AND ");
                    query.append(" ").append(MESSAGGI).append(".TIPO=?");
                    if (applicativo != null) {
                        query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".SERVIZIO_APPLICATIVO=?");
                    }
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI, "m");
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI, "sa");
                    sqlQueryObject.addSelectAliasField("m", "ID_MESSAGGIO", "idmess");
                    sqlQueryObject.addSelectAliasField("m", "ORA_REGISTRAZIONE", "oramess");
                    sqlQueryObject.addSelectAliasField("m", MESSAGGI_COLUMN_ID_TRANSAZIONE, "idtransazione");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO, "sa");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_SOAP", "sbSoap");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_INFO_PROTOCOL", "sbProtocol");
                    sqlQueryObject.addSelectAliasField("sa", "NOME_PORTA", "nomePorta");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_LOCK_CONSEGNA, "lock");
                    sqlQueryObject.addSelectAliasField("sa", "CLUSTER_ID", "cluster");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_ATTESA_ESITO, "attesa");
                    sqlQueryObject.addSelectField("m", "ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("m", MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("m", "TIPO");
                    sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=sa.ID_MESSAGGIO");
                    sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=?");
                    sqlQueryObject.addWhereCondition("m.TIPO=?");
                    if (applicativo != null) {
                        sqlQueryObject.addWhereCondition("sa.SERVIZIO_APPLICATIVO=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsg = connectionDB.prepareStatement(queryString);
                int index = 1;
                pstmtMsg.setString(index++, this.idBusta);
                pstmtMsg.setString(index++, tipo);
                if (applicativo != null) {
                    pstmtMsg.setString(index++, applicativo);
                }
                Object terzoArgomento = "";
                if (applicativo != null) {
                    terzoArgomento = " 3[" + applicativo + "]";
                }
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (debug) {
                    log.debug("[QUERY] (Messaggi.readDestinatari) [" + queryString + "] 1[" + this.idBusta + "] 2[" + tipo + "]" + (String)terzoArgomento + " ...");
                }
                rs = pstmtMsg.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long diffSQLCommand = endDateSQLCommand - startDateSQLCommand;
                if (debug) {
                    log.debug("[QUERY] (Messaggi.readDestinatari) [" + queryString + "] 1[" + this.idBusta + "] 2[" + tipo + "]" + (String)terzoArgomento + " effettuata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diffSQLCommand, (boolean)true));
                }
                while (rs.next()) {
                    MessaggioServizioApplicativo msg = new MessaggioServizioApplicativo();
                    msg.setIdTransazione(rs.getString("idtransazione"));
                    msg.setIdMessaggio(rs.getString("idmess"));
                    msg.setServizioApplicativo(rs.getString("sa"));
                    int sbSoap = rs.getInt("sbSoap");
                    msg.setSbustamentoSoap(sbSoap == 1);
                    int sbInfoProt = rs.getInt("sbProtocol");
                    msg.setSbustamentoInformazioniProtocollo(sbInfoProt == 1);
                    msg.setNomePorta(rs.getString("nomePorta"));
                    Timestamp oraRegistrazione = rs.getTimestamp("oramess");
                    msg.setOraRegistrazione(oraRegistrazione);
                    Timestamp dataPresaInConsegna = rs.getTimestamp("lock");
                    msg.setDataPresaInConsegna(dataPresaInConsegna);
                    msg.setClusterIdPresaInConsegna(rs.getString("cluster"));
                    int attesaTransazioneCapostipite = rs.getInt("attesa");
                    msg.setAttesaEsitoTransazioneCapostipite(attesaTransazioneCapostipite == 1);
                    idMsg.add(msg);
                }
                rs.close();
                pstmtMsg.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readDestinatari] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsg != null) {
                        pstmtMsg.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void updateMessaggioPresaInCosegna(String servizioApplicativo, String clusterId, boolean debug, RunnableLogger loggerSql) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                Timestamp now = DateManager.getTimestamp();
                String query = "UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA=?, CLUSTER_ID=? WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                int index = 1;
                pstmt.setTimestamp(index++, now);
                pstmt.setString(index++, clusterId);
                pstmt.setString(index++, this.idBusta);
                pstmt.setString(index++, servizioApplicativo);
                int row = pstmt.executeUpdate();
                if (debug) {
                    loggerSql.debug("(rows update: " + row + ") UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA='" + DateUtils.getSimpleDateFormatMs().format(now) + "', CLUSTER_ID='" + cluster_id + "' WHERE ID_MESSAGGIO='" + this.idBusta + "' AND SERVIZIO_APPLICATIVO='" + servizioApplicativo + "'");
                }
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception query) {
                    // empty catch block
                }
                String msgError = "ERROR updateMessaggioPresaInCosegna: " + e.getMessage();
                loggerSql.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void releaseMessaggioPresaInCosegna(String servizioApplicativo, String clusterId, boolean debug, RunnableLogger loggerSql) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                String query = "UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA=?, CLUSTER_ID=? WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                int index = 1;
                pstmt.setTimestamp(index++, null);
                pstmt.setString(index++, null);
                pstmt.setString(index++, this.idBusta);
                pstmt.setString(index++, servizioApplicativo);
                int row = pstmt.executeUpdate();
                if (debug) {
                    loggerSql.debug("(rows update: " + row + ") UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA=null, CLUSTER_ID=null WHERE ID_MESSAGGIO='" + this.idBusta + "' AND SERVIZIO_APPLICATIVO='" + servizioApplicativo + "'");
                }
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                String msgError = "ERROR releaseMessaggioPresaInCosegna: " + e.getMessage();
                loggerSql.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void releaseMessaggiPresaInCosegna(String queue, String clusterId, boolean debug, RunnableLogger loggerSql) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                String condition = clusterId == null || "".equals(clusterId) ? "CLUSTER_ID is null" : " CLUSTER_ID=?";
                String query = "UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA=?, CLUSTER_ID=? WHERE " + condition + " AND CODA=? AND LOCK_CONSEGNA is not null AND LOCK_CONSEGNA<?";
                pstmt = connectionDB.prepareStatement(query);
                int index = 1;
                pstmt.setTimestamp(index++, null);
                pstmt.setString(index++, null);
                if (clusterId != null && !"".equals(clusterId)) {
                    pstmt.setString(index++, clusterId);
                }
                pstmt.setString(index++, queue);
                pstmt.setTimestamp(index++, TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA);
                int row = pstmt.executeUpdate();
                if (debug) {
                    loggerSql.debug("(rows update: " + row + ") (clusterID: " + clusterId + ") UPDATE MSG_SERVIZI_APPLICATIVI SET LOCK_CONSEGNA=null, CLUSTER_ID=null WHERE " + condition + " AND CODA=" + queue + " AND LOCK_CONSEGNA is not null AND LOCK_CONSEGNA<" + DateUtils.getSimpleDateFormatMs().format(TimerConsegnaContenutiApplicativiThread.LOCK_CONSEGNA_FUTURA));
                }
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception query) {
                    // empty catch block
                }
                String msgError = "ERROR releaseMessaggioPresaInCosegna: " + e.getMessage();
                loggerSql.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void releaseAttesaEsiti(boolean debug, Logger log) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                String query = "UPDATE MSG_SERVIZI_APPLICATIVI SET ATTESA_ESITO=? WHERE ID_MESSAGGIO=?";
                pstmt = connectionDB.prepareStatement(query);
                int index = 1;
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, this.idBusta);
                int row = pstmt.executeUpdate();
                if (debug) {
                    log.debug("(rows update: " + row + ") UPDATE MSG_SERVIZI_APPLICATIVI SET ATTESA_ESITO=0 WHERE ID_MESSAGGIO='" + this.idBusta + "'");
                }
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception index) {
                    // empty catch block
                }
                String msgError = "ERROR releaseMessaggioPresaInCosegna: " + e.getMessage();
                log.error(msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public static Date getOraRegistrazioneMassima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws GestoreMessaggiException {
        return GestoreMessaggi._getOraRegistrazione(false, connectionDB, tipoDatabase, logQuery, logger);
    }

    public static Date getOraRegistrazioneMinima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws GestoreMessaggiException {
        return GestoreMessaggi._getOraRegistrazione(true, connectionDB, tipoDatabase, logQuery, logger);
    }

    private static Date _getOraRegistrazione(boolean min, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws GestoreMessaggiException {
        Statement pstmt = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            if (min) {
                sqlQueryObject.addSelectMinField("ORA_REGISTRAZIONE", "check_data");
            } else {
                sqlQueryObject.addSelectMaxField("ORA_REGISTRAZIONE", "check_data");
            }
            sqlQueryObject.addFromTable(MESSAGGI);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            pstmt = connectionDB.prepareStatement(queryString);
            rs = pstmt.executeQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata");
            }
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("check_data");
                return timestamp;
            }
            Date date = null;
            return date;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreMessaggi.getOraRegistrazione] errore, queryString[" + queryString + "]: " + e.getMessage();
            throw new GestoreMessaggiException(errorMsg, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int countMessaggiInutiliIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate) throws GestoreMessaggiException {
        return GestoreMessaggi._countMessaggiIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, null);
    }

    public static int countMessaggiInutiliIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate) throws GestoreMessaggiException {
        return GestoreMessaggi._countMessaggiIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, null);
    }

    public static int countMessaggiScadutiIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, long scadenzaMsg) throws GestoreMessaggiException {
        return GestoreMessaggi._countMessaggiIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, scadenzaMsg);
    }

    public static int countMessaggiScadutiIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, long scadenzaMsg) throws GestoreMessaggiException {
        return GestoreMessaggi._countMessaggiIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, scadenzaMsg);
    }

    private static int _countMessaggiIntoBox(boolean searchIntoInbox, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, Long scadenzaMsg) throws GestoreMessaggiException {
        String tipo = null;
        tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
        String idModuloCleaner = "GestoreMessaggi";
        Statement pstmt = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            Timestamp scandenzaT = null;
            if (scadenzaMsg != null) {
                long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
                scandenzaT = new Timestamp(scadenza);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addSelectCountField("totale_msg");
            sqlQueryObject.addFromTable(MESSAGGI);
            if (leftDate != null) {
                sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE>=?");
            }
            if (rightDate != null) {
                sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE<=?");
            }
            if (scadenzaMsg != null) {
                sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                sqlQueryObject.addWhereCondition("TIPO=?");
            } else {
                sqlQueryObject.addWhereCondition("TIPO=?");
                sqlQueryObject.addWhereCondition("PROPRIETARIO=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            pstmt = connectionDB.prepareStatement(queryString);
            int index = 1;
            ArrayList<String> objects = new ArrayList<String>();
            if (leftDate != null) {
                Timestamp leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDateT));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDateT));
                }
            }
            if (scadenzaMsg != null) {
                pstmt.setTimestamp(index++, scandenzaT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
                pstmt.setString(index++, idModuloCleaner);
                if (logQuery) {
                    objects.add(idModuloCleaner);
                }
            }
            String query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)queryString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            rs = pstmt.executeQuery();
            int res = 0;
            if (rs.next()) {
                res = rs.getInt("totale_msg");
            }
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; trovati " + res + " risultati");
            }
            int n = res;
            return n;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreMessaggi.countMessaggiIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
            throw new GestoreMessaggiException(errorMsg, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static SortedMap<Integer> deleteMessaggiInutiliIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, IGestoreRepository repository) throws GestoreMessaggiException {
        return GestoreMessaggi._deleteMessaggiIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, null, repository);
    }

    public static SortedMap<Integer> deleteMessaggiInutiliIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, IGestoreRepository repository) throws GestoreMessaggiException {
        return GestoreMessaggi._deleteMessaggiIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, null, repository);
    }

    public static SortedMap<Integer> deleteMessaggiScadutiIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, long scadenzaMsg, IGestoreRepository repository) throws GestoreMessaggiException {
        return GestoreMessaggi._deleteMessaggiIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, scadenzaMsg, repository);
    }

    public static SortedMap<Integer> deleteMessaggiScadutiIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, long scadenzaMsg, IGestoreRepository repository) throws GestoreMessaggiException {
        return GestoreMessaggi._deleteMessaggiIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, leftDate, rightDate, scadenzaMsg, repository);
    }

    private static SortedMap<Integer> _deleteMessaggiIntoBox(boolean searchIntoInbox, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, Date leftDate, Date rightDate, Long scadenzaMsg, IGestoreRepository repository) throws GestoreMessaggiException {
        SortedMap mapTabelleRigheEliminate = new SortedMap();
        String tipo = null;
        tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
        String idModuloCleaner = "GestoreMessaggi";
        Statement pstmt = null;
        String deleteString = null;
        try {
            int result;
            String query;
            Timestamp rightDateT;
            Timestamp leftDateT;
            ArrayList<String> objects;
            int index;
            Timestamp scandenzaT = null;
            if (scadenzaMsg != null) {
                long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
                scandenzaT = new Timestamp(scadenza);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addSelectField("ID_MESSAGGIO");
            sqlQueryObject.addFromTable(MESSAGGI);
            if (leftDate != null) {
                sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE>=?");
            }
            if (rightDate != null) {
                sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE<=?");
            }
            if (scadenzaMsg != null) {
                sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                sqlQueryObject.addWhereCondition("TIPO=?");
            } else {
                sqlQueryObject.addWhereCondition("TIPO=?");
                sqlQueryObject.addWhereCondition("PROPRIETARIO=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            if (searchIntoInbox) {
                ISQLQueryObject sqlQueryObjectMsgServiziApplicativi = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                sqlQueryObjectMsgServiziApplicativi.addDeleteTable(MSG_SERVIZI_APPLICATIVI);
                sqlQueryObjectMsgServiziApplicativi.addWhereINSelectSQLCondition(false, "ID_MESSAGGIO", sqlQueryObject);
                sqlQueryObjectMsgServiziApplicativi.setANDLogicOperator(true);
                deleteString = sqlQueryObjectMsgServiziApplicativi.createSQLDelete();
                pstmt = connectionDB.prepareStatement(deleteString);
                index = 1;
                objects = new ArrayList<String>();
                if (leftDate != null) {
                    leftDateT = new Timestamp(leftDate.getTime());
                    pstmt.setTimestamp(index++, leftDateT);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(leftDate));
                    }
                }
                if (rightDate != null) {
                    rightDateT = new Timestamp(rightDate.getTime());
                    pstmt.setTimestamp(index++, rightDateT);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(rightDate));
                    }
                }
                if (scadenzaMsg != null) {
                    pstmt.setTimestamp(index++, scandenzaT);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                    }
                    pstmt.setString(index++, tipo);
                    if (logQuery) {
                        objects.add(tipo);
                    }
                } else {
                    pstmt.setString(index++, tipo);
                    if (logQuery) {
                        objects.add(tipo);
                    }
                    pstmt.setString(index++, idModuloCleaner);
                    if (logQuery) {
                        objects.add(idModuloCleaner);
                    }
                }
                query = null;
                if (logQuery) {
                    query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                    logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
                }
                result = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                if (logQuery) {
                    logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
                }
                mapTabelleRigheEliminate.add(MSG_SERVIZI_APPLICATIVI, (Object)result);
            }
            ISQLQueryObject sqlQueryObjectDefinizioneMessaggi = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectDefinizioneMessaggi.addDeleteTable(DEFINIZIONE_MESSAGGI);
            sqlQueryObjectDefinizioneMessaggi.addWhereCondition("TIPO=?");
            sqlQueryObjectDefinizioneMessaggi.addWhereINSelectSQLCondition(false, "ID_MESSAGGIO", sqlQueryObject);
            sqlQueryObjectDefinizioneMessaggi.setANDLogicOperator(true);
            deleteString = sqlQueryObjectDefinizioneMessaggi.createSQLDelete();
            pstmt = connectionDB.prepareStatement(deleteString);
            index = 1;
            objects = new ArrayList();
            pstmt.setString(index++, tipo);
            if (logQuery) {
                objects.add(tipo);
            }
            if (leftDate != null) {
                leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDate));
                }
            }
            if (rightDate != null) {
                rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDate));
                }
            }
            if (scadenzaMsg != null) {
                pstmt.setTimestamp(index++, scandenzaT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
                pstmt.setString(index++, idModuloCleaner);
                if (logQuery) {
                    objects.add(idModuloCleaner);
                }
            }
            query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            result = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
            }
            mapTabelleRigheEliminate.add(DEFINIZIONE_MESSAGGI, (Object)result);
            if (repository != null) {
                ISQLQueryObject sqlQueryObjectRepositoryBusteJoin = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                sqlQueryObjectRepositoryBusteJoin.addSelectField("ID_MESSAGGIO");
                sqlQueryObjectRepositoryBusteJoin.addFromTable("REPOSITORY_BUSTE");
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBusteJoin.addWhereINSelectSQLCondition(false, "ID_MESSAGGIO", sqlQueryObject);
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition(false, new String[]{repository.createSQLCondition_enableOnlyPdd(), repository.createSQLCondition_disabledAll()});
                sqlQueryObjectRepositoryBusteJoin.setANDLogicOperator(true);
                GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_RISCONTRI", "TIPO", "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_TRASMISSIONI", "TIPO", "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_ECCEZIONI", "TIPO", "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_EXT_PROTOCOL_INFO", "TIPO", "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "ASINCRONO", "TIPO", "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                if (!searchIntoInbox) {
                    GestoreMessaggi._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "RISCONTRI_DA_RICEVERE", null, "ID_MESSAGGIO", tipo, leftDate, rightDate, scandenzaT, idModuloCleaner, sqlQueryObjectRepositoryBusteJoin, (SortedMap<Integer>)mapTabelleRigheEliminate);
                }
                ISQLQueryObject sqlQueryObjectRepositoryBuste = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                sqlQueryObjectRepositoryBuste.addDeleteTable("REPOSITORY_BUSTE");
                sqlQueryObjectRepositoryBuste.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBuste.addWhereINSelectSQLCondition(false, "ID_MESSAGGIO", sqlQueryObject);
                sqlQueryObjectRepositoryBuste.addWhereCondition(false, new String[]{repository.createSQLCondition_enableOnlyPdd(), repository.createSQLCondition_disabledAll()});
                sqlQueryObjectRepositoryBuste.setANDLogicOperator(true);
                deleteString = sqlQueryObjectRepositoryBuste.createSQLDelete();
                pstmt = connectionDB.prepareStatement(deleteString);
                index = 1;
                objects = new ArrayList();
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
                if (leftDate != null) {
                    Timestamp leftDateT2 = new Timestamp(leftDate.getTime());
                    pstmt.setTimestamp(index++, leftDateT2);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(leftDate));
                    }
                }
                if (rightDate != null) {
                    Timestamp rightDateT2 = new Timestamp(rightDate.getTime());
                    pstmt.setTimestamp(index++, rightDateT2);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(rightDate));
                    }
                }
                if (scadenzaMsg != null) {
                    pstmt.setTimestamp(index++, scandenzaT);
                    if (logQuery) {
                        objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                    }
                    pstmt.setString(index++, tipo);
                    if (logQuery) {
                        objects.add(tipo);
                    }
                } else {
                    pstmt.setString(index++, tipo);
                    if (logQuery) {
                        objects.add(tipo);
                    }
                    pstmt.setString(index++, idModuloCleaner);
                    if (logQuery) {
                        objects.add(idModuloCleaner);
                    }
                }
                query = null;
                if (logQuery) {
                    query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                    logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
                }
                result = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                if (logQuery) {
                    logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
                }
                mapTabelleRigheEliminate.add("REPOSITORY_BUSTE", (Object)result);
            }
            ISQLQueryObject sqlQueryObjectMessaggi = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectMessaggi.addDeleteTable(MESSAGGI);
            if (leftDate != null) {
                sqlQueryObjectMessaggi.addWhereCondition("ORA_REGISTRAZIONE>=?");
            }
            if (rightDate != null) {
                sqlQueryObjectMessaggi.addWhereCondition("ORA_REGISTRAZIONE<=?");
            }
            if (scadenzaMsg != null) {
                sqlQueryObjectMessaggi.addWhereCondition("? > ORA_REGISTRAZIONE");
                sqlQueryObjectMessaggi.addWhereCondition("TIPO=?");
            } else {
                sqlQueryObjectMessaggi.addWhereCondition("TIPO=?");
                sqlQueryObjectMessaggi.addWhereCondition("PROPRIETARIO=?");
            }
            sqlQueryObjectMessaggi.setANDLogicOperator(true);
            deleteString = sqlQueryObjectMessaggi.createSQLDelete();
            pstmt = connectionDB.prepareStatement(deleteString);
            index = 1;
            objects = new ArrayList();
            if (leftDate != null) {
                Timestamp leftDateT3 = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT3);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDate));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT3 = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT3);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDate));
                }
            }
            if (scadenzaMsg != null) {
                pstmt.setTimestamp(index++, scandenzaT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
                pstmt.setString(index++, idModuloCleaner);
                if (logQuery) {
                    objects.add(idModuloCleaner);
                }
            }
            query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            result = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
            }
            mapTabelleRigheEliminate.add(MESSAGGI, (Object)result);
            SortedMap sortedMap = mapTabelleRigheEliminate;
            return sortedMap;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreMessaggi.deleteMessaggiIntoBox] errore, deleteString[" + deleteString + "]: " + e.getMessage();
            throw new GestoreMessaggiException(errorMsg, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _deleteListaRepositoryBuste(String tipoDatabase, Connection connectionDB, boolean logQuery, Logger logger, String nomeTabella, String nomeColonnaTipoMessaggio, String nomeColonnaIdMessaggio, String tipo, Date leftDate, Date rightDate, Timestamp scandenzaT, String idModuloCleaner, ISQLQueryObject sqlQueryObjectRepositoryBusteJoin, SortedMap<Integer> mapTabelleRigheEliminate) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObject.addDeleteTable(nomeTabella);
        if (nomeColonnaTipoMessaggio != null) {
            sqlQueryObject.addWhereCondition(nomeColonnaTipoMessaggio + "=?");
        }
        sqlQueryObject.addWhereINSelectSQLCondition(false, nomeColonnaIdMessaggio, sqlQueryObjectRepositoryBusteJoin);
        sqlQueryObject.setANDLogicOperator(true);
        String deleteString = sqlQueryObject.createSQLDelete();
        PreparedStatement pstmt = null;
        try {
            pstmt = connectionDB.prepareStatement(deleteString);
            int index = 1;
            ArrayList<String> objects = new ArrayList<String>();
            if (nomeColonnaTipoMessaggio != null) {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            }
            pstmt.setString(index++, tipo);
            if (logQuery) {
                objects.add(tipo);
            }
            if (leftDate != null) {
                Timestamp leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDate));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDate));
                }
            }
            if (scandenzaT != null) {
                pstmt.setTimestamp(index++, scandenzaT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
                pstmt.setString(index++, idModuloCleaner);
                if (logQuery) {
                    objects.add(idModuloCleaner);
                }
            }
            String query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            int result = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
            }
            mapTabelleRigheEliminate.add(nomeTabella, (Object)result);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> readMessaggiInutiliIntoInbox(String idModuloCleaner, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(true, idModuloCleaner, limit, logQuery, orderBy, data);
    }

    public List<String> readMessaggiInutiliIntoOutbox(String idModuloCleaner, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(false, idModuloCleaner, limit, logQuery, orderBy, data);
    }

    private List<String> readMessaggiInutiliIntoBox(boolean searchIntoInbox, String idModuloCleaner, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<String> idMsg = new ArrayList<String>();
            Statement pstmtMsgEliminati = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ").append("ID_MESSAGGIO").append(" FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ").append("TIPO").append("=? AND ").append(MESSAGGI_COLUMN_PROPRIETARIO).append("=? ");
                    if (data != null) {
                        query.append(" AND ").append("ORA_REGISTRAZIONE").append("<=?");
                    }
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition("PROPRIETARIO=?");
                    if (data != null) {
                        sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE<=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgEliminati = connectionDB.prepareStatement(queryString);
                pstmtMsgEliminati.setString(1, tipo);
                pstmtMsgEliminati.setString(2, idModuloCleaner);
                Timestamp nowT = null;
                if (data != null) {
                    nowT = new Timestamp(data.getTime());
                    pstmtMsgEliminati.setTimestamp(3, nowT);
                }
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + idModuloCleaner + "] 3[" + String.valueOf(nowT) + "] ...");
                }
                rs = pstmtMsgEliminati.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + idModuloCleaner + "] 3[" + String.valueOf(nowT) + "] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgEliminati.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiInutiliIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgEliminati != null) {
                        pstmtMsgEliminati.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public List<String> readMessaggiScadutiIntoInbox(long scadenzaMsg, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(true, scadenzaMsg, limit, logQuery, orderBy, data);
    }

    public List<String> readMessaggiScadutiIntoOutbox(long scadenzaMsg, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(false, scadenzaMsg, limit, logQuery, orderBy, data);
    }

    private List<String> readMessaggiScadutiIntoBox(boolean searchIntoInbox, long scadenzaMsg, int limit, boolean logQuery, boolean orderBy, Date data) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<String> idMsg = new ArrayList<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ").append("ID_MESSAGGIO").append(" FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ").append("ORA_REGISTRAZIONE").append(" AND ").append("TIPO").append("=?");
                    if (data != null) {
                        query.append(" AND ").append("ORA_REGISTRAZIONE").append("<=?");
                    }
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    if (data != null) {
                        sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE<=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, tipo);
                Timestamp nowT = null;
                if (data != null) {
                    nowT = new Timestamp(data.getTime());
                    pstmtMsgScaduti.setTimestamp(3, nowT);
                }
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[" + tipo + "] 3[" + String.valueOf(nowT) + "]...");
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[" + tipo + "] 3[" + String.valueOf(nowT) + "] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiScadutiIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsServiziApplicativiDestinatariMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtExistsAnotherServiziApplicativi = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT SERVIZIO_APPLICATIVO FROM ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append(" WHERE ID_MESSAGGIO=?");
                queryString = query.toString();
                pstmtExistsAnotherServiziApplicativi = connectionDB.prepareStatement(queryString);
                pstmtExistsAnotherServiziApplicativi.setString(1, this.idBusta);
                rs = pstmtExistsAnotherServiziApplicativi.executeQuery();
                boolean risultato = rs.next();
                rs.close();
                pstmtExistsAnotherServiziApplicativi.close();
                return risultato;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.existsServiziApplicativiDestinatariMessaggio] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtExistsAnotherServiziApplicativi != null) {
                        pstmtExistsAnotherServiziApplicativi.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public List<String> readMsgForRicezioneContenutiApplicativiNonGestiti(long timeout, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<String> idMsg = new ArrayList<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT MESSAGGI.ID_MESSAGGIO as identificativoBusta,MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ? > MESSAGGI.ORA_REGISTRAZIONE AND MESSAGGI.RIFERIMENTO_MSG IS NOT NULL AND MESSAGGI.TIPO=? AND MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=? AND MESSAGGI.PROPRIETARIO LIKE 'RicezioneContenutiApplicativi%' AND MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=? AND MESSAGGI.ID_MESSAGGIO=MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_MESSAGGIO", "identificativoBusta");
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO);
                    sqlQueryObject.addSelectField(MESSAGGI, "ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "TIPO", "TipoMessaggio");
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI_COLUMN_TIPO_CONSEGNA);
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI_COLUMN_INTEGRATION_MANAGER);
                    sqlQueryObject.addWhereCondition("? > MESSAGGI.ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("MESSAGGI.RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=?");
                    sqlQueryObject.addWhereLikeCondition("MESSAGGI.PROPRIETARIO", "RicezioneContenutiApplicativi", true, true);
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=?");
                    sqlQueryObject.addWhereCondition("MESSAGGI.ID_MESSAGGIO=MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "INBOX");
                pstmtMsgScaduti.setString(3, CONSEGNA_TRAMITE_CONNECTION_REPLY);
                pstmtMsgScaduti.setLong(4, 0L);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[INBOX] 3[ConnectionReply] 4[0]...");
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[INBOX] 3[ConnectionReply] 4[0] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("identificativoBusta") + "@" + rs.getString(MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneContenutiApplicativiNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public List<String> readMsgForRicezioneBusteNonGestiti(long timeout, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            ArrayList<String> idMsg = new ArrayList<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ORA_REGISTRAZIONE AND RIFERIMENTO_MSG IS NOT NULL AND TIPO=? AND PROPRIETARIO LIKE 'RicezioneBuste%'");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereLikeCondition(MESSAGGI_COLUMN_PROPRIETARIO, "RicezioneBuste", true, true);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "OUTBOX");
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.scadutiPerRicezioneBuste) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[OUTBOX]...");
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] Messaggi.scadutiPerRicezioneBuste) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] 2[OUTBOX] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneBusteNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public List<String> readBusteNonRiferiteDaMessaggiFromInBox(int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        return this.readBusteNonRiferiteDaMessaggi("INBOX", limit, logQuery, forceIndex, orderBy);
    }

    public List<String> readBusteNonRiferiteDaMessaggiFromOutBox(int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        return this.readBusteNonRiferiteDaMessaggi("OUTBOX", limit, logQuery, forceIndex, orderBy);
    }

    private List<String> readBusteNonRiferiteDaMessaggi(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        ArrayList<String> idBuste = new ArrayList<String>();
        int pdd = 0;
        int profilo = 0;
        int pddProfilo = 0;
        this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, true, false, idBuste);
        pdd = idBuste.size();
        if (idBuste.size() < limit) {
            this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, false, true, idBuste);
            profilo = idBuste.size() - pdd;
        }
        if (idBuste.size() < limit) {
            this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, true, true, idBuste);
            pddProfilo = idBuste.size() - pdd - profilo;
        }
        if (logQuery) {
            this.log.debug("[" + tipoBusta + "] Trovati messaggi cosi suddivisi pdd[" + pdd + "] profilo[" + profilo + "] pddAndProfilo[" + pddProfilo + "]");
        }
        return idBuste;
    }

    private void _engine_ReadBusteNonRiferiteDaMessaggi(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean orderBy, boolean pdd, boolean profilo, List<String> idBuste) throws ProtocolException, GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipoRovesciato = null;
                tipoRovesciato = "INBOX".equals(tipoBusta) ? "OUTBOX" : "INBOX";
                IGestoreRepository gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    if (pdd && profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    query.append(" AND ");
                    query.append("(");
                    query.append("  NOT EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryBuste.createSQLFields());
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    if (pdd && profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    ISQLQueryObject sqlQueryObjectAsincronoNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoNotExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoNotExists.addWhereCondition(true, new String[]{"ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAsincronoNotExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setString(2, tipoRovesciato);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.busteNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "]...");
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.busteNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    String id = rs.getString("ID_MESSAGGIO");
                    if (idBuste.contains(id)) continue;
                    idBuste.add(id);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                pstmt.close();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    if (pdd && profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    query.append(" AND ");
                    query.append("(");
                    query.append("  EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO AND ");
                    query.append("REPOSITORY_BUSTE.SCADENZA_BUSTA < ?");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryBuste.createSQLFields());
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    if (pdd && profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    ISQLQueryObject sqlQueryObjectAsincronoExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("REPOSITORY_BUSTE.SCADENZA_BUSTA < ?");
                    sqlQueryObjectAsincronoExists.setANDLogicOperator(true);
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAsincronoExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                Timestamp now = DateManager.getTimestamp();
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setTimestamp(2, now);
                pstmt.setString(3, tipoRovesciato);
                startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.busteNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + String.valueOf(now) + "] 3[" + tipoRovesciato + "]...");
                }
                rs = pstmt.executeQuery();
                endDateSQLCommand = DateManager.getTimeMillis();
                secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (Messaggi.busteNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + String.valueOf(now) + "] 3[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi");
                }
                countLimit = 0;
                while (rs.next()) {
                    String id = rs.getString("ID_MESSAGGIO");
                    if (idBuste.contains(id)) continue;
                    idBuste.add(id);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "[RepositoryBuste.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void logicDeleteMessage() throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine("GestoreMessaggi", false, true);
    }

    @Deprecated
    public void deleteMessageWithLock(String causa, long attesaAttivaLock, int checkIntervalLock) throws GestoreMessaggiException {
        this._deleteMessageWithLock(causa, attesaAttivaLock, checkIntervalLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _deleteMessageWithLock(String causa, long attesaAttivaLock, int checkIntervalLock) throws GestoreMessaggiException {
        Connection connectionDB = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            connectionDB = stateMSG.getConnectionDB();
        }
        Semaphore semaphoreDB = null;
        TimerLock timerLock = null;
        try {
            timerLock = new TimerLock(TipoLock._getLockGestioneRepositoryMessaggi());
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
        try {
            try {
                semaphoreDB = this.getSemaphoreByInstance(timerLock.getIdLock());
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
            try {
                GestoreMessaggi.acquireLock(semaphoreDB, connectionDB, timerLock, this.msgDiag, causa, attesaAttivaLock, checkIntervalLock);
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
            this.deleteMessage(null);
        }
        finally {
            try {
                GestoreMessaggi.releaseLock(semaphoreDB, connectionDB, timerLock, this.msgDiag, causa);
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public void deleteMessageWithoutLock() throws GestoreMessaggiException {
        this._deleteMessageWithoutLock();
    }

    public void _deleteMessageWithoutLock() throws GestoreMessaggiException {
        this.deleteMessage(null);
    }

    public void deleteMessageByOraRegistrazione(Date data) throws GestoreMessaggiException {
        this.deleteMessage(data);
    }

    public void deleteMessageByNow() throws GestoreMessaggiException {
        this.deleteMessage(DateManager.getDate());
    }

    private void deleteMessage(Date data) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtDeleteSIL = null;
            Statement pstmtDeleteMSG = null;
            try {
                Timestamp nowT = null;
                if (data != null) {
                    nowT = new Timestamp(data.getTime());
                }
                if ("INBOX".equals(this.tipo)) {
                    Object query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=?";
                    if (data != null) {
                        query = (String)query + " AND ORA_REGISTRAZIONE<=?";
                    }
                    pstmtDeleteSIL = connectionDB.prepareStatement((String)query);
                    pstmtDeleteSIL.setString(1, this.idBusta);
                    if (data != null) {
                        pstmtDeleteSIL.setTimestamp(2, nowT);
                    }
                    pstmtDeleteSIL.execute();
                    pstmtDeleteSIL.close();
                }
                SavedMessage msgDelete = new SavedMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgDelete.delete(this.isRichiesta, this.oneWayVersione11, nowT);
                Object query = "DELETE FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                if (data != null) {
                    query = (String)query + " AND ORA_REGISTRAZIONE<=?";
                }
                pstmtDeleteMSG = connectionDB.prepareStatement((String)query);
                pstmtDeleteMSG.setString(1, this.idBusta);
                pstmtDeleteMSG.setString(2, this.tipo);
                if (data != null) {
                    pstmtDeleteMSG.setTimestamp(3, nowT);
                }
                pstmtDeleteMSG.execute();
                pstmtDeleteMSG.close();
                GestoreMessaggi.deleteFromCache_Proprietario("GestoreMessaggi", this.tipo, this.idBusta);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmtDeleteMSG != null) {
                        pstmtDeleteMSG.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void deleteMessageFromFileSystem() {
        SavedMessage msgDelete = null;
        try {
            msgDelete = new SavedMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            msgDelete.deleteMessageFromFileSystem();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
        }
    }

    public void validateAndDeleteMsgOneWayRiscontrato() throws GestoreMessaggiException, ProtocolException {
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Riscontri gestoreRiscontri = null;
        try {
            gestoreRiscontri = new Riscontri((IState)stateMSG);
            gestoreRiscontri.validazioneRiscontroRicevuto(this.idBusta);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgOneWayRiscontrato", null, false);
    }

    public void validateAndDeleteMsgAsincronoRiscontrato(Busta bustaRicevuta) throws GestoreMessaggiException, ProtocolException {
        StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, this.protocolFactory);
            profiloCollaborazione.asincrono_valdazioneRicevuta(bustaRicevuta);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgAsincronoRiscontrato", null, false);
    }

    public boolean forcedDeleteMessage(RequestInfo requestInfo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            RollbackRepositoryBuste rollbackMessaggio = null;
            RollbackRepositoryBuste rollbackRepository = null;
            try {
                if (!this.existsMessage_noCache()) {
                    return false;
                }
                String rifMsg = this.getRiferimentoMessaggio();
                JMSReceiver receiverJMS = null;
                if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                    String idT = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext);
                    String protocol = null;
                    if (this.protocolFactory != null) {
                        protocol = this.protocolFactory.getProtocol();
                    }
                    receiverJMS = new JMSReceiver(this.propertiesReader.getIdentitaPortaDefault(protocol, requestInfo), "ForcedDeleteMessage", this.propertiesReader.singleConnectionNodeReceiver(), this.log, idT);
                }
                if ("INBOX".equals(this.tipo)) {
                    rollbackMessaggio = new RollbackRepositoryBuste(this.idBusta, (IState)stateful, this.oneWayVersione11);
                    rollbackMessaggio.rollbackBustaIntoInBox();
                    if (rifMsg == null) {
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + this.idBusta + "'")) {
                            this.log.info("Trovato messaggio nella coda RicezioneBuste con id [" + this.idBusta + "] non consumato");
                        }
                    } else {
                        rollbackRepository = new RollbackRepositoryBuste(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackRepository.rollbackBustaIntoOutBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info("Trovato messaggio (tramite riferimento) nella coda RicezioneContenutiApplicativi con id [" + rifMsg + "] non consumato");
                        }
                    }
                } else {
                    rollbackMessaggio = new RollbackRepositoryBuste(this.idBusta, (IState)stateful, this.oneWayVersione11);
                    rollbackMessaggio.rollbackBustaIntoOutBox();
                    if (rifMsg == null) {
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + this.idBusta + "'")) {
                            this.log.info("Trovato messaggio nella coda RicezioneContenutiApplicativi con id [" + this.idBusta + "] non consumato");
                        }
                    } else {
                        rollbackRepository = new RollbackRepositoryBuste(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackRepository.rollbackBustaIntoInBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info("Trovato messaggio (tramite riferimento) nella coda RicezioneBuste con id [" + rifMsg + "] non consumato");
                        }
                    }
                }
                this.aggiornaProprietarioMessaggio("GestoreMessaggi");
                this.openspcoopstate.commit();
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "forcedDeleteMessage", this.getRiferimentoMessaggio(), false);
                return true;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore forcedDeleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public OpenSPCoop2Message buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi(IDSoggetto soggettoMittente, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        try {
            String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Body>\n<pubblicazioneMessaggio xmlns=\"http://gestoreeventi.openspcoop.org\"><richiesta xmlns:types=\"http://types.gestoreeventi.openspcoop.org\"><types:idMessaggio>" + this.idBusta + "</types:idMessaggio><types:soggetto><types:nome>" + soggettoMittente.getNome() + "</types:nome><types:tipo>" + soggettoMittente.getTipo() + "</types:tipo></types:soggetto><types:servizio><types:nome>" + servizio + "</types:nome><types:tipo>" + tipoServizio + "</types:tipo></types:servizio><types:tipoEvento>" + azione + "</types:tipoEvento></richiesta></pubblicazioneMessaggio>\n</soapenv:Body>\n</soapenv:Envelope>";
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.SOAP_11, MessageRole.REQUEST, MessageUtilities.getDefaultContentType((MessageType)MessageType.SOAP_11), msg.getBytes());
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public OpenSPCoop2Message buildRispostaPrelevamentoMessaggio_RepositoryMessaggi(byte[] messaggio, MessageType messageType) throws GestoreMessaggiException {
        try {
            String namespace = MessageType.SOAP_11.equals((Object)messageType) ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            String msgUpper = "<soapenv:Envelope xmlns:soapenv=\"" + namespace + "\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Body>\n<prelevaMessaggioResponse xmlns=\"http://gestoreeventi.openspcoop.org\"><prelevaMessaggioReturn>";
            String msgDown = "</prelevaMessaggioReturn></prelevaMessaggioResponse>\n</soapenv:Body>\n</soapenv:Envelope>";
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(msgUpper.getBytes());
            bout.write(Base64Utilities.encode((byte[])messaggio));
            bout.write(msgDown.getBytes());
            bout.flush();
            bout.close();
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(messageType, MessageRole.RESPONSE, MessageUtilities.getDefaultContentType((MessageType)messageType), bout.toByteArray());
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRispostaPrelevamentoMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void setReadyForDrop(boolean readyForDrop) {
        this.readyForDrop = readyForDrop;
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public boolean isOneWayVersione11() {
        return this.oneWayVersione11;
    }

    public void setPortaDiTipoStateless(boolean portaDiTipoStateless) {
        this.portaDiTipoStateless = portaDiTipoStateless;
    }

    public void setRoutingStateless(boolean routingStateless) {
        this.routingStateless = routingStateless;
    }

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    private Semaphore getSemaphoreByInstance(String idLock) throws UtilsException {
        if (this.propertiesReader.isTimerLockByDatabase()) {
            try {
                InfoStatistics semaphore_statistics = new InfoStatistics();
                SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerGestoreMessaggiLockMaxLife(), this.propertiesReader.getTimerGestoreMessaggiLockIdleTime());
                TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
                Semaphore semaphoreDB = new Semaphore(semaphore_statistics, SemaphoreMapping.newInstance((String)idLock), config, databaseType, this.log);
                return semaphoreDB;
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private Connection getConnectionByInstance() {
        Connection connectionDB = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            connectionDB = stateMSG.getConnectionDB();
        }
        return connectionDB;
    }

    public static SemaphoreConfiguration newSemaphoreConfiguration(long maxLife, long idleTime) {
        OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
        Logger logTimers = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        SemaphoreConfiguration config = new SemaphoreConfiguration();
        config.setSerializableTimeWaitMs(propertiesReader.getGestioneSerializableDBAttesaAttiva());
        config.setSerializableNextIntervalTimeMs(propertiesReader.getGestioneSerializableDBCheckInterval());
        config.setMaxLife(maxLife);
        config.setMaxIdleTime(idleTime);
        boolean logEvent = propertiesReader.isTimerLockByDatabaseNotifyLogEnabled();
        config.setEmitEvent(logEvent);
        if (logEvent) {
            config.setEventGenerator((ISemaphoreEventGenerator)new SemaphoreLogEventGenerator(logTimers));
        }
        config.setIdNode(propertiesReader.getClusterId(true));
        config.setSerializableLevel(false);
        return config;
    }

    public static void acquireLock(GestoreMessaggi gestoreMessaggi, TimerLock timerLock, MsgDiagnostico msgDiag, String causa, long attesaAttivaLock, int checkIntervalLock) throws UtilsException, TimerLockNotAvailableException {
        GestoreMessaggi.acquireLock(gestoreMessaggi.getSemaphoreByInstance(timerLock.getIdLock()), gestoreMessaggi.getConnectionByInstance(), timerLock, msgDiag, causa, attesaAttivaLock, checkIntervalLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquireLock(Semaphore semaphoreDB, Connection connectionDB, TimerLock timerLock, MsgDiagnostico msgDiag, String causa, long attesaAttivaLock, int checkIntervalLock) throws UtilsException, TimerLockNotAvailableException {
        msgDiag.addKeyword("@CAUSA_LOCK@", causa);
        msgDiag.logPersonalizzato("all.", "acquisizioneLock.inCorso");
        if (semaphoreDB != null) {
            if (connectionDB == null) {
                throw new UtilsException("Gestione Lock su db richiede una connessione");
            }
            try {
                if (connectionDB.isClosed()) {
                    throw new UtilsException("Gestione Lock su db richiede una connessione attiva");
                }
            }
            catch (Exception e) {
                throw new UtilsException("Gestione Lock su db richiede una connessione attiva: " + e.getMessage(), (Throwable)e);
            }
            Utilities.sleep((long)checkIntervalLock);
            boolean lock = semaphoreDB.newLock(connectionDB, causa);
            int i = 0;
            while ((long)i < attesaAttivaLock && !lock) {
                Utilities.sleep((long)checkIntervalLock);
                i += checkIntervalLock;
                lock = semaphoreDB.newLock(connectionDB, causa);
            }
            if (!lock) {
                String error = "Timeout: lock non disponibile dopo una attesa di " + attesaAttivaLock + "ms";
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", error);
                msgDiag.logPersonalizzato("all.", "acquisizioneLock.nonDisponibile");
                throw new TimerLockNotAvailableException(error);
            }
        } else if (TipoLock._getLockGestioneRepositoryMessaggi().equals(timerLock.getTipoLock())) {
            StringBuilder lock = LOCK;
            synchronized (lock) {
                if (LOCK.length() > 0) {
                    msgDiag.addKeyword("@CAUSA_LOCK@", LOCK.toString());
                    msgDiag.addKeyword("@ID_MODULO_PROPRIETARIO_LOCK@", LOCK_MODULO);
                    msgDiag.logPersonalizzato("all.", "acquisizioneLock.wait.existsOldOwner");
                } else {
                    msgDiag.logPersonalizzato("all.", "acquisizioneLock.wait.withoutOwner");
                }
            }
            boolean lockAcquired = false;
            try {
                lockAcquired = LOCK_SEMAPHORE.tryAcquire(attesaAttivaLock, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new UtilsException("Timeout: lock non disponibile dopo una attesa di " + attesaAttivaLock + "ms (attuale modulo proprietario: " + LOCK_MODULO + ", causa: " + LOCK.toString() + "): " + ie.getMessage(), (Throwable)ie);
            }
            if (!lockAcquired) {
                throw new UtilsException("Timeout: lock non disponibile dopo una attesa di " + attesaAttivaLock + "ms (attuale modulo proprietario: " + LOCK_MODULO + ", causa: " + LOCK.toString() + ")");
            }
            LOCK.append(causa);
            LOCK_MODULO = msgDiag.getFunzione();
        }
        msgDiag.logPersonalizzato("all.", "acquisizioneLock.ok");
    }

    public static void updateLock(GestoreMessaggi gestoreMessaggi, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        GestoreMessaggi.updateLock(gestoreMessaggi.getSemaphoreByInstance(timerLock.getIdLock()), gestoreMessaggi.getConnectionByInstance(), timerLock, msgDiag, causa);
    }

    public static void updateLock(Semaphore semaphoreDB, Connection connectionDB, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        msgDiag.addKeyword("@CAUSA_LOCK@", causa);
        msgDiag.logPersonalizzato("all.", "updateLock.inCorso");
        if (semaphoreDB != null) {
            if (connectionDB == null) {
                throw new UtilsException("Gestione Lock su db richiede una connessione");
            }
            try {
                if (connectionDB.isClosed()) {
                    throw new UtilsException("Gestione Lock su db richiede una connessione attiva");
                }
            }
            catch (Exception e) {
                throw new UtilsException("Gestione Lock su db richiede una connessione attiva: " + e.getMessage(), (Throwable)e);
            }
            boolean unlock = semaphoreDB.updateLock(connectionDB, causa);
            if (!unlock) {
                msgDiag.logPersonalizzato("all.", "updateLock.ko");
                throw new UtilsException(msgDiag.getMessaggio_replaceKeywords("all", "updateLock.ko"));
            }
        }
        msgDiag.logPersonalizzato("all.", "updateLock.ok");
    }

    public static void releaseSafeLock(GestoreMessaggi gestoreMessaggi, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        GestoreMessaggi.releaseSafeLock(gestoreMessaggi.getSemaphoreByInstance(timerLock.getIdLock()), gestoreMessaggi.getConnectionByInstance(), timerLock, msgDiag, causa);
    }

    public static void releaseSafeLock(Semaphore semaphoreDB, Connection connectionDB, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        try {
            GestoreMessaggi.releaseLock(semaphoreDB, connectionDB, timerLock, msgDiag, causa);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void releaseLock(GestoreMessaggi gestoreMessaggi, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        GestoreMessaggi.releaseLock(gestoreMessaggi.getSemaphoreByInstance(timerLock.getIdLock()), gestoreMessaggi.getConnectionByInstance(), timerLock, msgDiag, causa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseLock(Semaphore semaphoreDB, Connection connectionDB, TimerLock timerLock, MsgDiagnostico msgDiag, String causa) throws UtilsException {
        msgDiag.addKeyword("@CAUSA_LOCK@", causa);
        msgDiag.logPersonalizzato("all.", "acquisizioneUnlock.inCorso");
        if (semaphoreDB != null) {
            if (connectionDB == null) {
                throw new UtilsException("Gestione Lock su db richiede una connessione");
            }
            try {
                if (connectionDB.isClosed()) {
                    throw new UtilsException("Gestione Lock su db richiede una connessione attiva");
                }
            }
            catch (Exception e) {
                throw new UtilsException("Gestione Lock su db richiede una connessione attiva: " + e.getMessage(), (Throwable)e);
            }
            boolean unlock = semaphoreDB.releaseLock(connectionDB, causa);
            if (!unlock) {
                msgDiag.logPersonalizzato("all.", "acquisizioneUnlock.ko");
                throw new UtilsException(msgDiag.getMessaggio_replaceKeywords("all", "acquisizioneUnlock.ko"));
            }
        } else if (TipoLock._getLockGestioneRepositoryMessaggi().equals(timerLock.getTipoLock())) {
            if (LOCK.length() <= 0) {
                msgDiag.logPersonalizzato("all.", "acquisizioneUnlock.ko");
                throw new UtilsException(msgDiag.getMessaggio_replaceKeywords("all", "acquisizioneUnlock.ko"));
            }
            StringBuilder stringBuilder = LOCK;
            synchronized (stringBuilder) {
                LOCK.delete(0, LOCK.length());
                LOCK_MODULO = null;
            }
            LOCK_SEMAPHORE.release();
        }
        msgDiag.logPersonalizzato("all.", "acquisizioneUnlock.ok");
    }
}

