/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.File;
import java.util.Date;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class FileSystemSerializer {
    private static FileSystemSerializer staticInstance = null;
    private File directory = OpenSPCoop2Properties.getInstance().getFileSystemRecoveryRepository();
    private static final String FORMAT_NEW = "yyyyMMdd_HHmmssSSS";
    private static final String FORMAT_OLD = "yyyy-MM-dd_HH:mm:ss.SSS";

    private static synchronized void initialize() throws CoreException {
        if (staticInstance == null) {
            staticInstance = new FileSystemSerializer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystemSerializer getInstance() throws CoreException {
        if (staticInstance != null) return staticInstance;
        Class<FileSystemSerializer> clazz = FileSystemSerializer.class;
        synchronized (FileSystemSerializer.class) {
            FileSystemSerializer.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private FileSystemSerializer() throws CoreException {
        String prefix = "Directory [" + this.directory.getAbsolutePath() + "] ";
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new CoreException(prefix + "non esistente e creazione non riuscita");
        }
        if (!this.directory.canRead()) {
            throw new CoreException(prefix + "non accessibile in lettura");
        }
        if (!this.directory.canWrite()) {
            throw new CoreException(prefix + "non accessibile in scrittura");
        }
    }

    public void registraEvento(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "Evento", date, this.getDirEventi());
    }

    public File getDirEventi() {
        return new File(this.directory, "eventi");
    }

    public void registraTransazione(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "Transazione", date, this.getDirTransazioni());
    }

    public File getDirTransazioni() {
        return new File(this.directory, "transazioni");
    }

    public void registraDiagnostico(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "Diagnostico", date, this.getDirDiagnostici());
    }

    public File getDirDiagnostici() {
        return new File(this.directory, "diagnostici");
    }

    public void registraTraccia(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "Traccia", date, this.getDirTracce());
    }

    public File getDirTracce() {
        return new File(this.directory, "tracce");
    }

    public void registraDump(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "Messaggio", date, this.getDirDump());
    }

    public File getDirDump() {
        return new File(this.directory, "messaggi");
    }

    public void registraTransazioneApplicativoServer(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "TransazioneAppServer", date, this.getDirTransazioneApplicativoServer());
    }

    public File getDirTransazioneApplicativoServer() {
        return new File(this.directory, "transazioni_sa");
    }

    public void registraTransazioneApplicativoServerConsegnaTerminata(byte[] oggettSerializzato, Date date) throws CoreException, UtilsException {
        this.registra(oggettSerializzato, "TransazioneUpdateInfoConsegna", date, this.getDirTransazioneApplicativoServerConsegnaTerminata());
    }

    public File getDirTransazioneApplicativoServerConsegnaTerminata() {
        return new File(this.directory, "transazioni_sa_update_info");
    }

    private void registra(byte[] oggettSerializzato, String prefix, Date date, File dir) throws CoreException, UtilsException {
        if (!dir.exists()) {
            this.mkdir(dir);
        }
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)FORMAT_NEW);
        String uniqueId = null;
        try {
            uniqueId = UniqueIdentifierManager.newUniqueIdentifier().getAsString().replace("-", "_");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        String nomeFile = prefix + "_" + dateformat.format(date) + "__" + uniqueId + ".xml";
        File f = new File(dir, nomeFile);
        FileSystemUtilities.writeFile((File)f, (byte[])oggettSerializzato);
    }

    private void mkdir(File dir) throws CoreException {
        if (!dir.exists()) {
            this.mkdirEngine(dir);
        }
    }

    private synchronized void mkdirEngine(File dir) throws CoreException {
        if (!dir.exists() && !dir.mkdir()) {
            throw new CoreException("Directory [" + this.directory.getAbsolutePath() + "] non esistente e creazione non riuscita");
        }
    }
}

