/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.manifest.Context;
import org.openspcoop2.protocol.manifest.WebEmptyContext;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class UrlInvocazioneAPI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String baseUrl;
    private String context;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getUrl() {
        if (this.baseUrl == null) {
            return null;
        }
        return Utilities.buildUrl((String)this.baseUrl, (String)this.context);
    }

    public static UrlInvocazioneAPI getConfigurazioneUrlInvocazione(ConfigurazioneUrlInvocazione configurazioneUrlInvocazione, IProtocolFactory<?> protocolFactory, RuoloContesto ruolo, ServiceBinding serviceBinding, String interfaceName, IDSoggetto soggettoOperativo, List<String> tags, String canale) throws DriverConfigurazioneException {
        return UrlInvocazioneAPI.getConfigurazioneUrlInvocazione(configurazioneUrlInvocazione, protocolFactory, ruolo, serviceBinding, interfaceName, soggettoOperativo, tags, canale, true);
    }

    public static UrlInvocazioneAPI getConfigurazioneUrlInvocazione(ConfigurazioneUrlInvocazione configurazioneUrlInvocazione, IProtocolFactory<?> protocolFactory, RuoloContesto ruolo, ServiceBinding serviceBinding, String interfaceName, IDSoggetto soggettoOperativo, List<String> tags, String canale, boolean analizeProxyPassRules) throws DriverConfigurazioneException {
        String interfaceNameNormalizzata;
        if (configurazioneUrlInvocazione == null) {
            configurazioneUrlInvocazione = new ConfigurazioneUrlInvocazione();
            UrlInvocazioneAPI.initConfigurazioneProtocolloUrlInvocazione(configurazioneUrlInvocazione);
        }
        if ((interfaceNameNormalizzata = interfaceName) != null) {
            try {
                PorteNamingUtils utils = new PorteNamingUtils(protocolFactory);
                interfaceNameNormalizzata = RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo) ? utils.normalizePD(interfaceName) : utils.normalizePA(interfaceName);
            }
            catch (Exception e) {
                protocolFactory.getLogger().debug("Normalizzazione interface name '" + interfaceName + "' non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        ConfigurazioneUrlInvocazioneRegola regolaDefault = UrlInvocazioneAPI.getConfigurazioneUrlInvocazioneDefault(configurazioneUrlInvocazione, protocolFactory, ruolo, serviceBinding, interfaceNameNormalizzata);
        ConfigurazioneUrlInvocazioneRegola regola = null;
        if (analizeProxyPassRules) {
            HashMap<String, ConfigurazioneUrlInvocazioneRegola> regole = new HashMap<String, ConfigurazioneUrlInvocazioneRegola>();
            for (ConfigurazioneUrlInvocazioneRegola check : configurazioneUrlInvocazione.getRegolaList()) {
                String paddedNumber = String.format("%010d", check.getPosizione());
                regole.put(paddedNumber, check);
            }
            if (regole.size() > 0) {
                ArrayList posizioni = new ArrayList();
                posizioni.addAll(regole.keySet());
                Collections.sort(posizioni);
                for (String posizione : posizioni) {
                    ConfigurazioneUrlInvocazioneRegola check = (ConfigurazioneUrlInvocazioneRegola)regole.get(posizione);
                    try {
                        String contesto = UrlInvocazioneAPI.getContext(protocolFactory, ruolo, serviceBinding, interfaceNameNormalizzata);
                        if (!UrlInvocazioneAPI.isMatchRegolaUrlInvocazione(check, protocolFactory, ruolo, serviceBinding, contesto, soggettoOperativo)) continue;
                        regola = UrlInvocazioneAPI.processMatchRegolaUrlInvocazione(check, contesto, tags, canale);
                        break;
                    }
                    catch (Exception e) {
                        protocolFactory.getLogger().error("Errore durante il processamento della regola-" + posizione + " '" + check.getNome() + "': " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (regola == null) {
            regola = regolaDefault;
        }
        UrlInvocazioneAPI url = new UrlInvocazioneAPI();
        if (regola.getBaseUrl() != null) {
            url.setBaseUrl(regola.getBaseUrl());
        } else if (RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo) && configurazioneUrlInvocazione.getBaseUrlFruizione() != null) {
            url.setBaseUrl(configurazioneUrlInvocazione.getBaseUrlFruizione());
        } else {
            url.setBaseUrl(configurazioneUrlInvocazione.getBaseUrl());
        }
        url.setContext(regola.getContestoEsterno());
        return url;
    }

    private static void initConfigurazioneProtocolloUrlInvocazione(ConfigurazioneUrlInvocazione configurazioneUrlInvocazione) throws DriverConfigurazioneException {
        try {
            if (configurazioneUrlInvocazione.getBaseUrl() == null) {
                configurazioneUrlInvocazione.setBaseUrl("http://localhost:8080/govway/");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    private static ConfigurazioneUrlInvocazioneRegola getConfigurazioneUrlInvocazioneDefault(ConfigurazioneUrlInvocazione configurazioneUrlInvocazione, IProtocolFactory<?> protocolFactory, RuoloContesto ruolo, ServiceBinding serviceBinding, String interfaceNameNormalizzata) throws DriverConfigurazioneException {
        try {
            if (configurazioneUrlInvocazione != null) {
                // empty if block
            }
            ConfigurazioneUrlInvocazioneRegola regola = new ConfigurazioneUrlInvocazioneRegola();
            regola.setNome("-default-");
            regola.setPosizione(-1);
            regola.setStato(StatoFunzionalita.ABILITATO);
            regola.setDescrizione("Default rule");
            regola.setRegexpr(false);
            regola.setRegola("");
            regola.setContestoEsterno(UrlInvocazioneAPI.getContext(protocolFactory, ruolo, serviceBinding, interfaceNameNormalizzata));
            regola.setBaseUrl(null);
            regola.setProtocollo(protocolFactory.getProtocol());
            regola.setRuolo(ruolo);
            if (serviceBinding != null) {
                regola.setServiceBinding(ServiceBinding.REST.equals((Object)serviceBinding) ? org.openspcoop2.core.config.constants.ServiceBinding.REST : org.openspcoop2.core.config.constants.ServiceBinding.SOAP);
            }
            return regola;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isMatchRegolaUrlInvocazione(ConfigurazioneUrlInvocazioneRegola check, IProtocolFactory<?> protocolFactory, RuoloContesto ruolo, ServiceBinding serviceBinding, String contesto, IDSoggetto soggettoOperativoInterfaccia) throws DriverConfigurazioneException {
        if (StatoFunzionalita.DISABILITATO.equals((Object)check.getStato())) {
            return false;
        }
        if (check.getProtocollo() != null) {
            if (protocolFactory == null) {
                return false;
            }
            if (!check.getProtocollo().equals(protocolFactory.getProtocol())) {
                return false;
            }
        }
        if (check.getRuolo() != null) {
            if (ruolo == null) {
                return false;
            }
            if (!check.getRuolo().equals((Object)ruolo)) {
                return false;
            }
        }
        if (check.getServiceBinding() != null) {
            if (serviceBinding == null) {
                return false;
            }
            if (!check.getServiceBinding().name().equals(serviceBinding.name())) {
                return false;
            }
        }
        if (check.getSoggetto() != null && check.getSoggetto().getTipo() != null && check.getSoggetto().getNome() != null) {
            if (soggettoOperativoInterfaccia == null) {
                return false;
            }
            try {
                if (!check.getSoggetto().toIDSoggetto().equals((Object)soggettoOperativoInterfaccia)) {
                    return false;
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (contesto == null) {
            return false;
        }
        if (check.isRegexpr()) {
            try {
                boolean isMatch = RegularExpressionEngine.isMatch((String)contesto, (String)check.getRegola());
                if (isMatch) {
                    return true;
                }
                return contesto.startsWith("/") && contesto.length() > 1 && (isMatch = RegularExpressionEngine.isMatch((String)contesto.substring(1), (String)check.getRegola()));
            }
            catch (RegExpNotFoundException notFound) {
                return false;
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        Object contestDaVerificare = contesto;
        if (contesto.startsWith("/")) {
            if (!check.getRegola().startsWith("/")) {
                contestDaVerificare = contesto.length() == 1 ? "" : ((String)contestDaVerificare).substring(1);
            }
        } else if (check.getRegola().startsWith("/")) {
            contestDaVerificare = "/" + (String)contestDaVerificare;
        }
        return ((String)contestDaVerificare).startsWith(check.getRegola());
    }

    private static ConfigurazioneUrlInvocazioneRegola processMatchRegolaUrlInvocazione(ConfigurazioneUrlInvocazioneRegola regolaParam, String contestoParam, List<String> tags, String canale) throws DriverConfigurazioneException {
        String newContesto;
        ConfigurazioneUrlInvocazioneRegola regola = (ConfigurazioneUrlInvocazioneRegola)regolaParam.clone();
        if (regola.isRegexpr()) {
            try {
                List list;
                block27: {
                    String contestoDaUsarePerVerifica = contestoParam;
                    boolean isMatch = RegularExpressionEngine.isMatch((String)contestoDaUsarePerVerifica, (String)regola.getRegola());
                    if (!isMatch && contestoDaUsarePerVerifica.startsWith("/") && contestoDaUsarePerVerifica.length() > 1) {
                        contestoDaUsarePerVerifica = contestoDaUsarePerVerifica.substring(1);
                    }
                    list = null;
                    try {
                        list = RegularExpressionEngine.getAllStringMatchPattern((String)contestoDaUsarePerVerifica, (String)regola.getRegola());
                    }
                    catch (RegExpNotFoundException notFound) {
                        if (RegularExpressionEngine.isMatch((String)contestoDaUsarePerVerifica, (String)regola.getRegola())) break block27;
                        throw notFound;
                    }
                }
                String newContesto2 = regola.getContestoEsterno();
                if (newContesto2 == null) {
                    newContesto2 = "";
                }
                String baseUrl = regola.getBaseUrl();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String found = (String)list.get(i);
                        if (found == null) {
                            found = "";
                        }
                        String key = "${" + i + "}";
                        while (newContesto2.contains(key)) {
                            newContesto2 = newContesto2.replace(key, found);
                        }
                        if (baseUrl == null) continue;
                        while (baseUrl.contains(key)) {
                            baseUrl = baseUrl.replace(key, found);
                        }
                    }
                }
                regola.setContestoEsterno(newContesto2);
                regola.setBaseUrl(baseUrl);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (tags != null && !tags.isEmpty()) {
            newContesto = regola.getContestoEsterno();
            if (newContesto == null) {
                newContesto = "";
            }
            String baseUrl = regola.getBaseUrl();
            for (int i = 0; i < tags.size(); ++i) {
                Object key;
                String found = tags.get(i);
                if (found == null) {
                    found = "";
                }
                if (i == 0) {
                    key = "${tag}";
                    while (newContesto.contains((CharSequence)key)) {
                        newContesto = newContesto.replace((CharSequence)key, found);
                    }
                    if (baseUrl != null) {
                        while (baseUrl.contains((CharSequence)key)) {
                            baseUrl = baseUrl.replace((CharSequence)key, found);
                        }
                    }
                }
                key = "${tag[" + i + "]}";
                while (newContesto.contains((CharSequence)key)) {
                    newContesto = newContesto.replace((CharSequence)key, found);
                }
                if (baseUrl == null) continue;
                while (baseUrl.contains((CharSequence)key)) {
                    baseUrl = baseUrl.replace((CharSequence)key, found);
                }
            }
            regola.setContestoEsterno(newContesto);
            regola.setBaseUrl(baseUrl);
        }
        if (canale != null) {
            newContesto = regola.getContestoEsterno();
            if (newContesto == null) {
                newContesto = "";
            }
            String baseUrl = regola.getBaseUrl();
            String key = "${canale}";
            while (newContesto.contains(key)) {
                newContesto = newContesto.replace(key, canale);
            }
            if (baseUrl != null) {
                while (baseUrl.contains(key)) {
                    baseUrl = baseUrl.replace(key, canale);
                }
            }
            regola.setContestoEsterno(newContesto);
            regola.setBaseUrl(baseUrl);
        }
        return regola;
    }

    private static String getContext(IProtocolFactory<?> protocolFactory, RuoloContesto ruolo, ServiceBinding serviceBinding, String interfaceNameNormalizzata) throws DriverConfigurazioneException {
        try {
            boolean trasparente = false;
            if (protocolFactory != null) {
                trasparente = "trasparente".equals(protocolFactory.getProtocol());
            }
            boolean forceContextWithoutBinding = false;
            if (trasparente) {
                forceContextWithoutBinding = true;
            }
            String contextWithoutBinding = null;
            String contextWithRestBinding = null;
            String contextWithSoapBinding = null;
            if (protocolFactory != null && protocolFactory.getManifest().getWeb().getEmptyContext() != null) {
                WebEmptyContext ctx = protocolFactory.getManifest().getWeb().getEmptyContext();
                if (ctx.getBinding() == null) {
                    if (contextWithoutBinding == null) {
                        contextWithoutBinding = "";
                    }
                } else if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)ctx.getBinding())) {
                    if (contextWithRestBinding == null) {
                        contextWithRestBinding = "";
                    }
                } else if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)ctx.getBinding()) && contextWithSoapBinding == null) {
                    contextWithSoapBinding = "";
                }
            }
            if (protocolFactory != null && protocolFactory.getManifest().getWeb().sizeContextList() > 0) {
                for (Context ctx : protocolFactory.getManifest().getWeb().getContextList()) {
                    if (ctx.getBinding() == null) {
                        if (contextWithoutBinding != null) continue;
                        contextWithoutBinding = ctx.getName();
                        continue;
                    }
                    if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)ctx.getBinding())) {
                        if (contextWithRestBinding != null) continue;
                        contextWithRestBinding = ctx.getName();
                        continue;
                    }
                    if (!org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)ctx.getBinding()) || contextWithSoapBinding != null) continue;
                    contextWithSoapBinding = ctx.getName();
                }
            }
            if (contextWithRestBinding == null || forceContextWithoutBinding && contextWithoutBinding != null) {
                contextWithRestBinding = contextWithoutBinding;
            }
            if (contextWithSoapBinding == null || forceContextWithoutBinding && contextWithoutBinding != null) {
                contextWithSoapBinding = contextWithoutBinding;
            }
            if (contextWithoutBinding == null) {
                throw new DriverConfigurazioneException("Contesto senza uno specifico binding non indicato");
            }
            Object contestoEsterno = null;
            if (serviceBinding != null) {
                switch (serviceBinding) {
                    case REST: {
                        contestoEsterno = RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo) ? CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePd((String)contextWithRestBinding) : CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePa((String)contextWithRestBinding);
                        break;
                    }
                    case SOAP: {
                        contestoEsterno = RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo) ? CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePd((String)contextWithSoapBinding) : CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePa((String)contextWithSoapBinding);
                    }
                }
            } else {
                Object object = contestoEsterno = RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo) ? CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePd((String)contextWithoutBinding) : CostantiConfigurazione.getDefaultValueParametroConfigurazioneProtocolloPrefixUrlInvocazionePa((String)contextWithoutBinding);
            }
            if (contestoEsterno != null) {
                if ("trasparente".equalsIgnoreCase(protocolFactory.getProtocol())) {
                    if (RuoloContesto.PORTA_APPLICATIVA.equals((Object)ruolo)) {
                        if (((String)contestoEsterno).endsWith("in/")) {
                            contestoEsterno = ((String)contestoEsterno).substring(0, ((String)contestoEsterno).length() - "in/".length());
                        } else if (((String)contestoEsterno).endsWith("in")) {
                            contestoEsterno = ((String)contestoEsterno).substring(0, ((String)contestoEsterno).length() - "in".length());
                        }
                    }
                } else if ("sdi".equalsIgnoreCase(protocolFactory.getProtocol()) && RuoloContesto.PORTA_DELEGATA.equals((Object)ruolo)) {
                    if (((String)contestoEsterno).endsWith("out/")) {
                        contestoEsterno = (String)contestoEsterno + "xml2soap/";
                    } else if (((String)contestoEsterno).endsWith("out")) {
                        contestoEsterno = (String)contestoEsterno + "/xml2soap/";
                    }
                }
            }
            boolean useInterfaceName = false;
            useInterfaceName = RuoloContesto.PORTA_APPLICATIVA.equals((Object)ruolo) ? protocolFactory.createProtocolIntegrationConfiguration().useInterfaceNameInImplementationInvocationURL(serviceBinding) : protocolFactory.createProtocolIntegrationConfiguration().useInterfaceNameInSubscriptionInvocationURL(serviceBinding);
            if (useInterfaceName && interfaceNameNormalizzata != null && !"".equals(interfaceNameNormalizzata)) {
                contestoEsterno = contestoEsterno != null ? (String)contestoEsterno + "/" + interfaceNameNormalizzata : interfaceNameNormalizzata;
            }
            if (contestoEsterno != null) {
                while (((String)contestoEsterno).contains("//")) {
                    contestoEsterno = ((String)contestoEsterno).replace("//", "/");
                }
            }
            if (contestoEsterno != null && !((String)contestoEsterno).startsWith("/")) {
                contestoEsterno = "/" + (String)contestoEsterno;
            }
            return contestoEsterno;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }
}

