/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.GestoreAutenticazione;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProvider;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.PDNDTokenInfoDetails;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.json.JSONUtils;

public class PDNDResolver {
    private Context context;
    private List<RemoteStoreConfig> remoteStores;
    public static final String REMOTE_STORE_KEY_KID_STARTS_WITH_CLIENT_ID = "ClientId--";

    public PDNDResolver(Context context, List<RemoteStoreConfig> remoteStores) {
        this.context = context;
        this.remoteStores = remoteStores;
    }

    public boolean isRemoteStore(String name) {
        return PDNDResolver.isRemoteStore(name, this.remoteStores);
    }

    public static boolean isRemoteStore(String name, List<RemoteStoreConfig> remoteStores) {
        for (RemoteStoreConfig rsc : remoteStores) {
            if (!name.equals(rsc.getStoreName())) continue;
            return true;
        }
        return false;
    }

    public RemoteStoreConfig getRemoteStoreConfig(String name, IDSoggetto idDominio) throws ProtocolException {
        return PDNDResolver.getRemoteStoreConfig(name, idDominio, this.remoteStores);
    }

    public static RemoteStoreConfig getRemoteStoreConfig(String name, IDSoggetto idDominio, List<RemoteStoreConfig> remoteStores) throws ProtocolException {
        for (RemoteStoreConfig rsc : remoteStores) {
            if (!name.equals(rsc.getStoreName())) continue;
            if (rsc.isMultitenant() && idDominio != null && idDominio.getNome() != null) {
                try {
                    return rsc.newInstanceMultitenant(idDominio.getNome());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            return rsc;
        }
        return null;
    }

    public RemoteStoreConfig getRemoteStoreConfigByTokenPolicy(String name, IDSoggetto idDominio) throws ProtocolException {
        return PDNDResolver.getRemoteStoreConfigByTokenPolicy(name, idDominio, this.remoteStores);
    }

    public static RemoteStoreConfig getRemoteStoreConfigByTokenPolicy(String name, IDSoggetto idDominio, List<RemoteStoreConfig> remoteStores) throws ProtocolException {
        for (RemoteStoreConfig rsc : remoteStores) {
            if (!name.equals(rsc.getTokenPolicy())) continue;
            if (rsc.isMultitenant() && idDominio != null && idDominio.getNome() != null) {
                try {
                    return rsc.newInstanceMultitenant(idDominio.getNome());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            return rsc;
        }
        return null;
    }

    public RemoteStoreConfig enrichTokenInfo(RequestInfo requestInfo, IDSoggetto idSoggetto, InformazioniToken informazioniToken, SecurityToken securityTokenForContext) throws ProtocolException {
        return this.enrichTokenInfo(requestInfo, false, false, idSoggetto, informazioniToken, securityTokenForContext);
    }

    public RemoteStoreConfig enrichTokenInfo(RequestInfo requestInfo, boolean sicurezzaMessaggio, boolean sicurezzaAudit, IDSoggetto idSoggetto) throws ProtocolException {
        Object oInformazioniTokenNormalizzate = null;
        if (this.context != null) {
            oInformazioniTokenNormalizzate = this.context.getObject(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
        }
        InformazioniToken informazioniTokenNormalizzate = null;
        if (oInformazioniTokenNormalizzate instanceof InformazioniToken) {
            informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
        }
        SecurityToken securityTokenForContext = SecurityTokenUtilities.readSecurityToken((Context)this.context);
        return this.enrichTokenInfo(requestInfo, sicurezzaMessaggio, sicurezzaAudit, idSoggetto, informazioniTokenNormalizzate, securityTokenForContext);
    }

    private RemoteStoreConfig enrichTokenInfo(RequestInfo requestInfo, boolean sicurezzaMessaggio, boolean sicurezzaAudit, IDSoggetto idSoggetto, InformazioniToken informazioniToken, SecurityToken securityTokenForContext) throws ProtocolException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        RemoteStoreConfig rsc = null;
        try {
            if (op2Properties.isGestoreChiaviPDNDclientInfoEnabled()) {
                rsc = this.getRemoteStoreConfig(idSoggetto);
                if (rsc == null) {
                    return rsc;
                }
                String clientId = null;
                if (informazioniToken != null) {
                    clientId = informazioniToken.getClientId();
                }
                if (clientId == null) {
                    return rsc;
                }
                String kid = this.readKid(sicurezzaMessaggio, sicurezzaAudit, securityTokenForContext, clientId);
                this.enrichTokenInfo(requestInfo, idSoggetto, informazioniToken, securityTokenForContext, rsc, clientId, kid);
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        return rsc;
    }

    private void enrichTokenInfo(RequestInfo requestInfo, IDSoggetto idSoggetto, InformazioniToken informazioniToken, SecurityToken securityTokenForContext, RemoteStoreConfig rsc, String clientId, String kid) throws KeystoreException, SecurityException, UtilsException, TransactionNotExistsException, CoreException, TransactionDeletedException {
        String s;
        Object oInfoPDND = null;
        if (this.context != null) {
            oInfoPDND = this.context.getObject(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_PDND_CLIENT_READ);
        }
        if (oInfoPDND instanceof String && "true".equals(s = (String)oInfoPDND)) {
            return;
        }
        this.enrichTokenInfo(securityTokenForContext, informazioniToken, requestInfo, rsc, kid, clientId);
        if (kid.startsWith(REMOTE_STORE_KEY_KID_STARTS_WITH_CLIENT_ID)) {
            this.context.put(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_PDND_CLIENT_READ, (Object)"true");
        }
        this.updateCredenzialiTokenPDND(requestInfo, idSoggetto, informazioniToken);
    }

    private void updateCredenzialiTokenPDND(RequestInfo requestInfo, IDSoggetto idSoggetto, InformazioniToken informazioniToken) throws TransactionNotExistsException, CoreException, TransactionDeletedException {
        Transaction transaction;
        CredenzialiMittente credenzialiMittente;
        String idTransazione = null;
        if (this.context != null) {
            idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        if ((credenzialiMittente = (transaction = TransactionContext.getTransaction(idTransazione)).getCredenzialiMittente()) == null) {
            credenzialiMittente = new CredenzialiMittente();
            transaction.setCredenzialiMittente(credenzialiMittente);
        }
        try {
            GestoreAutenticazione.updateCredenzialiTokenPDND(idSoggetto, "ModIValidator", idTransazione, informazioniToken, credenzialiMittente, null, "ModIValidator.credenzialiPDND", requestInfo, this.context);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private RemoteStoreConfig getRemoteStoreConfig(IDSoggetto idSoggetto) throws ProtocolException {
        Object oTokenPolicy = null;
        if (this.context != null) {
            oTokenPolicy = this.context.getObject(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_POLICY);
        }
        String tokenPolicy = null;
        if (oTokenPolicy instanceof String) {
            tokenPolicy = (String)oTokenPolicy;
        }
        if (tokenPolicy == null) {
            return null;
        }
        return this.getRemoteStoreConfigByTokenPolicy(tokenPolicy, idSoggetto);
    }

    private String readKid(boolean sicurezzaMessaggio, boolean sicurezzaAudit, SecurityToken securityTokenForContext, String clientId) throws UtilsException {
        Object kid = null;
        if (sicurezzaMessaggio) {
            kid = this.readKidFromTokenIntegrity(securityTokenForContext);
        }
        if (kid == null && sicurezzaAudit) {
            kid = this.readKidFromTokenAudit(securityTokenForContext);
        }
        if (kid == null) {
            kid = REMOTE_STORE_KEY_KID_STARTS_WITH_CLIENT_ID + clientId;
        }
        return kid;
    }

    private String readKidFromTokenIntegrity(SecurityToken securityTokenForContext) throws UtilsException {
        String kid = null;
        if (securityTokenForContext != null && securityTokenForContext.getIntegrity() != null && (kid = securityTokenForContext.getIntegrity().getKid()) == null) {
            kid = securityTokenForContext.getIntegrity().getHeaderClaim("kid");
        }
        return kid;
    }

    private String readKidFromTokenAudit(SecurityToken securityTokenForContext) throws UtilsException {
        String kid = null;
        if (securityTokenForContext != null && securityTokenForContext.getAudit() != null && (kid = securityTokenForContext.getAudit().getKid()) == null) {
            kid = securityTokenForContext.getAudit().getHeaderClaim("kid");
        }
        return kid;
    }

    private void enrichTokenInfo(SecurityToken securityTokenForContext, InformazioniToken informazioniTokenNormalizzate, RequestInfo requestInfo, RemoteStoreConfig rsc, String kid, String clientId) throws KeystoreException, SecurityException, UtilsException {
        RemoteKeyType keyType = RemoteKeyType.JWK;
        RemoteStoreProvider remoteStoreProvider = new RemoteStoreProvider(requestInfo, keyType);
        RemoteStoreClientInfo rsci = GestoreKeystoreCache.getRemoteStoreClientInfo((RequestInfo)requestInfo, (String)kid, (String)clientId, (RemoteStoreConfig)rsc, (IRemoteStoreProvider)remoteStoreProvider, (Map)this.context);
        if (rsci != null && (rsci.getClientDetails() != null || rsci.getOrganizationId() != null || rsci.getOrganizationDetails() != null)) {
            PDNDTokenInfoDetails info;
            JsonNode root;
            JSONUtils jsonUtils;
            if (informazioniTokenNormalizzate.getPdnd() == null) {
                informazioniTokenNormalizzate.setPdnd(new HashMap<String, Serializable>());
            }
            if (rsci.getClientDetails() != null && (jsonUtils = JSONUtils.getInstance()).isJson(rsci.getClientDetails())) {
                root = jsonUtils.getAsNode(rsci.getClientDetails());
                info = new PDNDTokenInfoDetails();
                info.setId(rsci.getClientId());
                info.setDetails(rsci.getClientDetails());
                this.enrichTokenInfoAddInClaims(jsonUtils, securityTokenForContext, informazioniTokenNormalizzate, root, "client", info);
            }
            if (rsci.getOrganizationDetails() != null && (jsonUtils = JSONUtils.getInstance()).isJson(rsci.getOrganizationDetails())) {
                root = jsonUtils.getAsNode(rsci.getOrganizationDetails());
                info = new PDNDTokenInfoDetails();
                info.setId(rsci.getOrganizationId());
                info.setDetails(rsci.getOrganizationDetails());
                this.enrichTokenInfoAddInClaims(jsonUtils, securityTokenForContext, informazioniTokenNormalizzate, root, "organization", info);
            }
        }
    }

    private void enrichTokenInfoAddInClaims(JSONUtils jsonUtils, SecurityToken securityTokenForContext, InformazioniToken informazioniTokenNormalizzate, JsonNode root, String type, PDNDTokenInfoDetails info) {
        java.util.Map readClaims = jsonUtils.convertToSimpleMap(root);
        if (!readClaims.isEmpty()) {
            this.enrichTokenInfoAddInClaims(securityTokenForContext, informazioniTokenNormalizzate, type, info, readClaims);
        }
    }

    private void enrichTokenInfoAddInClaims(SecurityToken securityTokenForContext, InformazioniToken informazioniTokenNormalizzate, String type, PDNDTokenInfoDetails info, java.util.Map<String, Serializable> readClaims) {
        informazioniTokenNormalizzate.getPdnd().put(type, TokenUtilities.toHashMapSerializable(readClaims));
        String prefix = "pdnd." + type + ".";
        HashMap<String, Serializable> readClaimsSerializable = new HashMap<String, Serializable>();
        if (informazioniTokenNormalizzate.getClaims() != null) {
            for (Map.Entry<String, Serializable> entry : readClaims.entrySet()) {
                String key = prefix + entry.getKey();
                if (!informazioniTokenNormalizzate.getClaims().containsKey(key)) {
                    informazioniTokenNormalizzate.getClaims().put(key, entry.getValue());
                }
                if (!(entry.getValue() instanceof Serializable)) continue;
                readClaimsSerializable.put(entry.getKey(), entry.getValue());
            }
        }
        info.setClaims(readClaimsSerializable);
        if (securityTokenForContext != null) {
            if (securityTokenForContext.getPdnd() == null) {
                securityTokenForContext.setPdnd(new PDNDTokenInfo());
            }
            securityTokenForContext.getPdnd().setInfo(type, info);
        }
    }
}

