/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.pdd.config.DBConsegnePreseInCaricoManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class OpenSPCoop2DBConfigurationUtility {
    private static final String TIPOLOGIA_ELIMINAZIONE_FRUIZIONE = "fruizione";
    private static final String TIPOLOGIA_ELIMINAZIONE_EROGAZIONE = "erogazione";

    private static void logError(Logger log, String msg, Exception e) {
        if (log != null) {
            log.error(msg, (Throwable)e);
        }
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String errorMsg;
        DataSource ds;
        GestoreJNDI gestoreJNDI;
        Properties context;
        String dataSource;
        if (args.length < 4) {
            String errorMsg2 = "ERROR, Usage:  java OpenSPCoop2DBConfigurationUtility proprietaAccessoDatabase tipologiaEliminazione(fruzione/erogazione) servizio(tipo/nome) soggettoErogatoreServizio(tipo/nome o *) fruitore(SOLO se tipologia=fruizione) [Logger]";
            System.err.println(errorMsg2);
            throw new CoreException(errorMsg2);
        }
        if (args[0] == null) {
            throw new CoreException("Proprieta' per la configurazione dell'accesso al database non fornite");
        }
        String proprietaAccessoDatabase = args[0].trim();
        if (args[1] == null) {
            throw new CoreException("Tipo di eliminazione non indicata");
        }
        String tipologiaEliminazione = args[1].trim();
        if (!TIPOLOGIA_ELIMINAZIONE_EROGAZIONE.equals(tipologiaEliminazione) && !TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
            throw new CoreException("Tipo di eliminazione non gestito");
        }
        if (args[2] == null) {
            throw new Exception("Servizio da eliminare non indicato");
        }
        String tipoNomeServizio = args[2].trim();
        if (!tipoNomeServizio.contains("/")) {
            throw new Exception("Servizio da eliminare non indicato correttamente, atteso: tipo/nome");
        }
        String tipoServizio = null;
        String nomeServizio = null;
        try {
            tipoServizio = tipoNomeServizio.split("/")[0].trim();
            nomeServizio = tipoNomeServizio.split("/")[1].trim();
        }
        catch (Exception e) {
            throw new CoreException("Servizio da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), (Throwable)e);
        }
        if (args[3] == null) {
            throw new CoreException("Soggetto da eliminare non indicato");
        }
        String tipoNomeSoggetto = args[3].trim();
        String tipoSoggettoErogatore = null;
        String nomeSoggettoErogatore = null;
        if (!"*".equals(tipoNomeSoggetto)) {
            if (!tipoNomeSoggetto.contains("/")) {
                throw new CoreException("Soggetto erogatore del servizio da eliminare non indicato correttamente, atteso: tipo/nome");
            }
            try {
                tipoSoggettoErogatore = tipoNomeSoggetto.split("/")[0].trim();
                nomeSoggettoErogatore = tipoNomeSoggetto.split("/")[1].trim();
            }
            catch (Exception e) {
                throw new CoreException("Soggetto erogatore del servizio da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), (Throwable)e);
            }
        }
        int logIndex = 4;
        String tipoSoggettoFruitore = null;
        String nomeSoggettoFruitore = null;
        if (TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
            ++logIndex;
            String tipoNomeSoggettoFruitore = args[4].trim();
            if (tipoNomeSoggettoFruitore == null) {
                throw new CoreException("Soggetto fruitore da eliminare non indicato");
            }
            if (!tipoNomeSoggettoFruitore.contains("/")) {
                throw new CoreException("Soggetto fruitore da eliminare non indicato correttamente, atteso: tipo/nome");
            }
            try {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.split("/")[0].trim();
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.split("/")[1].trim();
            }
            catch (Exception e) {
                throw new CoreException("Soggetto fruitore da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (args.length == logIndex + 1) {
                LoggerWrapperFactory.setLogConfiguration((String)args[logIndex]);
            } else {
                LoggerWrapperFactory.setLogConfiguration((URL)OpenSPCoop2DBConfigurationUtility.class.getResource("/console.log4j2.properties"));
            }
        }
        catch (Exception e) {
            String errorMsg3 = "Errore durante il caricamento del file di log args" + logIndex + "[" + args[logIndex] + "] : " + e.getMessage();
            System.err.println(errorMsg3);
            throw new CoreException(errorMsg3);
        }
        Logger log = LoggerWrapperFactory.getLogger((String)"gestoreEliminazioneServizio");
        Properties reader = new Properties();
        try (FileInputStream fin = new FileInputStream(proprietaAccessoDatabase);){
            reader.load(fin);
        }
        catch (IOException e) {
            String errorMsg4 = "Errore durante il caricamento del file di properties [" + proprietaAccessoDatabase + "] : " + e.getMessage();
            OpenSPCoop2DBConfigurationUtility.logError(log, errorMsg4, e);
            throw new CoreException(errorMsg4, (Throwable)e);
        }
        String govwayConsole = reader.getProperty("openspcoop2.govwayConsole");
        String tipoDatabase = null;
        boolean govwayConsoleMode = false;
        if (govwayConsole != null) {
            govwayConsoleMode = Boolean.parseBoolean(govwayConsole.trim());
        }
        Connection connectionConfigurazione = null;
        DriverConfigurazioneDB driverConfigurazione = null;
        try {
            String connection = null;
            String username = null;
            String password = null;
            String driver = null;
            boolean condivisioneDBRegservPddValue = false;
            tipoDatabase = reader.getProperty("openspcoop2.configurazione.db.tipo");
            if (tipoDatabase == null) {
                throw new CoreException("Non e' stato definito il tipo di database per la configurazione");
            }
            tipoDatabase = tipoDatabase.trim();
            String condivisioneDBRegservPdd = reader.getProperty("openspcoop2.configurazione.db.condivisioneDBRegserv");
            try {
                condivisioneDBRegservPddValue = Boolean.parseBoolean(condivisioneDBRegservPdd.trim());
            }
            catch (Exception e) {
                throw new CoreException("Non e' stato definita o e' definita non correttamente la proprieta' [openspcoop2.configurazione.db.condivisioneDBRegserv]: " + e.getMessage());
            }
            dataSource = reader.getProperty("openspcoop2.configurazione.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                context = Utilities.readProperties((String)"openspcoop2.configurazione.db.context.", (Properties)reader);
                gestoreJNDI = new GestoreJNDI(context);
                ds = (DataSource)gestoreJNDI.lookup(dataSource);
                connectionConfigurazione = ds.getConnection();
            } else {
                connection = reader.getProperty("openspcoop2.configurazione.db.url");
                if (connection == null) {
                    throw new CoreException("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                driver = reader.getProperty("openspcoop2.configurazione.db.driver");
                if (driver == null) {
                    throw new CoreException("Connessione diretta: non e' stato definito il Driver");
                }
                driver = driver.trim();
                username = reader.getProperty("openspcoop2.configurazione.db.user");
                password = reader.getProperty("openspcoop2.configurazione.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                Loader.getInstance().newInstance(driver);
                connectionConfigurazione = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
            }
            driverConfigurazione = new DriverConfigurazioneDB(connectionConfigurazione, null, tipoDatabase, condivisioneDBRegservPddValue);
        }
        catch (Exception e) {
            String errorMsg5 = "Errore durante la lettura del file di properties [" + args[1] + "] : " + e.getMessage();
            OpenSPCoop2DBConfigurationUtility.logError(log, errorMsg5, e);
            throw new CoreException(errorMsg5, (Throwable)e);
        }
        Connection connectionRegistroServizi = null;
        DriverRegistroServiziDB driverRegistroServizi = null;
        try {
            String connection = null;
            String username = null;
            String password = null;
            String driver = null;
            tipoDatabase = reader.getProperty("openspcoop2.registroServizi.db.tipo");
            if (tipoDatabase == null) {
                throw new CoreException("Non e' stato definito il tipo di database per la configurazione");
            }
            tipoDatabase = tipoDatabase.trim();
            dataSource = reader.getProperty("openspcoop2.registroServizi.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                context = Utilities.readProperties((String)"openspcoop2.registroServizi.db.context.", (Properties)reader);
                if (!govwayConsoleMode) {
                    gestoreJNDI = new GestoreJNDI(context);
                    ds = (DataSource)gestoreJNDI.lookup(dataSource);
                    connectionRegistroServizi = ds.getConnection();
                }
            } else {
                connection = reader.getProperty("openspcoop2.registroServizi.db.url");
                if (connection == null) {
                    throw new CoreException("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                driver = reader.getProperty("openspcoop2.registroServizi.db.driver");
                if (driver == null) {
                    throw new CoreException("Connessione diretta: non e' stato definito il Driver");
                }
                driver = driver.trim();
                username = reader.getProperty("openspcoop2.registroServizi.db.user");
                password = reader.getProperty("openspcoop2.registroServizi.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                if (!govwayConsoleMode) {
                    Loader.getInstance().newInstance(driver);
                    connectionRegistroServizi = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                }
            }
            driverRegistroServizi = govwayConsoleMode ? new DriverRegistroServiziDB(connectionConfigurazione, null, tipoDatabase) : new DriverRegistroServiziDB(connectionRegistroServizi, null, tipoDatabase);
        }
        catch (Exception e) {
            errorMsg = "Errore durante la lettura del file di properties [" + args[1] + "] : " + e.getMessage();
            OpenSPCoop2DBConfigurationUtility.logError(log, errorMsg, e);
            throw new CoreException(errorMsg, (Throwable)e);
        }
        try {
            List idServizio;
            OpenSPCoop2DBConfigurationUtility.logDebug(log, "Imposto auto-commit a false");
            connectionConfigurazione.setAutoCommit(false);
            if (!govwayConsoleMode) {
                connectionRegistroServizi.setAutoCommit(false);
            } else {
                connectionRegistroServizi = connectionConfigurazione;
            }
            FiltroRicercaServizi filtroRicercaServizio2332 = new FiltroRicercaServizi();
            filtroRicercaServizio2332.setTipo(tipoServizio);
            filtroRicercaServizio2332.setNome(nomeServizio);
            if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
                filtroRicercaServizio2332.setTipoSoggettoErogatore(tipoSoggettoErogatore);
                filtroRicercaServizio2332.setNomeSoggettoErogatore(nomeSoggettoErogatore);
            }
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            try {
                idServizio = driverRegistroServizi.getAllIdServizi(filtroRicercaServizio2332);
                if (idServizio != null) {
                    for (int i = 0; i < idServizio.size(); ++i) {
                        idServizi.add((IDServizio)idServizio.get(i));
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                OpenSPCoop2DBConfigurationUtility.logDebug(log, "Ricerca di servizi con filtro [" + filtroRicercaServizio2332.toString() + "] non ha prodotto risultati: " + notFound.getMessage());
            }
            OpenSPCoop2DBConfigurationUtility.logDebug(log, "Totale servizi da eliminare con tipologia [" + tipologiaEliminazione + "] : " + idServizi.size());
            while (!idServizi.isEmpty()) {
                idServizio = (IDServizio)idServizi.remove(0);
                OpenSPCoop2DBConfigurationUtility.logDebug(log, "Gestione eliminazione servizio [" + idServizio.toString() + "] ...");
                AccordoServizioParteSpecifica asps = driverRegistroServizi.getAccordoServizioParteSpecifica((IDServizio)idServizio);
                IDSoggetto soggettoErogatore = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t dati servizio SoggettoErogatore[" + asps.getTipoSoggettoErogatore() + "/" + asps.getNomeSoggettoErogatore() + "] Tipologia[" + asps.getTipologiaServizio().toString() + "] ...");
                if (TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
                    PortaDelegata pd;
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t dati Fruitore da eliminare [" + tipoSoggettoFruitore + "/" + nomeSoggettoFruitore + "]");
                    IDSoggetto soggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                    if (govwayConsoleMode) {
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping fruizioni ...");
                        DBMappingUtils.deleteMappingFruizione((IDServizio)idServizio, (IDSoggetto)soggettoFruitore, (Connection)connectionConfigurazione, (String)tipoDatabase);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping fruizioni effettuata");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione fruizione dal servizio ...");
                    for (int i = 0; i < asps.sizeFruitoreList(); ++i) {
                        Fruitore fr = asps.getFruitore(i);
                        if (!fr.getTipo().equals(tipoSoggettoFruitore) || !fr.getNome().equals(nomeSoggettoFruitore)) continue;
                        asps.removeFruitore(i);
                        break;
                    }
                    driverRegistroServizi.updateAccordoServizioParteSpecifica(asps);
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione fruizione dal servizio effettuata");
                    ArrayList<String> nomiServiziApplicativi = new ArrayList<String>();
                    List listaPorteDelegate = driverConfigurazione.getPorteDelegateWithServizio(asps.getId(), asps.getTipo(), asps.getNome(), asps.getVersione(), asps.getIdSoggetto(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                    ArrayList<PortaDelegata> listaPorteDelegateFruitoreDaEliminare = new ArrayList<PortaDelegata>();
                    while (!listaPorteDelegate.isEmpty()) {
                        pd = (PortaDelegata)listaPorteDelegate.remove(0);
                        if (!pd.getTipoSoggettoProprietario().equals(tipoSoggettoFruitore) || !pd.getNomeSoggettoProprietario().equals(nomeSoggettoFruitore)) continue;
                        listaPorteDelegateFruitoreDaEliminare.add(pd);
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte delegate (" + listaPorteDelegateFruitoreDaEliminare.size() + ") ...");
                    while (!listaPorteDelegateFruitoreDaEliminare.isEmpty()) {
                        pd = (PortaDelegata)listaPorteDelegateFruitoreDaEliminare.remove(0);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta delegata (" + pd.getNome() + ") ...");
                        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
                            sa = pd.getServizioApplicativo(i).getNome();
                            if (nomiServiziApplicativi.contains(sa)) continue;
                            nomiServiziApplicativi.add(sa);
                        }
                        driverConfigurazione.deletePortaDelegata(pd);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta delegata (" + pd.getNome() + ") eliminata");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte delegate effettuata");
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizi applicativi (" + nomiServiziApplicativi.size() + ") ...");
                    while (!nomiServiziApplicativi.isEmpty()) {
                        String nomeSA = (String)nomiServiziApplicativi.remove(0);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. servizio applicativo (" + nomeSA + ") ...");
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(soggettoFruitore);
                        idSA.setNome(nomeSA);
                        sa = driverConfigurazione.getServizioApplicativo(idSA);
                        driverConfigurazione.deleteServizioApplicativo((ServizioApplicativo)sa);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. servizio applicativo (" + nomeSA + ") eliminato");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizi applicativi effettuata");
                } else {
                    String sa;
                    if (govwayConsoleMode) {
                        for (int i = 0; i < asps.sizeFruitoreList(); ++i) {
                            Fruitore fr = asps.getFruitore(i);
                            IDSoggetto soggettoFruitore = new IDSoggetto(fr.getTipo(), fr.getNome());
                            OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping fruizioni ...");
                            DBMappingUtils.deleteMappingFruizione((IDServizio)idServizio, (IDSoggetto)soggettoFruitore, (Connection)connectionConfigurazione, (String)tipoDatabase);
                            OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping fruizioni effettuata");
                        }
                    }
                    ArrayList<IDServizioApplicativo> nomiServiziApplicativi = new ArrayList<IDServizioApplicativo>();
                    List listaPorteDelegate = driverConfigurazione.getPorteDelegateWithServizio(asps.getId(), asps.getTipo(), asps.getNome(), asps.getVersione(), asps.getIdSoggetto(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte delegate (" + listaPorteDelegate.size() + ") ...");
                    while (!listaPorteDelegate.isEmpty()) {
                        PortaDelegata pd = (PortaDelegata)listaPorteDelegate.remove(0);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta delegata (" + pd.getNome() + ") ...");
                        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
                            sa = pd.getServizioApplicativo(i).getNome();
                            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setNome(sa);
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                            if (nomiServiziApplicativi.contains(idServizioApplicativo)) continue;
                            nomiServiziApplicativi.add(idServizioApplicativo);
                        }
                        driverConfigurazione.deletePortaDelegata(pd);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta delegata (" + pd.getNome() + ") eliminata");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte delegate effettuata");
                    List listaPorteApplicative = driverConfigurazione.getPorteApplicativeWithServizio(asps.getId(), asps.getTipo(), asps.getNome(), asps.getVersione(), asps.getIdSoggetto(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte applicative (" + listaPorteApplicative.size() + ") ...");
                    while (!listaPorteApplicative.isEmpty()) {
                        PortaApplicativa pa = (PortaApplicativa)listaPorteApplicative.remove(0);
                        IDPortaApplicativa idpa = new IDPortaApplicativa();
                        idpa.setNome(pa.getNome());
                        pa = driverConfigurazione.getPortaApplicativa(idpa);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta applicativa (" + pa.getNome() + ") ...");
                        for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                            sa = pa.getServizioApplicativo(i).getNome();
                            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setNome(sa);
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                            if (nomiServiziApplicativi.contains(idServizioApplicativo)) continue;
                            nomiServiziApplicativi.add(idServizioApplicativo);
                        }
                        driverConfigurazione.deletePortaApplicativa(pa);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. porta applicativa (" + pa.getNome() + ") eliminata");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione porte applicative effettuata");
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizi applicativi (" + nomiServiziApplicativi.size() + ") ...");
                    while (!nomiServiziApplicativi.isEmpty()) {
                        IDServizioApplicativo idSA = (IDServizioApplicativo)nomiServiziApplicativi.remove(0);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. servizio applicativo (" + idSA.toString() + ") ...");
                        try {
                            sa = driverConfigurazione.getServizioApplicativo(idSA);
                            driverConfigurazione.deleteServizioApplicativo((ServizioApplicativo)sa);
                            OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. servizio applicativo (" + idSA.toString() + ") eliminato");
                        }
                        catch (DriverConfigurazioneNotFound notFound) {
                            OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t\t. servizio applicativo (" + idSA.toString() + ") non esiste (puo' darsi che veniva riferito da piu' oggetti, e sia gia' stato eliminato)");
                        }
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizi applicativi effettuata");
                    if (govwayConsoleMode) {
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping erogazione ...");
                        DBMappingUtils.deleteMappingErogazione((IDServizio)idServizio, (Connection)connectionConfigurazione, (String)tipoDatabase);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione mapping erogazione effettuata");
                    }
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizio ...");
                    driverRegistroServizi.deleteAccordoServizioParteSpecifica(asps);
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione servizio effettuata");
                    OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione accordo parte comune ...");
                    FiltroRicercaServizi filtroAltriServizi = new FiltroRicercaServizi();
                    IDAccordo idAccordoParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                    filtroAltriServizi.setIdAccordoServizioParteComune(idAccordoParteComune);
                    boolean existsAltriServizi = false;
                    StringBuilder bfAltriServizi = new StringBuilder();
                    try {
                        List others = driverRegistroServizi.getAllIdServizi(filtroAltriServizi);
                        if (others != null && !others.isEmpty()) {
                            existsAltriServizi = true;
                            for (int i = 0; i < others.size(); ++i) {
                                if (bfAltriServizi.length() > 0) {
                                    bfAltriServizi.append(",");
                                }
                                bfAltriServizi.append(((IDServizio)others.get(i)).toString());
                            }
                        }
                    }
                    catch (DriverRegistroServiziNotFound others) {
                        // empty catch block
                    }
                    if (!existsAltriServizi) {
                        AccordoServizioParteComune as = new AccordoServizioParteComune();
                        as.setNome(idAccordoParteComune.getNome());
                        as.setVersione(idAccordoParteComune.getVersione());
                        if (idAccordoParteComune.getSoggettoReferente() != null) {
                            IdSoggetto asr = new IdSoggetto();
                            asr.setTipo(idAccordoParteComune.getSoggettoReferente().getTipo());
                            asr.setNome(idAccordoParteComune.getSoggettoReferente().getNome());
                            as.setSoggettoReferente(asr);
                        }
                        driverRegistroServizi.deleteAccordoServizioParteComune(as);
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione accordo parte comune effettuata");
                    } else {
                        OpenSPCoop2DBConfigurationUtility.logDebug(log, "\t- eliminazione accordo parte comune non effettuata poiche' implementato da altri servizi: " + bfAltriServizi.toString());
                    }
                }
                OpenSPCoop2DBConfigurationUtility.logDebug(log, "Gestione eliminazione servizio [" + idServizio.toString() + "] completata");
            }
            OpenSPCoop2DBConfigurationUtility.logDebug(log, "Commit...");
            connectionConfigurazione.commit();
            if (!govwayConsoleMode) {
                connectionRegistroServizi.commit();
            }
            OpenSPCoop2DBConfigurationUtility.logDebug(log, "Commit effettuato");
        }
        catch (Exception e) {
            try {
                try {
                    connectionConfigurazione.rollback();
                }
                catch (Exception checkAutocommit) {
                    // empty catch block
                }
                try {
                    if (!govwayConsoleMode) {
                        connectionRegistroServizi.rollback();
                    }
                }
                catch (Exception checkAutocommit) {
                    // empty catch block
                }
                errorMsg = "Errore avvenuto durante l'eliminazione: " + e.getMessage();
                OpenSPCoop2DBConfigurationUtility.logError(log, errorMsg, e);
                throw new CoreException(errorMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                boolean checkIsClosed;
                boolean checkAutocommit;
                try {
                    connectionConfigurazione.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!govwayConsoleMode) {
                        connectionRegistroServizi.setAutoCommit(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Logger logR42 = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBConsegnePreseInCaricoManager.class);
                    checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
                    checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
                    JDBCUtilities.closeConnection((Logger)logR42, (Connection)connectionConfigurazione, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
                catch (Exception logR42) {
                    // empty catch block
                }
                try {
                    if (govwayConsoleMode) throw throwable;
                    Logger logR = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBConsegnePreseInCaricoManager.class);
                    checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
                    checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
                    JDBCUtilities.closeConnection((Logger)logR, (Connection)connectionRegistroServizi, (boolean)checkAutocommit, (boolean)checkIsClosed);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connectionConfigurazione.setAutoCommit(true);
        }
        catch (Exception filtroRicercaServizio2332) {
            // empty catch block
        }
        try {
            if (!govwayConsoleMode) {
                connectionRegistroServizi.setAutoCommit(true);
            }
        }
        catch (Exception filtroRicercaServizio2332) {
            // empty catch block
        }
        try {
            Logger logR2 = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBConsegnePreseInCaricoManager.class);
            boolean checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
            boolean checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
            JDBCUtilities.closeConnection((Logger)logR2, (Connection)connectionConfigurazione, (boolean)checkAutocommit, (boolean)checkIsClosed);
        }
        catch (Exception logR2) {
            // empty catch block
        }
        try {
            if (govwayConsoleMode) return;
            Logger logR3 = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBConsegnePreseInCaricoManager.class);
            boolean checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
            boolean checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
            JDBCUtilities.closeConnection((Logger)logR3, (Connection)connectionRegistroServizi, (boolean)checkAutocommit, (boolean)checkIsClosed);
            return;
        }
        catch (Exception logR3) {
            return;
        }
    }
}

