/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.pdd.config.ClassNameInstanceProperties;
import org.openspcoop2.pdd.core.autenticazione.pa.IAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pd.IAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazioneContenutoPortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazioneContenutoPortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.controllo_traffico.plugins.IRateLimiting;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenzialiIM;
import org.openspcoop2.pdd.core.handlers.notifier.INotifierCallback;
import org.openspcoop2.pdd.core.handlers.transazioni.ISalvataggioDiagnosticiManager;
import org.openspcoop2.pdd.core.handlers.transazioni.ISalvataggioTracceManager;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.threshold.IThreshold;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityDigestReader;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.IDate;
import org.openspcoop2.utils.id.IUniqueIdentifierGenerator;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class ClassNameProperties {
    private Logger log = OpenSPCoop2Startup.initialize ? OpenSPCoop2Logger.getLoggerOpenSPCoopCore() : LoggerWrapperFactory.getLogger((String)"govway.startup");
    private ClassNameInstanceProperties reader;
    private static ClassNameProperties classNameProperties = null;

    private ClassNameProperties(boolean logError) throws UtilsException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ClassNameProperties.class.getResourceAsStream("/govway.classRegistry.properties");
            if (properties == null) {
                throw new UtilsException("File '/govway.classRegistry.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            if (logError) {
                String msg = "Riscontrato errore durante la lettura del file 'govway.classRegistry.properties': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
            }
            throw new UtilsException("ClassName initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new ClassNameInstanceProperties(propertiesReader, this.log);
    }

    public void refreshLocalProperties(Properties localProp, String confDir) {
        this.reader.searchLocalFileImplementation(confDir);
        if (localProp != null) {
            this.reader.setLocalObjectImplementation(localProp);
        }
    }

    public static boolean initialize(boolean logError) {
        try {
            classNameProperties = new ClassNameProperties(logError);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassNameProperties getInstance() {
        if (classNameProperties != null) return classNameProperties;
        Class<ClassNameProperties> clazz = ClassNameProperties.class;
        synchronized (ClassNameProperties.class) {
            if (classNameProperties != null) return classNameProperties;
            ClassNameProperties.initialize(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return classNameProperties;
        }
    }

    public boolean validaConfigurazione(ClassLoader loader, String db) {
        try {
            String className;
            TipiDatabase tipiDatabase = TipiDatabase.DEFAULT;
            if (db != null) {
                tipiDatabase = TipiDatabase.toEnumConstant((String)db);
            }
            Loader loaderOpenSPCoop = null;
            loaderOpenSPCoop = loader != null ? Loader.getInstance() : new Loader(loader);
            String[] tmp = this.getConnettore();
            if (tmp != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if (CostantiConfigurazione.DISABILITATO.toString().equals(tipo) || TipiConnettore.JMS.getNome().equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getConnettore(tipo), tipo, IConnettore.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getRealmContainerCustom()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getRealmContainerCustom(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IAutorizzazioneSecurityContainer.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutenticazionePortaDelegata()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutenticazionePortaDelegata(tipo), tipo, IAutenticazionePortaDelegata.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutenticazionePortaApplicativa()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutenticazionePortaApplicativa(tipo), tipo, IAutenticazionePortaApplicativa.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutorizzazionePortaDelegata()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutorizzazionePortaDelegata(tipo), tipo, IAutorizzazionePortaDelegata.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutorizzazionePortaApplicativa()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutorizzazionePortaApplicativa(tipo), tipo, IAutorizzazionePortaApplicativa.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutorizzazioneContenutoPortaDelegata()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutorizzazioneContenutoPortaDelegata(tipo), tipo, IAutorizzazioneContenutoPortaDelegata.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAutorizzazioneContenutoPortaApplicativa()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if ("none".equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getAutorizzazioneContenutoPortaApplicativa(tipo), tipo, IAutorizzazioneContenutoPortaApplicativa.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getIntegrazionePortaDelegata()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getIntegrazionePortaDelegata(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IGestoreIntegrazionePD.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getIntegrazionePortaApplicativa()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getIntegrazionePortaApplicativa(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IGestoreIntegrazionePA.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getJDBCAdapter()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getJDBCAdapter(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IJDBCAdapter.class, tipiDatabase)) continue;
                    return false;
                }
            }
            if ((tmp = this.getThreshold()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getThreshold(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IThreshold.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getMsgDiagnosticoOpenSPCoopAppender()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getMsgDiagnosticoOpenSPCoopAppender(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IDiagnosticProducer.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getTracciamentoOpenSPCoopAppender()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getTracciamentoOpenSPCoopAppender(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, ITracciaProducer.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getDumpOpenSPCoopAppender()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getDumpOpenSPCoopAppender(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IDumpProducer.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getNodeReceiver()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if (TipiConnettore.JMS.getNome().equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getNodeReceiver(tipo), tipo, INodeReceiver.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getNodeSender()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    if (TipiConnettore.JMS.getNome().equals(tipo) || this.validate(loaderOpenSPCoop, className = this.getNodeSender(tipo), tipo, INodeSender.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getRepositoryBuste()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getRepositoryBuste(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IGestoreRepository.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getSQLQueryObject()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getSQLQueryObject(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, ISQLQueryObject.class, tipiDatabase)) continue;
                    return false;
                }
            }
            if ((tmp = this.getDateManager()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getDateManager(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IDate.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getUniqueIdentifier()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getUniqueIdentifier(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IUniqueIdentifierGenerator.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getFiltroDuplicati()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getFiltroDuplicati(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IFiltroDuplicati.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getOpenSPCoop2MessageFactory()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getOpenSPCoop2MessageFactory(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, OpenSPCoop2MessageFactory.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getMessageSecurityContext()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getMessageSecurityContext(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, MessageSecurityContext.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getMessageSecurityDigestReader()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getMessageSecurityDigestReader(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, MessageSecurityDigestReader.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getGestoreCredenziali()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getGestoreCredenziali(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IGestoreCredenziali.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getGestoreCredenzialiIM()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getGestoreCredenzialiIM(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IGestoreCredenzialiIM.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getNotifierCallback()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getNotifierCallback(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, INotifierCallback.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getBehaviour()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getBehaviour(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IBehaviour.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getSalvataggioTracceManager()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getSalvataggioTracceManager(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, ISalvataggioTracceManager.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getSalvataggioDiagnosticiManager()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getSalvataggioDiagnosticiManager(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, ISalvataggioDiagnosticiManager.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getRateLimiting()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getRateLimiting(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IRateLimiting.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getTokenValidazione()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getTokenValidazione(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, ITokenParser.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getTokenNegoziazione()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getTokenNegoziazione(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, INegoziazioneTokenParser.class)) continue;
                    return false;
                }
            }
            if ((tmp = this.getAttributeAuthority()) != null && tmp.length > 0) {
                for (String tipo : tmp) {
                    className = this.getAttributeAuthority(tipo);
                    if (this.validate(loaderOpenSPCoop, className, tipo, IRetrieveAttributeAuthorityResponseParser.class)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la validazione lettura della proprieta' di openspcoop: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean validate(Loader loaderOpenSPCoop, String className, String tipo, Class<?> classAttesa) {
        return this.validate(loaderOpenSPCoop, className, tipo, classAttesa, null);
    }

    private boolean validate(Loader loaderOpenSPCoop, String className, String tipo, Class<?> classAttesa, TipiDatabase tipiDatabase) {
        try {
            Object o = null;
            o = tipiDatabase == null ? loaderOpenSPCoop.newInstance(className) : loaderOpenSPCoop.newInstance(className, new Object[]{tipiDatabase});
            o.toString();
            if (!classAttesa.isInstance(o)) {
                throw new UtilsException("Classe '" + className + "' non implementa l'interfaccia '" + classAttesa.getName() + "'");
            }
            return true;
        }
        catch (Throwable e) {
            this.log.error("Riscontrato errore durante l'istanziazione della classe '" + className + "' associata al tipo '" + tipo + "' riguardante la gestione dell'interfaccia '" + classAttesa.getName() + "': " + e.getMessage(), e);
            return false;
        }
    }

    public String getConnettore(String nome) {
        return this.getValue("org.openspcoop2.connettore.", nome);
    }

    public String[] getConnettore() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.connettore.", CostantiConfigurazione.DISABILITATO.toString());
    }

    public String getRealmContainerCustom(String nome) {
        return this.getValue("org.openspcoop2.realmContainer.custom.", nome);
    }

    public String[] getRealmContainerCustom() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.realmContainer.custom.", new String[0]);
    }

    public String getAutenticazionePortaDelegata(String nome) {
        return this.getValue("org.openspcoop2.autenticazione.pd.", nome);
    }

    public String[] getAutenticazionePortaDelegata() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autenticazione.pd.", "none");
    }

    public String getAutenticazionePortaApplicativa(String nome) {
        return this.getValue("org.openspcoop2.autenticazione.pa.", nome);
    }

    public String[] getAutenticazionePortaApplicativa() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autenticazione.pa.", "none");
    }

    public String getAutorizzazionePortaDelegata(String nome) {
        return this.getValue("org.openspcoop2.autorizzazione.pd.", nome);
    }

    public String[] getAutorizzazionePortaDelegata() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autorizzazione.pd.", "none");
    }

    public String getAutorizzazionePortaApplicativa(String nome) {
        return this.getValue("org.openspcoop2.autorizzazione.pa.", nome);
    }

    public String[] getAutorizzazionePortaApplicativa() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autorizzazione.pa.", "none");
    }

    public String getAutorizzazioneContenutoPortaDelegata(String nome) {
        return this.getValue("org.openspcoop2.autorizzazioneContenuto.pd.", nome);
    }

    public String[] getAutorizzazioneContenutoPortaDelegata() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autorizzazioneContenuto.pd.", "none");
    }

    public String getAutorizzazioneContenutoPortaApplicativa(String nome) {
        return this.getValue("org.openspcoop2.autorizzazioneContenuto.pa.", nome);
    }

    public String[] getAutorizzazioneContenutoPortaApplicativa() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.autorizzazioneContenuto.pa.", "none");
    }

    public String getIntegrazionePortaDelegata(String nome) {
        return this.getValue("org.openspcoop2.integrazione.pd.", nome);
    }

    public String[] getIntegrazionePortaDelegata() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.integrazione.pd.", new String[0]);
    }

    public String getIntegrazionePortaApplicativa(String nome) {
        return this.getValue("org.openspcoop2.integrazione.pa.", nome);
    }

    public String[] getIntegrazionePortaApplicativa() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.integrazione.pa.", new String[0]);
    }

    public String getJDBCAdapter(String nome) {
        return this.getValue("org.openspcoop2.jdbcAdapter.", nome);
    }

    public String[] getJDBCAdapter() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.jdbcAdapter.", new String[0]);
    }

    public String getThreshold(String nome) {
        return this.getValue("org.openspcoop2.threshold.", nome);
    }

    public String[] getThreshold() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.threshold.", new String[0]);
    }

    public String getMsgDiagnosticoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop2.msgdiagnosticoAppender.", nome);
    }

    public String[] getMsgDiagnosticoOpenSPCoopAppender() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.msgdiagnosticoAppender.", new String[0]);
    }

    public String getTracciamentoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop2.tracciamentoAppender.", nome);
    }

    public String[] getTracciamentoOpenSPCoopAppender() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.tracciamentoAppender.", new String[0]);
    }

    public String getDumpOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop2.dumpAppender.", nome);
    }

    public String[] getDumpOpenSPCoopAppender() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.dumpAppender.", new String[0]);
    }

    public String getNodeReceiver(String nome) {
        return this.getValue("org.openspcoop2.nodeReceiver.", nome);
    }

    public String[] getNodeReceiver() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.nodeReceiver.", new String[0]);
    }

    public String getNodeSender(String nome) {
        return this.getValue("org.openspcoop2.nodeSender.", nome);
    }

    public String[] getNodeSender() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.nodeSender.", new String[0]);
    }

    public String getRepositoryBuste(String nome) {
        return this.getValue("org.openspcoop2.repositoryBuste.", nome);
    }

    public String[] getRepositoryBuste() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.repositoryBuste.", new String[0]);
    }

    public String getSQLQueryObject(String nome) {
        return this.getValue("org.openspcoop2.sqlQueryObject.", nome);
    }

    public String[] getSQLQueryObject() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.sqlQueryObject.", new String[0]);
    }

    public String getDateManager(String nome) {
        return this.getValue("org.openspcoop2.date.", nome);
    }

    public String[] getDateManager() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.date.", new String[0]);
    }

    public String getUniqueIdentifier(String nome) {
        return this.getValue("org.openspcoop2.id.", nome);
    }

    public String[] getUniqueIdentifier() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.id.", new String[0]);
    }

    public String getFiltroDuplicati(String nome) {
        return this.getValue("org.openspcoop2.protocol.filtroDuplicati.", nome);
    }

    public String[] getFiltroDuplicati() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.protocol.filtroDuplicati.", new String[0]);
    }

    public String getInitHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.init.", nome);
    }

    public String[] getInitHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.init.", new String[0]);
    }

    public String getExitHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.exit.", nome);
    }

    public String[] getExitHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.exit.", new String[0]);
    }

    public String getPreInRequestHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.pre-in-request.", nome);
    }

    public String[] getPreInRequestHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.pre-in-request.", new String[0]);
    }

    public String getInRequestHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.in-request.", nome);
    }

    public String[] getInRequestHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.in-request.", new String[0]);
    }

    public String getInRequestProtocolHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.in-protocol-request.", nome);
    }

    public String[] getInRequestProtocolHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.in-protocol-request.", new String[0]);
    }

    public String getOutRequestHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.out-request.", nome);
    }

    public String[] getOutRequestHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.out-request.", new String[0]);
    }

    public String getPostOutRequestHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.post-out-request.", nome);
    }

    public String[] getPostOutRequestHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.post-out-request.", new String[0]);
    }

    public String getPreInResponseHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.pre-in-response.", nome);
    }

    public String[] getPreInResponseHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.pre-in-response.", new String[0]);
    }

    public String getInResponseHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.in-response.", nome);
    }

    public String[] getInResponseHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.in-response.", new String[0]);
    }

    public String getOutResponseHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.out-response.", nome);
    }

    public String[] getOutResponseHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.out-response.", new String[0]);
    }

    public String getPostOutResponseHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.built-in.post-out-response.", nome);
    }

    public String[] getPostOutResponseHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.built-in.post-out-response.", new String[0]);
    }

    public String getIntegrationManagerRequestHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.built-in.request.", nome);
    }

    public String[] getIntegrationManagerRequestHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.built-in.request.", new String[0]);
    }

    public String getIntegrationManagerResponseHandlerBuiltIn(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.built-in.response.", nome);
    }

    public String[] getIntegrationManagerResponseHandlerBuiltIn() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.built-in.response.", new String[0]);
    }

    public String getInitHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.init.", nome);
    }

    public String[] getInitHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.init.", new String[0]);
    }

    public String getExitHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.exit.", nome);
    }

    public String[] getExitHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.exit.", new String[0]);
    }

    public String getPreInRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.pre-in-request.", nome);
    }

    public String[] getPreInRequestHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.pre-in-request.", new String[0]);
    }

    public String getInRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-request.", nome);
    }

    public String[] getInRequestHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-request.", new String[0]);
    }

    public String getInRequestProtocolHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-protocol-request.", nome);
    }

    public String[] getInRequestProtocolHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-protocol-request.", new String[0]);
    }

    public String getOutRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.out-request.", nome);
    }

    public String[] getOutRequestHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.out-request.", new String[0]);
    }

    public String getPostOutRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.post-out-request.", nome);
    }

    public String[] getPostOutRequestHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.post-out-request.", new String[0]);
    }

    public String getPreInResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.pre-in-response.", nome);
    }

    public String[] getPreInResponseHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.pre-in-response.", new String[0]);
    }

    public String getInResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-response.", nome);
    }

    public String[] getInResponseHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-response.", new String[0]);
    }

    public String getOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.out-response.", nome);
    }

    public String[] getOutResponseHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.out-response.", new String[0]);
    }

    public String getPostOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.post-out-response.", nome);
    }

    public String[] getPostOutResponseHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.post-out-response.", new String[0]);
    }

    public String getIntegrationManagerRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.request.", nome);
    }

    public String[] getIntegrationManagerRequestHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.request.", new String[0]);
    }

    public String getIntegrationManagerResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.response.", nome);
    }

    public String[] getIntegrationManagerResponseHandler() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.response.", new String[0]);
    }

    public String getOpenSPCoop2MessageFactory(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messagefactory.", nome);
    }

    public String[] getOpenSPCoop2MessageFactory() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.messagefactory.", new String[0]);
    }

    public String getMessageSecurityContext(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messageSecurity.context.", nome);
    }

    public String[] getMessageSecurityContext() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.messageSecurity.context.", new String[0]);
    }

    public String getMessageSecurityDigestReader(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messageSecurity.digestReader.", nome);
    }

    public String[] getMessageSecurityDigestReader() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.messageSecurity.digestReader.", new String[0]);
    }

    public String getGestoreCredenziali(String nome) {
        return this.getValue("org.openspcoop2.pdd.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenziali() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.gestoreCredenziali.", new String[0]);
    }

    public String getGestoreCredenzialiIM(String nome) {
        return this.getValue("org.openspcoop2.integrationManager.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenzialiIM() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.integrationManager.gestoreCredenziali.", new String[0]);
    }

    public String getNotifierCallback(String nome) {
        return this.getValue("org.openspcoop2.notifierCallback.", nome);
    }

    public String[] getNotifierCallback() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.notifierCallback.", new String[0]);
    }

    public String getBehaviour(String nome) {
        return this.getValue("org.openspcoop2.behaviour.", nome);
    }

    public String[] getBehaviour() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.behaviour.", new String[0]);
    }

    public String getSalvataggioTracceManager(String nome) {
        return this.getValue("org.openspcoop2.pdd.transazioni.tracce.salvataggio.", nome);
    }

    public String[] getSalvataggioTracceManager() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.transazioni.tracce.salvataggio.", new String[0]);
    }

    public String getSalvataggioDiagnosticiManager(String nome) {
        return this.getValue("org.openspcoop2.pdd.transazioni.diagnostici.salvataggio.", nome);
    }

    public String[] getSalvataggioDiagnosticiManager() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.transazioni.diagnostici.salvataggio.", new String[0]);
    }

    public String getRateLimiting(String nome) {
        return this.getValue("org.openspcoop2.pdd.controlloTraffico.rateLimiting.", nome);
    }

    public String[] getRateLimiting() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.controlloTraffico.rateLimiting.", new String[0]);
    }

    public String getTokenDynamicDiscovery(String nome) {
        return this.getValue("org.openspcoop2.pdd.token.dynamicDiscovery.", nome);
    }

    public String[] getTokenDynamicDiscovery() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.token.dynamicDiscovery.", new String[0]);
    }

    public String getTokenValidazione(String nome) {
        return this.getValue("org.openspcoop2.pdd.token.validazione.", nome);
    }

    public String[] getTokenValidazione() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.token.validazione.", new String[0]);
    }

    public String getTokenNegoziazione(String nome) {
        return this.getValue("org.openspcoop2.pdd.token.negoziazione.", nome);
    }

    public String[] getTokenNegoziazione() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.token.negoziazione.", new String[0]);
    }

    public String getAttributeAuthority(String nome) {
        return this.getValue("org.openspcoop2.pdd.attributeAuthority.", nome);
    }

    public String[] getAttributeAuthority() throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.attributeAuthority.", new String[0]);
    }

    public String getExtended(String tipologia, String nome) {
        return this.getValue("org.openspcoop2.pdd.extended.", tipologia + "." + nome);
    }

    public String[] getExtended(String tipologia) throws UtilsException {
        return this.getTipiGestiti("org.openspcoop2.pdd.extended." + tipologia + ".", new String[0]);
    }

    private String getValue(String prop, String nome) {
        try {
            String value = this.reader.getValue(prop + nome);
            if (value != null) {
                value = value.trim();
            } else {
                value = this.reader.getValue(prop + nome.toLowerCase());
                if (value != null) {
                    value = value.trim();
                } else {
                    value = this.reader.getValue(prop + nome.toUpperCase());
                    if (value != null) {
                        value = value.trim();
                    }
                }
            }
            return value;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura della proprieta [" + prop + nome + "]: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String[] getTipiGestiti(String prefix, String ... defaults) throws UtilsException {
        Properties prop = this.reader.readProperties(prefix);
        Enumeration<Object> en = prop.keys();
        ArrayList<String> tipi = new ArrayList<String>();
        if (defaults != null && defaults.length > 0) {
            tipi.addAll(Arrays.asList(defaults));
        }
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o == null) continue;
            String v = (String)o;
            tipi.add(v.trim());
        }
        String[] sNull = null;
        if (!tipi.isEmpty()) {
            return tipi.toArray(new String[1]);
        }
        return sNull;
    }
}

