/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.eventi.mbean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.eventi.bean.EventiSearchForm;
import org.openspcoop2.web.monitor.eventi.bean.EventoBean;
import org.slf4j.Logger;

public class EventiBean
extends PdDBaseBean<EventoBean, Long, IService<EventoBean, Long>> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient EventiSearchForm search;
    private EventoBean evento;
    private List<SelectItem> tipiSeverita = null;
    private String eventoAction = "add";
    private boolean visualizzaIdCluster = false;
    private boolean visualizzaIdClusterAsSelectList = false;
    private List<String> listIdCluster;
    private List<String> listLabelIdCluster;
    private boolean visualizzaCanali = false;
    private List<String> listCanali;
    private Map<String, List<String>> mapCanaleToNodi;
    private boolean visualizzaConfigurazioneEventiTimeout = false;

    public EventiBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            List govwayMonitorare = govwayMonitorProperties.getListaPdDMonitorate_StatusPdD();
            this.setVisualizzaIdCluster(govwayMonitorare != null && govwayMonitorare.size() > 1);
            this.visualizzaIdClusterAsSelectList = govwayMonitorProperties.isAttivoTransazioniUtilizzoSondaPdDListAsClusterId();
            if (govwayMonitorare != null && govwayMonitorare.size() > 1) {
                this.listIdCluster = new ArrayList<String>();
                this.listIdCluster.add("--");
                this.listIdCluster.addAll(govwayMonitorare);
                this.listLabelIdCluster = new ArrayList<String>();
                ConfigurazioneNodiRuntime config = govwayMonitorProperties.getConfigurazioneNodiRuntime();
                for (String nodoRun : this.listIdCluster) {
                    String descrizione = null;
                    if (config.containsNode(nodoRun)) {
                        descrizione = config.getDescrizione(nodoRun);
                    }
                    this.listLabelIdCluster.add(descrizione != null ? descrizione : nodoRun);
                }
            }
            this.visualizzaCanali = Utility.isCanaliAbilitato();
            if (this.visualizzaCanali) {
                List canali = Utility.getCanali();
                this.listCanali = new ArrayList<String>();
                this.listCanali.add("--");
                if (canali != null && !canali.isEmpty()) {
                    this.listCanali.addAll(canali);
                    this.mapCanaleToNodi = new HashMap<String, List<String>>();
                    for (String canale : canali) {
                        ArrayList nodi = Utility.getNodi((String)canale);
                        if (nodi == null) {
                            nodi = new ArrayList();
                        }
                        this.mapCanaleToNodi.put(canale, nodi);
                    }
                }
            }
            this.visualizzaConfigurazioneEventiTimeout = govwayMonitorProperties.isAttivoVisualizzazioneConfigurazioneEventiTimeout();
        }
        catch (Exception e) {
            log.error("Errore durante l'inizializzazione EventiBean.", (Throwable)e);
        }
    }

    public EventoBean getEvento() {
        if (this.evento == null) {
            this.evento = new EventoBean();
        }
        return this.evento;
    }

    public void setEvento(EventoBean evento) {
        this.evento = evento;
    }

    public void setSearch(EventiSearchForm search) {
        this.search = search;
    }

    public EventiSearchForm getSearch() {
        return this.search;
    }

    public List<SelectItem> getTipiSeverita() {
        if (this.tipiSeverita != null) {
            return this.tipiSeverita;
        }
        this.tipiSeverita = new ArrayList<SelectItem>();
        this.tipiSeverita.add(new SelectItem((Object)"--"));
        this.tipiSeverita.add(new SelectItem((Object)TipoSeverita.FATAL.getValue()));
        this.tipiSeverita.add(new SelectItem((Object)TipoSeverita.ERROR.getValue()));
        this.tipiSeverita.add(new SelectItem((Object)TipoSeverita.WARN.getValue()));
        this.tipiSeverita.add(new SelectItem((Object)TipoSeverita.INFO.getValue()));
        this.tipiSeverita.add(new SelectItem((Object)TipoSeverita.DEBUG.getValue()));
        return this.tipiSeverita;
    }

    public void addNewListener(ActionEvent ae) {
        this.evento = null;
    }

    public IService<EventoBean, Long> getService() {
        return this.service;
    }

    public String getEventoAction() {
        return this.eventoAction;
    }

    public void setEventoAction(String eventoAction) {
        this.eventoAction = eventoAction;
    }

    public boolean isVisualizzaIdCluster() {
        return this.visualizzaIdCluster;
    }

    public void setVisualizzaIdCluster(boolean visualizzaIdCluster) {
        this.visualizzaIdCluster = visualizzaIdCluster;
    }

    public boolean isVisualizzaIdClusterAsSelectList() {
        return this.visualizzaIdClusterAsSelectList;
    }

    public void setVisualizzaIdClusterAsSelectList(boolean visualizzaIdClusterAsSelectList) {
        this.visualizzaIdClusterAsSelectList = visualizzaIdClusterAsSelectList;
    }

    public List<SelectItem> getListIdCluster() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        if (this.listIdCluster != null && this.listIdCluster.size() > 0) {
            for (int i = 0; i < this.listIdCluster.size(); ++i) {
                List<String> nodi;
                String id = this.listIdCluster.get(i);
                if ("--".equals(id)) {
                    list.add(new SelectItem((Object)id));
                    continue;
                }
                String label = this.listLabelIdCluster.get(i);
                if (this.search != null && this.search.getCanale() != null && !"".equals(this.search.getCanale()) && !"--".equals(this.search.getCanale()) && this.visualizzaCanali && this.mapCanaleToNodi != null && ((nodi = this.mapCanaleToNodi.get(this.search.getCanale())) == null || !nodi.contains(id))) continue;
                list.add(new SelectItem((Object)id, label));
            }
        }
        return list;
    }

    public boolean isVisualizzaCanali() {
        return this.visualizzaCanali;
    }

    public void setVisualizzaCanali(boolean visualizzaCanali) {
        this.visualizzaCanali = visualizzaCanali;
    }

    public List<SelectItem> getListCanali() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        if (this.listCanali != null && this.listCanali.size() > 0) {
            for (String id : this.listCanali) {
                list.add(new SelectItem((Object)id));
            }
        }
        return list;
    }

    public List<String> getIdClusterByCanale(String canale) {
        return this.mapCanaleToNodi.get(canale);
    }

    public boolean isVisualizzaConfigurazioneEventiTimeout() {
        return this.visualizzaConfigurazioneEventiTimeout;
    }
}

