/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.eventi.bean;

import java.util.ArrayList;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;

public class EventoBean
extends Evento {
    private static final long serialVersionUID = 1L;

    public EventoBean() {
    }

    public EventoBean(Evento evento) {
        ArrayList metodiEsclusi = new ArrayList(0);
        BeanUtils.copy((Object)((Object)this), (Object)evento, metodiEsclusi);
    }

    public String getSeveritaReadable() {
        try {
            TipoSeverita tipo = SeveritaConverter.toSeverita((int)this.getSeverita());
            return tipo.name();
        }
        catch (Exception e) {
            return "" + this.getSeverita();
        }
    }

    public String getIdConfigurazioneCompact() {
        String idconfigurazione = this.getIdConfigurazione();
        if (idconfigurazione != null && idconfigurazione.length() > 100) {
            return idconfigurazione.substring(0, 97) + "...";
        }
        return idconfigurazione;
    }

    public String getConfigurazioneHTML() {
        String tmp = this.getConfigurazione();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains("\n")) {
                return this.formatHTML(tmp);
            }
            return tmp;
        }
        return null;
    }

    private String formatHTML(String tmp) {
        String[] split = tmp.split("\n");
        if (split != null && split.length > 0) {
            StringBuilder bf = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                if (bf.length() > 0) {
                    bf.append("<BR/>");
                }
                bf.append(split[i].trim());
            }
            return bf.toString();
        }
        return tmp;
    }

    public boolean isEventoTimeout() {
        return this.getTipo() != null && (TipoEvento.CONTROLLO_TRAFFICO_CONNECTION_TIMEOUT.equals(this.getTipo()) || TipoEvento.CONTROLLO_TRAFFICO_REQUEST_READ_TIMEOUT.equals(this.getTipo()) || TipoEvento.CONTROLLO_TRAFFICO_READ_TIMEOUT.equals(this.getTipo()));
    }
}

